/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import java.sql.CallableStatement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mariadb.jdbc.internal.util.dao.CallableStatementCacheKey;

public class CallableStatementCache
extends LinkedHashMap<CallableStatementCacheKey, CallableStatement> {
    private int maxSize;

    private CallableStatementCache(int size) {
        super(size, 0.75f, true);
        this.maxSize = size;
    }

    public static CallableStatementCache newInstance(int size) {
        return new CallableStatementCache(size);
    }

    public CallableStatement putIfNone(CallableStatementCacheKey key, CallableStatement value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<CallableStatementCacheKey, CallableStatement> eldest) {
        return this.size() > this.maxSize;
    }
}

