/*
 * Copyright © 2014-2015  Rinat Ibragimov
 *
 * This file is part of "apulse" project.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef APULSE__TRACE_H
#define APULSE__TRACE_H

#include <glib.h>
#include <pulse/pulseaudio.h>

#if WITH_TRACE >= 2

#define trace_info_f(...)   trace_info(__VA_ARGS__)
#define trace_info_z(...)   trace_info(__VA_ARGS__)

#elif WITH_TRACE == 1

#define trace_info_f(...)
#define trace_info_z(...)   trace_info(__VA_ARGS__)

#else // WITH_TRACE == 0

#define trace_info_f(...)
#define trace_info_z(...)

#endif

void    trace_info(const char *fmt, ...) __attribute__((format (printf, 1, 2)));
void    trace_warning(const char *fmt, ...) __attribute__((format (printf, 1, 2)));
void    trace_error(const char *fmt, ...) __attribute__((format (printf, 1, 2)));

gchar *
trace_pa_buffer_attr_as_string(const pa_buffer_attr *attr);

gchar *
trace_pa_volume_as_string(const pa_cvolume *v);

void
trace_lock(void);

void
trace_unlock(void);

#endif // APULSE__TRACE_H
