#!/bin/bash

# Funktion zur Ausgabe von grünem Text
print_green() {
    echo -e "\e[32m$1\e[0m"
}

# Funktion zur Ausgabe von rotem Text
print_red() {
    echo -e "\e[31m$1\e[0m"
}

# Überprüfen, ob das Skript mit Root-Rechten ausgeführt wird
if [ "$EUID" -ne 0 ]; then
    print_red "Fehler: Bitte führe das Skript mit Root-Rechten aus (z. B. mit sudo)."
    exit 1
fi

# Schritt 1: Aktualisiere das System
echo "Aktualisiere Paketlisten und installiere Updates..."
apt update -y
apt full-upgrade -y

# Schritt 2: Finde und lösche alte Kernel und zugehörige Header-Dateien
echo "Lösche alte Kernel-Images und Header-Dateien..."

# Ermittle den aktuell verwendeten Kernel
CURRENT_KERNEL=$(uname -r | sed 's/-generic//g')

# Finde alle installierten Kernel-Images (außer dem aktuellen) und bereinige sie
dpkg --list | grep 'linux-image' | awk '{print $2}' | grep -v "$CURRENT_KERNEL" | xargs -r apt-get purge -y

# Finde alle installierten Kernel-Header (außer dem aktuellen) und bereinige sie
dpkg --list | grep 'linux-headers' | awk '{print $2}' | grep -v "$CURRENT_KERNEL" | xargs -r apt-get purge -y

# Schritt 3: Bereinige verwaiste Pakete und den Cache
echo "Bereinige verwaiste Pakete und den Cache..."
apt autoremove --purge -y
apt autoclean
apt clean

# Ausgabe der Erfolgsmeldung
print_green "-----------------------------------------------------------"
print_green "\n✅ System-Update und Bereinigung erfolgreich abgeschlossen! ✅\n"
print_green "-----------------------------------------------------------"
print_green "Bitte den Rechner neu starten, um die Änderungen vollständig zu übernehmen."
