<div align="center">

# adw-gtk3
An unofficial GTK3 port of [libadwaita](https://gnome.pages.gitlab.gnome.org/libadwaita/).

<sup>*This port does not claim to be a 100% look-a-like of libadwaita. There are some limitations to what GTK3 can do.*</sup>

| Light theme | Dark theme |
|:-----------:|:----------:|
| ![adw-gtk3-light](preview-light.png?raw=true) | ![adw-gtk3-dark](preview-dark.png?raw=true) |

<sup>*Wallpapers: [here](https://imgur.com/a/Bcw5L) and [here](https://i.imgur.com/bb6B3tL.jpg)*</sup>

</div>

<div align="center">

## How to install

</div>

### Tarball
1. Go to the [releases](https://github.com/lassekongo83/adw-gtk3/releases) section and download the latest `tar.xz` file.
2. Extract the file to `~/.local/share/themes/`

**Note:** Do not extract it to multiple locations. Only use one path.

3. If you use flatpak applications you have 2 options to use the theme (only choose one):
    1. Install the themes from Flathub: `flatpak install org.gtk.Gtk3theme.adw-gtk3 org.gtk.Gtk3theme.adw-gtk3-dark`
    2. Or you can use flatpak override. The benefit of using this option is that non-libadwaita GTK4 applications from Flathub will be styled. For this to work the theme must be installed in `~/.local/share/themes`. From a terminal run:
    ```bash
    sudo flatpak override --filesystem=xdg-data/themes && sudo flatpak mask org.gtk.Gtk3theme.adw-gtk3 && sudo flatpak mask org.gtk.Gtk3theme.adw-gtk3-dark
    ```

4. You can then enable adw-gtk3 in the application `gnome-tweaks`. (Some applications may require a relog.)

**If you use the dark theme** you'll also need to enable the dark appearance in `gnome-control-center`.

Alternatively you can set the theme with your terminal:

Change the theme to adw-gtk3 light:
```bash
gsettings set org.gnome.desktop.interface gtk-theme 'adw-gtk3' && gsettings set org.gnome.desktop.interface color-scheme 'default'
```
Change the theme to adw-gtk3-dark:
```bash
gsettings set org.gnome.desktop.interface gtk-theme 'adw-gtk3-dark' && gsettings set org.gnome.desktop.interface color-scheme 'prefer-dark'
```
Revert to GNOME's default theme:
```bash
gsettings set org.gnome.desktop.interface gtk-theme 'Adwaita' && gsettings set org.gnome.desktop.interface color-scheme 'default'
```

### Other installation options
These are maintained by contributors.

* **Fedora:** `dnf install adw-gtk3-theme`
* **Arch:** `pacman -S adw-gtk-theme`
* **Manjaro**: `pamac install adw-gtk3`
* **Debian**: https://gitlab.com/julianfairfax/package-repo#how-to-add-repository-for-debian-based-linux-distributions

Thanks to [@Pryka](https://github.com/Pryka) (Flatpak), [@solopasha](https://github.com/solopasha) (Fedora), [@dusansimic](https://github.com/dusansimic) (AUR), [@julianfairfax](https://github.com/julianfairfax) for the help.

### Installation from source
This will install the latest version from the main branch. Use this installation method if you want to contribute and help testing the theme.

See [CONTRIBUTING.md](https://github.com/lassekongo83/adw-gtk3/blob/main/CONTRIBUTING.md) for the instructions.

<div align="center">

## Customizing
If you want to change your accent color for most applications in GNOME 47 or later, then you can use the small cli program [accent-color-change](https://github.com/lassekongo83/adw-colors/tree/main/accent-color-change).

![adw-gtk3-customized](preview-customized.png?raw=true)

<sup>*Wallpaper: [here](https://i.imgur.com/ZbyNlmh.png) | Customization: [Peninsula-dark](https://github.com/lassekongo83/adw-colors/blob/main/themes/Peninsula-dark/gtk.css)*</sup>

</div>

Adw-gtk3 and libadwaita can be customized with GTK named colors. See [adw-colors](https://github.com/lassekongo83/adw-colors) for more info.

Note: GTK3 doesn't support the accent color feature introduced in GNOME 47. Only libadwaita does.

<div align="center">

## For more consistency

</div>

- **GTK4:** [Info on how to extract libadwaita from source.](https://github.com/lassekongo83/adw-gtk3/blob/main/gtk4.md)
- **GTK2:** https://github.com/eylles/adw-gtk2-colorizer
- **Gimp 3:** https://github.com/dp0sk/adw-gimp3
- **Kvantum:** https://github.com/GabePoel/KvLibadwaita
- **Firefox:** https://github.com/rafaelmardojai/firefox-gnome-theme
- **Thunderbird:** https://github.com/rafaelmardojai/thunderbird-gnome-theme
- **Steam:** https://github.com/tkashkin/Adwaita-for-Steam
- **VSCode:** https://github.com/piousdeer/vscode-adwaita
- **Discord:** https://github.com/GeopJr/DNOME
- **Obsidian:** https://github.com/birneee/obsidian-adwaita-theme
- **xfwm4:** https://github.com/FabianOvrWrt/adw-xfwm4
<div align="center">

## How to uninstall the theme(s)

</div>

- For a local installation: `rm -r ~/.local/share/themes/adw-gtk3*`
- For a global installation: `sudo rm -r /usr/share/themes/adw-gtk3*`

Flatpak: `flatpak uninstall org.gtk.Gtk3theme.adw-gtk3 org.gtk.Gtk3theme.adw-gtk3-dark`

<div align="center">

## Credits

</div>

- Libadwaita source: https://gitlab.gnome.org/GNOME/libadwaita
- Adw-gtk3 contributors: https://github.com/lassekongo83/adw-gtk3/graphs/contributors
