﻿#pragma once

// slug, name, brand, author,
// module-slug, module-name, module-description, tags
struct Entry
{
	const char* slug;
	const char* name;
	const char* brand;
	const char* author;

	const char* modslug;
	const char* modname;
	const char* moddesc;
	const char* tags;
};

Entry entries[] = {
 {"21kHz", "21kHz", "21kHz", "21kHz, Netboy3", "kHzPalmLoop", "PalmLoop", "CPU friendly voltage controlled oscillator with polyBLEP/BLAMP anti-aliasing", "Oscillator" },
 { "21kHz", "21kHz", "21kHz", "21kHz, Netboy3", "kHzTachyonEntangler", "TachyonEntangler", "Anti-aliased chaotic sync voltage controlled oscillator", "Oscillator" },
 { "21kHz", "21kHz", "21kHz", "21kHz, Netboy3", "kHzD_Inf", u8"D\u221e", "Polyphonic module for modifying V/OCT signals by transposition and inversion", "Tuner Utility Polyphonic" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "Mem", "Mem", "Sample & Hold with replay/looping abilities", "Sample and hold S&H Utility Sampler Sequencer" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "Merge8", "Merge8", "8 voice polyphonic merger", "Polyphonic Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "MultimapK", "Multimap", "Versatile Midi IO & mapping utility, 16 knobs version", "Midi Controller Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "MultimapS", "Multimap", "Versatile Midi IO & mapping utility, 16 switches version", "Midi Controller Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "Split8", "Split8", "8 voices polyphonic splitter", "Polyphonic Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "Split4", "Split4", "2 x 4 voices polyphonic splitter", "Polyphonic Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "Merge4", "Merge4", "2 x 4 voices polyphonic merger", "Polyphonic Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "Morph", "Morph", "8 Knobs controller with snapshots and morphing", "Controller" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "SwitchN1", "SwitchN1", "Polyphonic N to 1 sequential switch", "Utility Polyphonic Switch" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "Cells", "Cells", "Cellular automaton sequencer", "Random Visual Sequencer" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "ClockM8", "ClockM8", "Polyphonic Clock Modulator", "Clock Modulator Polyphonic" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "MidiPC", "MidiPC", "Sends and receive midi program change", "MIDI" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "PolyMerge", "PolyMerge", "Merge N polyphonic inputs to 1 polyphonic output", "Polyphonic Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "PolySplit", "PolySplit", "Splits 1 polyphonic input to N polyphonic outputs", "Polyphonic Utility" },
 { "23volts", "23volts", "23volts", u8"R\u00e9mi Collin", "MonoPoly", "MonoPoly", "Copy a mono channel to 1-n poly channels", "Polyphonic Utility" },
 { "3HR", "3HR", "3HR", "Robin Hammar", "Repeat3hr", "Repeat3hr", "Creative mono delay with a decimated feedback line.", "delay distortion" },
 { "3HR", "3HR", "3HR", "Robin Hammar", "Xtenuat3hr", "Xtenuat3hr", "CV-controlled crossfader and attenuverter.", "attenuator utility" },
 { "3HR", "3HR", "3HR", "Robin Hammar", "FM3HR", "FM3HR", "Sequential Self-FMing Oscillator", "oscillator polyphonic" },
 { "3HR", "3HR", "3HR", "Robin Hammar", "ENVELOOP3HR", "ENVELOOP3HR", "Dual envelope with hold-style looping and curve control", "envelope generator polyphonic" },
 { "3HR", "3HR", "3HR", "Robin Hammar", "FMFILT3HR", "FMFILT3HR", "Lowpass filter with additive and multiplicative FM", "filter polyphonic" },
 { "3HR", "3HR", "3HR", "Robin Hammar", "GLTCH3HR", "GLTCH3HR", "Threshold-controlled glitch loop generator", "sampler effect" },
 { "8Mode", "8Mode", "8Mode", "Matt Dwyer, 8Mode", "softSN", "softSN Machine", "", "Oscillator Synth voice" },
 { "AaronStatic", "Aaron Static", "Aaron Static", "Aaron Static", "ChordCV", "ChordCV", "Generates a chord", "Polyphonic Tuner" },
 { "AaronStatic", "Aaron Static", "Aaron Static", "Aaron Static", "ScaleCV", "ScaleCV", "Generates a scale", "Polyphonic Tuner Quantizer" },
 { "AaronStatic", "Aaron Static", "Aaron Static", "Aaron Static", "DiatonicCV", "DiatonicCV", "Generates diatonic chords from the provided scale", "Polyphonic Tuner" },
 { "AaronStatic", "Aaron Static", "Aaron Static", "Aaron Static", "RandomNoteCV", "RandomNoteCV", "Generates a random note when triggered", "Polyphonic Tuner Random" },
 { "Admiral", "Admiral", "Admiral", "Wannes Rombouts", "Watches", "Watches", "Dual switched multiples.", "Dual Multiple Switch Utility Polyphonic" },
 { "Admiral", "Admiral", "Admiral", "Wannes Rombouts", "Shifts", "Shifts", "Two stage Bernoulli mixer.", "Mixer Panning Random" },
 { "Admiral", "Admiral", "Admiral", "Wannes Rombouts", "Tables", "Tables", "Quad sequencer.", "Clock modulator Quad Sequencer" },
 { "Admiral", "Admiral", "Admiral", "Wannes Rombouts", "Divisions", "Divisions", "Clock divider and polyrhythm generator.", "Switch Clock modulator Sequencer" },
 { "AetrionModular", "AetrionModular", "aetrion", "Mirko Melcher & Andrew Hanson", "ChordVault", "ChordVault", "Record polyphonic cv/gate pairs into up to 16 steps and choose from a one of 8 sequencing modes.", "Sequencer" },
 { "Agave", "Agave", "Agave", "Fabian Eqsueda, Jatin Chowdhury", "LowpassFilterBank", "Agave Lowpass Filter Bank", "Bank of RC lowpass filters", "Filter" },
 { "Agave", "Agave", "Agave", "Fabian Eqsueda, Jatin Chowdhury", "SharpWavefolder", "Agave Fxld", "Buchla-style wavefolder", "Waveshaper Effect" },
 { "Agave", "Agave", "Agave", "Fabian Eqsueda, Jatin Chowdhury", "MetallicNoise", "Agave Metallic", "Noise generator for cymbals", "Noise" },
 { "Agave", "Agave", "Agave", "Fabian Eqsueda, Jatin Chowdhury", "MS20VCF", "Agave VCF", "VCF modelled after the Korg MS-20", "Filter Physical modeling Effect" },
 { "Agave", "Agave", "Agave", "Fabian Eqsueda, Jatin Chowdhury", "AgaveBlank", "AgaveBlank", "", "Blank" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "Tracker", "Tracker", "sequencer with tracker interface", "Arpeggiator Envelope generator Clock generator Polyphonic Recording Sequencer" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "TapeRecorder", "Tape Recorder", "micro cassette recorder", "Clock generator Delay Polyphonic Recording Sampler" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "TapeRecorderMixer", "Tape Recorder Mixer", "mixer for micro cassette recorder", "Attenuator Controller Expander Mixer Utility Visual Voltage-controlled amplifier" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "FlyingFader", "Flying Fader", "cv-controlled fader", "Attenuator Controller Polyphonic Utility Visual Voltage-controlled amplifier" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "EqualDivision", "Equal Division", "microtonal re-tuner and attenuverter", "Attenuator Tuner Polyphonic" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "CVFreqShift", "CV-Frequency Shift", "linear frequency shifter and modulator for note-cv", "Tuner Polyphonic" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "FunWithFrames", "Fun with Frames", "utility to enhance Regen Modular Frames", "Utility Polyphonic" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "Metronome", "Metronome", "classic rehearsal metronome", "Clock generator" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "Harmonizer", "Harmonizer", "harmonic and subharmonic CV generator", "Envelope follower Multiple Polyphonic Tuner" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "MIDIPolyExpression", "MIDI Poly Expression", "MIDI MPE to CV", "External MIDI Polyphonic Utility" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "MIDIOverAudio", "MIDI over Audio", "complement to the MIDI over Audio VST", "External MIDI Multiple Utility" },
 { "Ahornberg", "Ahornberg", "Ahornberg", "Ahornberg", "CopyPastePreset", "Copy Paste Preset", "copy-paste a preset from the module on the left side to the modules on the right side", "Utility" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "simplexandhold", "simplex & hold", "sample & hold module using internal simplex noise source", "S&H Polyphonic Random" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "blank6hp", "blank 6hp", "a simple blank", "Blank" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "polyrand", "polyrand", "output a random channel of a poly input with a trigger", "Utility Polyphonic Random" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "noize", "noize", "random noise generator with duration parameter and 0-10V cv input", "Noise Random" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "steps", "steps", "a simple 8 step sequencer with randomize trigger and eoc output", "Sequencer" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "fibb", "fibb", "a clock divider based on the fibonacci sequence", "Clock modulator" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "octsclr", "oct sclr", "scales voltage to specified octave range", "Utility" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "shift", "shift", "an 8-step shift register with probability params for each step", "Utility" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "mlt", "mlt", "two 1:3 polyphonic multiples", "Polyphonic Utility" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "math", "math", "applies various math operations on two inputs, clamped to +/-10V", "Logic Utility" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "logic", "logic", "perform logical operations on two inputs", "Logic Utility" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "probablynot", "probably not", "mute a signal on trigger, based on probability", "Utility" },
 { "alefsbits", "alef's bits", "alef's bits", "alefnull", "polyplay", "polyplay", "load and play a sample polyphonically", "Sampler Polyphonic" },
 { "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "Clockkky", "Clockkky", "A simple clock and gate sequencer", "Clock generator Sequencer" },
 { "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "Planetz", "Planetz", "The music produced by rotating planets", "Sequencer Random" },
 { "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "MusiFrog", "MusiFrog", "A musical frog jumping around an harmonic lake", "Sequencer Random" },
 { "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "Zefiro", "Zefiro", "A full synthesizer inspired by the iconic Buchla Music Easel", "Synth voice" },
 { "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "HoldMeTight", "HoldMeTight", "Triple sample and hold with an integrated quantizer", "Sample and hold Quantizer" },
 { "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "CyclicCA", "CyclicCA", "Cyclic Cellular Automata visualizer and sequencer", "Visual Sequencer" },
 { "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "AlgoritmArte", "MusiMath", "MusiMath", "Music meets math, an arithmetic driven sequencer", "Sequencer Random" },
 { "Alikins", "Alikins", "", "Adrian Likins", "GateLength", "Gate Length", "Create a gate with CV controlled length", "Utility" },
 { "Alikins", "Alikins", "", "Adrian Likins", "BigMuteButton", "Big Mute Button", "A big mute button", "Utility" },
 { "Alikins", "Alikins", "", "Adrian Likins", "Reference", "Reference Voltages", "Fixed output voltages for -10V,-5V, -1V, 0V, 1V, 5V, 10V", "Utility" },
 { "Alikins", "Alikins", "", "Adrian Likins", "ColorPanel", "Color Panel", "Control the color of the panel with CV", "Visual" },
 { "Alikins", "Alikins", "", "Adrian Likins", "MomentaryOnButtons", "Momentary On Buttons", "Set of momentarily on buttons", "Switch" },
 { "Alikins", "Alikins", "", "Adrian Likins", "ShiftPedal", "Shift Pedal", "Generate gates on mod key presses", "Utility" },
 { "Alikins", "Alikins", "", "Adrian Likins", "SpecificValue", "Specific Value", "Set or view voltages with text widget", "Utility" },
 { "Alikins", "Alikins", "", "Adrian Likins", "HoveredValue", "Hovered Value", "Display and output the value of the currently hovered widget", "Utility Controller" },
 { "Alikins", "Alikins", "", "Adrian Likins", "InjectValue", "Inject Value", "Inject value into param under cursor", "Utility Controller" },
 { "Alikins", "Alikins", "", "Adrian Likins", "ValueSaver", "Value Saver", "Save last used value", "Utility" },
 { "Alikins", "Alikins", "", "Adrian Likins", "IdleSwitch", "Idle Switch", "If a signal goes idle, flip a switch", "Utility Switch" },
 { "AlliewayAudio_Freebies", "AlliewayAudio_Freebies", "AlliewayAudio", "Allie Way", "chilly_cheese", "Chilly Cheese", "1:1 digital recreation of Mannequins 'Cold Mac' esoteric macro-utility (made with permission, but not by Mannequins)", "Attenuator Compressor Envelope follower Logic Ring modulator Slew limiter Utility Voltage-controlled amplifier Waveshaper" },
 { "AlliewayAudio_Series_I", "AlliewayAudio Series I", "AlliewayAudio", "Allie Way", "Koan", "Koan", "Transforms audio or CVs from subtle warming to annihilation. Telecommunications signal compander (Variable MU-law Encoder/Decoder) with built-in noise, analog clipping, mixer, and thru-zero VCA. Try plugging your favorite filter or effect between encoder and decoder!", "Compressor Distortion Digital Effect Limiter Mixer Noise Ring modulator Speech Utility Voltage-controlled amplifier Waveshaper" },
 { "AlliewayAudio_Series_I", "AlliewayAudio Series I", "AlliewayAudio", "Allie Way", "Bumper", "Bumper", "Quad Stepped Digital Accumulator. Based on the programming concept of incrementally 'bumping' variables up and down. Send it some gates, and it creates many stepped CVs and sub-rhythms as output - send it some oscillators, and it will explode your Atari.", "Clock Modulator Digital Function Generator Logic Low-frequency Oscillator Oscillator Quad Sample and hold Sequencer Utility Waveshaper" },
 { "AlliewayAudio_Series_I", "AlliewayAudio Series I", "AlliewayAudio", "Allie Way", "CartoonRunning", "CartoonRunning", "Circuit-Bent Newtonian Physics! Can be used a signal woggler, unstable Oscillator / Envelope / Chaos generator, or as a rather crazy audio effect! Warning: This module has a mind of it's own - use caution (and a limiter if you're using it for audio)!", "Digital Distortion Drum Filter Function Generator Low-frequency Oscillator Oscillator Physical Modeling Waveshaper" },
 { "ALM032", "ALM Busy Circuits MFX", "ALM Busy Circuits", "ALM", "MFX", "MFX", "ALM032 MFX: Stereo Multi Effects Processor", "Effect Digital Hardware Clone" },
 { "ALM032", "ALM Busy Circuits MFX", "ALM Busy Circuits", "ALM", "AXON", "AXON-1", "AXON-1 Expander for ALM032 MFX", "Expander" },
 { "ALMFree", "ALM Busy Circuits Free", "ALM Busy Circuits", "ALM", "Beast", "Beast's Chalkboard", "ALM002 Beast's Chalkboard", "Utility Hardware Clone" },
 { "ALMFree", "ALM Busy Circuits Free", "ALM Busy Circuits", "ALM", "OAx2", "O/A/x2", "ALM010 O/A/x2", "Utility Hardware Clone" },
 { "ALMFree", "ALM Busy Circuits Free", "ALM Busy Circuits", "ALM", "Tangle", "Tangle Quartet", "ALM009 Tangle Quartet", "Mixer Hardware Clone" },
 { "AlrightDevices", "Alright Devices", "", "Alright Devices", "Chronoblob2", "Chronoblob2", "Dual clock-syncable delay", "Delay Digital Dual Effect Hardware" },
 { "AlrightDevices", "Alright Devices", "", "Alright Devices", "T-Wrex", "T-Wrex", "Analog bitcrusher and decimator", "Distortion Effect Sample and hold Hardware" },
 { "AlrightDevices", "Alright Devices", "", "Alright Devices", "Zzzorb", "Zzzorb", "Four-pole multimode filter and VCA", "Filter VCA Hardware" },
 { "alto777_LFSR", "LFSR", "p.s.F/X", "alto777", "a7Utility", "a7Utility VIS", "", "Utility" },
 { "alto777_LFSR", "LFSR", "p.s.F/X", "alto777", "Amuse", "Amuse", "", "Sequencer" },
 { "alto777_LFSR", "LFSR", "p.s.F/X", "alto777", "cheapFX", "Cheap F/X", "", "LFO" },
 { "alto777_LFSR", "LFSR", "p.s.F/X", "alto777", "Divada", "Divada VIS", "", "Oscillator" },
 { "alto777_LFSR", "LFSR", "p.s.F/X", "alto777", "FG8", "FG-8", "", "Sequencer" },
 { "alto777_LFSR", "LFSR", "p.s.F/X", "alto777", "Psychtone", "Psych tone", "", "Sequencer" },
 { "alto777_LFSR", "LFSR", "p.s.F/X", "alto777", "YASeq3", "Yet Another SEQ3", "", "Sequencer" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Arp31", "Arp 3.1 - Chord", "Arpeggios over a chord", "Arpeggiator" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Arp32", "Arp 3.2 - Pattern", "Pattern arpeggios", "Arpeggiator" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Bombe", "Bombe", "A semi-random shift-register chord generator and looper", "Sequencer Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Circle", "Fifths and Fourths", "An implementation of the Circle of Fifths", "Utility" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Chord", "D'acchord", "Six voice VCO", "VCO Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Galaxy", "Galaxy", "Semi-random chord generation", "Sequencer Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Generative", "Generative", "A toolkit of functions intended to support generative music creation", "Noise Sample and hold LFO Random Clock generator" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Imp", "Imp", "A single channel trigger-to-gate and clock divider module", "Clock modulator Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Imperfect2", "Imperfect MkII", "A multi-channel trigger-to-gate and clock divider module", "Clock modulator" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Progress2", "Progress MkII", "A chord sequencer", "Sequencer Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Ruckus", "Ruckus", "A trigger sequencer based on summed clock-dividers", "Sequencer" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "ScaleQuantizer2", "Scale Quantizer MkII", "Scale-aware quantizer", "Quantizer Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "SLN", "SLN", "Slew-Limited Noise ", "Sample and hold Noise" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "MuxDeMux", "MuxDeMux", "Multiplexer/Demultiplexer for polyphonic cables", "Utility Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "PolyProbe", "PolyProbe", "Display polyphonic cable voltages", "Visual Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "PolyScope", "PolyScope", "Polyphonic 'Scope", "Visual Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "PolyUtils", "PolyUtils", "Utilities for Polyphony", "Utility Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "PolyVolt", "PolyVolt", "Set voltages in Poly cable", "Utility Polyphonic" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Arpeggiator2", "Arpeggiator MkII (deprecated)", "A multi-input arpeggiator", "Arpeggiator" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "Progress", "Progress  (deprecated)", "A chord sequencer", "Sequencer" },
 { "AmalgamatedHarmonics", "Amalgamated Harmonics", "", "John Hoar", "ScaleQuantizer", "Scale Quantizer (legacy)", "Scale-aware quantizer", "Quantizer" },
 { "AnimatedCircuits", "Animated Circuits", "Animated Circuits", "Animated Circuits", "ACFolding", "Folding", "Wavefolder", "Waveshaper Polyphonic" },
 { "AnimatedCircuits", "Animated Circuits", "Animated Circuits", "Animated Circuits", "ACLFold", "LFold", "Folded LFO", "Low-frequency oscillator Waveshaper Polyphonic" },
 { "ArableInstruments", "Arable Instruments", "Arable Instruments", "adbrant", "Joni", "Joni", "", "Granular Reverb" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Splort", "Signature Series Splort", "16 channels polyphonic split with optional linkable sort mode", "Polyphonic Utility" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Smerge", "Signature Series Smerge", "16 channels polyphonic merge with optional linkable sort mode", "Polyphonic Utility" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Spleet", "Signature Series Spleet", "Dual 4 channels / single 8 channels polyphonic split with optional sort mode", "Polyphonic Utility Dual" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Swerge", "Signature Series Swerge", "Dual 4 channels / single 8 channels polyphonic merge with optional sort mode", "Polyphonic Utility Dual" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Splirge", "Signature Series Splirge", "4 channels polyphonic split and merge with optional sort mode", "Polyphonic Utility" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Qqqq", "Quatherina's Quality Quad Quantizer", "Quatherina the Quantum Duck's Quantizer with custom & Poly External Scales, 16 scenes, offset, sample and hold,\ntransposition, lead sheet chords parsing, 4 polyphonic quantizer columns, and a licensed illustration of Quatherina", "Quantizer Polyphonic Quad Expander" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Quack", "Quatherina's Quack", "Quatherina the Quantum Duck's smaller quantizer", "Quantizer Polyphonic Expander" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Q", "Quatherina's Q<", "Quatherina the Quantum Duck's tiny quantizer - external or expander input only", "Quantizer Polyphonic Expander" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Quale", "Quatherina's Quale", "Convert chords to scales and scales to chords, using Poly External Scale representation", "Polyphonic Utility Expander" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Darius", "Signature Series Darius", "Branching 8-step sequencer taking a random path through its nodes", "Sequencer Random" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Solomon4", "Signature Series Modulellus Salomonis Regis", "4-step sequencer conjuring grand knowledge of the arts for those who self-patch pleasing sigils", "Sequencer Random" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Solomon8", "Signature Series Modulus Salomonis Regis", "8-step sequencer conjuring stupendous knowledge of the arts for those who self-patch pleasing sigils", "Sequencer Random" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Solomon16", "Signature Series Modulissimus Salomonis Regis", "16-step sequencer conjuring transmundane knowledge of the arts for those who self-patch pleasing sigils", "Sequencer Random" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Arcane", "Signature Series Arcane", u8"Today's fortune \u2605", "Random Clock generator Polyphonic Quantizer Sequencer" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Atout", "Signature Series Atout", u8"Today's fortune \u2605", "Random Clock generator Polyphonic Quantizer Sequencer" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aleister", "Signature Series Aleister", u8"Today's fortune \u2605", "Random Clock generator Polyphonic Quantizer Sequencer Expander" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Psychopump", "Signature Series Psychopump", "8 triggered channels of CV presets and S&H with randomization. \nPairs great with percussive sound sources to send your beats straight to Hades.", "Controller Polyphonic Sample and hold Utility" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Pokies4", "Signature Series Pokies", "4 tiny buttons for automation or manual performance of CV parameters. Right-click options to change output values, and use in latch mode.", "Controller Utility Quad" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Grabby", "Signature Series Grabby", "A lil fader for automation or manual performance of CV parameters. Right-click options to offset and invert output.\n Support for Poly External Scales from Quatherina's Quantizer.", "Controller Utility" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Rotatoes4", "Signature Series Rotatoes", "4 tiny knobs for automation or manual performance of CV parameters. Right-click options to offset and invert output.\n Support for Poly External Scales from Quatherina's Quantizer.", "Controller Utility Quad" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Undular", "Signature Series Undular", "Scroll the rack via CV for live performance. After initialization, waits 10 seconds before processing signals.\nIf locked out by mistake, save your patch and reload it, you will have 10 seconds to unplug UnDuLaR", "Controller Visual" },
 { "AriaSalvatrice", "Aria Salvatrice", "Aria Salvatrice", "Aria Salvatrice", "Blank", "Signature Series 8hp Blank Plate", u8"A complimentary blank plate and \u2665-head screwdriver are included with every Signature Series module purchase", "Blank" },
 { "aridacity", "aridacity", "", "cubeleco", "ClockDiv", "Clock Divider", "16 step clock divider and sequencer", "Clock modulator Switch Sequencer" },
 { "aridacity", "aridacity", "", "cubeleco", "BCrush", "Bit Crush", "Bit crusher with bit operators", "Digital Distortion Sample and hold Polyphonic" },
 { "aridacity", "aridacity", "", "cubeleco", "Clip", "Clip Limiter", "Hard limiter with inner and outer limits", "Limiter Polyphonic" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums8x8Kicks", "HIP Kick", "808 style Sampled Kick Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums8x8Snares", "HIP Snare", "808 style Sampled Snare Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums8x8Hihats", "HIP Hihats", "808 style Sampled Hihats", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums8x8toms", "HIP Toms", "808 style sampled Toms", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums8x8Percs", "HIP Percussions", "808 style sampled Percussions", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums9x9Kicks", "TEK Kick", "909 style sampled Kick Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums9x9Snares", "TEK Snare", "909 style sampled Snare Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums9x9Hihats", "TEK Hihats", "909 style sampled Hihats", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "Drums9x9Percs", "TEK Percussions", "909 style sampled Percussions", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsSdSKicks", "RCK Kick", "Simmons style sampled Kick Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsSdSSnares", "RCK Snare", "Simmons style sampled Snare Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsSdSHihats", "RCK Hihats", "Simmons style sampled Hihats", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsSdStoms", "RCK Toms", "Simmons style sampled Toms", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsC64Kicks", "CMP Kick", "C64 style sampled Kick Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsC64Snares", "CMP Snare", "C64 style sampled Snare Drum", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsC64Hihats", "CMP Hihats", "C64 style sampled Hihats", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "DrumsC64Percs", "CMP Percussions", "C64 style sampled Percussions", "Drum" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "VCFilter", "VC Filter", "Voltage Controlled Filter", "VCF" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "VCFilterStereo", "VC Filter Stereo", "Voltage Controlled Stereo Filter", "VCF" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "FixedFilterBank", "Fixed Filter Bank", "12 bands Fixed Filter Bank + LP + HP Filter", "VCF" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "ParaEQ", "Parametric EQ", "Parametric Equalizer", "Equalizer" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "BlankPanel4Dark", "BlankPanel Dark 4", "Blank Panel Dark 4 HP", "Blank" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "BlankPanel6Dark", "BlankPanel Dark 6", "Blank Panel Dark 6 HP", "Blank" },
 { "AS-Drums-n-Filters", "AS Drums n Filters", "AS", "Alfredo Santamaria", "BlankPanel8Dark", "BlankPanel Dark 8", "Blank Panel Dark 8 HP", "Blank" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReCon", "ReCon", "Controller helper for ReStepOne, ReStep sequencers", "Utility" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReStepOne", "ReStepOne", "Single step sequencer", "Sequencer" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReStep", "ReStep", "4 steps sequencer", "Sequencer" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReBeat", "ReBeat Trigger Seq/Clock Divider", "4x4 Grid trigger sequencer/clock divider", "Sequencer Clock modulator" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReBit", "ReBit Trigger Seq/Clock Divider", "Single 4 step trigger sequencer/clock divider", "Sequencer Clock modulator" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReQ", "ReQ", "Note quantizer", "Quantizer" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReNote", "ReNote", "3 channel note transposer", "Utility" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReKey", "ReKey", "1V/oct-key keyboard", "Controller Utility" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReGate", "ReGate", "Gate generator/modifier", "Dual Utility" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReFluke", "ReFluke", "S&H/Noise/Gate generator", "Noise Random Sample and hold" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "ReFlip", "ReFlip", "Random Gate Switch", "Dual Utility" },
 { "AS-Seqs-n-Tools", "AS Seqs n Tools", "AS", "Alfredo Santamaria", "aBy", "A-B-Y Switch", "A-B-Y Switch", "Switch Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "SineOSC", "TinySine", "Simple Voltage-controlled sine oscillator", "Oscillator" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "SawOSC", "TinySawish", "Simple Voltage-controlled saw oscillator", "Oscillator" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "ADSR", "ADSR", "Generates an envelope with Attack/Decay/Sustain/Release", "Envelope Generator" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "VCA", "VCA", "Voltage-controlled amplifier", "Voltage-controlled amplifier Dual" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "QuadVCA", "QuadVCA/Mixer", "VCA module x 4, plus mixer functionality", "Voltage-controlled amplifier Mixer" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "TriLFO", "TriLFO", "Low-frequency oscillator", "LFO" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "AtNuVrTr", "AtNuVrTr", "Dual Attenuator", "Attenuator Dual" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "BPMClock", "BPM Clock", "BPM Clock", "Clock" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "BPMCalc", "BPM to delay/hz calculator", "BPM to delay/hz calculator helper", "Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "BPMCalc2", "BPM to delay/ms calculator", "BPM Delay/MS Calculator", "Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "SEQ16", "SEQ16", "3-channel 16-step sequencer with step editor", "Sequencer" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Mixer2ch", "Mixer2ch", "2 channel Mixer", "Mixer" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Mixer4ch", "Mixer4ch", "4 channel Mixer", "Mixer" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Mixer8ch", "Mixer8ch", "8 channel Mixer", "Mixer" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "MonoVUmeter", "MonoVUmeter", "Mono VU meter", "Visual Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "StereoVUmeter", "StereoVUmeter", "Stereo VU meter", "Visual Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Steps", "Steps", "3 channel 64 steps counter", "Sequencer Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "LaunchGate", "LaunchGate", "2 channel signal flow start counter", "Sequencer Dual Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "KillGate", "KillGate", "2 channel signal stop counter", "Sequencer Dual Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Flow", "Flow", "Cut the flow of signals with a switch or a cv signal input", "Switch Dual Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "SignalDelay", "Signal Delay", "Delay the incomming CV signal by set milliseconds", "Delay Dual Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Cv2T", "CV 2 Trigger", "CV to Trigger generator", "Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "ZeroCV2T", "Zero CV 2 Trigger", "Zero Crossing CV to Trigger generator", "Utility Polyphonic" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "ReScale", "ReScale", "Utility module to convert from one voltage range to another", "Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Multiple2_5", "Multi 2x5", "2x5 Signal multiplier", "Multiple Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "Merge2_5", "Merge2x5", "2x5 CV Signal merger", "Multiple Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "TriggersMKI", "Triggers MKI", "Manual CV signal trigger with latch and temporary triggers + adjustable output voltage", "Switch Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "TriggersMKII", "Triggers MKII", "Manual CV signal temporary trigger with labeling integrated", "Switch Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "TriggersMKIII", "TriggersMKIII", "Manual CV signal temporary trigger with editable labeling integrated", "Switch Utility" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "DelayPlusFx", "Delay Plus Fx", "Delay effect with MS digital display, wet signal send & return and bypass switch", "Delay Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "DelayPlusStereoFx", "Delay Plus Stereo Fx", "Stereo Delay effect with MS digital display, wet signal send & return and bypass switch", "Delay Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "PhaserFx", "Phaser Fx", "Phaser FX with CV input for each parameter and bypass switch", "Phaser Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "ReverbFx", "Reverb Fx", "Reverb FX with CV input for each parameter and bypass switch", "Reverb Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "ReverbStereoFx", "Reverb Stereo Fx", "Stereo Reverb FX with CV input for each parameter and bypass switch", "Reverb Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "SuperDriveFx", "SuperDrive Fx", "Overdrive FX with CV input for each parameter and bypass switch", "Distortion Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "SuperDriveStereoFx", "SuperDrive Stereo Fx", "Stereo Overdrive FX with CV input for each parameter and bypass switch", "Distortion Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "TremoloFx", "Tremolo Fx", "Tremolo Fx with CV input for each parameter and bypass switch", "Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "TremoloStereoFx", "Tremolo Stereo Fx", "Stereo Tremolo Fx with CV input for each parameter and bypass switch", "Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "WaveShaper", "Wave Shaper", "WaveShaper Fx with bypass switch", "Waveshaper Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "WaveShaperStereo", "Wave Shaper Stereo", "WaveShaper Stereo Fx with bypass switch", "Waveshaper Effect" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "BlankPanel4", "BlankPanel4", "Blank Panel 4 HP", "Blank" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "BlankPanel6", "BlankPanel6", "Blank Panel 6 HP", "Blank" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "BlankPanel8", "BlankPanel8", "Blank Panel 8 HP", "Blank" },
 { "AS", "AS", "AS", "Alfredo Santamaria", "BlankPanelSpecial", "Blank Panel Special", "Blank Panel goodies", "Blank" },
 { "ASK", "ASK", "\u00c4SK", "Patrik Wallstr\u00f6m", "rnsh", "rnsh", "8 channel noise generator with sample and hold, with a global spread attenuator", "Random Noise S&H Sample and Hold Sample & Hold" },
 { "Atelier", "Atelier", "Atelier", "Xenakios (Panel Design by Pyer)", "AtelierPalette", "Palette", "Based on Mutable Instruments Plaits", "Oscillator Hardware Polyphonic" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Braids", "Macro Oscillator", "Based on Mutable Instruments Braids", "Oscillator Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Plaits", "Macro Oscillator 2", "Based on Mutable Instruments Plaits", "Oscillator Hardware clone Polyphonic" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Elements", "Modal Synthesizer", "Based on Mutable Instruments Elements", "Physical modeling Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Tides", "Tidal Modulator", "Based on Mutable Instruments Tides", "LFO Oscillator Waveshaper Function generator Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Tides2", "Tidal Modulator 2", "Based on Mutable Instruments Tides", "LFO Oscillator Waveshaper Function generator Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Clouds", "Texture Synthesizer", "Based on Mutable Instruments Clouds", "Granular Reverb Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Warps", "Meta Modulator", "Based on Mutable Instruments Warps", "Ring modulator Waveshaper Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Rings", "Resonator", "Based on Mutable Instruments Rings", "Physical modeling Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Links", "Multiples", "Based on Mutable Instruments Links", "Multiple Mixer Hardware clone Polyphonic" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Kinks", "Utilities", "Based on Mutable Instruments Kinks", "Utility Sample and hold Noise Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Shades", "Mixer", "Based on Mutable Instruments Shades", "Mixer Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Branches", "Bernoulli Gate", "Based on Mutable Instruments Branches", "Random Dual Hardware clone Polyphonic" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Blinds", "Quad VC-polarizer", "Based on Mutable Instruments Blinds", "Mixer Attenuator Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Veils", "Quad VCA", "Based on Mutable Instruments Veils", "Mixer Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Frames", "Keyframer/Mixer", "Based on Mutable Instruments Frames", "Oscillator Mixer Attenuator LFO Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Stages", "Segment Generator", "Based on Mutable Instruments Stages", "Function generator Envelope generator Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Marbles", "Random Sampler", "Based on Mutable Instruments Marbles", "Random Hardware clone" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Ripples", "Liquid Filter", "Based on Mutable Instruments Ripples", "Filter Voltage-controlled amplifier Hardware clone Polyphonic" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Shelves", "EQ Filter", "Based on Mutable Instruments Shelves", "Equalizer Filter Polyphonic" },
 { "AudibleInstruments", "Audible Instruments", "", "VCV", "Streams", "Dual Dynamics Gate", "Based on Mutable Instruments Streams", "Dynamics Low-pass gate Polyphonic" },
 { "AuntyLangtonsFree", "Aunty Langton's", "Aunty Langton's", "Alex Weatherley", "MusicalAnt", "Musical Ant", "A Langton's Ant implementation in Rack", "Sequencer Clock generator Clock modulator Arpeggiator Poly" },
 { "AuraAudio", "Aura Audio", "Aura Audio", "Evan Murray", "ModularForecast", "Modular Forecast", "Visualize sound as weather!", "Visual" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Amp", "Amp", "Amplifier", "VCA Polyphonic Attenuator" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Bass", "Bass", "Bass and Acid synth", "VCF Physical modeling" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Boomerang", "Mera", "Pre-post VCA", "VCA Attenuator" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "CVConverter", "Conv", "Converts to and from uni/bi CV voltages", "Utility" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Deadband", "Deadband", "Constrain low voltages to zero", "VCA Attenuator" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Digi", "Digi", "Quantizes a signal into discrete steps", "Utility Digital Effect Quantizer Waveshaper" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Disee", "DC", "Outputs DC component of signal", "Utility" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Flopper", "Flopper", "Mix signals in uncommon way", "Waveshaper" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Jette", "Jette", "Oscillator with harmonics control", "VCO" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Oxcart", "Oxcart", "Aggresive oscillator. Best for low/mid frequencies.", "VCO" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Retri", "Flora", "A 24dB low-pass filter emulating a 4-pole transistor ladder", "VCF Physical modeling Dual" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Saw", "Saw", "Oscillator with a sawish sound", "VCO" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Sjip", "Sjip", "Oscillator with rounded waveform", "VCO" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Square", "Square", "Oscillator with a squareish sound", "VCO" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Vector", "Vxy", "Random x-y generator", "Controller Utility Random" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Vibrato", "Vibrato", "Vibrato effect with optional Flanger", "Effect Delay Flanger" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Zod", "Zod", "Dynamic range manipulator with noisegate", "Compressor Limiter Dynamics Expander Dual" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "TriBand", "Imp", "Simple Triple Band Equalizer", "Equalizer" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Mixer6", "6 Channel Mixer", "6 channel mixer with no CV", "Mixer Equalizer" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Non", "Non", "Limiter", "Limiter Dynamics Dual" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Overdrive", "Fil", "Filing away at audio (Overdrive)", "Effect Distortion" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Distortion", "Nap", "Taking a nap (Distortion)", "Effect Distortion" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Melody", "Fluencerator", "Random melody sequencer with special constraints that make it sound more pleasant for the ear", "Sequencer Random" },
 { "Autinn", "Autinn", "Autinn", "Nikolai V. Chr.", "Chord", "Rebel", "Plays a random selected chord from a root note (does not have to be in tune). Polyphonic outputs.", "Utility Polyphonic" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsKick", "Drums - Kick", "Sampled Kick module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsSnare", "Drums - Snare", "Sampled Snare module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsHiHatClosed", "Drums - Closed Hats", "Sampled Closed Hi-Hats module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsHiHatOpen", "Drums - HiHat Open", "Sampled Open Hi-Hats module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsClaps", "Drums - Claps", "Sampled Claps module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsRimClaves", "Drums - Rim/Claves", "Sampled Rim/Claves module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsCymbals", "Drums - Cymbals", "Sampled Cymbals module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsRide", "Drums - Ride", "Sampled Ride module with different samples of vintage Drum Machines", "Drums" },
 { "Autodafe-DrumKit", "Autodafe - DrumKit", "Autodafe", "Autodafe", "DrumsMixer", "Drums - Mixer", "8-Channel Mixer Module with CV Controls", "Mixer" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "SQUARE", "S[Q]UARE", "A Square VCO made up of sine waves and Harmonics", "VCO" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "COSINE", "CO[S]INE", "A VCO based on Cosine Waves", "VCO" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "TRESAMIGOS", "TRES[AM]IGOS", "A triple wave VCO with AM (Amplitude Modulation) between the Oscillators", "VCO" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "KICK", "[K]ICK", "Kick Drum generator, analogue emulation", "Drums" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "SNARE", "[S]NARE", "Snare Drum generator, analogue emulation", "Drums" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "HATS", "[H]ATS", "Hi-Hats generator, analogue emulation", "Drums" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "WARSAW", "WAR[S]AW", "A Super-Saw Oscillator", "VCO" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "FMERIDES", "[FM]ERIDES", "A FM (frequency Modulation) Oscillator with one carrier and one modulator", "VCO" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "TWLV", "T[W]LV", "An Oscillator based on a wave and its 12 harmonics", "VCO" },
 { "Autodafe-REDs", "Autodafe - REDs", "Autodafe", "Autodafe", "DRUMSAMPLER", "[DR]UMSAMPLER", "8 part Drum Sampler", "Drums" },
 { "Autodafe-REDsFREE", "Autodafe - REDs FREE", "", "", "SQUARE", "S[Q]UARE", "A Square VCO made up of sine waves and Harmonics", "VCO" },
 { "Autodafe-REDsFREE", "Autodafe - REDs FREE", "", "", "COSINE", "CO[S]INE", "A VCO based on Cosine Waves", "VCO" },
 { "Autodafe-REDsFREE", "Autodafe - REDs FREE", "", "", "TRESAMIGOS", "TRES[AM]IGOS", "A triple wave VCO with AM (Amplitude Modulation) between the Oscillators", "VCO" },
 { "Autodafe-REDsFREE", "Autodafe - REDs FREE", "", "", "KICK", "[K]ICK", "Kick Drum generator, analogue emulation", "Drums" },
 { "Autodafe-REDsFREE", "Autodafe - REDs FREE", "", "", "DRUMSAMPLER", "[DR]UMSAMPLER", "8 part Drum Sampler", "Drums" },
 { "Autodafe-REDsFREE", "Autodafe - REDs FREE", "", "", "HATS", "[H]ATS", "Hi-Hats generator, analogue emulation", "Drums" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "BitCrusher", "Bit Crusher", "A BitCrusher/Reducer distortion effect", "Effect Distortion" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "Multiple18", "Multiple 1x8", "A simple 1x8 Multiple", "Multiple" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "Multiple28", "Multiple 2x8", "A simple 2x8 Multiple", "Multiple" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "LFO", "LFO", "Basic LFO with different shapes", "LFO" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "Keyboard", "Keyboard", "A handy Keyboard with CV/Gate outputs", "Controller" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "BPMClock", "BPM Clock", "A Clock Generator with BPM sync", "Clock generator" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "ClockDivider", "Clock Divider", "Clock Divider and Multiplier", "Clock modulator" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "FixedFilter", "Fixed Filter", "A Fixed Filter Bank", "VCF" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "MultiModeFilter", "MultiMode Filter", "MultiMode Filter with LP, HP, BP and Notch Filter modes", "VCF" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "FormantFilter", "Formant Filter", "A nice-sounding Formant Filter", "VCF" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "FoldBack", "FoldBack Distortion", "Simple FoldBack Distortion module", "Distortion" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "PhaserFx", "Phaser", "A simple Phaser Effect", "Phaser" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "ChorusFx", "Chorus", "A simple Chorus Effect", "Chorus" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "ReverbFx", "Reverb", "A simple Reverb Effect", "Reverb" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "SEQ8", "SEQ8", "8-Step Sequencer with Start and Stop", "Sequencer" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "SEQ16", "SEQ16", "16-Step Sequencer with Start and Stop", "Sequencer" },
 { "Autodafe", "Autodafe", "Autodafe", "Autodafe", "TriggerSeq", "TriggerSeq", "16 x 8 Trigger Sequencer", "Sequencer" },
 { "Axioma", "Axioma", "Axioma", "Kaue Werner", "TheBifurcator", "TheBifurcator", "Generate CV/GATE/TRIGGER outputs based on bifurcation maps of iterated functions", "Sequencer Noise Random Visual" },
 { "Axioma", "Axioma", "Axioma", "Kaue Werner", "Tesseract", "Tesseract", "Generate CV output sequences using vertex positions of a rotating tesseract projected on a 2D space", "Low-frequency oscillator Visual" },
 { "Axioma", "Axioma", "Axioma", "Kaue Werner", "Ikeda", "Ikeda", "Generate CV output sequences with positions of chaotic attractors in the Ikeda map", "Sequencer Noise Random Visual" },
 { "Axioma", "Axioma", "Axioma", "Kaue Werner", "Rhodonea", "Rhodonea", "Oscillator based on rhodonea (rose) curves", "Oscillator Visual" },
 { "az", "az", "az", "azrrik", "modulo", "modulo", "sequencer based on the modulo % operation", "sequencer arpeggiator" },
 { "az", "az", "az", "azrrik", "LoFiTV", "LoFiTV", "slime mold simulation", "visual" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "HarMoNee", "HarMoNee", "Apply musical (major third, fifth, etc...) offsets to CV 1v/oct signals", "Quantizer Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "Glissinator", "Glissinator", "Do a constant time gliss over a changing input signal", "Slew limiter Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "PolyGnome", "PolyGnome", "A poly-rhythmic clock generator", "Clock generator" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "QuantEyes", "QuantEyes", "Quantize your signals to notes on a 12 tone scale", "Quantizer Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "SampleDelay", "SampleDelay", "A tiny number of sample delay", "Utility Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "ChipNoise", "ChipNoise", "A recreation of the NES Noise Generator", "Noise" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "ChipWaves", "ChipWaves", "A recreation of the NES oscillators", "Oscillator Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "ChipYourWave", "ChipYourWave", "An 8 bit oscillator where you draw the waveform", "Oscillator Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "Open303", "Open303", "A rack wrapper around Robin Schmidt's open-303 codebase", "Oscillator Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "KarplusStrongPoly", "KarplusStrongPoly", "An implementation of KS in a module", "Oscillator Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "ALingADing", "ALingADing", "A sub-par ring modulator", "Ring modulator Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "Bitulator", "Bitulator", "A sub-par distortion and bit cruncher", "Distortion Waveshaper Polyphonic" },
 { "BaconMusic", "Bacon Music", "", "@baconpaul", "PolyGenerator", "PolyGenerator", "Generate test polyphonic midi-like sequences", "Utility Polyphonic" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "LMH", "Low Mid High EQ", "Attenuating EQ with mid boost.", "EQ Attenuator" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "SHTH", "S&H / T&H", "Sample & Hold | Track & Hold", "Polyphonic Sample and hold" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "EOsum", "EO Sum", "Sums polyphonic channels and\ndistributes them to outputs\nbased on odd / even channel\nnumbers.", "Polyphonic Utility" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "TrimLFO", "Trim LFO Hz", "Trims top/bottom values on the selected\nLFO output, without attenuating. Quick\naccess buttons on labels\n", "LFO Utility Logic Dual Clock generator" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "OneBand", "One Band", "Dual-Mono parametric EQ\n", "EQ Attenuator" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "bpmTrimLFO", "Trim LFO BPM", "Trims top/bottom values on the selected\nLFO output, without attenuating. Quick\naccess buttons on labels\n", "LFO Utility Logic Dual Clock generator" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "PolyMix", "Polyphonic Mixer", "One Cable(s),\n4x4 channel Mixer with send/return. Constant\npower pan law Aux pre solo/master\npost fader\n", "Mixer Polyphonic" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "QuadLogic", "Quad Logic", "Min/Max value based on inputs\n", "Utility Logic" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "Panel6", "Panel 6", "Blank\n", "Blank" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "Clamp", "Clamp", "Feed signal, gained output won't\ngo over voltages set. Can also\nattenuvert signals, Invert\napplied to input.\n", "Utility Attenuator Dual Limiter" },
 { "Bark", "Coirt / Bark", "Bark", "Phil Golden", "PolyX", "Poly X", "Merge to polyphonic with mute buttons.\n\nWhen no input channels are connected\nthe mute buttons send 1v or 0v, for\nuse with Level/Pan inputs on Poly Mix.\n", "Polyphonic Switch" },
 { "Bastl", "Bastl", "Bastl", "Stefano Manconi, Ewan Hemingway, Bastl collaborators", "Kompas", "Kompas", "Kompas is a three-coordinate probabilistic pattern navigator.", "Clock modulator Hardware clone Random Sequencer" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "fox", "Fox", "Clean Overdrive", "Effect Distortion" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "ability", "Mirror", "Multi-Algorithm Module", "Utility" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "mixture", "MX", "Amplifier, Mixer and Attenuator", "Amplifier Mixer Attenuator" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "triverse", "TT", "Mixer and Attenuator", "Mixer Attenuator" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "bimix", "BX", "Mixer and Attenuator", "Mixer Attenuator" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "nostromo", "Nostromo", "Complex Oscillator", "Oscillator" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "yggdrasill", "Yggdrasill", "Random Function Generator", "Utility" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "oknotok", "oknotok", "Step Sequencer RNG", "Sequencer" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "ut", "UT", "Touch Strip", "Utility" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "nodes", "Nodes", "Patch Bay", "Utility" },
 { "BBModules", "BB Modules", "BB Modules", "Roberto Colabene", "erb", "Einstein-Rosen Bridge", "Time Delayer", "Effect" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "EvenVCO", "Even VCO", "Oscillator including even-harmonic waveform", "VCO Hardware clone Polyphonic" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "Rampage", "Rampage", "Dual ramp generator", "Function Generator Logic Slew Limiter Envelope Follower Dual Hardware clone Polyphonic" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "ABC", "A*B+C", "Dual four-quadrant multiplier with VC offset", "Ring Modulator Attenuator Dual Hardware clone Polyphonic" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "SpringReverb", "Spring Reverb", "Spring reverb tank driver", "Reverb Hardware clone" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "Mixer", "Mixer", "Four-channel mixer for audio or CV", "Mixer Hardware clone Polyphonic" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "SlewLimiter", "Slew Limiter", "Voltage controlled slew limiter, AKA lag processor", "Slew Limiter Envelope Follower Hardware clone Polyphonic" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "DualAtenuverter", "Dual Atenuverter", "Attenuates, inverts, and applies offset to a signal", "Attenuator Dual Hardware clone Polyphonic" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "Percall", "Percall", "Percussive Envelope Generator", "Envelope generator Mixer Polyphonic Hardware clone Quad" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "HexmixVCA", "Hex Mix VCA", "Six channel VCA with response curve range from logarithmic to linear and to exponential", "Mixer Hardware clone Polyphonic VCA" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "ChoppingKinky", "Chopping Kinky", "Voltage controllable, dual channel wavefolder", "Dual Hardware clone Voltage-controlled amplifier Waveshaper" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "Kickall", "Kickall", "Bassdrum module, with pitch and volume envelopes", "Drum Hardware clone Synth voice" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "SamplingModulator", "Sampling Modulator", "Multi-function module that lies somewhere between a VCO, a Sample & Hold, and an 8 step trigger sequencer", "Clock generator Hardware clone Oscillator Sample and hold" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "Morphader", "Morphader", "Multichannel CV/Audio crossfader", "Controller Hardware clone Mixer Polyphonic Quad" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "ADSR", "ADSR", "ADSR envelope generator with gate output on each stage, plus variable shape", "Envelope generator Hardware clone" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "STMix", "STMix", "A compact 4 channel stereo mixer with an auxiliary input", "Hardware clone Mixer Polyphonic" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "Muxlicer", "Muxlicer", "VC adressable sequential switch and sequencer", "Clock generator Hardware clone Polyphonic Sequencer Switch" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "Mex", "Mex", "Gate Expander for Befaco Muxlicer", "Expander Hardware clone" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "NoisePlethora", "Noise Plethora", "Multitimbral noise monster", "Dual Filter Hardware clone Noise" },
 { "Befaco", "Befaco", "Befaco", "VCV, Ewan Hemingway", "StereoStrip", "Stereo Strip", "Stereo VCA, panning, and EQ", "Equalizer Hardware clone Mixer Limiter Panning Polyphonic" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "tOCAnTe", "tOCAnTe", "Clock", "Clock" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "lATe", "lATe", "Clock Modulator, Takes a clock input\nand applies a delay on even ticks to\ncreate swing. Reset sets the next tick\nfor the incoming clock to odd.", "Logic Sequencer Clock modulator" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ChUTE", "ChUTE", "Space/Strange trigger based on the\nfree fall and bouncing an object.\nYou can change the drop altitude\nbetween 1cm and 3m\n", "Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "MU", "\u00b5", "Synced pulse generator", "Logic Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "RATEAU", "ratEaU", "Gate generator", "Clock modulator Logic Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "dTrOY", "dTrOY", "Sequencer", "Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "bordL", "bordL", "Sequencer", "Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ZOUMAI", "zO\u00f9 MA\u00ef", "Sequencer", "Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ZOUMAI-Expander", "zO\u00f9 MA\u00ef Expander", "Expander for zO\u00f9 MA\u00ef", "Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ENCORE", "enCORE", "Sequencer", "Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ENCORE-Expander", "enCORE Expander", "Expander for enCORE", "Sequencer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "DIKTAT", "DIKTAT", "Authoritarian quantizer", "Quantizer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "antN", "antN", "mp3 m3u pls radio", "Oscillator" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "TiARE", "TiARE", "Phase distortion oscillator", "Oscillator LFO" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "liMonADe", "liMonADe", "Wavetable oscillator station & additive synth", "Oscillator" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ForK", "ForK", "Formant oscillator", "Oscillator" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "OUAIve", "OUAIve", "Sample player with beat slicing grid", "Sampler" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "eDsaroS", "eDsaroS", "Sample player base on Laurent De Soras resampler", "Sampler" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "POUPRE", "p\u00f3UPr\u00e8", "Sample player", "Sampler" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "MAGMA", "maGma", "Sample player", "Sampler" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "OAI", "oA\u00ef", "Sample player", "Sampler" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "cANARd", "cANARd", "Sampler with slice tools & transients detection", "Sampler" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "EMILE", "EMILE", ".png to sound", "Sampler" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ACnE", "ACnE", "Mixer with snaphots", "Mixer" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "MS", "MS", "Mid/Side Decoder/Encoder", "Effect Utility" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "SIGMA", u8"\u03a3 multiprise :)", "Patch", "Multiple" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "lIMbO", "lIMbO", "4th order stereo LP ladder filter.\nGain boosts the signal to compensate for\nglobal signal energy lose at high\nresonance. When non linear is selected gain is applied to each stage", "VCF Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "pErCO", "pErCO", "3 bands filter", "VCF Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "BAFIS", "bAFIs", "Multiband distortion", "Effect VCF Distortion" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "ziNC", "ziNC", "Vocoder", "Effect Vocoder" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "baR", "baR", "Compressor", "Dynamics Effect Compressor" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "mINIBar", "mINIBar", "Compressor", "Dynamics Effect Compressor" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "dFUZE", "dFUZE", "Reverb", "Reverb Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "REI", "REI", "Reverb", "Reverb Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "HCTIP", "HCTIP", "Pitch shifter", "Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "SPORE", "SPORE", "Pitch shifter", "Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "FREIN", "fREIN", "Break", "Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "rabBIT", "rabBIT", "Bit toy", "Effect Distortion" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "BISTROT", "BISTROT", "Bit toy", "Effect Distortion" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "LoURdE", "LoURdE", "Neural comparator & gate", "Logic Effect" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "DilEMO", "DilEMO", "Logic", "Logic" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "lambda", "lambda", "Logic", "Logic Sample and hold S&H Sample & hold" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "BanCau", "BanCau", "Envelope tool", "Envelope generator Oscillator VCO LFO Waveshaper" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "MOiRE", "MOiRE", "Controller with snapshots and morphing", "Controller" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "PILOT", u8"\u03c0lOT", "Controller with snapshots and morphing", "Controller" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "HUITre", "HUITre", "Pattern launcher", "Controller" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "dUKe", "dUKe", "Controller", "Controller" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "fLAME", "fLAME", "FFT display", "Visual Controller" },
 { "Bidoo", "Bidoo", "Bidoo", "Bidoo", "VOID", "vOId", "The ultimate mastering tool for Rack.\nOnce plugged in your Rack, you gonna\n sound FAAAAT.\n\nPicture is taken from a very good LP\nTERA MELOS.\n", "Blank" },
 { "Blamsoft-XFXDistortionPack", "XFX Distortion Pack", "Blamsoft", "Blamsoft", "Blamsoft-XFXGrunge", "XFX Grunge", "Distortion Stompbox", "Effect Distortion" },
 { "Blamsoft-XFXDistortionPack", "XFX Distortion Pack", "Blamsoft", "Blamsoft", "Blamsoft-XFXOverdrive", "XFX Overdrive", "Distortion Stompbox", "Effect Distortion" },
 { "Blamsoft-XFXDistortionPack", "XFX Distortion Pack", "Blamsoft", "Blamsoft", "Blamsoft-XFXTube", "XFX Tube", "Tube Distortion", "Effect Distortion" },
 { "Blamsoft-XFXF35", "XFX F-35", "Blamsoft", "Blamsoft", "Blamsoft-XFXF35", "XFX F-35", "Multimode Filter", "Effect Filter Polyphonic" },
 { "Blamsoft-XFXReverb", "XFX Reverb", "Blamsoft", "Blamsoft", "Blamsoft-XFXReverb", "XFX Reverb", "Reverb", "Effect Reverb" },
 { "Blamsoft-XFXWave", "XFX Wave", "Blamsoft", "Blamsoft", "Blamsoft-XFXWave", "XFX Wave", "Wavetable Oscillator", "Oscillator Polyphonic" },
 { "BlushAudio", "Blush Audio", "Blush Audio", "Blush Audio", "BuffMult", "Buff Mult", "A Mult", "Multiple Hardware clone" },
 { "BlushAudio", "Blush Audio", "Blush Audio", "Blush Audio", "BuffMix", "Buff Mix", "A Mixer", "Mixer Hardware clone" },
 { "BlushAudio", "Blush Audio", "Blush Audio", "Blush Audio", "Logician", "Logician", "A logic module", "Logic" },
 { "BlushAudio", "Blush Audio", "Blush Audio", "Blush Audio", "TrackAndField", "Track and Field", "A S&H / T&H module", "Sample and hold Random" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-VCO", "VCO", "Oscillator", "Oscillator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-LVCO", "LVCO", "Oscillator", "Oscillator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Sine", "SINE", "Sine oscillator with phase offset", "Oscillator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Pulse", "PULSE", "Square/pulse oscillator", "Oscillator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-XCO", "XCO", "Oscillator", "Oscillator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Additator", "ADDITATOR", "Additive oscillator", "Oscillator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-FMOp", "FM-OP", "FM operator / oscillator / synth voice", "Oscillator Synth voice Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Chirp", "CHIRP", "Swept-sine oscillator", "Oscillator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-LFO", "LFO", "Low frequency oscillator", "LFO Random Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-LLFO", "LLFO", "Low frequency oscillator", "LFO Random Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-FourFO", "4FO", "Quadrature LFO", "LFO Random Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-EightFO", "8FO", "LFO with outputs at 8 different phases", "LFO Random Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-VCF", "VCF", "Multimode filter", "Filter Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-LVCF", "LVCF", "Multimode filter", "Filter Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-FFB", "FFB", "Fixed filter bank", "Filter Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-EQ", "EQ", "3-band equalizer", "Equalizer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-EQS", "EQS", "Stereo 3-band equalizer", "Equalizer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-LPG", "LPG", "Low-pass gate", "Low-pass gate Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-LLPG", "LLPG", "Low-pass gate", "Low-pass gate Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-MegaGate", "MEGAGATE", "Low- and high-pass gate", "Low-pass gate Dual Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PEQ", "PEQ", "3-channel parametric equalizer", "Filter Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PEQ6", "PEQ6", "6-channel parametric equalizer / filter bank", "Filter Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PEQ6XF", "PEQ6XF", "PEQ6 envelope followers expander", "Filter Expander Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PEQ14", "PEQ14", "14-channel parametric equalizer / filter bank", "Filter Vocoder Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PEQ14XF", "PEQ14XF", "PEQ14 envelope followers expander", "Filter Expander Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-DADSRH", "DADSR(H)", "Advanced envelope generator", "Envelope generator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-DADSRHPlus", "DADSR(H)+", "Advanced envelope generator with additional CV", "Envelope generator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Shaper", "SHAPER", "Retro-inspired envelope generator and amplifier", "Envelope generator VCA Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-ShaperPlus", "SHAPER+", "Retro-inspired envelope generator and amplifier with additional CV", "Envelope generator VCA Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-AD", "AD", "Attack/decay envelope generator", "Envelope generator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-ASR", "ASR", "Attack/sustain/release envelope generator", "Envelope generator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-ADSR", "ADSR", "ADSR envelope generator", "Envelope generator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Vish", "VISH", "Vactrol-ish envelope generator", "Envelope generator Slew Limiter Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Follow", "FOLLOW", "Envelope follower", "Envelope follower Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-DGate", "DGATE", "Trigger-to-gate converter with delay", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-RGate", "RGATE", "Clock-relative gate generator & clock divider/multiplier", "Clock modulator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Edge", "EDGE", "Edge detector, gate-to-trigger, comparator", "Logic Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Noise", "NOISE", "Noise source", "Noise Random Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-SampleHold", "S&H", "Dual sample (or track) and hold", "Sample and hold Dual Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Walk2", "WALK2", "2D random-walk and X/Y controller", "Random Sample and hold Controller" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Walk", "WALK", "Random-walk CV source", "Random Sample and hold Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mix8", "MIX8", "8-channel mixer and panner", "Mixer Panning" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mix8x", "MIX8X", "Expander for MIX8, adds EQs and sends", "Mixer Expander" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mix4", "MIX4", "4-channel mixer and panner", "Mixer Panning" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mix4x", "MIX4X", "Expander for MIX4, adds EQs and sends", "Mixer Expander" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mix2", "MIX2", "Stereo fader/amplifier with CV-controllable mute", "VCA Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mix1", "MIX1", "Fader/amplifier with CV-controllable mute", "VCA Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-VCM", "VCM", "4-channel CV controllable mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mute8", "MUTE8", "8 independent mutes with CV control", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Pan", "PAN", "Dual stereo panner", "Panning Dual Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-XFade", "XFADE", "Crossfader", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-VCA", "VCA", "Dual voltage controlled attenuator", "VCA Dual Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-VCAmp", "VCAMP", "Voltage controlled amplifier with 12dB gain", "VCA Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Velo", "VELO", "Triple-CV VCA, for tremolo, MIDI velocity, etc", "VCA Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-UMix", "UMIX", "8-input unity mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mumix", "MUMIX", "8-input unity mixer with mutes", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Matrix81", "MATRIX81", "8-channel mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Matrix18", "MATRIX18", "8-way signal router with attenuverters", "Switch Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Matrix44", "MATRIX44", "4x4 matrix mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Matrix44Cvm", "MX44CVM", "CV and mutes expander for MATRIX44", "Mixer Expander Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Matrix88", "MATRIX88", "8x8 matrix mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Matrix88Cv", "MX88CV", "CV expander for MATRIX88", "Mixer Expander Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Matrix88M", "MX88M", "Mutes expander for MATRIX88", "Mixer Expander Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Switch81", "SWITCH81", "8-channel mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Switch18", "SWITCH18", "8-way signal router", "Switch Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Switch44", "SWITCH44", "4x4 matrix mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Switch88", "SWITCH88", "8x8 matrix mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Switch1616", "SWITCH1616", "16x16 matrix mixer", "Mixer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-AMRM", "AM/RM", "Variable ring/amplitude modulator and rectifier", "Ring modulator Effect Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Pressor", "PRESSOR", "Stereo compressor and noise gate", "Compressor Dynamics Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Clpr", "CLPR (Clipper)", "Hard clipper and distortion", "Dynamics Limiter Distortion Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Lmtr", "LMTR", "Limiter", "Limiter Dynamics Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Nsgt", "NSGT", "Noise gate", "Dynamics Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-CmpDist", "CMPDIST", "Comparator-based distortion", "Distortion Effect Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-OneEight", "1:8", "8-channel multiplexer & sequential switch", "Switch Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-EightOne", "8:1", "8-channel demultiplexer & sequential switch", "Switch Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-AddrSeq", "ADDR-SEQ", "Voltage-addressable 8-step sequencer", "Sequencer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-AddrSeqX", "ASX", "8-step chainable expander for ADDR-SEQ", "Sequencer Expander Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Pgmr", "PGMR", "4-step programmer and sequencer", "Sequencer Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PgmrX", "PGMRX", "4-step chainable expander for PGMR", "Sequencer Expander Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-VU", "VU", "Stereo signal meter", "Visual" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Analyzer", "ANALYZER", "4-channel spectrum analyzer", "Visual" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-AnalyzerXL", "ANALYZER-XL", "8-channel spectrum analyzer", "Visual" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Ranalyzer", "RANALYZER", "Swept-sine frequency response analyzer", "Visual" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Detune", "DETUNE", "Pitch CV processor for detuning oscillator pairs", "Tuner Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Stack", "STACK", "Pitch CV transposer", "Tuner Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Reftone", "REFTONE", "Precision pitch CV generator", "Tuner" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mono", "MONO", "Polyphonic-to-monophonic converter with onboard compressor", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Arp", "ARP", "Polyphonic-input arpeggiator", "Arpeggiator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Assign", "ASSIGN", "Polyphonic voice (re)assigner", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Unison", "UNISON", "Polyphonic unison voicing processor with detune", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PolyCon8", "POLYCON8", "Polyphonic per-channel constant voltages", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PolyCon", "POLYCON16", "Polyphonic per-channel constant voltages", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PolyOff8", "POLYOFF8", "Polyphonic per-channel offset and scale", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PolyOff16", "POLYOFF16", "Polyphonic per-channel offset and scale", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-PolyMult", "POLYMULT", "Monophonic-to-polyphonic multiple", "Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Bool", "BOOL", "Boolean logic", "Logic Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Cmp", "CMP", "Window comparator", "Logic Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-CVD", "CVD", "Simple delay designed for triggers and other CVs", "Delay Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-FlipFlop", "FLIPFLOP", "Dual flipflop", "Logic Dual Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Inv", "INV", "Dual signal inverter", "Logic Dual Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Manual", "MANUAL", "Button controlled gates / triggers", "Controller" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-FourMan", "4MAN", "Quad button-controlled gates / triggers", "Controller Quad" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Mult", "MULT", "1:6 or dual 1:3 multiple/splitter", "Multiple Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Offset", "OFFSET", "CV offset and scaler", "Attenuator Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Slew", "SLEW", "Slew limiter / lag generator / glide", "Slew limiter Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Sums", "SUMS", "Arithmetic logic", "Logic Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Switch", "SWITCH", "2-way signal router", "Switch Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Lgsw", "LGSW", "2-way signal router with logic", "Switch Logic Polyphonic" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Blank3", "BLANK3", "3HP blank panel", "Blank" },
 { "Bogaudio", "Bogaudio", "Bogaudio", "Matt Demanett", "Bogaudio-Blank6", "BLANK6", "6HP blank panel", "Blank" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "Blank901", "Blank 901", "1HP Blank 90h theme", "Blank" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "Blank902", "Blank 902", "2HP Blank 90h theme", "Blank" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "Blank904", "Blank 904", "4HP Blank 90h theme", "Blank" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "Blank908", "Blank 908", "8HP Blank 90h theme", "Blank" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "IMO", "IMO - Input to Multiple Output", "Dual polyphonic input to multi out", "Dual Multiple Polyphonic Utility" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "MIO", "MIO - Multiple Input to Output", "Dual polyphonic multi input to out", "Dual Mixer Multiple Polyphonic Utility" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "Nip", "Nip", "Hard clipper with ceiling", "Distortion Dynamics Limiter Polyphonic" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "Pow", "Pow", "Uni-polar and Bi-polar voltage generator and attenuator", "Attenuator Polyphonic Utility" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "VBNO", "VBNO - Voice By Note Oscillator", "Oscillator with locked pitch by octave & note. Also allows for v/oct overrides rounding voltage to nearest octave or note.", "Digital Oscillator Tuner" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "DBug", "DBug", "Debug expander allowing for simple debug from any module.", "Expander Utility" },
 { "CaptainsSounds", "Captain's Sounds", "Captain's Sounds", "Mike Allison", "Dip", "Dip", "Parallel High-pass & Low-pass filter. Like a notch filter on sterioids.", "Filter" },
 { "captvolt", "CaptVolt's VCV Modules", "captvolt", "Christian Vogelgsang", "captvolt-sidofon", "sidofon", "Raw SID 6581/8580 chip emulation using ReSID engine", "Synth Voice Filter" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-1", "2hp Blanco", "2hp decorated blank panel", "Blank Visual" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-2", "3hp Blanco", "3hp decorated blank panel", "Blank Visual" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-3", "3hp Blanco flipped", "3hp decorated blank panel", "Blank Visual" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-4", "4hp Blanco", "4hp decorated blank panel", "Blank Visual" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-5", "4hp Blanco alternate", "4hp decorated blank panel", "Blank Visual" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-6", "5hp Blanco", "5hp decorated blank panel", "Blank Visual" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-7", "10hp Blanco", "10hp decorated blank panel", "Blank Visual" },
 { "CatroBlanco", "Catro/Blanco", "Catro/Blanco", "catronomix", "CatroBlanco_CB-meter", "2hp Meter", "2hp decorated meter", "Visual" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-1", "8xlfo", "8x LFO with full CV control and bpm sync", "LFO" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-2", "8xatn", "8 attenuverters with cv control anx x2 signal boost", "Attenuator Mixer" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-3", "PreSetSeq", "Preset scanner/sequencer for 8 parameters with 8 save slots", "Sample and hold sequencer" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-4", "vcClk", "BPM clock with BPM sync output for other C/M modules", "Clock generator" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-5", "vcClk++", "Clock multiplier for vcClk", "Clock modulator" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-6", "1hp blank", "May the Light shine forever upon You", "Blank" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-7", "vcClk--", "Clock divider for vcClk", "Clock modulator" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-8", "aAvsBb", "Multi-purpose quadcomparator/wave folder with 4 inputs", "Logic Sample and hold Waveshaper" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-9", "1-8-1", "8>1 and 1>8 (stepping) switch in one.", "Switch" },
 { "CatroModulo", "Catro/Modulo", "catronomix", "catronomix", "CatroModulo_CM-10", "bitStep", "1 'building block' for creating binary shift registers", "Logic" },
 { "cf", "cf", "cf", "clement foulc", "METRO", "Metro", "Clock", "Clock generator" },
 { "cf", "cf", "cf", "clement foulc", "EACH", "Each", "Clock divider", "Clock modulator" },
 { "cf", "cf", "cf", "clement foulc", "trSEQ", "trSeq", "sequencer with per step inputs", "Sequencer" },
 { "cf", "cf", "cf", "clement foulc", "LEDSEQ", "ledSeq", "5x16 triggers sequencer", "Sequencer" },
 { "cf", "cf", "cf", "clement foulc", "L3DS3Q", "l3dS3q", "5x16 triggers sequencer", "Sequencer" },
 { "cf", "cf", "cf", "clement foulc", "SLIDERSEQ", "SliderSeq", "16 CVs sequencer", "Sequencer" },
 { "cf", "cf", "cf", "clement foulc", "PLAYER", "Player", "Sample player", "Sampler" },
 { "cf", "cf", "cf", "clement foulc", "PLAY", "Play", "Mini sample player", "Sampler" },
 { "cf", "cf", "cf", "clement foulc", "MONO", "Mono", "Modular mixer Mono Channel", "Mixer" },
 { "cf", "cf", "cf", "clement foulc", "STEREO", "Stereo", "Modular mixer Stereo Channel", "Mixer" },
 { "cf", "cf", "cf", "clement foulc", "SUB", "Sub", "Modular mixer Sends", "Mixer" },
 { "cf", "cf", "cf", "clement foulc", "MASTER", "Master", "Modular mixer Master", "Mixer" },
 { "cf", "cf", "cf", "clement foulc", "VARIABLE", "Variable", "Sample & Hold", "Utility" },
 { "cf", "cf", "cf", "clement foulc", "ALGEBRA", "Algebra", "2 signals math", "Utility" },
 { "cf", "cf", "cf", "clement foulc", "FUNKTION", "Funktion", "1 signal math", "Utility" },
 { "cf", "cf", "cf", "clement foulc", "CHOKE", "Choke", "hi hat style choker", "Utility" },
 { "cf", "cf", "cf", "clement foulc", "FOUR", "Four", "4 x solo/mute", "Utility" },
 { "cf", "cf", "cf", "clement foulc", "STEPS", "Steps", "quantiser", "Utility" },
 { "cf", "cf", "cf", "clement foulc", "PEAK", "Peak", "limiter", "Limiter" },
 { "cf", "cf", "cf", "clement foulc", "CUTS", "Cuts", "dirty HP & LP filters", "Filter" },
 { "cf", "cf", "cf", "clement foulc", "BUFFER", "Buffer", "dirty delay buffer/filter", "Delay" },
 { "cf", "cf", "cf", "clement foulc", "DISTO", "Disto", "dirty distortion", "Distortion" },
 { "cf", "cf", "cf", "clement foulc", "CUBE", "Cube", "weird lfo", "Low-frequency oscillator" },
 { "cf", "cf", "cf", "clement foulc", "PATCH", "Patch", "patch bay", "Utility" },
 { "cf", "cf", "cf", "clement foulc", "LABEL", "LABEL", "label", "Visual" },
 { "cf", "cf", "cf", "clement foulc", "DAVE", "Dave", "blank panel", "Blank" },
 { "cf_hardware", "Number9", "cf", "clement foulc", "Number9", "Number9", "sample based keyboard drum machine", "SEQUENCER" },
 { "cf_hardware", "Number9", "cf", "clement foulc", "N9exp", "N9exp", "Number9 Expander", "EXPANDER" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "DTMF", "DTMF", "DTMF Tone Generator", "Envelope generator" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Noise", "Noise", "White and Pink Noise Generator", "Envelope generator Noise" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "CVSequencer", "CV Sequencer", "CV Sequencer", "Logic Sequencer" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Not", "Not", "CV and Voltage Inverter", "Logic" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Pan", "Pan", "Stereo Panner", "Panning" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Shift", "Shift", "CV and Waveform Shifter/Attenuator", "Logic Attenuator" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Oscar2", "Oscar^2", "Oscillator Madness", "VCO Waveshaper" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Eq", "Eq", "CV Controlled Equalizer", "Equalizer" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Carbon", "Carbon", "Moog-like Filter", "VCF" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Mixer", "Mixer", "8 Channel Stereo Mixer", "Mixer" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "MixerCV", "Mixer CV", "CV Controlled 8 Channel Mixer", "Mixer" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "CV", "CV", "Simple CV Manipulator", "Logic" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "M", "M", "Mini 2 Channel Mixer", "Mixer" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Tine", "Tine", "Voltage Based Splitter", "Attenuator Mixer" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "K", "K", "K is for Compressor", "Attenuator Compressor" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "X", "X", "Audio Exciter", "Effect" },
 { "CharredDesert", "CharredDesert", "SV Modular", "Jerry Sievert", "Tsunami", "Tsunami", "Tsunami Wave Multiplier", "Effect Delay Waveshaper" },
 { "Chinenual-VCV", "Chinenual", "Chinenual", "Steve Tynor", "MIDIRecorder", "MIDIRecorder", "Multi-track MIDI Recorder", "midi recording" },
 { "Chinenual-VCV", "Chinenual", "Chinenual", "Steve Tynor", "MIDIRecorderCC", "MIDIRecorderCC", "CC expander for the MIDI Recorder", "midi recording expander" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank1HP", "Blank 1HP", "1 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank2HP", "Blank 2HP", "2 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank3HP", "Blank 3HP", "3 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank4HP", "Blank 4HP", "4 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank6HP", "Blank 6HP", "6 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank10HP", "Blank 10HP", "10 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank12HP", "Blank 12HP", "12 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank16HP", "Blank 16HP", "16 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank20HP", "Blank 20HP", "20 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank26HP", "Blank 26HP", "26 HP Blanking Plate", "Blank" },
 { "Chiptuner", "Chiptuner", "TGA", "Andrea Grossi", "Blank32HP", "Blank 32HP", "32 HP Blanking Plate", "Blank" },
 { "ChordController", "Chord Controller", "ym2612", "Trevor Wilson", "ChordController", "Chord Controller", "Builds control voltages for a chord of up to six notes from one CV input", "Utility" },
 { "ChordSuite", "Chord Suite", "maglav modular", "Jiahao Huang", "ChordPlayer", "Chord Player", "5-voice chord/pitch cv generator with independent bass output", "Polyphonic Quantizer Arpeggiator" },
 { "ChordSuite", "Chord Suite", "maglav modular", "Jiahao Huang", "ArpPlayer", "Arp Player", "Chain-able arpeggiator/quantizer expander for Chord Player", "Arpeggiator Quantizer Sample and hold Expander" },
 { "ChortlingHamsterModules", "Chortling Hamster Modules", "Chortling Hamster Modules", "Alan Holding", "Pop", "Pop", "Pop is a small sample and hold module. One input, one trigger and one output. But it has a chortling hamster on it!", "Sample and hold" },
 { "ChortlingHamsterModules", "Chortling Hamster Modules", "Chortling Hamster Modules", "Alan Holding", "Bitwise", "Bitwise", "Bitwise is four sample and hold circuits whose triggers can be affected by CV controlled patterns.", "Polyphonic Sample and hold" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowTape", "ChowTape", "Analog tape emulation", "Effect Distortion Physical modeling" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowPhaserFeedback", "ChowPhaserFeedback", "A feedback phaser", "Effect Phaser" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowPhaserMod", "ChowPhaserMod", "A modulation phaser", "Effect Phaser" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowFDN", "ChowFDN", "Feedback delay network reverb", "Effect Reverb" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowRNN", "ChowRNN", "Simple recurrent neural network", "Effect" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowModal", "ChowModal", "Single resonant mode", "Effect Oscillator Filter" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowDer", "ChowDer", "Truculent analog distortion effect", "Effect Distortion Physical modeling" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "Werner", "Werner Filter", "SVF based on a generalized Moog-Octave CAT architecture", "Effect Filter Physical modeling" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "Credit", "Credit", "Creates a text file that credits all the modules used in your patch", "utility" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowPulse", "ChowPulse", "Pulse shaper based on the TR-808 Kick Drum circuit", "envelope generator physical modeling" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "Warp", "Warp", "A warping distortion, developed in collaboration with IggyLabs", "Effect Distortion" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowTapeComp", "ChowTape Compression", "Analog tape compression emulation", "Effect Compressor Distortion" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowTapeChew", "ChowTape Chew", "Emulation of magnetic tape that has been chewed up by a tape machine", "Effect Distortion" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowTapeDegrade", "ChowTape Degrade", "Emulation of magnetic tape that has been degraded by time and use", "Effect Distortion" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowTapeLoss", "ChowTape Loss", "Emulation of playhead loss effects for a reel-to-reel analog tape machine", "Effect Filter" },
 { "ChowDSP", "ChowDSP", "chowdsp", "Jatin Chowdhury", "ChowChorus", "ChowChorus", "", "Effect Chorus Physical modeling" },
 { "Circlefade", "Circlefade", "Circlefade", "Max Circlefade", "Random", "Random", "Random Pitch Gate with Ratcheting", "Random" },
 { "Circlefade", "Circlefade", "Circlefade", "Max Circlefade", "Random2", "Random2", "Random Pitch Gate with Ratcheting, Sync, Scales and Loop", "Random" },
 { "Circlefade", "Circlefade", "Circlefade", "Max Circlefade", "LFO", "LFO", "LFO with a Reset Input", "LFO" },
 { "Circlefade", "Circlefade", "Circlefade", "Max Circlefade", "Delay", "Delay", "Delay module", "Delay" },
 { "Circlefade", "Circlefade", "Circlefade", "Max Circlefade", "Clock", "Clock", "Clock module", "Clock" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Between", "Between", "On trigger, out puts a random CV value between two values.", "Utility Random Sample and hold" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Travel", "Travel", "On trigger, take two samples and interpolate an output", "Utility Slew Limiter Sample and hold" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "HiLo", "HiLo", "Given one or two inputs, output the maximum and minimum voltage.", "Utility" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Some", "Some", "From a group of active inputs, when triggered, mute a number of the inputs, based on a probability", "Utility Random" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Together", "Together", "An 8 channel, 4 group sequencer, with triggered randomized movement.", "Utility Clock modulator Logic Random Sequencer" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Tumble", "Tumble", "A chain of up to 8 pulse countdowns, which can produce bursts of triggers or gates.", "Utility Clock modulator Logic Sequencer" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Set", "Set", "Dual offset and scaling with CV control.", "Utility Dual" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Fork", "Fork", "Provide two inputs and a probability/chance, will output one, when triggered.", "Utility Logic Random Sample and hold" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Some2", "Some2", "On trigger, based on a CV input, between 0-n input is passed to outputs.", "Utility Random Logic" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Tap", "Tap", "Three push buttons to control tree triggers and gates.", "Utility" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Fork2", "Fork2", "Compare an input with a threshold and output one of two other inputs.", "Logic Utility" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Some3", "Some3", "From a polyphonic input, when triggered, mute a number of the inputs, based on a probability", "Polyphonic Random Utility" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Juice", "Juice", "Select one of 16 sets of 8 fixed voltages, based on a CV input.", "Polyphonic Utility" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Twinned2", "Twinned2", "A sequencer with pair of 8 step notes, gates, randomisation and polyphonic input.", "Sequencer Polyphonic Random" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Set2", "Set2", "A single large knob with up to 4 presets and smooth interploation over a specified time.", "Utility VCA" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Any", "Any", "A simple AND/OR logic utility with 8 inputs, 1 output.", "Utility Logic" },
 { "Coffee", "Coffee", "Coffee", "CoffeeVCV", "Quant", "Quant", "A small quantizer.", "Quantizer" },
 { "Comfortzone", "Comfortzone", "Comfortzone", "hampa", "kickbaba", "Kickbaba", "Psy Kick Bass", "Drum Oscillator" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-knolypobs", "Knoly Pobs", "16 knobs with polyphonic output", "Polyphonic Utility" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-bolyputtons", "Boly Puttons", "16 momentary or latch buttons with polyphonic output and optional input", "Polyphonic Utility" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-debug", "Debug", "Debugger, poly sample & hold, poly volt meter", "Polyphonic Utility Random Sample and hold" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-ohpeas", "Oh Peas!", "Quad Quantenuverter. \nAttenuverter, Offsetter, Microtonal Quantizer", "Polyphonic Quantizer Utility Quad" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-fatherandson", "Father and Son Patch Sequencer", "Patch Sequencer - 10 in, 10 out patch matrix with 16 scenes", "Polyphonic Utility Sequencer" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-laundry-soup", "Laundry Soup", "Rhythm sequencer, pulse generator, text-based", "Sequencer Clock modulator Random Polyphonic" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-i-love-cookies", "I Love Cookies", "Text-based CV and signal sequencer", "Sequencer Utility Random Polyphonic" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-roly-pouter", "Roly Pouter", "Polyphonic router", "Polyphonic Utility" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-toly-pools", "Toly Pools", "Polyphonic toolset including rotator, number-of-channels selector", "Polyphonic Utility Attenuator" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-soly-pequencer", "Soly Pequencer", "Sequentially step through the channels of a polyphonic signal.", "Polyphonic Sequencer" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-foly-pace", "Foly Pace", "Draw a face", "Visual Polyphonic" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-blank", "Custom Blank", "Customizable, resizable, lovable blank panel. \nLoad your own PNG, JPEG, BMP, or GIF.", "Blank Visual" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-blank-expander", "Custom Blank Expander", "Allows CV Control of Computerscare Custom Blank GIF Animation", "Blank Visual" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-stoly-fick-pigure", "Stoly Fick Pigure", "Draw a stick figure", "Visual Polyphonic" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-goly-penerator", "Goly Penerator", "Polyphonic constant CV signal generation", "Polyphonic Utility" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-moly-patrix", "Moly Patrix", "Polyphonic mix matrix", "Polyphonic Utility Mixer" },
 { "computerscare", "computerscare", "computerscare", "computerscare", "computerscare-horse-a-doodle-doo", "Horse A Doodle Doo", "Rhythm generator", "Sequencer Clock Modulator Polyphonic" },
 { "Core", "VCV Core", "VCV", "VCV", "AudioInterface2", "Audio 2", "Sends audio and CV to/from an audio device", "External" },
 { "Core", "VCV Core", "VCV", "VCV", "AudioInterface", "Audio 8", "Sends audio and CV to/from an audio device", "External" },
 { "Core", "VCV Core", "VCV", "VCV", "AudioInterface16", "Audio 16", "Sends audio and CV to/from an audio device", "External" },
 { "Core", "VCV Core", "VCV", "VCV", "MIDIToCVInterface", "MIDI to CV", "Converts MIDI from an external device to CV and gates", "External MIDI Polyphonic" },
 { "Core", "VCV Core", "VCV", "VCV", "MIDICCToCVInterface", "MIDI CC to CV", "Converts MIDI CC from an external device to CV", "External MIDI" },
 { "Core", "VCV Core", "VCV", "VCV", "MIDITriggerToCVInterface", "MIDI to Gate", "Converts MIDI notes from an external device to gates", "External MIDI" },
 { "Core", "VCV Core", "VCV", "VCV", "MIDI-Map", "MIDI Map", "Controls parameters (knobs, sliders, switches) directly with MIDI CC", "External MIDI" },
 { "Core", "VCV Core", "VCV", "VCV", "CV-MIDI", "CV to MIDI", "Converts CV to MIDI and sends to an external device", "External MIDI Polyphonic" },
 { "Core", "VCV Core", "VCV", "VCV", "CV-CC", "CV to MIDI CC", "Converts CV to MIDI CC and sends to an external device", "External MIDI" },
 { "Core", "VCV Core", "VCV", "VCV", "CV-Gate", "Gate to MIDI", "Converts gates to MIDI notes and sends to an external device", "External MIDI" },
 { "Core", "VCV Core", "VCV", "VCV", "Blank", "Blank", "A resizable blank panel", "Blank" },
 { "Core", "VCV Core", "VCV", "VCV", "Notes", "Notes", "Write text for patch notes or artist attribution", "Blank" },
 { "CosineKitty-Sapphire", "Sapphire", "Sapphire", "Don Cross", "Moots", "Moots", "Plugs/unplugs polyphonic cables.", "Controller Switch Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "AnalogueShiftRegister", "Analogue Shift Register", "A dual 4, or single 8, step shift register", "Sample and Hold" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Attenuator", "Attenuator", "Dual attenuator with attenuverting option", "Attenuator Dual Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BinarySequencer", "Binary Sequencer", "Binary counter based sequencer", "Clock generator Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BooleanAND", "Boolean AND Gate", "4 input boolean AND/NAND gate", "Logic Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BooleanOR", "Boolean OR Gate", "4 input boolean OR/NOR gate", "Logic Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BooleanVCNOT", "Boolean VC Inverter", "Dual voltage controlled logical inverter", "Logic Dual Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BooleanXOR", "Boolean XOR Gate", "4 input boolean XOR/XNOR gate", "Logic Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BurstGenerator", "Burst Generator", "Generates bursts of 1-16 pulses whenever a trigger is received at the trigger input", "Clock modulator Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Comparator", "Comparator", "Compares the input signal with either an internal or external threshold value and outputs gate signals based on the outcome.", "Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "CVSpreader", "CV Spreader", "Accepts \"Base\" and \"Spread\" CV inputs and creates a set of new CV values that are spread either side of the base value by an amount determined by the spread value.", "Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "EventArranger", "Event Arranger", "A VCV Rack implementation of the VC Clock and Event Arranger published in an article by John Blacet in the Jan/Feb edition of Synapse magazine", "Clock modulator Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "GateDelay", "Gate Delay", "A dual gate delay line giving up to 40 seconds of delay with voltage control over the delay time", "Delay Dual" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "GateModifier", "Gate Modifier", "Voltage controlled gate length modifier", "Logic Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "G2T", "G2T - Gate to Trigger Converter", "Gate to Trigger Converter", "Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Mangler", "Mangler", "A voltage controlled sample rate/bit depth reducer", "Distortion Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ManualCV", "Manual CV Generator", "A simple dual manual CV generator offering +/- 10V with both coarse and fine controls", "Dual Controller Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ManualGate", "Manual Gate", "A manually triggered gate generator offering a number of simultaneous gate and inverted gate outputs", "Utility Controller" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "MatrixMixer", "Matrix Mixer", "A 4 x 4 matrix mixer allowing up to 4 input signals to be independently mixed to 4 different outputs", "Mixer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "MinimusMaximus", "Minimus Maximus", "A signal processor that determines and outputs the minimum, maximum and mean (average) of up to 4 input signals", "Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Mixer", "Mixer", "A basic 4 input utility mixer with output level control, overload indicator, inverted output and selectable bipolar/unipolar operation", "Mixer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "MorphShaper", "Morph Shaper", "Morphing controller and wave shaper", "Utility Waveshaper" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Multiplexer", "Multiplexer", "A 1 input to 8 output and 8 input to 1 output multiplexer", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Mute", "Mute", "A voltage controlled mute", "Controller Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Mute-iple", "Mute-iple", "A dual 4-way/ Single 8 way mutable multiple", "Dual Multiple Controller Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Rectifier", "Rectifier", "A full/half wave rectifier with variable rectification axis", "Waveshaper Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SampleAndHold", "Sample & Hold", "Sample and Hold/Track and hold", "Sample and hold Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ShepardGenerator", "Shepard Generator", "Generates a set of 8 ramp and sawtooth control signals appropriately phased for generation of Shepard tones", "LFO Function generator Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SRFlipFlop", "Dual SR Flip Flop", "A dual logical Set/Reset flip flop with enable", "Logic Dual" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "StepSequencer8", "Dual 8 Step Sequencer", "Fully featured dual channel 8 step sequencer", "Sequencer Dual Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "TFlipFlop", "Dual T Flip Flop", "A dual logical T type (toggle) flip flop with enable", "Logic Dual" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "TriggerSequencer8", "Trigger Sequencer (8 Step)", "Quad 8 step trigger sequencer", "Quad Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "TriggerSequencer16", "Trigger Sequencer (16 Step)", "Quad 16 step trigger sequencer", "Quad Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "GateDelayMT", "Tapped Gate Delay", "A gate delay that offers up to 40 seconds of delay with tapped outputs at equal intervals along the delay line", "Delay" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "VCPolarizer", "Voltage Controlled Polarizer", "A dual voltage controlled polarizer", "Dual Polyphonic Attenuator Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "VoltageControlledSwitch", "Voltage Controlled Switch", "Selects between 2 inputs or routes 1 input to one of 2 outputs based on the level of the signal at the CV input", "Switch Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "VoltageInverter", "Voltage Inverter", "A quad voltage inverter that inverts signals around zero", "Utility Polyphonic Quad" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BasicSequencer8", "Basic 8 Step Sequencer", "Basic single channel 8 step sequencer", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerExpanderCV8", "Sequencer CV Expander", "8 step sequencer expander adding an extra channel of CV output", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerExpanderOut8", "Sequencer Output Expander", "8 step sequencer expander adding a gate output for each step", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerExpanderTrig8", "Sequencer Trigger Expander", "8 step sequencer expander adding a an extra channel of gate/trigger output", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SubHarmonicGenerator", "Sub Harmonic Generator ", "Fatten up a single oscillator with sub harmonics", "Waveshaper" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "VCFrequencyDivider", "Voltage Controlled Frequency Divider (Deprecated - Do Not Use)", "This module is no longer supported - use VC Frequency Divider instead", "Clock modulator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "VCFrequencyDividerMkII", "Voltage Controlled Frequency Divider MkII", "Frequency divider with a variable and voltage controlled division ratio from 1 to around 20", "Clock modulator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyrhythmicGenerator", "Polyrhythmic Generator  (Deprecated - Do Not Use)", "This module is no longer supported - use Polyrhythmic Generator MkII instead", "Clock modulator Sequencer Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyrhythmicGeneratorMkII", "Polyrhythmic Generator MkII", "A set of 8 voltage controlled clock dividers that can be used to generate polyrhythms by clocking and/or dividing at different rates", "Clock modulator Sequencer Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "GatedComparator", "Gated Comparator", "Gated Comparator", "Sequencer Random" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SlopeDetector", "Slope Detector", "Slope Detector", "Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerExpanderRM8", "Gated Comparator Expander - Random Melody", "Gated Comparator expander adding Random Melody output (also works with other sequencers)", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerExpanderLOG8", "Gated Comparator Expander - Gate Logic", "Gated Comparator expander adding logical mixing of the shift register outputs", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "StartupDelay", "Startup Delay", "Generates delayed start signals for sequencers on load or startup", "Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "RackEarLeft", "Left Hand Rack Ear", "A Left Hand Rack Ear", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "RackEarRight", "Right Hand Rack Ear", "A Right Hand Rack Ear", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Blank2HP", "Blank Panel - 2HP", "2HP blanking panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Blank4HP", "Blank Panel - 4HP", "4HP blanking panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Blank8HP", "Blank Panel - 8HP", "8HP blank panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Blank12HP", "Blank Panel - 12HP", "12HP blank panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Blank16HP", "Blank Panel - 16HP", "16HP blank panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Blank20HP", "Blank Panel - 20HP", "20HP blank panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Blank24HP", "Blank Panel - 24HP", "24HP blank panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "OffsetGenerator", "Offset Generator", "Offsets a CV signal by a given amount", "Utility Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Chances", "Chances - bernoulli gate", "Single bernoulli gate offering randomized routing of gate signals", "Random Logic Clock Modulator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Fade", "Fade-in/Fade-out and Record Controller", "Automated fade in/out with integrated start/stop control for the VCV Record module", "Controller Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "FadeExpander", "Fade-in/Fade-out Expander", "Adds sequencer start/stop and envelope outputs to the fade controller", "Controller Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerExpanderTSG", "Trigger Sequencer Gate Expander", "Adds gate outputs to the 8 and 16 Step Trigger Sequencers", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "VCPulseDivider", "Voltage Controlled Pulse Divider", "Voltage controlled division of pulse signals such as gates and triggers", "Clock modulator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ClockedRandomGates", "Clocked Random Gates", "Generates a set of 8 synchronised gates and triggers", "Clock Modulator Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ClockedRandomGateExpanderCV", "Clocked Random Gate CV Expander", "Generates CV based on the state of the random gates", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ClockedRandomGateExpanderLog", "Clocked Random Gate Logic Expander", "Logical processing of the gates from the Clocked Random Gates module", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Euclid", "Euclidean Sequencer", "Algorithmic trigger sequencer based on Euclidean division", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "EuclidExpanderCV", "Euclidean Sequencer Expander", "CV Expander for the Euclidean Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "VoltageScaler", "Voltage Scaler", "Rescale a voltage from one range to another", "Attenuator Utility Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyMinMax", "Polyphonic Min/Max", "Determines minimum and maximum values from a polyphonic CV input", "Utility Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Breakout", "Breakout", "Breaks polyphonic signals out to individual normalled output/input pairs", "Utility Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "GateSequencer8", "8 x 8 Gate Sequencer", "An 8 Channel 8 Step Gate/Trigger Sequencer", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "GateSequencer16", "8 x 16 Gate Sequencer", "An 8 Channel 16 Step Gate/Trigger Sequencer", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyMute", "Polyphonic Mute", "Polyphonic Manual/VC Mute", "Controller Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Sequencer16", "16 Step Sequencer", "16 Step Sequencer", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Sequencer8", "8 Step Sequencer", "8 Step Sequencer", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerChannel16", "16 Step Sequencer Channel Expander", "Adds another channel to the 16 Step Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerChannel8", "8 Step Sequencer Channel Expander", "Adds another channel to the 8 Step Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "MasterReset", "Master Reset Controller", "Master reset button and clock wrangler", "Clock modulator Controller Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyChances", "Polyphonic Bernoulli Gate", "Randomized routing of polyphonic gate signals", "Random Logic Clock Modulator Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyVCSwitch", "Polyphonic Voltage Controlled Switch", "Selects between 2 polyphonic inputs or routes 1 polyphonic input to one of 2 polyphonic outputs based on the level of the signal at the polyphonic CV input", "Switch Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyVCPolarizer", "Polyphonic VC Polarizer", "A polyphonic voltage controlled polarizer", "Polyphonic Attenuator Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyLogic", "Polyphonic Boolean Logic Processor", "Applies boolean logic across the channels of a polyphonic signal", "Polyphonic Logic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ManualCV2", "Polyphonic Manual CV Generator", "A basic manual CV generator with a range of output voltages", "Polyphonic Utility Controller" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Manifold", "Signal Manifold", "Replicates a mono/poly input signal to a selected number of channels in a poly output signal", "Multiple Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerGates8", "8 Step Sequencer Gate Output Expander", "Adds individual gate outputs to the 8 Step Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerGates16", "16 Step Sequencer Gate Output Expander", "Adds individual gate outputs to the 16 Step Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Attenuverter", "Attenuverter", "Attenuverter/Attenuator", "Utility Attenuator Polyphonic Controller" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyG2T", "gate to Trigger Converter", "Description.", "Utility Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Switch1To8", "Switch 1-8", "1 input to 8 output sequential/VC switch", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Switch8To1", "Switch 8-1", "8 input to 1 output sequential/VC switch/router", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Switch1To16", "Switch 1-16", "1 input to 16 output sequential/VC switch", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Switch16To1", "Switch 16-1", "16 input to 1 output sequential/VC switch/router", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerTriggers8", "8 Step Sequencer Trigger Output Expander", "Adds individual trigger outputs to the 8 Step Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequencerTriggers16", "16 Step Sequencer Trigger Output Expander", "Adds individual trigger outputs to the 16 Step Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BusRoute", "Bus Route", "Switched gate combiner/router", "Switch Logic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BusRoute2", "Bus Route", "Switched gate combiner", "Switch Logic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "MatrixCombiner", "Matrix Combiner", "Gate combiner/switched multiple", "Switch Logic Multiple" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "ClockDivider", "Clock Divider", "Clock divider with up/down mode and optional trigger outputs", "Clock modulator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BinaryComparator", "Binary Comparator", "Compares two binary words", "Logic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "EventTimer", "Countdown", "Clocked/realtime event counter with 3 digits", "Clock modulator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "EventTimer2", "Countdown 5", "Clocked/realtime event counter with 5 digits", "Clock modulator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Arpeggiator", "Super Arpeggiator", "Arpeggiator with user definable patterns", "Arpeggiator" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "HyperManiacalLFO", "Hyper Maniacal LFO", "Complex LFO", "LFO" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "HyperManiacalLFOExpander", "Hyper Maniacal LFO Output Expander", "Individual Outputs for the Hyper Maniacal LFO", "LFO Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "LightStrip", "Light Strip", "Illuminated Blanking Panel", "Blank" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Megalomaniac", "Megalomaniac - Hyper Maniacal LFO CV Expander", "Voltage control over the Hyper Maniacal LFO", "LFO Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SingleTFlipFlop", "T Flip Flop", "A logical T type (toggle) flip flop with enable", "Logic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SingleSRFlipFlop", "SR Flip Flop", "A logical Set/Reset flip flop with enable", "Logic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Switch2", "Manual DPDT Switch", "Manually switch between 2 inputs", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Switch3", "Manual 3 Input Switch", "Manually select any one of 3 inputs", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Switch4", "Manual 4 Input Switch", "Manually select any one of 4 inputs", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Carousel", "Carousel Rotating Router", "Sequentially rotate up to 8 inputs through up to 8 outputs", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "OctetTriggerSequencer", "Octet Trigger Sequencer", "Binary octet based trigger sequencer", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "OctetTriggerSequencerCVExpander", "Octet Trigger Sequencer CV Expander", "Adds a CV channel to the Octet Trigger Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "BarGraph", "Bar Graph", "Linear Bar Graph Meter", "Utility Visual" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Oscilloscope", "Quad Trace Oscilloscope", "Quad trace oscilloscope.", "Utility Visual" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SingleDFlipFlop", "D Flip Flop", "A logical D type flip flop with clock enable", "Logic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "OctetTriggerSequencerGateExpander", "Octet Trigger Sequencer Gate Expander", "Adds individual gate outputs to the Octet Trigger Sequencer", "Sequencer Expander" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Mult", "Multiple", "Normalled polyphonic multiple", "Multiple Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "PolyGateModifier", "Poly Gate Modifier", "Polyphonic voltage controlled gate length modifier", "Logic Utility Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SampleAndHold2", "Super Sample & Hold", "Sample and Hold/Track and hold with probability, offset and inbuilt noise source", "Sample and hold Polyphonic" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "Palette", "Cable Palette", "Cable colour picker", "Utility" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "SequenceEncoder", "4Bit Sequence Encoder", "Binary addressed encoder for sequencer expanders", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "NibbleTriggerSequencer", "Nibble Trigger Sequencer", "Binary nibble based trigger sequencer", "Sequencer" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "RandomAccessSwitch18", "Random Access Switch 1-8", "Random access switch 1 input to 8 output", "Switch" },
 { "CountModula", "Count Modula", "Count Modula", "Adam Verspaget", "RandomAccessSwitch81", "Random Access Switch 8-1", "Random access switch 8 inputs to 1 output", "Switch" },
 { "CrystalPalace", "Crystal Palace", "Crystal Palace", "David Peterson", "Perspex", "Perspex", "Revolving 16-channel mixer", "Mixer" },
 { "cvly", "cvly", "cvly", "Benja Appel", "brst", "brst", "Burst generator with up to 8 outputs", "poly sample and hold sequencer switch" },
 { "cvly", "cvly", "cvly", "Benja Appel", "bss", "bss", "Generates a bass note for the incoming poly input, using one of three modes", "poly quantizer sample and hold utility" },
 { "cvly", "cvly", "cvly", "Benja Appel", "crcl", "crcl", "Quantizer/sequencer based on the circle of fifths", "quantizer poly sample and hold sequencer" },
 { "cvly", "cvly", "cvly", "Benja Appel", "ntrvlc", "ntrvlc", "4x8 sequencer with incorporated quantizer", "quantizer poly sequencer" },
 { "cvly", "cvly", "cvly", "Benja Appel", "ntrvlx", "ntrvlx", "ntrvlc expander with output triggers and stacking configuration", "expander" },
 { "cvly", "cvly", "cvly", "Benja Appel", "spc", "spc", "Spreads the notes for incoming poly input, with a settable minimum interval distance", "quantizer poly utility" },
 { "cvly", "cvly", "cvly", "Benja Appel", "stpr", "stpr", "Sequencer with switches for each step", "sequencer switch" },
 { "cvly", "cvly", "cvly", "Benja Appel", "txt", "txt", "Informative expander for all cvly modules", "expander utility" },
 { "cvly", "cvly", "cvly", "Benja Appel", "vbrt", "vbrt", "Multiple pitch voltage detuner with incorporated per-channel LFO", "multiple lfo poly" },
 { "cvly", "cvly", "cvly", "Benja Appel", "whl", "whl", "3hp blank panel with cvly whale logo", "blank" },
 { "CYC", "Strong Kar", "CYC", "Alexander Letourneau", "cyc-strong_kar", "Strong Kar", "Implementation of the Karplus-Strong algorithm", "VCO" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "Wavulike", "Wavulike", "[12hp] VCO based on generated waveform", "Oscillator Low-frequency oscillator" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "TMNT", "TMNT", "[34hp] Timed Mutating Non-Linear Triggers", "Clock generator Sequencer" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "5Splice", "5Splice", "[4hp] Window mixer for up to 5 inputs", "Mixer Switch" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "PKorre", "PKorre", "[6hp] CV source based on correlation between two signals", "Utility" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "Kanal", "Kanal", "[6hp] Waveshaper", "Utility" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "BillyG8s", "Billy G8s", "[10hp] Gates Generator", "Utility" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "BrightIdea", "Bright Idea", "[4hp] CV control over cable opacity & tension, room brightness & light bloom", "Utility" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "Nonaquant", "Nonaquant", "[40hp] Quantizer across 9 octaves", "Quantizer" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "Chromagica", "Chromagica", "[2hp] ARGB CV controller for Magical CV plugin theme", "Utility Visual" },
 { "DanTModules", "DanTModules", "DanT", "dtilley", "Chromakey", "Chromakey", "[vari-hp] Blank that can change panel size & colour", "Visual" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "NavControl", "NavControl", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Bench", "Bench", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Contorno", "Contorno", "", "Envelope Generator" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Transpose", "Transpose", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Utility", "Utility", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Chord", "Chord", "", "Quantizer" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Bene", "Bene", "", "Sequencer" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "BenePads", "BenePads", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "PerfMixer", "PerfMixer", "", "Mixer VCA" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "PerfMixer4", "PerfMixer4", "", "Mixer VCA" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "DrMix", "DrMix", "", "Mixer VCA" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Remix", "Remix", "", "Mixer VCA" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Smixer", "Smixer", "", "Mixer VCA" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "VCA4", "VCA4", "", "Mixer VCA" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "VCA530", "VCA530", "", "Mixer VCA" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Verbo", "Verbo", "", "VCO" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "DVCO", "DVCO", "", "VCO" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "DAOSC", "DAOSC", "", "VCO" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "TROSC", "TROSC", "", "VCO" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "TROSCMK2", "TROSCMK2", "", "VCO" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "SuHa", "SuHa", "", "VCO" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "SuHaMK2", "SuHaMK2", "", "VCO" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "FourSeq", "FourSeq", "", "Sequencer" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Divider", "Divider", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Util2", "Util2", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Smorph", "Smorph", "", "Sequencer" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "BigSmorph", "BigSmorph", "", "Sequencer" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "QuePasa", "QuePasa", "", "Filter" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "DualFilter", "DualFilter", "", "Filter" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "Order", "Order", "", "Utility" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "DualMatrix", "DualMatrix", "", "Mixer" },
 { "dBiz", "dBiz", "dBiz", "Giovanni Ghisleni", "SPan", "SPan", "", "VCA" },
 { "dbRackFormulaOne", "dbRackFormulaOne", "docB", "docB", "FormulaOne", "Formula One", "A fast script evaluator", "Polyphonic" },
 { "dbRackFormulaOne", "dbRackFormulaOne", "docB", "docB", "FormulaOneEdit", "FormulaOneEdit", "Expander for editing scripts", "Expander" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "GeneticTerrain", "GeneticTerrain", "Genetic Wave Terrain Synthesis", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "GeneticSuperTerrain", "GeneticSuperTerrain", "Genetic Wave Terrain Synthesis with Superformula Curves", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "DCBlock", "DCBlock", "A stereo polyphonic dc blocker", "Filter Polyphonic Effect" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "RndHvs3", "RND-HVS3", "A Random Value Cube", "Random" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "JTScaler", "JTScaler", "Tunes standard V/OCT pitches to Just Intonation Scales", "Utility Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "AddSynth", "AddSynth", "A two dimensional additive synth voice", "Oscillator" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "RndH", "RndH", "Polyphonic Random Hold", "Random Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "RndC", "RndC", "Polyphonic RandomLFO with cubic interpolation", "Polyphonic Random" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "GenScale", "GenScale", "Generates a polyphonic Scale", "Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "JTKeys", "JTKeys", "Just Intonation Keyboard", "Utility Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Hopa", "Hopa", "Hopalong Attractor", "Random" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Frac", "Frac", "Outputs expansions of integer fractions", "Sequencer" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "HexSeq", "HexSeq", "A Sequencer using compact hexadecimal strings for trigger sequencing", "Sequencer" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Interface", "Interface", "Create an interface for a selection of connected modules", "Utility" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "HexSeqP", "HexSeqP", "A 16x16x64 Trigger Sequencer", "Sequencer Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "MVerb", "MVerb", "5x5 Waveguide Mesh Reverb", "Reverb Effect" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "PShift", "PShift", "Pitch Shifter", "Effect" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "FLA", "FLA", "applies integer arithmetic to a CV signal", "Distortion" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "FLL", "FLL", "applies integer bit operations to a CV signal", "Distortion" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Gendy", "Gendy", "Iannis Xenakis GENDYN Simulation", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "RTrig", "RTrig", "Random Deviation Trigger", "Random Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "STrig", "STrig", "Polyphonic Schmitt-Trigger", "Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "RSC", "RSC", "Reverb", "Reverb Effect" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Pad", "Pad", "PadSynth", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Pad2", "Pad2", "PadSynth with smooth control", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "RndG", "RndG", "Random Gates", "Random Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Plotter", "Plotter", "Plots a 2D signal", "Visual" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "SuperLFO", "SuperLFO", "2D LFO for superformula curves", "Oscillator Low-frequency Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "HexSeqExp", "HexSeqExp", "Gate, clock and inverted outputs for HexSeq", "Expander" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "PHSR", "PHSR", "Phasor", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "PhS", "PhS", "Phase Shaper", "Waveshaper Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "SPL", "SPL", "Spline wave oscillator with phase input", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "PhO", "PhO", "Phase driven additive oscillator", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Faders", "Faders", "Three polyphonic slider banks with modulation and value grids", "Controller Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "YAC", "YAC", "Yet another chorus, this one can be modulated", "Chorus" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "PLC", "PLC", "Poly Controller", "Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "MPad2", "\u00b5Pad2", "Micro Pad2", "Oscillator" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "PHSR2", "PHSR2", "Advanced Phasor with Line Segments and FM", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "Ratio", "Ratio", "Ratio scaling for FM", "Utility Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "CSOSC", "CSOSC", "Cosine Oscillator", "Oscillator Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "EVA", "EVA", "ADSR with integrated VCA", "Envelope Generator Voltage Controlled Amplifier Polyphonic" },
 { "dbRackModules", "dbRackModules", "docB", "docB", "BWF", "BWF", "A brickwall filter", "Effect Filter Polyphonic" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "JTChords", "JTChords", "Just Intonation Chords", "Utility Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "Chords", "Chords", "Chord Sequencer", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "AG", "AG", "Voltage addressable Gate Patterns", "Polyphonic Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "ACC", "ACC", "Accumulator", "Utility" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "CV", "CV", "CV Source for Sequencing", "Utility" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "Klee", "Klee", "A Klee like sequencer", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "M851", "M851", "M851 Sequencer", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "CYC", "CYC", "A cyclic sequencer", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "PwmClock", "PwmClock", "Clock generator with nine configurable clocks with adjustable pwm", "Clock generator" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "TD4", "TD4", "A building block for 4x4 sequencers", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "P16", "P16", "One hundred permutations of 16 steps", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "P4", "P4", "Permutations of 4 steps", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "PXY", "PXY", "2D Cartesian Sequencer", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "C42", "C42", "An universal Sequencer with up to 16 play heads and cellular automation", "Sequencer Polyphonic" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "C42E", "C42E", "C42 Expander", "Expander" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "Sum", "Sum", "Expandable Polyphonic Adder, Mixer ", "Utility" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "SE", "SE", "Expander for Sum", "Expander" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "Uno", "Uno", "A step sequencer with random skip function", "Sequencer" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "UnoE", "UnoE", "Expander for Uno", "Expander" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "TheMatrix", "TheMatrix", "A 32x32 Grid ASCII Sequencer with up to 16 play heads", "Sequencer Polyphonic" },
 { "dbRackSequencer", "dbRackSequencer", "docB", "docB", "N3", "N3", "A trigger sequencer", "Sequencer" },
 { "DelexanderVol1", "Delexander Volume 1", "Delexander", "Delexander Collective", "Algomorph", "Algomorph", "4-Channel Multistate Router with Morphing and Graph Visualization", "Mixer Multiple Polyphonic Quad Utility Visual" },
 { "DelexanderVol1", "Delexander Volume 1", "Delexander", "Delexander Collective", "AlgomorphSmall", "Algomorph Pocket", "Miniature 4-Channel Multistate Router with Morphing and Graph Visualization", "Mixer Multiple Polyphonic Quad Utility Visual" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Blossom", "Blossom", "Generates a pair of complex, pulsing LFO signals", "LFO" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "BoosterStage", "Booster Stage", "Generates a single envelope stage", "Envelope Generator" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Buttons", "Buttons", "8 buttons with overrides", "Utility" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Cubic", "Cubic", "Offsets, scales, squares, and cubes its input signal", "Waveshaper" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "CurveSequencer4", "Curve Sequencer 4", "Generates a 4 step sequence of curves", "Sequencer Envelope Generator LFO" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "CurveSequencer8", "Curve Sequencer 8", "Generates an 8 step sequence of curves", "Sequencer Envelope Generator LFO" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "CurveSequencer16", "Curve Sequencer 16", "Generates a 16 step sequence of curves", "Sequencer Envelope Generator LFO" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "FuzzyLogicH", "Fuzzy Logic H", "Combines signals by applying hyperbolic paraboloid fuzzy logic operators", "Logic Dual" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "FuzzyLogicZ", "Fuzzy Logic Z", "Combines signals by applying Lofti Zadeh\u2019s fuzzy logic operators", "Logic Dual" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Func", "Func", "A knob with a selectable range to offset or scale its input signal", "Utility" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Func6", "Func 6", "A chain of knobs with selectable ranges to offset and scale input signals", "Utility" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Gator", "Gator", "Computes eight common logic functions for up to 16 inputs", "Logic" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Hostage", "Hostage", "Generates a hold or sustain envelope stage", "Envelope Generator" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Ranger", "Ranger", "A modulatable knob with an adjustable, modulatable range", "Utility" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Scannibal4", "Scannibal 4", "A 4 step scanned sequencer", "Sequencer Envelope Generator LFO" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Scannibal8", "Scannibal 8", "An 8 step scanned sequencer", "Sequencer Envelope Generator LFO" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Scannibal16", "Scannibal 16", "A 16 step scanned sequencer", "Sequencer Envelope Generator LFO" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Sequencizer4", "Sequencizer 4", "Generates a highly customizable 4 step sequence", "Sequencer Envelope Generator LFO Sample and Hold" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Sequencizer8", "Sequencizer 8", "Generates a highly customizable 8 step sequence", "Sequencer Envelope Generator LFO Sample and Hold" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Sequencizer16", "Sequencizer 16", "Generates a highly customizable 16 step sequence", "Sequencer Envelope Generator LFO Sample and Hold" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Stage", "Stage", "Generates a single envelope stage", "Envelope Generator" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Swave", "Swave", "A waveshaper with a unique sigmoid transfer function", "Waveshaper" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Tapers", "Tapers", "A pair of modulatable knobs with adjustable, modulatable tapers", "Dual Utility" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Truth2", "Truth 2", "Applies a customizable truth table to 2 inputs", "Logic" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Truth3", "Truth 3", "Applies a customizable truth table to 3 inputs", "Logic" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Truth4", "Truth 4", "Applies a customizable truth table to 4 inputs", "Logic" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Upstage", "Upstage", "Special-purpose envelope controls", "Envelope Generator" },
 { "DHE-Modules", "DHE Modules", "", "Dale Emery", "Xycloid", "Xycloid", "Generates a pair of complex, pulsing LFO signals", "LFO" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V100-Scanner", "V100 Scanner", "CV and voltage-control source sequencer / scanner", "Random Sequencer Utility" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V101-Dual_Envelope", "V101 Dual Envelope", "Dual ADSR, AR and LFO Generator", "Dual Envelope generator LFO Hardware" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V102-Output_Mixer", "V102 Output Mixer", "Four Input Mixer with Pan Pots and Output Level Meter", "Mixer Pan Quad Utility Hardware" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V103-Reverb_Delay", "V103 Reverb Delay", "Stereo Reverb and Delay Digital Effects Processor", "Delay Digital Effect Hardware Reverb" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V104-Four_Vs", "V104 Four Vs", "Four Channel Voltage Source", "Controller Hardware Quad Utility" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V105-Quad_CV_Proc", "V105 Quad CV Proc", "Quad Control Voltage Processor", "Attenuator Mixer Quad Hardware" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V107-Dual_Slew", "V107 Dual Slew", "Dual Slew Rate Limiter", "Dual Hardware Slew limiter" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V201-Tri_Comparator", "V201 Tri Comparator", "Analog Comparator Functions", "Logic Utility" },
 { "Dintree-Virtual", "Dintree", "Dintree", "Andrew Kilpatrick", "V218-SH-Clock-Noise", "V218 SH Clock Noise", "Sample and Hold, Clock and Noise Generator", "Clock Function generator Noise Random S&H Utility" },
 { "DivergentWaves", "Divergent Waves", "Divergent Waves", "Tom Carlson", "Logic", "Logic", "Fixed-function Logic Processor", "Logic Hardware Hardware clone" },
 { "Doepfer", "Doepfer", "Doepfer", "VCV", "A124", "A-124 VCF5 Wasp Filter", "2-pole CMOS-based state-variable filter", "Filter Polyphonic" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "BassDrum9", "Bass Drum 9", "Bass Drum Kit based on 909", "Drum" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "ClosedHiHat", "Closed HiHat", "HiHat Module", "DRUM" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "CR78", "CR78", "CompuRhythm 78 Kit", "DRUM" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "DMX", "DMX", "DMX Drum Kit", "Drum" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "OpenHiHat", "Open HiHat", "HiHat Module", "Drum" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "SyntheticBassDrum", "Synthetic Bass Drum", "Synthetic Bass Drum", "Drum" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "SnareDrumN", "Snare Drum N", "Snare Drum Kit based on Novation Drumstation", "Drum" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "Tomi", "Tomi", "Tom Drum Kit Module", "Drum" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "Gnome", "Gnome", "Gnome Clock Module", "Clock generator" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "Sequencer", "Sequencer", "Drum Focused Step Sequencer", "Sequencer" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "Baronial", "Baronial", "Drum Focused Envelope Generator", "Envelope generator" },
 { "DrumKit", "DrumKit", "SV Modular", "SV Modular", "MarionetteBass", "Marionette Bass", "Hybrid Bass Drum", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "Kick", "Kick+", "DrumKit Pro Kick+", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "Snare", "Snare+", "DrumKit Pro Snare+", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "HiHat", "HiHat+", "DrumKit Pro HiHat+", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "Tom", "Tom+", "DrumKit Pro Tom+", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "EDrum", "E-Drum", "DrumKit Pro E-Drum", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "Tek", "Tek", "DrumKit Pro Tek", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "MarionetteBass", "Marionette Bass+", "DrumKit Pro Marionette Bass+", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "Bomb", "Marionette Boom", "DrumKit Pro Boom Drum Synthesizer", "Drum" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "Shp", "Shp", "Envelope Shaper", "Envelope" },
 { "DrumKitPro", "DrumKit Pro", "SV Modular", "Jerry Sievert", "Baronial", "Baronial+", "DrumKit Pro Baronial+ Envelope Generator", "Envelope" },
 { "Edge", "Edge", "Edge", "Edge", "WCO_Osc", "WCO_Osc", "Window-Controlled Oscillator", "VCO Polyphonic" },
 { "Edge", "Edge", "Edge", "Edge", "K_Rush", "K_Rush", "WaveTable Crusher", "Distortion" },
 { "Edge", "Edge", "Edge", "Edge", "Bad_Haas", "Bad_Haas", "Haas Effect Panning", "Delay" },
 { "EH_modules", "EH-modules", "", "Eduard Heidt", "FV-1emu", "FV-1.emu", "Spin Semi FV-1 DSP chip emulator", "Effect" },
 { "EnigmaCurry", "EnigmaCurry", "EnigmaCurry", "EnigmaCurry", "Transport", "Transport", "A DAW-like transport for play/stop/record", "Utility Recording" },
 { "EnigmaCurry", "EnigmaCurry", "EnigmaCurry", "EnigmaCurry", "Latch", "Latch", "Latches with discrete triggers and resets", "Utility Polyphonic Dual Switch" },
 { "Entrian-AcousticDrums", "Entrian Acoustic Drums", "Entrian", "Entrian Solutions Ltd", "AcousticDrums", "Acoustic Drums", "Real acoustic drums, sampled with multiple round-robin samples in multiple velocity layers.", "Drum" },
 { "Entrian-AcousticDrums", "Entrian Acoustic Drums", "Entrian", "Entrian Solutions Ltd", "Drummer", "Drummer", "Trigger sequencer for expressive drum grooves.", "Drum Sequencer MIDI Random Recording" },
 { "Entrian-Free", "Entrian Free", "Entrian", "Entrian Solutions Ltd", "Follower", "Pitch and Envelope Follower", "Converts sounds into pitch and volume CV signals.", "Utility Visual Envelope Follower" },
 { "Entrian-Free", "Entrian Free", "Entrian", "Entrian Solutions Ltd", "Player-Drummer", "Player: Drummer", "Trigger sequence player for MIDI files and Entrian Sequencer songs.", "Drum Sequencer MIDI Random Recording" },
 { "Entrian-Free", "Entrian Free", "Entrian", "Entrian Solutions Ltd", "Player-Melody", "Player: Melody", "Piano roll melody and chord player for MIDI files and Entrian Sequencer songs.", "Sequencer Polyphonic MIDI Random Recording" },
 { "Entrian-Free", "Entrian Free", "Entrian", "Entrian Solutions Ltd", "Player-Timeline", "Player: Timeline", "DAW-style timeline player for MIDI files and Entrian Sequencer songs.", "Sequencer Polyphonic MIDI Random Recording" },
 { "Entrian-Sequencers", "Entrian Sequencers", "Entrian", "Entrian Solutions Ltd", "Drummer", "Drummer", "Trigger sequencer for expressive drum grooves.", "Drum Sequencer MIDI Random Recording" },
 { "Entrian-Sequencers", "Entrian Sequencers", "Entrian", "Entrian Solutions Ltd", "Melody", "Melody", "Piano roll melody and chord sequencer.", "Sequencer Polyphonic MIDI Random Recording" },
 { "Entrian-Sequencers", "Entrian Sequencers", "Entrian", "Entrian Solutions Ltd", "CV", "CV", "Multi-segment multi-channel CV sequencer and graphical editor.", "Sequencer Polyphonic MIDI Random Recording" },
 { "Entrian-Sequencers", "Entrian Sequencers", "Entrian", "Entrian Solutions Ltd", "Timeline", "Timeline", "DAW-style timeline sequencer.", "Sequencer Polyphonic MIDI Random Recording" },
 { "EricaCopies", "Erica Synths", "Erica Synths", "Erica Synths", "BlackWaveTableVCO", "Black WaveTable VCO", "Erica Synths Wavetable oscillator", "VCO Hardware clone" },
 { "EricaCopies", "Erica Synths", "Erica Synths", "Erica Synths", "BlackOctasource", "Black Octasource", "Erica Synths Octa LFO", "LFO Hardware clone" },
 { "EricaCopies", "Erica Synths", "Erica Synths", "Erica Synths", "PicoDrums", "Pico Drums", "Erica Synths Drum sampler", "DRUMS Hardware clone" },
 { "EricaCopies", "Erica Synths", "Erica Synths", "Erica Synths", "FusionDelay", "Fusion Delay", "Erica Synths BBD delay", "EFFECT DELAY Hardware clone" },
 { "ESeries", "E-Series", "", "VCV", "E340", "E340 Cloud Generator", "Based on Synthesis Technology E340", "VCO Polyphonic Hardware clone" },
 { "EucQuant", "EucQuant", "EucQuant", "brian", "EdoQuant", "EdoQuant", "n-EDO quantizer for generating xenharmonic melodies with CV", "quantizer" },
 { "ExpertSleepers-Encoders", "Encoders", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-Encoders-8CV", "8CV Encoder", "", "External" },
 { "ExpertSleepers-Encoders", "Encoders", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-Encoders-8GT", "8GT Encoder", "", "External" },
 { "ExpertSleepers-Encoders", "Encoders", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-Encoders-ES5", "ES-5 Encoder", "", "External" },
 { "ExpertSleepers-Encoders", "Encoders", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-Encoders-ES40", "ES-4(0) Encoder", "", "External" },
 { "ExpertSleepers-Encoders", "Encoders", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-Encoders-Calibrator", "Calibrator", "", "External" },
 { "ExpertSleepers-Encoders", "Encoders", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-Encoders-SMUX", "SMUX", "", "External" },
 { "ExpertSleepers-SilentWay", "Silent Way", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-SilentWay-VoiceController", "Voice Controller", "", "External" },
 { "ExpertSleepers-SilentWay", "Silent Way", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-SilentWay-ACEncoder", "AC Encoder", "", "External" },
 { "ExpertSleepers-SilentWay", "Silent Way", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-SilentWay-CVInput", "CV Input", "", "External" },
 { "ExpertSleepers-SilentWay", "Silent Way", "Expert Sleepers", "Andrew Ostler", "ExpertSleepers-SilentWay-CVToMIDI", "CV To MIDI", "", "External Polyphonic" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Modulo", "Modulo", "Adjustable modulo operator for octave-stripping and waveshaping.", "utility waveshaper polyphonic" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Opabinia", "Opabinia", "Primitive bassdrum, also accepts audio input for distortion and waveshaping.", "Drum Envelope generator Distortion waveshaper polyphonic" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Splitterburst", "Splitterburst", "Tempo multiplier and gate generator, perfect for snare-rushes.", "Clock modulator utility" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Puzzlebox", "Puzzlebox", "Confusing mystery module. Fun.", "logic visual" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Darwinism", "Hallucigenia", "Evolving, mutating random sequencer with memory - ideal for generative patches!", "Sequencer Random Polyphonic" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Ichneumonid", "Ichneumonid", "Switch randomly (or deterministically) between signals without creating discontinuities.", "Random Switch" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Meganeura", "Meganeura", "Tempo multipliers - ideal for making Speedcore.", "Clock Modulator" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Pureneura", "Mononeura", "Tempo multipliers - nothing else.", "Clock Modulator" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Mesoglea", "Mesoglea", "Flippable polyphonic gates and/or mutes with sample-and-hold options.", "Sample and hold Utility Polyphonic" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Mesohyl", "Mesohyl", "Easy knobs with built-in S&H powers.", "Sample and hold Utility Controller" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "Mesoglea2", "Mesoglea2", "Easy flippable gates/mutes with sample-and-hold.", "Sample and hold Utility Controller" },
 { "Extratone", "Extratone", "XTRTN", "Eater of Sheep", "XtrtnBlank", "Heraldry", "3600BPM Cult. Esoteric meme heraldry.", "Blank" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "PSIOP", "PSI OP", "FM Percussion Synth", "Oscillator Drum Synth voice" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Planck", "Planck", "Bit Depth and Sample Rate Crusher", "Effect Polyphonic" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Luigi", "Luigi", "Random Clock and Noise/Dust Generator", "noise random" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Aspect", "Aspect", "Clock Dividers and Sequential Sequencer", "Clock modulator" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Monte", "Monte", "Probabalistic Clock Generator", "Sequencer" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Arpanet", "Arpanet", "1601 Sequencer", "Sequencer" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Sigma", "Sigma", "Fixed Voltage Adder", "Utility Polyphonic" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Fax", "Fax", "CV Recording Sequencer", "Sequencer Recording Polyphonic" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Rasoir", "Rasoir", "Asymmetrical Voltage Processor", "Effect Waveshaper Slew Limiter Delay" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Chi", "Chi", "3 Band Crossover", "Equalizer Filter Poly" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Nova", "Nova", "Cut-up Sequenced Sampler", "Sampler Sequencer Random" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Lilt", "Lilt", "Phase-Shifted Shuffling Clock Pair", "Clock" },
 { "FehlerFabrik-Suite", "Fehler Fabrik", "Fehler Fabrik", "Ross Cameron", "Botzinger", "Botzinger", "Arbitrary Rhythm Generator", "Sequencer" },
 { "FLAG-Free", "FLAG Free", "FLAG", "Flag Audio", "Electric-Ensemble", "Electric Ensemble", "Chorus Ensemble", "Chorus Effect Distortion Filter" },
 { "FLAG-Free", "FLAG Free", "FLAG", "Flag Audio", "Tap-Dancer", "Tap Dancer", "Multi-Tap Delay with Modulation", "Delay Effect Distortion Filter" },
 { "FLAG-Free", "FLAG Free", "FLAG", "Flag Audio", "Thorns", "Thorns", "Multiband Saturation", "Effect Distortion Dynamics Limiter Waveshaper" },
 { "FLAG-Free", "FLAG Free", "FLAG", "Flag Audio", "Oppressor", "Oppressor", "Multiband Ducker and Compressor", "Dynamics Compressor Effect Filter" },
 { "FLAG-Free", "FLAG Free", "FLAG", "Flag Audio", "Stems", "Stems", "Multi Channel Stem Player", "Sampler Polyphonic" },
 { "FLAG-Free", "FLAG Free", "FLAG", "Flag Audio", "Prodigal-Son", "Prodigal Son", "Band Limited Super-Saw Oscillator with Amplitude Envelope", "Oscillator Polyphonic" },
 { "FLAG-Oppressor-Pro", "FLAG Oppressor Pro", "FLAG", "Flag Audio", "Oppressor-Pro", "Oppressor Pro", "Multiband Ducker/Gate/Compressor", "Dynamics Compressor Effect Filter Vocoder" },
 { "FLAG-Oppressor-Pro", "FLAG Oppressor Pro", "FLAG", "Flag Audio", "Oppressor-Pro-Env", "Oppressor Pro Env", "Multiband Envelope Follower", "Envelope follower Envelope generator" },
 { "forsitan", "forsitan modulare", "forsitan modulare", "Giampaolo Guiducci", "alea", "alea", "Add a random module to your rack", "utility random" },
 { "forsitan", "forsitan modulare", "forsitan modulare", "Giampaolo Guiducci", "interea", "interea", "Make a chord from a V/Oct input, with quality, voicing and inversion. Harmonize option.", "utility" },
 { "forsitan", "forsitan modulare", "forsitan modulare", "Giampaolo Guiducci", "cumuli", "cumuli", "Accumulator with up and down gates and rates.", "Envelope generator" },
 { "forsitan", "forsitan modulare", "forsitan modulare", "Giampaolo Guiducci", "deinde", "deinde", "Quad cascading addressable attack-hold envelope.", "Envelope generator Quad" },
 { "forsitan", "forsitan modulare", "forsitan modulare", "Giampaolo Guiducci", "pavo", "pavo", "Spreader of polyphonic mono signals across the stereo field (Splay Ugen).", "Panning Polyphonic" },
 { "FrankBuss", "Frank Buss", "", "Frank Buss", "Formula", "Formula", "Formula for CV and audio", "Utility Polyphonic" },
 { "FrankBuss", "Frank Buss", "", "Frank Buss", "Shaker", "Shaker", "Shake your Rack", "Visual" },
 { "FreeSurface", "Causal Systems", "Free Surface", "Free Surface", "FreeSurface-WaterTable", "WaterTable", "Physical modeling system with a fully analog design", "Distortion Filter Panning Ring modulator Physical modeling" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "BallOfConfusion", "Ball of Confusion", "Spherical Morphing Wavetable Oscillator", "Oscillator Digital Sampler Polyphonic" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "BoxOfRevelation", "Box of Revelation", "3 Dimensional Cube Filter", "Filter Effect" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "DanceThisMeshAround", "Dance This Mesh Around", "Multi-Dimensional Digital Waveguide Oscillator", "Oscillator Effect Physical modeling" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "DelayedReaction", "Delayed Reaction", "Spectrum based delay", "Delay Effect" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "FreudianSlip", "Freudian Slip", "Resynthesizing Sampler", "Synth voice Sampler" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "GrainsOfWrath", "Grains Of Wrath", "Spewer of Grains of varying dispositions", "Granular Sampler Effect Polyphonic" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "HarmonicConvergence", "Harmonic Convergence", "Resynthesis Engine", "Synth voice" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "HeatOfTheMoment", "Heat Of The Moment", "Impulse Generator", "Noise" },
 { "FrequencyDomain", "Frequency Domain", "Frequency Domain", "almostEric with JerrySV, Jatin Chowdhury", "Morphology", "Morphology", "Spectral Morpher", "Vocoder Effect" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "BPMLFO", "BPM LFO", "Beat Synchronized LFO", "Low-frequency oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "BPMLFO2", "BPM LFO 2", "Beat Synchronized LFO with CV Waveshape", "Low-frequency oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "BPMLFOPhaseExpander", "BPM LFO Phase Expander", "Add multiple phased outputs to BMPLFO and BPMLFO 2", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "CDCSeriouslySlowLFO", "CDC Seriously Slow LFO", "Slow LFO taken to absurdity", "Low-frequency oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "DamianLillard", "Damian Lillard", "4-channel CV crossover/mixer", "Voltage-controlled amplifier" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "DrunkenRampage", "Drunken Rampage", "Probalistic Dual ramp generator. Inspired by Befaco Rampage.", "Function Generator Logic Slew Limiter Envelope Follower Dual Random" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "FillingStation", "Filling Station", "Multi-Output Sequencer", "Sequencer" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "EverlastingGlottalStopper", "Everlasting Glottal Stopper", "Vocal Tract simulating VCO", "Oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "TheGardener", "The Gardener", "Sequencer Controller", "Clock Modulator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "HairPick", "Hair Pick", "64 Tap Rhythmic Comb Filter", "Filter" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "JustAPhaser", "Just A Phaser", "Advanced Phaser", "Phaser" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "LissajousLFO", "Lissajous LFO", "LFO based on interactions of 4 sine waves", "Low-frequency oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "ManicCompression", "Manic Compression", "Fun Compressor", "Compressor Dynamics" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "ManicCompressionMB", "Megalomanic Compression", "Fun Multi-Band Compressor", "Compressor Dynamics" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "Midichlorian", "Midichlorian", "Microtonal CV-MIDI", "MIDI Polyphonic" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "MidiRecorder", "MIDI Recorder", "MIDI Gate Recorder", "MIDI Polyphonic Recording Utility" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "MrBlueSky", "Mr. Blue Sky", "16 band vocoder", "Vocoder" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "TheOneRingModulator", "The One Ring Modulator", "Ring Modulator with CV controlable response", "Ring Modulator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "PhasedLockedLoop", "Phased Locked Loop", "PLL attempts to follow input signals freqency", "Oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "PortlandWeather", "Portland Weather", "16 tap rhythmic delay with per tap pitch shifting and filtering", "Delay Granular Filter" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "ProbablyNote", "Probably Note", "Probabilistic Quantizer", "Quantizer Random Polyphonic" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "ProbablyNoteArabic", "Probably Note - Arabic", "Probabilistic Quantizer using Arabic maqams, ajnas and sayrs", "Quantizer Random" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "ProbablyNoteBP", "Probably Note - Bohlen Pierce", "Probabilistic Quantizer using Bohlen Pierce scales and tuning", "Quantizer Random Polyphonic" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "ProbablyNoteMN", "Probably Note - Math Nerd", "Probabilistic Quantizer using prime number based generative scales", "Quantizer Random Polyphonic" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "PNChordExpander", "Probably Note - Chord Expander", "Adds Chord Generation to Probably Not(e)", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "PNOctaveProbabilityExpander", "Probably Note - Octave Probability Expander", "Adds Multi-Octave Note Range to Probably Not(e)", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "PWAlgorithmicExpander", "Portland Weather - Algorithmic Expander", "Allows Portland Weather to create Euclidean rhythms", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "PWGridControlExpander", "Portland Weather - Grid Control Expander", "Allows Portland Weather be modulated in a grid fashion", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "PWTapBreakoutExpander", "Portland Weather - Tap Breakoout Expander", "Individual Send/Returns for each PW Tap", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QuadAlgorithmicRhythm", "Quad Algorithmic Rhythm Generator", "4 track Euclidean and Golumb Ruler Sequencer", "Sequencer" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QARConditionalExpander", "QAR - Conditional", "Clock Divide individual beats in QAR Rhythms", "Expander Random" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QARGrooveExpander", "QAR - Groove", "Add Grooves and Microrhythms to QAR", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QARIrrationalityExpander", "QAR - Irrational", "Add Irrational Rhythms to QAR", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QARProbabilityExpander", "QAR - Probability", "Add Randomness to QAR Rhythms", "Expander Random" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QARWarpedSpaceExpander", "QAR - Warped Space", "Make your QAR Rhythms explore non-linear space", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QARWellFormedRhythmExpander", "QAR - Well Formed Rhythms", "Extra Parameters for Well Formed Algorithm", "Expander" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "QuantussyCell", "Quantussy Cell", "Chainable semi-chatotic CV generator", "Logic" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "RouletteLFO", "Roulette LFO", "LFO Based on based on rolling curves", "Low-frequency oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "SeedsOfChange", "Seeds Of Change", "Repeatable Random Number Generator", "Random" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "SeedsOfChangeCVExpander", "Seeds Of Change - CV Expander", "Additional CV Outs for SoC", "Expander Random" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "SeedsOfChangeGateExpander", "Seeds Of Change - Gate Expander", "Additional Gates for SoC", "Expander Random" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "SliceOfLife", "Slice Of Life", "Wave Slicing VCO", "Oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "StringTheory", "String Theory", "Karpus-Strong String Synthesis", "Oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "SeriouslySlowEG", "Seriously Slow EG", "Envelope Generator for modulating CV over *very* long time periods", "Envelope generator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "SeriouslySlowLFO", "Seriously Slow LFO", "LFO for modulating CV over *very* long time periods", "Low-frequency oscillator" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "VoxInhumana", "Vox Inhumana", "Formant/Vowel Filter", "Filter" },
 { "FrozenWasteland", "Frozen Wasteland", "", "almostEric", "VoxInhumanaExpander", "Vox Inhumana Expander", "Resonance and Slope Control", "Expander" },
 { "fruitsofkarma", "fruitsofkarma", "fruitsofkarma", "Alexey Komarov", "Quadro360", "Quadro360", "Quadro mixer with 8 inputs/4 outputs with rotation control", "Mixer Quad Panning" },
 { "fruitsofkarma", "fruitsofkarma", "fruitsofkarma", "Alexey Komarov", "PowVCO", "PowVCO", "Generates signal using x=y^n", "Oscillator Envelope generator Polyphonic" },
 { "fruitsofkarma", "fruitsofkarma", "fruitsofkarma", "Alexey Komarov", "ColoredGlass", "Colored Glass", "Simple particles effect", "Visual" },
 { "fruitsofkarma", "fruitsofkarma", "fruitsofkarma", "Alexey Komarov", "Math", "Math", "Basic math operations", "Envelope generator Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "VCO", "VCO", "Voltage-controlled oscillator", "VCO Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "VCO2", "Wavetable VCO", "Voltage-controlled wavetable oscillator", "VCO Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "VCF", "VCF", "Voltage-controlled filter", "VCF Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "VCA-1", "VCA", "Voltage-controlled amplifier", "VCA Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "VCA", "VCA-2", "2-channel voltage-controlled amplifier", "VCA Dual Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "LFO", "LFO", "Low-frequency oscillator", "LFO Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "LFO2", "Wavetable LFO", "Low-frequency wavetable oscillator", "LFO Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Delay", "Delay", "", "Delay" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "ADSR", "ADSR", "Generates an envelope with Attack/Decay/Sustain/Release", "Envelope Generator Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Mixer", "Mix", "Mixes 6 signals", "Mixer Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "VCMixer", "VCA Mix", "Mixes 4 signals with built-in VCAs", "Mixer VCA Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "8vert", "8vert", "Attenuverts 8 signals or creates constant voltages", "Attenuator Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Unity", "Unity", "Mixes or averages signals with unity gain", "Mixer Utility Dual" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Mutes", "Mutes", "Toggles up to 10 signals", "Switch Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Pulses", "Pulses", "Generates up to 10 trigger and gate signals", "Switch" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Scope", "Scope", "Inspect waveforms with an oscilloscope", "Visual Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "SEQ3", "SEQ 3", "3-channel 8-step sequencer also with gate outputs", "Sequencer" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "SequentialSwitch1", "Sequential Switch 1 to 4", "Routes 1 input to one of 4 outputs", "Utility Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "SequentialSwitch2", "Sequential Switch 4 to 1", "Routes one of 4 inputs to 1 output", "Utility Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Octave", "Octave", "Shifts 1V/oct pitch CV by octaves", "Utility Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Quantizer", "Quantizer", "12-note quantizer and scale selector", "Quantizer Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Split", "Split", "Splits a polyphonic cable into multiple monophonic cables", "Polyphonic Utility" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Merge", "Merge", "Combines multiple monophonic cables into a polyphonic cable", "Polyphonic Utility" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Sum", "Sum", "Sums all channels of a polyphonic cable", "Polyphonic Utility" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Viz", "Viz", "Visualizes all channels of a polyphonic cable", "Polyphonic Visual" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "MidSide", "Mid/Side", "Encodes/decodes between mid/side and left/right stereo signals", "Utility Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Noise", "Noise", "Multicolored noise generator", "Noise" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Random", "Random", "Random CV generator", "Random Sample and hold" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "CVMix", "CV Mix", "Mixes 3 CV signals with attenuverters", "Mixer Utility Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Fade", "Fade", "Crossfades audio or CV", "Panning Voltage-controlled amplifier Utility Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Logic", "Logic", "Gate logic processor", "Logic Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Compare", "Compare", "Compares two voltages", "Utility Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Gates", "Gates", "Gate processor", "Polyphonic" },
 { "Fundamental", "VCV Fundamental", "VCV", "VCV", "Process", "Process", "CV processor", "Polyphonic" },
 { "Geodesics-Vultiverse", "Geodesics-Vultiverse", "Geodesics+Vult", "Pyer + Leonardo Laguna Ruiz", "Hexaquark", "Hexaquark", "Quantum Chromodynamic Trigger Sequencer", "Sequencer Envelope generator" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "BlackHoles", "BlackHoles", "Gravitational attenumixset", "Ring modulator VCA Polyphonic Attenuator Controller Mixer Quad" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Pulsars", "Pulsars", "Neutron powered morphing", "Mixer Polyphonic Switch Sequencer" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Branes", "Branes", "Coliding sample and hold", "Sample and hold Random Dual Noise" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Ions", "Ions", "Atomic dual cv sequencer", "Sequencer Dual" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Entropia", "Entropia", "Thermodynamic microstate sequencer", "Sequencer Switch Random Attenuator" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Energy", "Energy", "Relativistic oscillator", "Oscillator Synth voice Polyphonic Digital LFO" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Torus", "Torus", "Bi-dimensional multimixer", "Mixer Filter Equalizer Multiple Utility Attenuator" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Fate", "Fate", "Event modifier", "Utility Random Clock modulator Dual Switch" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Blank-PanelInfo", "Blank-Panel Info", "Blank panel with info", "Blank" },
 { "Geodesics", "Geodesics", "Geodesics", "Pyer & Marc Boul\u00e9", "Blank-PanelLogo", "Blank-Panel Logo", "Blank panel with logo", "Blank" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "GigBus", "Gig Bus Mixer", "Stereo mixer to three stereo buses", "Mixer Panning Visual Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "MiniBus", "Mini Bus Mixer", "Mono mixer to three stereo buses", "Mixer Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "SchoolBus", "School Bus Mixer", "Pan and levels with CVs to three stereo buses", "Mixer Panning Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "MetroCityBus", "Metro City Bus Mixer", "Polyphonic stereo spread (and pan follow) to three stereo buses", "Mixer Panning Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "BusDepot", "Bus Depot", "Master fader, vu meters, or mix output for three stereo buses", "Mixer Visual Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "BusRoute", "Bus Route", "Three stereo sends and returns with optional sample delays", "Mixer Delay Utility Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "Road", "Road", "Merge stereo buses from mixers or mix groups", "Utility Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "EnterBus", "Enter Mixer Bus", "Three stereo inputs to three stereo buses", "Utility Polyphonic" },
 { "GlueTheGiant", "Glue the Giant", "Glue the Giant", "Paul Merchant", "ExitBus", "Exit Mixer Bus", "Three stereo outputs from three stereo buses", "Utility Polyphonic" },
 { "GoodSheperd", "GoodSheperd", "GoodSheperd", "Jens Schulze", "Hurdle", "Hurdle", "github.com/jensschulze3000/GoodSheperd", "Switch Random" },
 { "GoodSheperd", "GoodSheperd", "GoodSheperd", "Jens Schulze", "Stable16", "Stable16", "github.com/jensschulze3000/GoodSheperd", "Sequencer" },
 { "GoodSheperd", "GoodSheperd", "GoodSheperd", "Jens Schulze", "SEQ3st", "SEQ3st", "github.com/jensschulze3000/GoodSheperd", "Sequencer Random" },
 { "GoodSheperd", "GoodSheperd", "GoodSheperd", "Jens Schulze", "Stall", "Stall", "github.com/jensschulze3000/GoodSheperd", "Polyphonic Switch Utility" },
 { "GoodSheperd", "GoodSheperd", "GoodSheperd", "Jens Schulze", "Switch1", "Switch1", "github.com/jensschulze3000/GoodSheperd", "Switch" },
 { "GoodSheperd", "GoodSheperd", "GoodSheperd", "Jens Schulze", "Seqtrol", "Seqtrol", "github.com/jensschulze3000/GoodSheperd", "Clock modulator Sample and hold Switch Utility" },
 { "GrandeModular", "Grande", "", "David Grande", "Clip", "Clip", "Polyphonic hard clipper and visual clip monitor.", "Limiter Visual Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Compare3", "Compare3", "Three windowed comparators with common input.", "Logic Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "LFO3", "LFO3", "Three individual bipolar sine LFOs with separate frequency inputs.", "Low-frequency oscillator Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "LFO4", "LFO4", "Four ratioed bipolar sine LFOs with common primary frequency input.", "Low-frequency oscillator Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Logic", "Logic", "Polyphonic logic gates. (Gates also include two single-input modes: apply across all A channels, and invert all B channels.)", "Logic Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Merge8", "Merge8", "8-channel polyphonic merge.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "MergeSplit4", "MergeSplit4", "4-channel polyphonic merge and split.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "MicrotonalChords", "Microtonal Chords", "Microtonal quad chord generator.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "MicrotonalNotes", "Microtonal Notes", "Microtonal octal note generator.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "NoteMT", "NoteMT", "Microtonal note utility.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Peak", "Peak", "Captures polyphonic min/max peaks.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "PolyMergeResplit", "PolyMergeResplit", "Poly-to-poly Merge and Resplit back to the same channel widths.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "PolySplit", "PolySplit", "Poly-to-poly splitter with visual selection of channel split points.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Push", "Push", "Polyphonic push-button switches.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Quant", "Quant", "Quantizer with equi-likely notes mode.", "Quantizer Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "QuantIntervals", "Quant Intervals", "Microtonal quantizer based on pitch intervals.", "Quantizer Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "QuantMT", "QuantMT", "Microtonal quantizer.", "Quantizer Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "SampleDelays", "SampleDelays", "Provides multiple sample delay options.", "Delay Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Scale", "Scale", "Additional scales for Quant.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Split8", "Split8", "8-channel polyphonic split.", "Utility Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "Tails", "Tails", "Mono-to-poly sequential note splitter\u2014helps preserve envelope tails.", "Utility Polyphonic Voltage-controlled amplifier" },
 { "GrandeModular", "Grande", "", "David Grande", "Tails4", "Tails4", "Quad mono-to-poly sequential note splitter with common outputs\u2014helps preserve envelope tails.", "Utility Polyphonic Voltage-controlled amplifier" },
 { "GrandeModular", "Grande", "", "David Grande", "VarSampleDelays", "VarSampleDelays", "Quad independent variable sample-delay buffers.", "Delay Polyphonic Quad" },
 { "GrandeModular", "Grande", "", "David Grande", "VCA3", "VCA3", "Triple voltage-controlled amplifier.", "Voltage-controlled amplifier Polyphonic" },
 { "GrandeModular", "Grande", "", "David Grande", "VCA4", "VCA4", "Quad voltage-controlled amplifier.", "Voltage-controlled amplifier Polyphonic" },
 { "Grayscale", "Grayscale", "", "VCV", "Algorhythm", "Algorhythm", "8-channel polyrhythmic trigger sequencer", "Sequencer Hardware clone" },
 { "Grayscale", "Grayscale", "", "VCV", "Binary", "Binary", "Logic gate processor", "Logic Hardware clone" },
 { "Grayscale", "Grayscale", "", "VCV", "Binary2", "Binary\u00b2", "Logic gate processor", "Logic" },
 { "Grayscale", "Grayscale", "", "VCV", "Permutation18", "Permutation (18hp)", "Random sequencer based on the Turing Machine", "Sequencer Random Hardware clone" },
 { "Grayscale", "Grayscale", "", "VCV", "Permutation12", "Permutation (12hp)", "Random sequencer based on the Turing Machine", "Sequencer Random Hardware clone" },
 { "Grayscale", "Grayscale", "", "VCV", "Permutation6", "Permutation (6hp)", "Random sequencer based on the Turing Machine", "Sequencer Random Hardware clone" },
 { "Grayscale", "Grayscale", "", "VCV", "Variant", "Variant", "Expander for Permutation", "Sequencer Random Expander Hardware clone" },
 { "Grayscale", "Grayscale", "", "VCV", "Supercell", "Supercell", "Expanded version of Clouds by Mutable Instruments", "Granular Reverb Hardware clone" },
 { "h4n4-modules", "H4N4 Modules", "H4N4", "Hanna Koppelaar", "xen-qnt", "Xen Quantizer", "Polyphonic CV-controllable Scala Quantizer", "quantizer polyphonic" },
 { "HamptonHarmonics", "Hampton Harmonics", "Hampton Harmonics", "Scott Hampton", "Progress", "Progress", "Polyphonic Chord Sequencer", "sequencer poly" },
 { "HamptonHarmonics", "Hampton Harmonics", "Hampton Harmonics", "Scott Hampton", "Arp", "Arp", "Polyphonic Input Arpeggiator", "arpeggiator poly" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Chaos1Op", "1-Op Chaos", "Multimode audio and modulation chaos generator.", "Noise Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Chaos2Op", "2-Op Chaos", "Multimode audio and modulation chaos generator.", "Noise Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Chaos3Op", "3-Op Chaos", "Multimode audio and modulation chaos generator.", "Noise Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "ASR", "ASR", "Analog shift register. Multi-stage sample and hold", "Sequencer" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "AnalogToDigital", "Analog to Digital", "Converts a continuous signal into eight gates representing bit values.", "Logic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "BinaryGate", "Binary Gate", "Manually turn a gate on or off, or toggle its current state.", "Logic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "BinaryNoise", "Binary Noise", "Generates a random gate or square wave signal.", "Noise Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Bitshift", "Bitshift", "Bitshifting distortion and waveshaping effect", "Effect Distortion Waveshaper Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "BlankPanel", "Blank Panel", "A blank panel. Show your love for HetrickCV", "Blank" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Boolean3", "Boolean Logic", "Six way boolean logic processor", "Logic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "ChaoticAttractors", "Chaotic Attractors", "Multimode audio and modulation chaos generator.", "Noise Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "ClockedNoise", "Clocked Noise", "Multimode audio and modulation noise generator.", "Noise Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Comparator", "Comparator", "Determine whether a signal is above or below a threshold.", "Logic Utility" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Contrast", "Contrast", "A mild distortion that brightens up a signal.", "Effect Distortion Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Crackle", "Crackle", "Vinyl-like noise generator ported from SuperCollider.", "Noise" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "DataCompander", "Data Compander", "Compresses and expands signals with a-law or mu-law compansion.", "Utility Waveshaper Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Delta", "Delta", "Determine which direction a signal is heading.", "Logic Utility" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "DigitalToAnalog", "Digital to Analog", "Converts eight gates to a smooth signal.", "Logic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Dust", "Dust", "Random impulse and noise generator ported from SuperCollider", "Noise Granular" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Exponent", "Exponent", "Raise a signal to a power", "Waveshaper Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "FBSineChaos", "Feedback Sine Chaos", "A chaotic oscillator and LFO created through phase distortion and feedback.", "Noise Oscillator Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "FlipFlop", "Flip-Flop", "A flexible toggle switch", "Logic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "FlipPan", "Flip Pan", "A bidirectional panner, crossfader, and VCA", "Panning VCA Utility Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "GateJunction", "Gate Junction", "Eight channel gate processor.", "Switch Logic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Gingerbread", "Gingerbread Chaos", "Self-modulating audio and modulation chaos generator.", "Noise Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "LogicCombine", "OR Logic (Gate Combiner)", "Combines multiple gates into one gate.", "Logic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "MidSide", "Mid/Side", "Converts Left/Right signals to Mid/Side and vice versa.", "Utility Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "MinMax", "Min-Max", "Outputs the greatest and least voltages from up to 4 inputs.", "Utility Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "RandomGates", "Random Gates", "Generates up to eight random gates.", "Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Rotator", "Rotator", "Eight-way channel rotation.", "Switch" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Rungler", "Rungler", "8-Bit Shift Register and Comparator with stepped signal output via bits 6, 7, and 8.", "Sequencer Random" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Scanner", "Scanner", "8-channel signal crossfader, mixer, scanner, and router.", "Mixer Switch" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "2To4", "2 To 4 Mix Matrix", "Takes two signals and generates four variations.", "Mixer Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "Waveshaper", "Waveshaper", "Modulatable hyperbolic waveshaper", "Distortion Effect Waveshaper Polyphonic" },
 { "HetrickCV", "HetrickCV", "", "Michael Hetrick", "XYToPolar", "XY<->Polar", "Converts XY coordinates to Polar and vice versa.", "Utility Waveshaper Polyphonic" },
 { "HolonicSystems-Free", "Holonic Systems", "Holonic Systems", "Holonic Systems", "HolonicSystems-Gaps", "Gaps", "Clock divider with multiple modes", "CLOCK MODULATOR" },
 { "HolonicSystems-Free", "Holonic Systems", "Holonic Systems", "Holonic Systems", "HolonicSystems-Pantry", "Pantry", "Dual CV/Gate Recorder/Looper", "SEQUENCER RECORDING" },
 { "HolonicSystems-Free", "Holonic Systems", "Holonic Systems", "Holonic Systems", "HolonicSystems-DumbwaiterSequencer", "Dumbwaiter", "8 step sequencer and switch. One could see it as a A-155 / A-154 / A-152 merged into one module", "SEQUENCER ATTENUATOR SWITCH" },
 { "HolonicSystems-Free", "Holonic Systems", "Holonic Systems", "Holonic Systems", "HolonicSystems-SwissCheeseKnife", "SwissCheeseKnife", "Quad utility module with a twist", "UTILITY ATTENUATOR MIXER QUAD VCA SAMPLE AND HOLD SLEW LIMITER" },
 { "HolonicSystems-Free", "Holonic Systems", "Holonic Systems", "Holonic Systems", "HolonicSystems-HolonicSource", "Holonic Source", "Integrates with the Holon.ist iOS app and outputs CV control signals to VCV Rack", "CONTROLLER EXTERNAL" },
 { "HolonicSystems-Free", "Holonic Systems", "Holonic Systems", "Holonic Systems", "HolonicSystems-Junctions", "Junctions", "A simple dual switch. Two inputs, one output", "SWITCH DUAL" },
 { "HolonicSystems-Free", "Holonic Systems", "Holonic Systems", "Holonic Systems", "HolonicSystems-LazySusanQuantiser", "Lazy Susan", "Quad Quantiser with user editable scales", "QUANTIZER QUAD" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "BassDrumVult", "Bass Drum Vult", "Analog Bass Drum using vult made filter model", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "BassDrum-VCV", "Bass Drum", "Analog Bass Drum", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "Cymbal-VCV", "Cymbal", "Analog cymbal", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "HandClap-VCV", "HandClap/Maracas", "Analog Handclap", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "CymbalVult", "Cymbal Vult", "Analog Cymbal  using vult made filter model", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "HandClapVult", "HandClap/Maracas Vult", "Analog HandClap using vult made filter model", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "HiHat-VCV", "Hi-Hat", "Analog HiHat", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "HiHatVult", "Hi-Hat Vult", "Analog HiHat using vult made filter model (use the other clap module for better CPU load and more realisitic claps)", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "RimShot-VCV", "RimShot", "Analog RimShot", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "SoftBellVult", "SoftBell/Clave  Vult", "Analog Bell using vult made filter model", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "SnareDrum-VCV", "Snare Drum", "Analog Snare Drum", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "SnareDrumVult", "Snare Drum Vult", "Analog Snare Drum using vult made filter model", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "Toms-VCV", "Toms/Congas", "Analog Toms", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "TomsVult", "Toms/Congas Vult", "Analog Toms using vult made filter model", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "Deep", "Deep", "Analog Bass Drum", "DRUM" },
 { "Hora-AnalogDrums", "Analog Drums", "Hora", "Hora", "Bicephalous", "Bicephalous", "Analog Drum Synth", "DRUM" },
 { "Hora-Mixers", "Mixers", "Hora", "Hora", "StereoMixer-8", "Stereo Mixer", "8 Tracks Stereo Mixer", "Mixer" },
 { "Hora-Mixers", "Mixers", "Hora", "Hora", "StereoMixer-8-2", "Stereo Mixer 8", "8 Track 2 loops CV controlled Mixer", "Mixer" },
 { "Hora-Mixers", "Mixers", "Hora", "Hora", "StereoMixer-16-2", "StereoMixer 16", "16 tracks 2 loops cv controlled mixer", "Mixer" },
 { "Hora-Modulation", "Modulations", "Hora", "Hora", "Relief-Envelopegeneretor", "complexEnvelope", "complex envelope generator", "Envelope generator" },
 { "Hora-Modulation", "Modulations", "Hora", "Hora", "TwinQuartet-LFO", "quadraLFO", "Quadratic LFO", "LFO" },
 { "Hora-ModulationFree", "Modulations Free", "Hora", "Hora", "TwinQuartet-LFO", "quadraLFO Free", "Quadratic LFO", "LFO" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMDDD1", "PCM drums", "DDD1 & PSS50 samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMDMX", "PCM drums", "DMX & MXR samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMEmu", "PCM drums", "EMU & SP12 samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMDrumLDrum", "PCM drums", "LinnDrum samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMRX", "PCM drums", "RX samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMRXII", "PCM drums", "RXII samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMSakata", "PCM drums", "Sakata & sequentialTOM samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCMX26", "PCM drums", "626 samples based drums", "DRUM" },
 { "Hora-PCMDrum", "PCM Drum", "Hora", "Hora", "Hora-PCM907", "PCM drums", "707 & 909 samples based drums", "DRUM" },
 { "Hora-PCMDrumFree", "PCM Drums free", "Hora", "Hora", "Hora-PCMDrumLDrum", "PCM Drum Free", "LinnDrum samples based drums", "DRUM" },
 { "Hora-Processors", "Processors", "Hora", "Hora", "SpectralProcessor", "Spectral Processor", "Spectral processor inspired by bucchla 296e", "Effect" },
 { "Hora-Processors", "Processors", "Hora", "Hora", "EnvelopeFollower", "Follower", "Envelope follower", "Envelope follower" },
 { "Hora-Processors", "Processors", "Hora", "Hora", "Delay", "Millenial", "Multimode tap delay and resonator", "Effect Physical modeling Delay" },
 { "Hora-Processors", "Processors", "Hora", "Hora", "Vacuum", "Vacuumba", "Tube Distortion", "Effect Distortion" },
 { "Hora-Processors", "Processors", "Hora", "Hora", "Scheme", "Scheme", "Tube Drive", "Effect Overdrive" },
 { "Hora-Processors", "Processors", "Hora", "Hora", "Brigade", "Flux", "Bucket Brigade Delay", "Effect Delay" },
 { "Hora-ProcessorsFree", "Processors Free", "Hora", "Hora", "EnvelopeFollower", "Envelope Follower Free", "Envelope follower", "Envelope follower" },
 { "Hora-ProcessorsFree", "Processors Free", "Hora", "Hora", "Delay", "Millenial Free", "multimode delay", "Effect" },
 { "Hora-ProcessorsFree", "Processors Free", "Hora", "Hora", "Vacuum", "Vacuumba Free", "Tube Distortion", "Effect Distortion" },
 { "Hora-ProcessorsFree", "Processors Free", "Hora", "Hora", "Brigade", "Brigade Free", "Bucket Brigade Delay", "Effect Delay" },
 { "Hora-Sequencers", "Sequencers", "Hora", "Hora", "Frequencydivider", "Frequency Divider", "frequency divider", "Utility" },
 { "Hora-Sequencers", "Sequencers", "Hora", "Hora", "Drumsequencer", "Drum Sequencer", "Advanced drum sequencer", "Sequencer" },
 { "Hora-Sequencers", "Sequencers", "Hora", "Hora", "DrumSongMapper", "Song Mapper", "Pattern sequencer", "Sequencer" },
 { "Hora-treasureFree", "Treasure Free", "Hora", "Hora", "SnareDrum-VCV", "Snare Drum Free", "Analog Snare Drum", "DRUM" },
 { "Hora-treasureFree", "Treasure Free", "Hora", "Hora", "SoftBell", "Soft Bell Free", "Analog Bell using vult made fiter mdoel", "DRUM" },
 { "Hora-treasureFree", "Treasure Free", "Hora", "Hora", "HiHat", "Hi Hat Free", "Analog HiHat  using vult made fiter mdoel", "DRUM" },
 { "Hora-treasureFree", "Treasure Free", "Hora", "Hora", "Frequencydivider", "Frequency Divider Free", "Frequency divider", "Utility" },
 { "Hora-treasureFree", "Treasure Free", "Hora", "Hora", "Deep", "Deep Free", "Analog Bass Drum", "DRUM" },
 { "Hora-VCO_VCF_VCA", "VCO VCF VCA", "Hora", "Hora", "Amplitude-VCMixer", "Amplitude", "Linear voltage controlled mixer/inverter/amp", "VCA POLYPHONIC MIXER" },
 { "Hora-VCO_VCF_VCA", "VCO VCF VCA", "Hora", "Hora", "Timbre-VCF", "Timbre VCF", "Multimode VCF", "VCF POLYPHONIC" },
 { "Hora-VCO_VCF_VCA", "VCO VCF VCA", "Hora", "Hora", "Vector-Synth", "Detour", "Vector Phaseshaping Synthesis", "VCO POLYPHONIC SYNTH VOICE" },
 { "Hora-VCO_VCF_VCA", "VCO VCF VCA", "Hora", "Hora", "Pure-VCO", "Pure VCO", "sine core foldable VCO", "VCO POLYPHONIC WAVEFOLDER EFFECT" },
 { "Hora-VCO_VCF_VCA_Free", "VCO-VCF-VCA Free", "Hora", "Hora", "Amplitude-VCMixer", "Amplitude Free", "voltage controlled mixer/inverter/amp", "VCA" },
 { "Hora-VCO_VCF_VCA_Free", "VCO-VCF-VCA Free", "Hora", "Hora", "Vector-Synth", "Detour Free", "Vector Phaseshaping Synthesis", "VCO SYNTH VOICE" },
 { "htLocal", "htLocal", "htLocal", "htLocal", "htFader", "htFader", "Fades signals in and out", "Utility" },
 { "htLocal", "htLocal", "htLocal", "htLocal", "htFader16", "htFader16", "Fades signals in and out", "Utility" },
 { "htLocal", "htLocal", "htLocal", "htLocal", "htAdder", "htAdder", "functions largely like the A-185-2 Precision CV Adder", "Hardware clone Utility" },
 { "huaba", "huaba", "huaba", "Daniel Huber", "EQ3", "EQ3", "3-Band Equalizer", "Equalizer" },
 { "huaba", "huaba", "huaba", "Daniel Huber", "ABBus", "A+B Bus", "Merges signals on the selected output bus", "Utility" },
 { "IggyLabsModules", "iggy.labs", "iggy.labs", "Isabel Kaspriskie", "table", "table", "Wavetable oscillator for user-imported wavetables", "oscillator polyphonic" },
 { "IggyLabsModules", "iggy.labs", "iggy.labs", "Isabel Kaspriskie", "select", "select", "Utility to route one of 16 inputs to an output", "utility" },
 { "IggyLabsModules", "iggy.labs", "iggy.labs", "Isabel Kaspriskie", "more-ideas", "more-ideas", "Elementary cellular automata sequencer (modeled after less concepts for norns)", "random" },
 { "ILovePerlin", "ILovePerlin", "", "digitalhappens.de", "PerlinOne", "PerlinOne", "adaption of NauModular Perin Noise module", "noise random" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Adaptive-Quantizer", "AdaptiveQuantizer", "Adaptive reference based quantizer", "Quantizer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Big-Button-Seq", "BigButtonSeq", "6-channel, 64-step trigger sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Big-Button-Seq2", "BigButtonSeq2", "6-channel, 128-step sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Chord-Key", "ChordKey", "Keyboard-based chord generator", "Sequencer Polyphonic" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Chord-Key-Expander", "ChordKey expander", "Expander for ChordKey", "Sequencer Polyphonic Quantizer Expander" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Clocked", "Clocked", "Chainable master clock with swing, clock delay and pulse width", "Clock generator" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Clocked-Expander", "Clocked expander", "Expander for Clocked", "Clock generator Expander" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Clocked-Clkd", "Clkd", "Chainable master clock", "Clock generator" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Cv-Pad", "CV-Pad", "16-pad CV controller", "Controller" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Foundry", "Foundry", "4-track, 32-step, 64-pattern sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Foundry-Expander", "Foundry expander", "Expander for Foundry", "Sequencer Expander" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Four-View", "FourView", "Quad note or chord viewer with passthrough", "Visual" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Gate-Seq-64", "GateSeq64", "64-step, 32-pattern gate sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Gate-Seq-64-Expander", "GateSeq64 expander", "Expander for GateSeq64", "Sequencer Expander" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Hotkey", "Hotkey", "Triggers when mouse is over module and hotkey is pressed", "Utility" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Part-Gate-Split", "Part", "Polyphonic gate splitter", "Utility Polyphonic" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Phrase-Seq-16", "PhraseSeq16", "16-step, 16-pattern sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Phrase-Seq-32", "PhraseSeq32", "32-step, 32-pattern sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Phrase-Seq-Expander", "PhraseSeq expander", "Expander for PhraseSeq16 and PhraseSeq32", "Sequencer Expander" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Prob-Key", "ProbKey", "Keyboard-based random sequencer", "Sequencer Random Polyphonic" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Semi-ModularSynth", "SMS16", "Semi-modular monophonic synthesizer, with 16-step sequencer", "Synth voice Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Sygen", "Sygen", "Synchronous gate enable", "Utility" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Tact", "Tact", "Dual-channel tactile-inspired controller", "Controller" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Tact1", "Tact1", "Tactile-inspired controller", "Controller" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "TactG", "TactG", "Tactile-inspired controller with gate output", "Controller" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Twelve-Key", "TwelveKey", "Chainable one octave keyboard controller", "Controller" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Write-Seq-32", "WriteSeq32", "3-channel, 32-step sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Write-Seq-64", "WriteSeq64", "4-channel, 64-step sequencer", "Sequencer" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Variations", "Variations", "Sample and hold a CV with addition of a random noise value", "Sample and hold Random Noise Polyphonic" },
 { "ImpromptuModular", "Impromptu", "Impromptu", "Marc Boul\u00e9", "Blank-Panel", "BlankPanel", "Impromptu Modular blank panel", "Blank" },
 { "InfrasonicAudio", "Infrasonic Audio", "Infrasonic Audio", "Infrasonic Audio LLC (Nick Donaldson)", "WarpCore", "Warp Core", "Dual-algorithm phase distortion and phase modulation oscillator", "Oscillator Polyphonic" },
 { "Inklen-CableColourKey", "Inklen Cable Colour Key", "Inklen", "Nick Feisst", "CableColourKey", "Cable Colour Key", "Change the colour of the currently selected cable using your keyboard", "Utility" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "troika", "troika", "Triple Oscillator", "Hardware clone Multiple Oscillator" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "traigh", "tr\u00e0igh", "Discrete Transistor Ladder Lowpass Filter (traigh)", "Hardware clone Filter Mixer Oscillator" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "harmonaig", "harmon\u00e0ig", "Diatonic Harmonic Quantiser (harmonaig)", "Hardware clone Controller Quad Quantizer" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "tona", u8"t\u00f2na", "Oscillator (tona)", "Hardware clone Oscillator" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "ceis", u8"c\u00e8is", "ADSR (ceis)", "Hardware clone Envelope generator Dynamics" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "vinca", u8"vinc\u00e2", "Dual VCA (vinca)", "Hardware clone Dual Voltage-controlled amplifier Attenuator" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "tanh", "tanh[3]", "Waveshaper / Limiter", "Hardware clone Dynamics Distortion Limiter Multiple Waveshaper" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "tsl", u8"T\u0161-L", "Oscillator (Ts-L, TsL)", "Hardware clone Oscillator Low-frequency oscillator" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "CsL", u8"C\u0161-L", "Complex Oscillator (Cs-L, CsL)", "Hardware clone Dual Oscillator Low-frequency oscillator Ring modulator Waveshaper" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "io47", u8"I-\u014d47", "Multimode Resonator / Filter (I-o47, Io47, 1047)", "Hardware clone Filter Oscillator" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "athru", u8"athr\u00fa", "Wavefolder (athru)", "Hardware clone Distortion Effect Waveshaper" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "2f", "[2]f", "Dual Fader Module (2f)", "Hardware clone Dual Utility" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "tagh", u8"t\u00e1gh", "Sample and Hold (tagh)", "Hardware clone Noise Random Sample and hold" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "ochd", u8"\u00f8chd", "LFO (ochd)", "Hardware clone Function generator Low-frequency oscillator Multiple Oscillator" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "tain", u8"t\u00e0in", "Switch Utility Module (tain)", "Hardware clone Digital Dual Switch Utility" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "lion", u8"l\u00econ", "Matrix Mixer (lion)", "Hardware clone Mixer Utility" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "saich", u8"sa\u00efch", "Quad Oscillator (saich)", "Hardware clone Oscillator Quad" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "1f", "[1]f", "Fader Module (1f)", "Hardware clone Attenuator Mixer Utility" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "eas", u8"e\u00e3s", "Logic Module (eas)", "Hardware clone Logic Utility" },
 { "Instruo", "Instruo", u8"Instru\u014d", u8"Instru\u014d", "neoni", u8"ne\u00f3ni", "Through-Zero Oscillator (neoni)", "Hardware clone Oscillator Low-frequency oscillator" },
 { "Interrobang", "Interrobang", "Interrobang", "Jim Allman", "ScribbleStrip", "Scribble Strip, 3 HP (SS-3)", "Makes it easy to navigate a complex patch.", "visual" },
 { "IvyFunPack", "Ivy Fun Pack", "ivy's stuff", "ivy<3", "cricle", "cricle", "Modulates a signal such that it appears to rotate around the listener.", "effect utility" },
 { "JE", "JE", "JE", "Julien Eres", "RM", "RM", "Ring Modulator", "Ring modulator" },
 { "JE", "JE", "JE", "Julien Eres", "WF", "WF", "Wave Folder", "Waveshaper" },
 { "JLmod", "JLmod", "JLmod", "Joakim Lindbom", "DebugExpander", "DebugExpander", "Debugger for Ratchets module", "Utility" },
 { "JLmod", "JLmod", "JLmod", "Joakim Lindbom", "Ratchets", "Ratchets", "Gate and CV sequencer with 1-8 gates generated per step, generating a ratcheting effect", "Sequencer" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "BlankPanel_1HP", "Blank Panel (1HP)", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "BlankPanel_SM", "Blank Panel (Small)", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "BlankPanel_MD", "Blank Panel (Medium)", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "BlankPanel_LG", "Blank Panel (Large)", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "CoolBreeze", "Cool Breeze", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Pete", "Pete", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Add5", "Add5", "", "Utility" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "BouncyBalls", "Bouncy Balls", "", "Sequencer Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "0Cat", "0Cat", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "FullScope", "Full Scope", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "GridSeq", "GridSeq", "", "Sequencer" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "8Seq", "8Seq", "", "Sequencer" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "DivSeq", "DivSeq", "", "Sequencer" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "MinMax", "Min Max", "", "Utility" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "NoteSeq", "NoteSeq", "", "Sequencer Poly" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "NoteSeqFu", "NoteSeqFu", "", "Sequencer Poly" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "NoteSeq16", "NoteSeq16", "", "Sequencer Poly" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Trigs", "Trigs", "", "Sequencer" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Patterns", "Patterns", "", "Sequencer Clock Modulator" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "1Pattern", "1Pattern", "", "Sequencer Clock Modulator" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Quantizer", "Quantizer", "", "Quantizer Poly" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "SimpleClock", "Simple Clock", "", "Clock Random" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Str1ker", "Str1ker", "", "Clock" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "D1v1de", "D1v1de", "Clock Divider", "Clock modulator Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Pres1t", "Pres1t", "Voltage Storage", "Utility" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "ThingThing", "Thing Thing", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "WavHead", "Wav Head", "", "Visual Poly" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "Tree", "Tree", "", "Visual" },
 { "JW-Modules", "JW-Modules", "", "Jeremy Wentworth", "XYPad", "XY Pad", "", "LFO Random" },
 { "K4815-Pattern_Generator", "K4815 Pattern Generator", "Kilpatrick Audio", "Kilpatrick Audio", "K4815-Pattern_Generator", "K4815 Pattern Generator", "CV and MIDI Pattern Generator", "Hardware MIDI Sequencer" },
 { "K4815-Pattern_Generator", "K4815 Pattern Generator", "Kilpatrick Audio", "Kilpatrick Audio", "K4815E-Expander", "K4815E Expander", "Pattern Generator Expander", "Expander" },
 { "K4815-Pattern_Generator", "K4815 Pattern Generator", "Kilpatrick Audio", "Kilpatrick Audio", "K4815P-Programmer", "K4815P Programmer", "Pattern Generator Programmer", "Expander" },
 { "KarateSnoopy", "KarateSnoopy", "", "KarateSnoopy", "KSnpy2DGridSeq", "2D grid sequencer", "2D grid sequencer", "Sequencer" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "Blocks", "Blocks", "Inspired by Mutable Instruments Edges.", "Noise Oscillator Polyphonic Synth voice" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "MiniBoss", "Mini Boss", "An emulation of the Yamaha YM2612 FM synthesis chip from the Sega Mega Drive and Sega Genesis.", "Noise Oscillator Polyphonic Synth voice" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "106", "Name Corp Octal Wave Generator", "An emulation of the Namco 163 wavetable chip from Nintendo Entertainment System (NES) cartridges.", "Oscillator Polyphonic" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "2612", "Boss Fight", "An emulation of the Yamaha YM2612 FM synthesis chip from the Sega Mega Drive and Sega Genesis.", "Noise Oscillator Polyphonic Synth voice" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "2612_Blank1", "Boss Fight Envelope Generator (Blank)", "A blank panel with an illustration of the envelope generator from Boss Fight.", "Blank" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "2A03", "Infinite Stairs", "An emulation of the Ricoh 2A03 chip from the Nintendo Entertainment System (NES).", "Noise Oscillator Polyphonic" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "AY_3_8910", "Jairasullator", "An emulation of the General Instrument AY-3-8910 chip.", "Distortion Low-frequency Oscillator Noise Oscillator Polyphonic Synth voice Voltage-controlled Amplifier" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "FME7", "Pulses", "An emulation of the Sunsoft FME-7 chip from Nintendo Entertainment System (NES) cartridges.", "Oscillator Polyphonic" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "GBS", "Pallet Town Waves System", "An emulation of the Nintendo Gameboy Sound System chip.", "Noise Oscillator Polyphonic" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "POKEY", "Pot Keys", "An emulation of the Atari POKEY chip.", "Noise Oscillator Polyphonic" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "SuperADSR", "Super ADSR", "An emulation of the ADSR envelope generator from the S-SMP chip on the Super Nintendo Entertainment System (SNES).", "Dual Envelope generator Polyphonic" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "SuperEcho", "Super Echo", "An emulation of the echo effect from the S-SMP chip on the Super Nintendo Entertainment System (SNES).", "Delay Dual Effect Filter Polyphonic Reverb" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "SuperVCA", "Super VCA", "An emulation of the Gaussian interpolation filter effect from the S-SMP chip on the Super Nintendo Entertainment System (SNES).", "Dual Polyphonic Voltage-controlled amplifier" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "Sony_S_SMP_Blank1", "S-SMP Blank", "A blank panel with an illustration of the Sony S-SMP chip on the Super Nintendo Entertainment System (SNES).", "Blank" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "SuperSampler", "Super Sampler", "An emulation of the BRR sample playback engine from the S-SMP chip on the Super Nintendo Entertainment System (SNES).", "Multiple Effect Filter Panning Polyphonic Sampler" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "SuperSynth", "Super Synth", "An emulation of the Sony S-SMP chip from the Super Nintendo Entertainment System (SNES).", "Multiple Noise Oscillator Polyphonic Synth voice" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "SN76489", "Mega Tone", "An emulation of the Texas Instruments SN76489 chip from the Sega Master System, Sega Mega Drive, and Sega Genesis.", "Noise Oscillator Polyphonic" },
 { "KautenjaDSP-PotatoChips", "KautenjaDSP Potato Chips", "KautenjaDSP", "Christian Kauten", "VRC6", "Step Saw", "An emulation of the Konami VRC6 chip from Nintendo Entertainment System (NES) cartridges.", "Oscillator Polyphonic" },
 { "KautenjaDSP-RackNES", "KautenjaDSP RackNES", "KautenjaDSP", "Christian Kauten", "RackNES", "RackNES", "A Nintendo Entertainment System emulator with CV", "Clock generator Sampler Visual" },
 { "KautenjaDSP-RackNES", "KautenjaDSP RackNES", "KautenjaDSP", "Christian Kauten", "InputGenie", "CV Genie (Input)", "Expander for RackNES", "Expander" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Channel", "MIDI Channel", "MIDI Channel Processor with vMIDI Support", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_CV", "MIDI CV", "MIDI to CV Module with vMIDI Support", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Input", "MIDI Input", "MIDI Hardware Input to vMIDI Adapter", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Mapper", "MIDI Mapper", "MIDI CC Mapper with vMIDI Support", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Merger", "MIDI Merger", "MIDI Merger and Filter with vMIDI Support", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Monitor", "MIDI Monitor", "MIDI Monitor with vMIDI Support", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Output", "MIDI Output", "MIDI Hardare Output from vMIDI Adapter", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Repeater", "MIDI Repeater", "MIDI Repeat Processor vMIDI Support", "MIDI Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "Quad_Decoder", "Quad Decoder", "Quadraphonic 4-2-4 Matrix Decoder", "Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "Quad_Encoder", "Quad Encoder", "Quadraphonic 4-2-4 Matrix Encoder", "Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "Quad_Panner", "Quad Panner", "Quad Panner", "Panning Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "Stereo_Meter", "Stereo Meter", "Stereo Audio Levelmeter", "Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "Test_Osc", "Test Osc", "Test Oscillator with Sweep", "Utility Oscillator" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "Multi_Meter", "Multi Meter", "Multi-channel and X/Y Meter", "Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_Clock", "MIDI Clock", "MIDI with Analog and vMIDI Support", "MIDI Clock Utility" },
 { "Kilpatrick-Toolbox", "Kilpatrick-Toolbox", "Kilpatrick Audio", "Andrew Kilpatrick", "MIDI_CC_Note", "MIDI CC Note", "MIDI CC to Note Converter with vMIDI Support", "MIDI Utility" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "SVF-1", "SVF", "State Variable Filter", "Filter Polyphonic" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "TRG", "TRG", "Trigger Sequencer", "Sequencer" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "LADR", "LADR", "4-pole Ladder Filter", "Filter Polyphonic" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "OP", "OP", "Phase-modulation operator", "Oscillator Polyphonic" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "PHASR", "PHASR", "Phasor oscillator", "Oscillator" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "MUL", "MUL", "Multiplier", "Utility" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "SKF", "SKF", "Sallen-Key filter", "Filter Polyphonic" },
 { "kocmoc", "kocmoc", "kocmoc", "janne808", "DDLY", "DDLY", "Digital Delay", "Delay" },
 { "Koralfx-Modules", "Koralfx-Modules", "Koralfx-Modules", "Tomasz Sosnowski", "Beatovnik", "Beatovnik", "", "Clock Clock Modulator" },
 { "Koralfx-Modules", "Koralfx-Modules", "Koralfx-Modules", "Tomasz Sosnowski", "Mixovnik", "Mixovnik", "", "Mixer" },
 { "Koralfx-Modules", "Koralfx-Modules", "Koralfx-Modules", "Tomasz Sosnowski", "Nullovnik4", "Nullovnik4", "", "Blank" },
 { "Koralfx-Modules", "Koralfx-Modules", "Koralfx-Modules", "Tomasz Sosnowski", "Nullovnik6", "Nullovnik6", "", "Blank" },
 { "Koralfx-Modules", "Koralfx-Modules", "Koralfx-Modules", "Tomasz Sosnowski", "Presetovnik", "Presetovnik", "", "Utility" },
 { "Koralfx-Modules", "Koralfx-Modules", "Koralfx-Modules", "Tomasz Sosnowski", "Quantovnik", "Quantovnik", "", "Effect" },
 { "Koralfx-Modules", "Koralfx-Modules", "Koralfx-Modules", "Tomasz Sosnowski", "Scorovnik", "Scorovnik", "", "Sequencer" },
 { "Kosmodules-Free", "Kosmodules", "Kosmodules", "Calvin Kosmatka", "OSF", "OSF", "Offset Scale Fold", "attenuator dual utility" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "A", "A", "Plate 18 dB filter. Band pass phased ring mod. Other ins\nand outs with different order are available. The ring\nmodulation is between a low and high pass for a band pass\nwith harmonics effect.", "Effect Filter Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "Mu", u8"\u03bc", "Time dependant caclulus on a summing junction with series\ntruncation distortion. This is complex to explain. Much\nbetter to listen and fiddle.", "Effect Waveshaper Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "T", "T", "Pitched time stretch and matched trigger sync delay. Spools\nand then plays back faster such that the overall waveform\nis produced at two different frequencies.", "Effect Tuner Delay Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "L", "L", "Synchronized delay with shortening. To synchronize with a\nbuffer but delayed by a bar or some other timed quantity.", "Utility Clock modulator Delay Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "D", ";D", "Exponential VCA and future estimator with error? A very\nsimple utility.", "Utility Attenuator Voltage-controlled amplifier Dynamics Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "R", "R", "Simple mixer split. Put a signal on another as an insert.", "Attenuator Mixer Utility Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "Om", u8"\u03a9", "Clock distribution randomizer. Generates a randomish\nsequence of length 64 and depending on the left-most\ndisplayed letter outputs a trigger when the clock is high\nor low.", "Clock modulator Polyphonic Random Switch" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "V", "V", "Envelope VCA and CV producer. A bit wierd. An experiment in\nmodule design.", "Envelope generator Voltage-controlled amplifier Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "F", "F", "24 dB morph filter. A 2D interpolation and extrapolation\nbetween 4 classic analytic filter responses of Bessel,\nButterworth, Linkwitz and Legendre. Includes an interpole\ndistortion effect and morphing to the inverse filter.", "Filter Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "W", "W", "Gate transposer. Kind of a tuning plug-board for gate\ntriggers.", "Attenuator Mixer Tuner Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "Y", "Y", "Triple sequencer. Nice but complex to operate. Try the\nonline help.", "Clock generator Sequencer" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "O", "O", "Triple parabolic skew feedback oscillator. An experimental\nmodule.", "Polyphonic Oscillator" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "S", "S", "Clock to CV generator. Needs MIDI clk, cont, stop and\nstart. Produces a time based CV.", "MIDI Clock modulator Low-frequency oscillator" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "E", "E", "Simple AR envelope with VCA. Nice. Gained modulation out.", "Envelope generator Voltage-controlled amplifier Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "X", "X", "Oversampled wave-folder. A lot of fizz in such a little\nmodule.", "Waveshaper Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "M", "M", "Emphisis and de-emphisis filter. Default is RIAA and\ninverse. This module has large gain. WARNING!", "Polyphonic Filter Effect Utility" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "Q", "Q", "Quantum gravimitator. Imitates a coupled gravity quantum\nidea. I really shouldn't explain. Just play.", "Polyphonic Effect Physical modeling Oscillator" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "C", "C", "A set of three attenuverters with mixing. Kind of useful\nchainable mixer. Includes LPF per channel.", "Attenuator Mixer Utility Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "U", "U", "Sample and hold quantizer. Simple.", "Quantizer Polyphonic Sample and hold Noise" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "B", "B", "Crossbar performance switch. Remembers internal routing for\nperformance switching.", "Switch Controller Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "J", "J", "All-pass filter and phaser. Has an LFO built-in.", "Filter Polyphonic Utility Phaser Low-frequency oscillator" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "K", "K", "Phase modulation oscillator.", "Polyphonic Oscillator" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "H", "H", "Base gimpathizer. An organ with phase modulation. Bass how\nlow can you go?", "Polyphonic Oscillator" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "I", "I", "Clock divider with downbeat extract.", "Clock modulator Polyphonic" },
 { "KRTPluginA", "KRTPluginA", "KRT", "Jacko", "G", "G", "Compressor with control outs. Has a low pass peaking filter.", "Polyphonic Compressor Limiter Dynamics" },
 { "LabSeven", "LabSeven", "LabSeven", "Gernot Wurst", "LS3340VCO", "LS3340-VCO", "", "Oscillator" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "TimeDiktat", "TimeDiktat", "Clock Gen based on JW clock", "Clock Generator" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "SequenceModeler", "SequenceModeler", "Sequencer based on Fundamental SEQ3", "Sequencer Dual" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "PitchDiktat", "PitchDiktat", "Quantizer based on ML Quantum", "Quantizer Random" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "PitchIntegrator", "PitchIntegrator", "Sequential switch  based on ML switches, with sample and hold designed for pitch", "Switch Sample and hold" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "BurstIntegrator", "BurstIntegrator", "Sequential switch based on ML switches, with trigger generator to add burst of trigs to yout patterns", "Switch Clock modulator" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "QuadModulator", "QuadModulator", "Quad synced LFO with skew from ramp up to ramp down through sine plus dual unity mixer", "LFO Quad" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "ImpulseControl", "ImpulseControl", "Trigger sequencer based on Fundamental SEQ3", "Sequencer Dual" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "PercussiveVibration", "PercussiveVibration", "Synth voice based on 21Khz PalmLoop and Befaco Rampage mainly for drums", "Synth voice Drum" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "QuadUtility", "QuadUtility", "4 scalers 4 adders and 4 VCAs", "Utility Dual" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "AdditiveVibration", "AdditiveVibration", "Additive/FM synth voice based on 21Khz PalmLoop and Befaco Rampage ", "Synth voice" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "QuadSteppedOffset", "QuadSteppedOffset", "Octave and semitone transposer", "Utility Quad" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "ComplexOsc", "ComplexOsc", "Complex Oscillator made with 2 phase modulatable sines plus a clipper", "Oscillator" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "Driftgen", "Driftgen", "CV modifier, will add subtle drift to V/Oct signals", "Utility" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "TimeExpansion", "TimeExpansion", "Clock extension", "Utility" },
 { "LifeFormModular", "LifeFormModular", "LifeFormModular", "Marc Dacunha", "TornArtery", "TornArtery", "Dual envelope + vca", "Utility" },
 { "LilacLoop", "Lilac Loop", "Lilac", "Gavin Rough", "Looper", "Looper", "Stereo multi-track live looper", "Polyphonic Recording Sampler" },
 { "LilacModules", "Lilac Modules", "Lilac", "Gavin Rough", "Accumulator", "Accumulator", "Dual polyphonic voltage accumulator or integrator", "Dual Polyphonic Utility" },
 { "LilacModules", "Lilac Modules", "Lilac", "Gavin Rough", "Comparator", "Comparator", "Polyphonic voltage comparator with adjustable tolerance", "Logic Polyphonic Utility" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "VCO", "Woldemar analog VCO", "Analog oscillator", "OSCILLATOR Polyphonic" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "Noiser", "NO!ZER Probability Emitter", "Variable noise and random generator", "OSCILLATOR" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "MicroWolde", "Compact Woldemar analog VCO", "Analog oscillator", "OSCILLATOR Polyphonic" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "TYPE35_VCF", "Vampyr type35 VCF", "Sallen-Key type dual filter: Lowpass: 12dB/oct Highpass: 6dB/oct", "FILTER" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "Neo", "Neo Filter", "Neo distortion filter", "FILTER Polyphonic" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "DIODE_VCF", "Laika Diode-Ladder Filter", "Classic diode driven ladder filter with 12/dB/oct", "FILTER" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "BlankPanel_01", "Blank: Logo", "Blank panel with Logo and Information", "BLANK" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "BlankPanel_Wood", "Blank: Wood-Panel", "Wooden side panel", "BLANK" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "LPFilter24dB", "Simple lowpass filter", "Simple ladder style filter with 24dB7oct", "FILTER" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "ReShaper", "ReShaper wavefolder", "Simple wavefolder module", "WAVESHAPER" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "BlankPanel_02", "Big Blankpanel", "Big Blankpanel", "BLANK" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "BlankPanel_Small", "Blankpanel | Multiple", "Small blankpanel extendable to a 2x4 multiple", "BLANK MULTIPLE" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "PolyStereo", "Stereo via polyphonic tool", "Converts a stereo signal to poly and vice versa", "TOOL Polyphonic" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "VCSpread", "Voltage Controlled Signal Spread", "Takes and input signal and generates n- shifted output signals via poly out", "TOOL" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "VCF", "Alma 24dB/oct ladder filter", "Alma 24dB/oct lowpass ladder filter", "FILTER" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "MS20_VCF", "Valerie MS20 filter", "Valerie MS20 type 12dB/oct lowpass filter", "FILTER" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "Westcoast_VCS", "Westcoast Complex Shaper", "Westcoast waveshaper with different modes", "WAVESHAPER" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "QuickMixer", "5 Channel Mixing Amp", "Voltage controlled 5 channel mixer amp with dynamic amp curve", "MIXER VCA" },
 { "LindenbergResearch", "LindenbergResearch", "", "Lindenberg Research", "Sangster", "Sangster BBD Analog Delay", "Voltage controlled BBD Analog time repeater", "DELAY EFFECT Polyphonic" },
 { "LittleUtils", "Little Utils", "", "M\u00e1rton Gunyh\u00f3", "Button", "Button", "Press a button to output a trigger, gate or flip-flop signal", "utility" },
 { "LittleUtils", "Little Utils", "", "M\u00e1rton Gunyh\u00f3", "BiasSemitone", "Bias/Semitone", "Offset an incoming voltage by volts or semitones", "utility polyphonic" },
 { "LittleUtils", "Little Utils", "", "M\u00e1rton Gunyh\u00f3", "MultiplyDivide", "Multiply/Divide", "Multiply or divide two signals", "utility polyphonic" },
 { "LittleUtils", "Little Utils", "", "M\u00e1rton Gunyh\u00f3", "PulseGenerator", "Pulse Generator", "Generate rectangular pulses with a given duration", "utility envelope generator polyphonic" },
 { "LittleUtils", "Little Utils", "", "M\u00e1rton Gunyh\u00f3", "TeleportIn", "Teleport In", "Send signals wirelessly to one or more Teleport Out modules", "utility polyphonic" },
 { "LittleUtils", "Little Utils", "", "M\u00e1rton Gunyh\u00f3", "TeleportOut", "Teleport Out", "Receive signals wirelessly from a Teleport In module", "utility polyphonic" },
 { "LOGinstruments", "LOGinstruments", "LOGinstruments", "L.Gabrielli", "Speck", "Speck", "FFT Spectrum Analysis", "Visual" },
 { "LOGinstruments", "LOGinstruments", "LOGinstruments", "L.Gabrielli", "Crystal", "Crystal", "Unpredictable oscillator - handle with care", "Oscillator" },
 { "LOGinstruments", "LOGinstruments", "LOGinstruments", "L.Gabrielli", "Velvet", "Velvet", "Velvet Noise generator", "Noise Random" },
 { "LOGinstruments", "LOGinstruments", "LOGinstruments", "L.Gabrielli", "LessMess", "Less Mess", "Add labels to your cables", "Utility" },
 { "LomasModules", "Lomas Modules", "Lomas", "Guillermo Moreno", "AdvancedSampler", "Advanced Sampler", "Monophonic sampler.", "Sampler Drums" },
 { "LomasModules", "Lomas Modules", "Lomas", "Guillermo Moreno", "GateSequencer", "Gate Sequencer", "Gate sequencer with 4 patterns and up to 64 steps. Pattern length", "Sequencer Expander" },
 { "LoopusModules", "Loopus Modules", "Sonus Dept.", "Sonus Dept.", "Foursome", "Foursome", "Four tracks looper", "Recording Sampler" },
 { "LoopusModules", "Loopus Modules", "Sonus Dept.", "Sonus Dept.", "Voyeur", "Voyeur", "Looper expander", "Expander Recording Sampler" },
 { "LoudNumbers", "Loud Numbers", "", "Duncan Geere", "LoudNumbers", "Loud Numbers", "Data sonification", "Sequencer Utility" },
 { "luckyxxl", "luckyxxl", "luckyxxl", "luckyxxl", "Distribute2", "Distribute2", "", "Multiple" },
 { "luckyxxl", "luckyxxl", "luckyxxl", "luckyxxl", "Distribute", "Distribute4", "", "Multiple" },
 { "luckyxxl", "luckyxxl", "luckyxxl", "luckyxxl", "Quantize", "Quantize", "", "Quantizer" },
 { "luckyxxl", "luckyxxl", "luckyxxl", "luckyxxl", "Tick", "Tick", "", "Clock" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "ADC", "Analogue to Digital Converter", "Analogue to Digital Converter", "Utility" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "DAC", "Digital to Analogue Converter", "Digital to Analogue Converter", "Utility" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "Buttons", "Hex manual logic buttons", "Hex manual logic buttons", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4000", "CD4000 Dual 3-Input NOR Gate plus Inverter", "Dual 3-Input NOR Gate plus Inverter", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4001", "CD4001 Quad 2-Input NOR Gate", "Quad 2-Input NOR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4002", "CD4002 Dual 4-Input NOR Gate", "Dual 4-Input NOR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4010", "CD4010 Hex Buffer", "Hex Buffer", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4011", "CD4011 Quad 2-Input NAND Gate", "Quad 2-Input NAND Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4012", "CD4012 Dual 4-Input NAND Gate", "Dual 4-Input NAND Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4015", "CD4015 Dual 4-Stage Static Shift Register", "Dual 4-Stage Static Shift Register", "Logic Clock modulator" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4017", "CD4017 Decade Counter/Divider", "Decade Counter/Divider", "Logic Clock modulator" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4019", "CD4019 Quad AND-OR Select Gate", "Quad AND-OR Select Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4022", "CD4022 Octal Counter/Divider", "Octal Counter/Divider", "Logic Clock modulator" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4023", "CD4023 Triple 3-Input NAND Gate", "Triple 3-Input NAND Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4025", "CD4025 Triple 3-Input NOR Gate", "Triple 3-Input NOR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4030", "CD4030 Quad 2-Input XOR Gate", "Quad 2-Input XOR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4031", "CD4031 64 Stage Static Shift Register", "64 Stage Static Shift Register", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4041", "CD4041 Quad True/Complement Buffer", "Quad True/Complement Buffer", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4042", "CD4042 Quad Clocked \"D\" Latch", "Quad Clocked \"D\" Latch", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4048", "CD4048 Multifunction Expandable 8-Input Gate", "Multifunction Expandable 8-Input Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4049", "CD4049 Hex Inverter", "Hex Inverter", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4063", "CD4063 4-Bit Magnitude Comparator", "4-Bit Magnitude Comparator", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4068", "CD4068 8-Input AND/NAND Gate", "8-Input AND/NAND Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4071", "CD4071 Quad 2-Input OR Gate", "Quad 2-Input OR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4072", "CD4072 Dual 4-Input OR Gate", "Dual 4-Input OR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4073", "CD4073 Triple 3-Input AND Gate", "Triple 3-Input AND Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4075", "CD4075 Triple 3-Input OR Gate", "Triple 3-Input OR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4077", "CD4077 Quad 2-Input XNOR Gate", "Quad 2-Input XNOR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4078", "CD4078 8-Input OR/NOR Gate", "8-Input OR/NOR Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4081", "CD4081 Quad 2-Input AND Gate", "Quad 2-Input AND Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4082", "CD4082 Dual 4-Input AND Gate", "Dual 4-Input AND Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "ConstantOnes", "Ones", "Constant Logical Ones", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "ConstantZeroes", "Zeroes", "Constant Logical Zeroes", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4086", "CD4086 Expandable 4-Wide 2-Input AND-OR-INVERT Gate", "Expandable 4-Wide 2-Input AND-OR-INVERT Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4532", "CD4532 8-Bit Priority Encoder", "8-Bit Priority Encoder", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "MC14530", "MC14530 Dual 5 Input Majority Gate", "Dual 5 Input Majority Gate", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD40106", "CD40106 Hex Schmitt-Trigger Inverters", "Hex Schmitt-Trigger Inverters", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4020", "CD4020 14-Stage Ripple-Carry Binary Counter/Divider", "14-Stage Ripple-Carry Binary Counter/Divider", "Logic Clock modulator" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4040", "CD4040 12-Stage Ripple-Carry Binary Counter/Divider", "12-Stage Ripple-Carry Binary Counter/Divider", "Logic Clock modulator" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4024", "CD4024 7-Stage Ripple-Carry Binary Counter/Divider", "7-Stage Ripple-Carry Binary Counter/Divider", "Logic Clock modulator" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4562", "CD4562 128 Stage Static Shift Register", "128 Stage Static Shift Register", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4008", "CD4008 4-Bit Full Adder With Parallel Carry Out", "4-Bit Full Adder With Parallel Carry Out", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4514", "CD4514 4-Bit Latched/4-to-16 Line Decoder (Active High Outputs)", "4-Bit Latched/4-to-16 Line Decoder with Active High Outputs)", "Logic" },
 { "LunettaModula", "Lunetta Modula by Count Modula", "Lunetta Modula", "Adam Verspaget", "CD4515", "CD4515 4-Bit Latched/4-to-16 Line Decoder (Active Low Outputs)", "4-Bit Latched/4-to-16 Line Decoder with Active Low Outputs", "Logic" },
 { "LyraeModules", "LyraeModules", "LyraeModules", "Vega Deftwing", "Sulafat", "Sulafat", "Distortion at 15 Solar Radii", "Distortion Waveshaper" },
 { "LyraeModules", "LyraeModules", "LyraeModules", "Vega Deftwing", "Gamma", "Gamma", "", "Utility" },
 { "LyraeModules", "LyraeModules", "LyraeModules", "Vega Deftwing", "Delta", "Delta", "So I heard you like ringmod", "Ring modulator" },
 { "LyraeModules", "LyraeModules", "LyraeModules", "Vega Deftwing", "Vega", "Vega", "ADSR with per stage outputs and ringmod", "Envelope Generator" },
 { "LyraeModules", "LyraeModules", "LyraeModules", "Vega Deftwing", "BD383238", "BD383238", "Expander for Vega ADSR", "Expander" },
 { "Madness", "Madness", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "KOSC", "Azathoth", "Chaotic oscillator (new)", "Oscillator Noise Hardware clone" },
 { "Madness", "Madness", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "KLFO", "Nyarlathotep", "Chaotic oscillator LFO (hbd Ryan!)", "Oscillator Low-frequency oscillator Noise Hardware clone" },
 { "Madness", "Madness", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "VCTRL", "Hastur", "Vactrol emulation", "Delay Envelope follower Voltage-controlled amplifier Hardware clone" },
 { "Madness", "Madness", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "SLEW", "Shoggoth", "Describe me please", "Filter" },
 { "Madness", "Madness", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "ALPG", "Yog-Sothoth", "Low pass gate emulation", "Filter" },
 { "Madness", "Madness", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "MNMX", "Eibon", "Saturating mixer", "Mixer" },
 { "manikkFree", "manikk Free Modules", "manikk", "manikk", "manikkOutbreakLink", "Outbreak Link", "SW Link to the HW manikk OUTBREAK", "MIDI" },
 { "manikkFree", "manikk Free Modules", "manikk", "manikk", "manikkShmix", "SHMIX", "6 channel mixer with level shift", "Mixer Hardware clone" },
 { "manikkFree", "manikk Free Modules", "manikk", "manikk", "manikkMash", "MASH", "1 Attenuverter, 2 Attenuators and Buffered multiple", "Utility Hardware clone" },
 { "manikkFree", "manikk Free Modules", "manikk", "manikk", "manikkDual3ChMixer", "Dual 3 Channel Mixer", "Dual 3 channel mixer. The upper mixer output is normalized to the lower mixer input 1", "Mixer Hardware clone" },
 { "manikkFree", "manikk Free Modules", "manikk", "manikk", "manikkDualMultiple", "Dual Active Multiple", "Dual active multiple. The upper multiple output 3 is normalized to the lower multiple input.", "Utility Hardware clone" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "DualAmp", "DualAmp", "Dual amplifier with up to X3 Gain", "Dual Attenuator Utility" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "StereoMult8", "StereoMult8", "Stereo multiplier 1x8", "Dual Multiple Utility" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "InSel8", "InSel8", "Input Selector 8x1", "Multiple Utility" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "OutSel8", "OutSel8", "Output Selector 1x8", "Multiple Utility" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "PanelA4", "Panel A4", "Blanking Panel 4hp", "Blank" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "PanelB4", "Panel B4", "Blanking Panel 4hp", "Blank" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "PanelC4", "Panel C4", "Blanking Panel 4hp", "Blank" },
 { "Mantra", "Mantra", "", "Giovanni Gramegna", "PanelD4", "Panel D4", "Power Panel 4hp", "Blank" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalMults", "MentalMults", "Dual multiple", "Multiple" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalMixer", "MentalMixer", "12 channel stereo mixer with 2 auxiliaries", "Mixer" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalSubMixer", "MentalSubMixer", "Simple 4 channel stereo mixer", "Mixer" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalFold", "MentalFold", "Wave Folder", "Effect" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalClip", "MentalClip", "Wave clipper", "Effect" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalGates", "MentalGates", "Gates or Mutes", "Switch Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalABSwitches", "MentalABSwitches", "A/B Switches, select A or B output", "Switch Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalQuantiser", "MentalQuantiser", "", "Quantizer Tuner" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalChord", "MentalChord", "Generates chords based on input pitch CV", "Controller" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalMuxes", "MentalMuxes", "Multiplexers", "Switch Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalLogic", "MentalLogic", "And, Or, Not logic gates", "Logic Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalButtons", "MentalButtons", "Control buttons and switches", "Controller Switch" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalSums", "MentalSums", "Dual 4 channel summing mixer", "Mixer" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalPitchShift", "MentalPitchShift", "Shift CVs by octaves or semitones", "Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalCartesian", "MentalCartesian", "Grid Sequencer based on Make Noise's Rene", "Sequencer" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalPatchMatrix", "MentalPatchMatrix", "10 * 10 switched summing matrix", "Switch Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalBinaryDecoder", "MentalBinaryDecoder", "", "Utility Logic" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalSwitch8", "MentalSwitch8", "Send one input and a selected output", "Switch" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalClockDivider", "MentalClockDivider", "Clock divider with odd number division outputs", "Clock" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalMux8", "MentalMux8", "8 input Multiplexer", "Utility Switch" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalCounters", "MentalCounters", "Clocked Counters", "Clock Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalKnobs", "MentalKnobs", "Outputs Constant CVs", "Controller Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalMasterClock", "MentalMasterClock", "BPM setable clock with division outputs", "Clock" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalGateMaker", "MentalGateMaker", "triggerable clocked gate with delay and tail", "Utility" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalQuadLFO", "MentalQuadLFO", "Quad LFO based on Batumi", "LFO Quad" },
 { "Mental", "Mental", "Strum's VCV Modules", "Strum", "MentalRadioButtons", "MentalRadioButtons", "Radio Buttons", "Switch Controller" },
 { "MH", "MH", "MH", "M. Terry Hunter", "Spiro", "Spiro", "", "Visual" },
 { "MicMusic", "MicMusic", "MicMusic", "Mike Maximov", "Seven", "SeVeN", "Adds +-1V signals", "Utility" },
 { "MicMusic", "MicMusic", "MicMusic", "Mike Maximov", "Cuter", "CuTeR", "Simple distortion - cuts signal between levels", "Distortion" },
 { "MindMeld-ShapeMasterPro", "ShapeMaster Pro", "MindMeld", "S.Baker and M.Boul\u00e9 ", "UMeld", "uMeld", "8-channel merge for SM-Pro CVs", "Polyphonic Utility" },
 { "MindMeld-ShapeMasterPro", "ShapeMaster Pro", "MindMeld", "S.Baker and M.Boul\u00e9 ", "ShapeMasterCvExpander", "ShapeMasterPro Cv Expander", "CV expander for ShapeMaster Pro", "Envelope generator LFO Sequencer Expander" },
 { "MindMeld-ShapeMasterPro", "ShapeMaster Pro", "MindMeld", "S.Baker and M.Boul\u00e9 ", "ShapeMasterPro", "ShapeMaster Pro", "Multi-Stage Envelope Generator (MSEG) / Complex LFO", "Envelope generator LFO Sequencer" },
 { "MindMeld-ShapeMasterPro", "ShapeMaster Pro", "MindMeld", "S.Baker and M.Boul\u00e9 ", "ShapeMasterTrigExpander", "ShapeMasterPro Trigger Expander", "Trigger expander for ShapeMaster Pro", "Envelope generator LFO Sequencer Expander" },
 { "MindMeld-ShapeMasterPro", "ShapeMaster Pro", "MindMeld", "S.Baker and M.Boul\u00e9 ", "ShapeTracker", "ShapeTracker", "Shape section gate and trigger generator for ShapeMaster PRO", "Utility" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "MixMasterJr", "MixMasterJr", "8-track stereo mixer with 2 group busses", "Mixer" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "AuxExpanderJr", "AuxSpanderJr", "4-aux FX bus expander for MixMasterJr", "Mixer Expander" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "MixMaster", "MixMaster", "16-track stereo mixer with 4 group busses", "Mixer" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "AuxExpander", "AuxSpander", "4-aux FX bus expander for MixMaster", "Mixer Expander" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "EqMaster", "EqMaster", "24-track EQ for MixMaster and MixMasterJr", "Equalizer" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "EqExpander", "EqSpander", "CV expander for EqMaster", "Equalizer Expander" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "Meld", "Meld", "8-track stereo merge for MixMaster", "Polyphonic Utility" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "Unmeld", "Unmeld", "8-track stereo splitter for MixMaster", "Polyphonic Utility" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "MSMelder", "M/S Melder", "Mid-side splitting and merging for MixMaster, VCV Mid/Side and EqMaster", "Polyphonic Utility" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "BassMasterJr", "BassMasterJr", "Dual band spatialiser for high spread and bass mono", "Utility Equalizer" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "BassMaster", "BassMaster", "Dual band spatialiser for high spread and bass mono with VU meter", "Utility Equalizer" },
 { "MindMeldModular", "MindMeld", "MindMeld", "S.Baker and M.Boul\u00e9 ", "ShapeMaster", "ShapeMaster", "Multi-Stage Envelope Generator (MSEG) / Complex LFO", "Envelope generator LFO Sequencer" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "BPMdetect", "BPM Tools", "detect incoming clock and output voltages for Fundamental LFO and Delay", "Clock generator Clock modulator" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Constants", "Constants", "Output constant voltages corresponding to common intervals", "Utility" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Counter", "Counter", "Create Trigger pulses after a certain number of clock ticks", "Clock modulator" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "FreeVerb", "FreeVerb", "VCV Rack implementation of the good old Freeverb", "Effect Reverb" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "OctaFlop", "OctaFlop", "8 Flip Flops, pre-wired as binary counter", "Utility Clock modulator" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "OctaPlus", "OctaPlus", "8 fold Adder.", "Utility Mixer Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "OctaSwitch", "OctaSwitch", "8 fold switch with CV controllable switching point", "Switch Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "OctaTimes", "OctaTimes", "8 fold multiplier", "Utility Ring modulator Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "OctaTrig", "OctaTrig", "Gate tp Trigger converter", "Clock modulator Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Quantizer", "Quantizer (h-bar)", "Semitone quantizer", "Quantizer Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Quantum", "Quantum", "Quantizer with selectable notes", "Quantizer Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "SH8", "S&H 8", "8 fold Sample and Hold", "Sample and hold Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "SeqSwitch", "Sequential Switch 8->1", "", "Switch Sequencer Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "SeqSwitch2", "Sequential Switch 1->8", "", "Switch Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "ShiftRegister", "Shift Register", "Analogue shift register", "Sample and hold Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Evolution", "Evolution", "Shift register based random sequencer", "Sequencer Sample and hold Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Sum8mk2", "Sum8 MkII", "Summer with selectable sign", "Mixer Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Sum8mk3", "Sum8 MkIII", "Summer with selectable sign", "Mixer Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Sum8", "Sum8", "simple summer", "Mixer Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "TrigBuf", "Trigger Buffer", "A trigger can be buffered, so that the next incoming clock will create an pulse.", "Utility Logic Dual Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "TrigDelay", "Trigger Delay", "Trigger delay and gate length modulator", "Utility Delay Dual" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "TrigSwitch", "TrigSwitch 8->1", "", "Switch Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "TrigSwitch2", "TrigSwitch 1->8", "", "Switch Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "TrigSwitch3", "TrigSwitch3 8->1", "", "Switch Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "TrigSwitch3_2", "TrigSwitch3 1->8", "", "Switch Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "VoltMeter", "Volt Meter", "", "Utility" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Cloner", "Cloner", "Clone a signal to polyphonic channels", "Utility Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "PolySplitter", "Poly Splitter", "split polyphonic inputs into two outputs", "Utility Polyphonic" },
 { "ML_modules", "ML Modules", "ML Modules", "Martin Lueders", "Arpeggiator", "Arpeggiator", "multi-channel arpeggiator", "Sequencer Polyphonic Arpeggiator" },
 { "ML_modules_QU", "Quantum Multiverse", "ML Modules", "Martin Lueders", "Quantum_Pro", "Quantum Multiverse", "", "Quantizer Polyphonic" },
 { "ML_modules_seq", "Sequencer Pack", "ML Modules", "Martin Lueders", "Mem_Sequencer", "Memory Sequencer", "", "Sequencer" },
 { "ML_modules_seq", "Sequencer Pack", "ML Modules", "Martin Lueders", "Analog_Sequencer", "Analog Sequencer", "", "Sequencer" },
 { "mmmodules", "mmmodules", "mmmodules", "Myst Mach", "3mountains", "3mountains", "Triple oscillator", "oscillator" },
 { "MM_ModelV", "Model V", "Mockba Modular", "Mockba the Borg", "ModelV", "Model V", "Virtual analog 3-oscillator polysynth", "Polyphonic Oscillator Synth voice" },
 { "MM_ModelX", "Model X", "Mockba Modular", "Mockba the Borg", "ModelX", "Model X", "Virtual analog 3-oscillator hybrid polysynth", "Polyphonic Oscillator Synth voice" },
 { "MM_Oscah", "Special Vintage Oscillators", "Mockba Modular", "Mockba the Borg", "CZOscah", "CZ Oscah", "Casio CZ like oscillator with wave sequence", "Polyphonic Oscillator" },
 { "MM_Oscah", "Special Vintage Oscillators", "Mockba Modular", "Mockba the Borg", "MaugOscah", "Maug Oscah", "Moog like oscillator with wave sequence", "Polyphonic Oscillator" },
 { "MM_Oscah", "Special Vintage Oscillators", "Mockba Modular", "Mockba the Borg", "MixOscah", "Mix Oscah", "Mixing waves oscillator", "Polyphonic Oscillator" },
 { "MM_Oscah", "Special Vintage Oscillators", "Mockba Modular", "Mockba the Borg", "WMOscah", "WaveMod Oscah", "Modulating waves oscillator", "Polyphonic Oscillator" },
 { "MM_Proton", "Proton", "Mockba Modular", "Mockba the Borg", "Proton", "Proton", "Virtual analog 3-oscillator polysynth", "Polyphonic Oscillator Synth voice" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "SMExpL", "SMExpL", "Split/Merge Mix Expander (left side, no crossfade)", "Utility Polyphonic" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "SMMix", "SMMix", "8 Channel splitter/merger with signal mix (crossfade)", "Utility Polyphonic" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "SMExpR", "SMExpR", "Split/Merge Mix Expander (right side, no crossfade)", "Utility Polyphonic" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "SHEight", "SHEight", "8 Channel S&H with poly output and clock", "Sample and Hold Polyphonic" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "sLewd", "sLewd", "8 Channel Slew Limiter for SHEight", "Expander" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "ASSprdr", "ASSprdr", "Multi channel automatic stereo spreader/combiner", "Utility Polyphonic" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "TheCBlocker", "TheCBlocker", "Polyphonic adjustable DC blocker", "Filter Polyphonic" },
 { "MM_Tools", "Mockba Modular Tools", "Mockba Modular", "Mockba the Borg", "Tuube", "Tuube", "Simple tube saturator/distortion", "Distortion Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Blank", "Blank", "Simple blank", "Blank" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Feidah", "Feidah", "Simple signal fader with VCA", "Attenuator VCA Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "FeidahS", "FeidahS", "Simple stereo signal fader with VCA", "Attenuator VCA Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Filtah", "Filtah", "Simple Moog style filter", "Filter Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Mixah", "Mixah", "Simple two signal mixer with VCA", "Mixer VCA Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Mixah3", "Mixah3", "Simple three signal mixer", "Mixer Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Dividah", "Dividah", "Simple clock divider", "Clock modulator" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Countah", "Countah", "Simple clock counter", "Clock modulator" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Selectah", "Selectah", "Simple 4 to 1 selector", "Utility Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Shapah", "Shapah", "Simple ADSR envelope shaper", "Envelope generator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Holdah", "Holdah", "Simple Sample & Hold", "Sample and hold" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Pannah", "Pannah", "Simple stereo panner with modulation", "Panning Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "ReVoltah", "ReVoltah", "Simple voltage range adapter", "Utility Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZSaw", "CZSaw", "Simple CZ style SAW oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZSquare", "CZSquare", "Simple CZ style SQUARE oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZPulse", "CZPulse", "Simple CZ style PULSE oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZDblSine", "CZDblSine", "Simple CZ style DBLSINE oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZSawPulse", "CZSawPulse", "Simple CZ style SAWPULSE oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZReso1", "CZReso1", "Simple CZ style RESO1 oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZReso2", "CZReso2", "Simple CZ style RESO2 oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZReso3", "CZReso3", "Simple CZ style RESO3 oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "CZOsc", "CZOsc", "Simple CZ style oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugTriangle", "MaugTriangle", "Simple Moog style TRIANGLE oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugShark", "MaugShark", "Simple Moog style SHARK oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugSaw", "MaugSaw", "Simple Moog style SAW oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugSaw2", "MaugSaw2", "Simple Moog style INVSAW oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugSquare", "MaugSquare", "Simple Moog style SQUARE .48 oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugSquare2", "MaugSquare2", "Simple Moog style SQUARE .29 oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugSquare3", "MaugSquare3", "Simple Moog style SQUARE .17 oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "MaugOsc", "MaugOsc", "Simple Moog style oscillator", "Oscillator Polyphonic" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "Comparator", "Comparator", "Simple voltage comparator", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualBUFFER", "DualBUFFER", "Simple BUFFER gates (3 actually)", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualNOT", "DualNOT", "Simple NOT gates (3 actually)", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualOR", "DualOR", "Simple OR gates", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualNOR", "DualNOR", "Simple NOR gates", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualAND", "DualAND", "Simple AND gates", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualNAND", "DualNAND", "Simple NAND gates", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualXOR", "DualXOR", "Simple XOR gates", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "DualXNOR", "DualXNOR", "Simple XNOR gates", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "PSelectah", "PSelectah", "Simple Priority Selector (AND->OR MUX)", "Logic Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "UDPClockMaster", "Mastah", "UDP Clock Synchronizer (Master)", "Utility" },
 { "MockbaModular", "Mockba Modular", "Mockba Modular", "Mockba the Borg", "UDPClockSlave", "Slavah", "UDP Clock Synchronizer (Slave)", "Utility" },
 { "moDllz", "moDllz", "moDllz", "Pablo DeLaLoza", "MIDIpolyMPE", "MIDIpolyMPE", "Polyphonic MIDI to CV with MPE mode", "MIDI External Polyphonic" },
 { "moDllz", "moDllz", "moDllz", "Pablo DeLaLoza", "PolyGlider", "PolyGlider", "Polyphonic Slew limiter ~ Portamento ~ Glide", "Polyphonic Slew limiter Envelope Follower" },
 { "moDllz", "moDllz", "moDllz", "Pablo DeLaLoza", "Kn8b", "Kn8b", "Polyphonic Attenuator / Inverter / VCA", "Utility Polyphonic Attenuator VCA" },
 { "moDllz", "moDllz", "moDllz", "Pablo DeLaLoza", "Xpand", "Xpand", "Voice & Outputs expander for MIDIpolyMPE", "MIDI Utility External Polyphonic" },
 { "modular80", "modular80", "modular80", "cschol", "Logistiker", "Logistiker", "Chaotic CV generator based on Logistics equation", "Random Sample and hold" },
 { "modular80", "modular80", "modular80", "cschol", "RadioMusic", "Radio Music", "The Music Thing Modular Radio Music is a sampler pretending to be a radio", "Sampler Hardware clone" },
 { "modular80", "modular80", "modular80", "cschol", "Nosering", "Nosering", "Interpretation of Grant Richter's Noisering design", "Noise Random Sample and hold" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank1HP", "Blank 1HP", "1 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank3HP", "Blank 3HP", "3 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank4HP", "Blank 4HP", "4 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank6HP", "Blank 6HP", "6 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank10HP", "Blank 10HP", "10 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank12HP", "Blank 12HP", "12 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank16HP", "Blank 16HP", "16 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank20HP", "Blank 20HP", "20 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank26HP", "Blank 26HP", "26 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Blank32HP", "Blank 32HP", "32 HP Blanking Plate", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Color12HP", "Color Scheme", "12 HP Blanking Plate with Color Key", "Blank" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "LightsOff", "Lights Off", "Dim the lights in your Rack!", "Utility" },
 { "ModularFungi", "Modular Fungi", "", "Omri Cohen", "Opsylloscope", "Opsylloscope", "Scope for when the lights are off", "Utility" },
 { "Mog", "Mog", "Mog", "Mog", "Network", "Network", "Node-based polyphonic sequencer", "Sequencer Polyphonic" },
 { "Mog", "Mog", "Mog", "Mog", "Nexus", "Nexus", "Combination clock divider & sequential switch", "Clock modulator Polyphonic" },
 { "Mojo", "Mojo", "Mojo Modules", "Tom DA SILVA FARIA", "dogs", "Dogs", "A doggy drive effect", "Effect Distortion Waveshaper" },
 { "Mojo", "Mojo", "Mojo Modules", "Tom DA SILVA FARIA", "pigs", "Pigs", "A porky bass sounds generator", "Oscillator" },
 { "Mojo", "Mojo", "Mojo Modules", "Tom DA SILVA FARIA", "sheep", "Sheep", "A sheepy random voltage generator", "Random Noise" },
 { "MosquitoLabs", "Mosquito Labs", "", "R. Mosquito", "PulseCzar", "PulseCzar", "8-bit wavetable oscillator based on C. Roads' Pulsar Synthesis model.", "Oscillator" },
 { "MosquitoLabs", "Mosquito Labs", "", "R. Mosquito", "PhaseCzar", "PhaseCzar", "8-bit wavetable oscillator based on Casio's Phase Distortion model.", "Oscillator" },
 { "MosquitoLabs", "Mosquito Labs", "", "R. Mosquito", "FoldCzar", "FoldCzar", "Variable slope oscillator with integrated wavefolding and pole-swapping.", "Oscillator" },
 { "MpSeries", "MpSeries", "MpSeries", "Omer Liberman", "MpMap", "MpMapper", "", "CONTROLLER" },
 { "MpSeries", "MpSeries", "MpSeries", "Omer Liberman", "Mp09", "CV-09", "", "CONTROLLER" },
 { "MrLumps", "MrLumps", "MrLumps", "David Peterson", "SEQE", "SEQEuclid", "Euclidean Sequencer", "Sequencer" },
 { "MrLumps", "MrLumps", "MrLumps", "David Peterson", "VCS1", "VCS1", "1x8 Voltage Controlled Switch", "Switch" },
 { "MrLumps", "MrLumps", "MrLumps", "David Peterson", "VCS2", "VCS2", "2x4 Voltage Controlled Switch", "Switch" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Compressor1", "Compressor", "Compressor", "Compressor" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "MasterClockx4", "Master Clock x4", "4 Channel Clock", "Clock" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "SEQ_Envelope_8", "ENVY - 9", "9 Channel Editable Envelope Generator", "Sequencer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "TriadSeq2", "Triad 2 Sequencer", "3 Channel Keyboard Sequencer", "Sequencer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "ARP700", "ARP 700", "7 Note programmable Arpeggiator", "Arpeggiator" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Seq_6ch_32step", "SEQ 6 x 32", "6 Channel 32 step voltage/trigger sequencer", "Sequencer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Osc_3Ch_Widget", "OSC 3 Channel", "3 Channel Synth", "Synth voice" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "PingPong_Widget", "Ping Pong", "Ping Pong Delay", "Delay" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "StepDelay", "Step Delay", "Step Delay", "Delay" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Mix_4_0_4", "MIX 4 Channel", "4 Channel Mixer", "Mixer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Mix_9_3_4", "MIX 9 Channel, 3 Groups", "9 Channel Mixer", "Mixer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Mix_16_4_4", "MIX 16 Channel, 4 groups", "16 Channel Mixer", "Mixer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Mix_24_4_4", "MIX 24 Channel, 4 groups", "24 Channel Mixer", "Mixer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "ASAF8", "ASAF8", "8 Channel Auto Stereo Audio Fader", "Mixer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Dronez", "Dronez", "Random Drone", "Oscillator" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Alienz", "Alienz", "Alien transmissions", "Oscillator" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Windz", "Windz", "Random Noise", "Random Noise" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Lorenz", "Lorenz", "Lorenz Attractor", "Random Noise" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Morze", "Morze", "Morse Code Generator", "Sequencer" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "OSC_WaveMorph_3", "Wave morph Oscillator", "CV Morph 3 Drawable Waveforms", "Oscillator" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "SynthDrums", "Synth Drums", "3 Channel Synth Drums", "Drum" },
 { "mscHack", "mscHack", "mscHack", "mscHack", "Maude221", "Maude Two to One", "Rectify/Combine 2 mono signals", "Waveshaper" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "ADSR", "ADSR", "ADSR Envelope Generator with modifiable curve shapes", "Envelope generator" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Bitcrusher", "Bitcrusher", "Distortion effect by changing the sample's bit length and sample rate", "Effect" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "BlankPanel", "Blank Panel", "Blank panel utilizing the MSM logo", "Blank" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "DualDelay", "Dual Delay", "Two independent delay lines with low/hi pass filters", "Delay" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "TreasureVCO", "Treasure VCO", "Voltage Controlled Oscillator with complex waveform modulation", "Oscillator" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Fade", "Fade", "Triple fader module", "Mixer" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "MLFO", "MLFO", "Low frequency oscillator with multiple waveform types", "LFO" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Morph", "Morph", "Variable input morpher with 8 inputs", "Effect" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Mult", "Mult", "Triple independent add/subtract split utility", "Multiple" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Noise", "Noise", "Noise generator with white, pink, brown and variable colored noise outputs", "Noise" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Phaser", "Phaser", "2-20 stage phaser distortion effect", "Effect" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "RandomSource", "Random Source", "Random source that produces variable shape staircase waveforms", "Sample and hold Random" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Ring", "Ring", "Dual ring modulator", "Effect" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "SimpleSlider", "Simple Slider", "Dual input VCA/Crossfader slider", "Mixer Amplifier" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "CrazyMult", "CrazyMult", "8 way dual output signal router", "Multiple" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "PAN-VCA", "PAN-VCA", "Stereo VCA/PAN combination", "Amplifier Panning" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "OSCiX", "OSCiX", "Advanced dual oscillator/LFO with a built-in wave folder", "Oscillator" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Rogue", "Rogue", "OSCiX's little brother. Advanced oscillator/LFO with multiple waveform type outputs", "Oscillator" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "Wavefolder", "Wavefolder", "Advanced wave folder with variable symmetry controls", "Waveshaper" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "WaveShaper", "WaveShaper", "Unique wave folder with multiple folding algorithms", "Waveshaper" },
 { "MSM", "MSM", "MSM", "Phal-anx, Netboy3", "XSEQ", "XSEQ", "Boolean logic sequencer", "Logic Random" },
 { "MyLittleTools", "MyLittleTools", "", "digitalhappens.de", "MyLittleFavorites", "MyLittleFavorites", "favorite module handling, with state saving and loading", "utility" },
 { "MyLittleTools", "MyLittleTools", "", "digitalhappens.de", "MyLittleTags", "MyLittleTags", "browse modules by tags the old way (without screenshots)", "utility" },
 { "Myth", "Myth", "Myth", "Pavlo Yevsehnieiev", "Mavka", "Mavka", "Oscillator with VCA per waveform", "Oscillator" },
 { "Myth", "Myth", "Myth", "Pavlo Yevsehnieiev", "Molphar", "Molphar", "Sequencer with probabilities", "Sequencer" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "MAR", "MAR", "Dual Eurorack Mixer", "Mixer Attenuator Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "FONT", "FONT", "Massive Sounding Liquid Filter", "Filter Oscillator Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "ALT", "ALT", "Quad Voltage Controlled Amplifier & Cascading Mixer", "Attenuator Mixer Quad VCA Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "QUART", "QUART", "Quad AD Envelope & LFO Generator", "Envelope generator LFO Oscillator Function generator Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "ONA", "ONA", "Analog Multifunction Oscillator", "Oscillator LFO Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "BLANK12Hp", "BLANK 12Hp", "Boast & protect your VCV rack", "Blank Visual Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "BLANK8Hp", "BLANK 8Hp", "Boast & protect your VCV rack", "Blank Visual Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "BLANK6Hp", "BLANK 6Hp", "Boast & protect your VCV rack", "Blank Visual Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "BLANK4Hp", "BLANK 4Hp", "Boast & protect your VCV rack", "Blank Visual Hardware clone" },
 { "NANOModules", "NANO Modules", "NANO Modules", "Jorge Gutierrez", "BLANK2Hp", "BLANK 2Hp", "Boast & protect your VCV rack", "Blank Visual Hardware clone" },
 { "NEXSwitches", "NEX Switches", "NEX", "Xavier Nayrac", "DoubleMute", "Double Mute", "Mute two channels at once with fades", "switch" },
 { "NEXSwitches", "NEX Switches", "NEX", "Xavier Nayrac", "TwoByTwo", "2 x 2 Mute", "Mute/unmute 2 groups of 2 inputs", "switch" },
 { "NEXSwitches", "NEX Switches", "NEX", "Xavier Nayrac", "MatrixMixer4", "Matrix Mixer 4", "4 x 4 matrix mixer", "mixer" },
 { "NocturnalEncoder", "Nocturnal Encoder", "Nocturnal Encoder", "David Peterson", "AMDecoder", "NE-1 Decoder", "Dual Amplitude Modulation Decoder", "Attenuator Slew limiter Envelope follower Dual" },
 { "NocturnalEncoder", "Nocturnal Encoder", "Nocturnal Encoder", "David Peterson", "AMEncoder", "NE-2 Encoder", "Dual Amplitude Modulation Encoder", "Oscillator Amplifier Dual" },
 { "Nohmad", "Nohmad", "", "Joel Robichaud", "Noise", "Noise", "", "Noise" },
 { "Nohmad", "Nohmad", "", "Joel Robichaud", "StrangeAttractors", "Strange Attractors", "", "Oscillator LFO" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "4Seq", "4Seq", "Dual sequencer and clock divider. Panel by jk.", "Sequencer Hardware Clone Clock Modulator" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "8BitCipher", "8-Bit Cipher", "Dual sequencer and clock divider. Panel by jk.", "Sequencer Hardware Clone Clock Modulator" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "BOOLs", "BOOLs", "Four binary logic jumblers. Panel by Papernoise.", "Logic Hardware Clone Quad" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "DivideConquer", "Divide & Conquer", "More clock dividers than you will ever need.", "Logic Clock Modulator Hardware Clone" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "DivineCMOS", "Divine CMOS", "Waveform and clock divider with multiple divison outputs, slew, and a mixer.", "Logic Hardware Clone" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "DoubleNeuron", "Double Neuron", "Two Neurons and Two Difference Rectifiers. Panel by Papernoise.", "Mixer Noise Utility Random Hardware Clone Dual" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "GENiE", "GENiE", "Three Neurons tangled together in a feedback network of chaos. Panel by jk.", "Mixer Noise Utility Random Hardware Clone" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "LetsSplosh", "Let's Splosh", "Four inputs run into lots of Difference Rectifiers for many output variations. Panel by Papernoise.", "Mixer Noise Utility Random Hardware Clone Quad" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "Neuron", "Neuron", "3-input comparator and Difference Rectifier for creating unpredictable interactions. Panel by jk.", "Mixer Noise Utility Random Hardware Clone Dual" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "Numberwang", "Numberwang", "Four gates make sixteen. That's Numberwang! Panel by jk.", "Logic Hardware Clone" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "Segue", "Segue", "Stereo channel-flipping panner, crossfader, or VCA", "Mixer Hardware Clone" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "SquidAxon", "Squid Axon", "Mixer, Shift Register, and Feedback. Panel by Jason Wehmhoener.", "Mixer Random Hardware Clone" },
 { "NonlinearCircuits", "Nonlinear Circuits", "", "Michael Hetrick", "Statues", "Statues", "1->8 Signal switch using binary inputs. Panel by jk.", "Logic Hardware Clone" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "QU4DiT", "QU4DiT", "Quadratic Iterator", "Oscillator" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "BallisticENV", "BallisticENV", "Ballistic ENV", "Envelope generator" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "LuciCell", "LuciCell", "Luci Cell", "Oscillator" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "Luci4AudioSum", "Luci4AudioSum", "Luci 4 Audio Sum", "Mixer" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "Luci4ParamDistr", "Luci4ParamDistr", "Luci 4 Param Distr", "Multiple" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "LuciControlRND", "LuciControlRND", "Luci Ctrl RAND", "Controller" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "LuciControlFREQ", "LuciControlFREQ", "Luci Ctrl FREQ", "Controller" },
 { "NonLinearInstruments", "NonLinearInstruments", "NLnRi", "Ignasi \u00c1lvarez Garriga", "LuciControlINFL", "LuciControlINFL", "Luci Ctrl INFLUENCE", "Controller" },
 { "noobhour", "noobhour", "noobhour", "Nicolas Neubauer", "baseliner", "Baseliner", "A 4x probabilistic attenuverting switch.", "random attenuator switch quad poly" },
 { "noobhour", "noobhour", "noobhour", "Nicolas Neubauer", "bsl1r", "Bsl1r", "A single-channel Baseliner.", "random attenuator switch poly" },
 { "noobhour", "noobhour", "noobhour", "Nicolas Neubauer", "customscale", "Customscaler", "A quantizer for custom, CV-modifiable scales.", "quantizer random poly" },
 { "noobhour", "noobhour", "noobhour", "Nicolas Neubauer", "Normaliser", "Normaliser", "An attenuator scaling values to an output range.", "attenuator poly" },
 { "NoraCodes", "NoraCodes", "NoraCodes", "Leonora Tindall", "NoraCodes_FivesAstable", "Fives Astable", "Astable-mode 555 oscillator", "Clock generator Low-frequency oscillator" },
 { "NoraCodes", "NoraCodes", "NoraCodes", "Leonora Tindall", "NoraCodes_FivesAstableC", "Fives Astable C", "Astable-mode 555 oscillator with period control and CV inputs.", "Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_ADSR", "Nozori_68_ADSR", "Dual loopable ADSR with modulation speed and integrated VCA", "Hardware clone Envelope generator Dual LFO" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_AR", "Nozori_68_AR", "Dual Attack Release with independent modulation", "Hardware clone Envelope generator Dual" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_CRUSH", "Nozori_68_CRUSH", "Stereo Down-sampler / Bitcrusher", "Hardware clone Digital Effect Dual" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_CV_REC", "Nozori_68_CV_REC", "Record and play back 2 independent CV, at variable speed", "Hardware clone Dual Digital Envelope generator Recording" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_DELAY", "Nozori_68_DELAY", "Audio Delay, with tempo synchronisation", "Hardware clone Dual Delay Effect" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_EQ", "Nozori_68_EQ", "3 band equalizer", "Hardware clone Dual Effect Equalizer" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_GRAN", "Nozori_68_GRAN", "Audio Granulator", "Hardware clone Digital Effect Granular" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_KS", "Nozori_68_KS", "Karplus-Strong audio model", "Hardware clone Delay Effect" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_LFO", "Nozori_68_LFO", "Dual LFO, with parametric waveform and syncronisation to any signal", "Hardware clone Dual Function generator LFO Sample and hold" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_LFO_MOD", "Nozori_68_LFO_MOD", "LFO, with parametric waveform and syncronisation to any signal", "Hardware clone Dual Function generator LFO Sample and hold" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_NOISE", "Nozori_68_NOISE", "Stereo Noise source, with low and high frequency filter", "Hardware clone Dual Noise" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_PITCH", "Nozori_68_PITCH", "Dual Pitch shifter using tape emulation", "Hardware clone Dual Effect" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_RND_LOOP", "Nozori_68_RND_LOOP", "Loop of Random Value, with various interpolation and external synchronisation", "Hardware clone Dual Function generator LFO Random" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_SIN_MOD", "Nozori_68_SIN_MOD", "Sinusoidal oscillator with 2 external modulation (PM / FM / AM)", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCA_PAN", "Nozori_68_VCA_PAN", "Stereo VCA-Panoramic, with modulation of the panoramic control", "Hardware clone Dual Effect Panning Voltage-controlled amplifier" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCF_MOD", "Nozori_68_VCF_MOD", "Stereo VCF", "Hardware clone Dual Filter" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCF_MORPH", "Nozori_68_VCF_MORPH", "Parametric stereo filter.", "Hardware clone Dual Filter" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCO", "Nozori_68_VCO", "Simple VCO, with VCA and VC Panoramic", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCO_LOOP", "Nozori_68_VCO_LOOP", "Loop of Random Value at audio rate", "Hardware clone Oscillator Random" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCO_MORPH", "Nozori_68_VCO_MORPH", "Parametric VCO, with VCA and VC Panoramic", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCO_QTZ", "Nozori_68_VCO_QTZ", "Simple VCO, with VCA", "Hardware clone Oscillator Quantizer" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_VCO_WS", "Nozori_68_VCO_WS", "Sinusoidal oscillator with VC waveshaper and VCA and VC Panoramic", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_68_WS", "Nozori_68_WS", "Wave shaper and distortion with a VC Panoramic", "Hardware clone Dual Distortion Effect Waveshaper" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_8_BITS", "Nozori_84_8_BITS", "8 bit audio generator", "Hardware clone Dual Digital Effect Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_ADD", "Nozori_84_ADD", "Additive synthesis : a sinusoidal oscillator with 6 different harmonics", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_ADSR", "Nozori_84_ADSR", "Dual ADSR with loop mode", "Hardware clone Dual Envelope generator LFO" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_CLOCK", "Nozori_84_CLOCK", "Stochastic Clock with ADSR and VCA", "Hardware clone Clock generator Envelope generator LFO" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_DOPPLER", "Nozori_84_DOPPLER", "Emulate a Doppler effect applied on an audio source", "Hardware clone Delay Effect" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_FM", "Nozori_84_FM", "Sinusoidal oscillator with 3 modulations oscillators", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_FM_LIN", "Nozori_84_FM_LIN", "4 sinusoidal oscillators linear FM synthesis", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_HARMONICS", "Nozori_84_HARMONICS", "Sinusoidal oscillator with 3 harmonics at variable relative frequency", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_JONG_LFO", "Nozori_84_JONG_LFO", "Peter de Jong chaotic attractor", "Hardware clone Function generator LFO" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_JONG_VCO", "Nozori_84_JONG_VCO", "Peter de Jong chaotic attractor at audio frequency", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_LFO", "Nozori_84_LFO", "Dual LFO", "Hardware clone Dual Function generator LFO Sample and hold" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_LFO_SEQ", "Nozori_84_LFO_SEQ", "6 step LFO / Sequencer", "Hardware clone Function generator LFO Sequencer" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_MODULATE", "Nozori_84_MODULATE", "Modulate 2 audio sources together using various algorithms", "Hardware clone Digital Effect Ring modulator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_PARAM", "Nozori_84_PARAM", "6 points parametric audio oscillator", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_SEQ_4", "Nozori_84_SEQ_4", "4 step sequencer with parameterizable step length", "Hardware clone Sequencer" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_SEQ_8", "Nozori_84_SEQ_8", "8 steps sequencer", "Hardware clone Sequencer" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_SIN_AM", "Nozori_84_SIN_AM", "4 oscillators AM modulation oscillator", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_SIN_FM", "Nozori_84_SIN_FM", "4 oscillators FM modulation oscillator", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_SIN_PM", "Nozori_84_SIN_PM", "4 oscillators Phase Modulation oscillator", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_SIN_WS", "Nozori_84_SIN_WS", "Dual oscillator and a Peter De Jong waveshaper", "Hardware clone Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_THOMAS", "Nozori_84_THOMAS", "Dual Thomas strange attractor for CV or audio noise source", "Hardware clone Digital LFO Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_TROPICAL", "Nozori_84_TROPICAL", "Tropical additive synthesis", "Hardware clone Digital Oscillator" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_VCF", "Nozori_84_VCF", "Dual filter with parametric control of the frequency response.", "Hardware clone Filter" },
 { "Nozoid", "Nozoid", "nozo\u00efd", "Cyrille Henry", "Nozori_84_WS", "Nozori_84_WS", "Stereo Wave Shaper", "Hardware clone Distortion Effect Waveshaper" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Logic", "Logic AND, OR, XOR, NOT", "Boolean module", "AND OR XOR NOT LOGIC" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Model277", "Model277 Buchla 277 imitation", "Imitation of the Buchla 277 feedback delay with some twists", "DELAY ECHO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Surveillance", "Surveillance", "One knob to drive all! (10 CV knob)", "Utility Controller Attenuator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "NYStereoPhaser", "StereoPhaser Phaser", "96-48 cells 2nd-4th order phaser", "Effect Phaser" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "NYStereoChorus", "StereoChorus Chorus", "Stereo Chorus with added nysthi movements modulators", "Effect Chorus" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DualSignalDelayer", "DualSignalDelayer Dual Signal Delay", "Dual Signal Delay", "Effect Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "NYEnvFollower", "EnvelopeFollower Envelope Follower", "Envelope Follower", "VCA Envelope follower" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "MasterRecorder2", "Stereo Recorder vers 2", "Stereo wave recorder", "Recording" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolyRecorder", "Polyphonic Recorder", "from 1 to 16 channels recorder", "Recording Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolyRecorder64", "PolyRecorder64 64 tracks", "64 tracks recorder", "Recording Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "VUMeterDual", "Dual VU Meter with VCA", "", "Visual" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "VUMeterSingle", "Single VU Meter", "", "Visual" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "VUMeterSlim", "Single Slim VU Meter", "", "Visual" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "AttackDecay", "AttackDecay AD", "Attack Decay, AD, Envelope EG", "Envelope generator Function generator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolyAttackDecay", "PolyAttackDecay Polyphonic AD", "Polyphonic Attack Decay, AD, ADSR, Envelope Generator EG", "Envelope generator Function generator Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DelayAttackHoldDecay", "DelayAttackHoldDecay DAHD", "DAHD Delay Attack Hold Decay Envelope like 281e, Serge USG, ems trapezoid", "Envelope generator Function generator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolyDelayAttackHoldDecay", "PolyDelayAttackHoldDecay PolyDAHD", "PolyDAHD Polyphonic Delay Attack Hold Decay Envelope, like 281e, Serge USG, ems trapezoid  EG DAHD", "Envelope generator Function generator Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolyAttackDecaySustainRelease", "PolyAttackDecaySustainRelease PolyADSR", "Polyphonic Attack Decay Sustain Release Envelope", "Envelope generator Function generator Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SimplerFileControlExpander", "SimplerFileControlExpander", "Controller for files imported in complex Simpler and slim Simpler", "Utility Controller Expander" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "slimSimpler", "slimSimpler Sample Player", "Sample player VCO", "Sample player VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "complexSimpler", "complexSimpler Sampler", "Sampler VCO", "Recording Sampler VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Dica33", "Dica33 303 filter", "Distorted Acid filter 303 wannabe", "filter" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "HotTuna", "HotTuna TUNER", "Chromatic TUNER", "Utility Tuner" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SoyModelSOU", "SoyModelSOU", "Source of uncertainty Buchla266/Doepfer149 wannabe wannabe", "Random Sample and hold" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SOU-UTILS", "SOUUtils", "SoyModelSOU little helper, scaler, offsetter, voltage folders, analogue shifter", "Random Sample and hold Utility VCA Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SQUONK", "SQUONK sequencer", "sequencer, keyboard, memory, gater, bridger, ratcheter", "Sequencer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHIOMETER", "NYSTHIOMETER", "", "Blank" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "QuadPanner", "QuadPanner", "Buchla 227e single channel emulation: quadraphonic audio source placer", "Mixer Panning" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DX7Envelope", "DX7Envelope", "DX7 style envelope", "Envelope generator Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DualFeedbackEcho", "DualFeedbackEcho", "experimental delay driven by VCO", "Effect Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "4DCBlock", "Quad DC Block", "High pass filter, selectable, to avoid Direct currents", "VCF Quad" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PlateVerb", "PlateVerb: Plate Reverb", "Plate Reverb based on dattorro paper (beware, sometimes scares you!)", "Reverb Effect" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DissonantVerb", "DissonantVerb: Plate Reverb", "Plate Reverb with dual pitch shifter (with different tuning) in the feedback loop", "Reverb Effect" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "ScalaQuantizer", "ScalaQuantizer", "Quantizer based on .scl SCALA files", "Quantizer Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "EqualDivisionQuantizer", "EqualDivisionQuantizer", "Quantizer based on the formula A-th root of B", "Quantizer Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "XattoTime", "XattoDelayer", "Clockable delayer, with precise microseconds settings", "Effect Delay Quad" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "ConstAddMult", "ConstAddMult", "Utility to Add, Sub, Div and Mult", "Utility Attenuator VCA Quad Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "8AttackDecay", "8 AD", "8 Attack Decay EG with VCA and unity mixer", "Function generator Envelope generator Quad" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "QuadSimplerSlicerQuantizer", "QuadSimplerSlicerQuantizer", "Quad Equal voltage division quantizer", "Quantizer Utility Quad" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Spectre", "Spectre", "Real time spectrogram", "Visual" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DeepNote", "DeepNote", "THX effect simulator", "VCO Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DOPPLAB", "DOPPLAB Doppler simulator", "Doppler simulator", "Filter" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "StereoPhaser2", "StereoPhaser2 phaser", "12-24 cells 1st-2nd order phaser", "Effect Phaser" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "StereoChorus2", "Stereo Chorus and Tremolo", "Stereo Chorus + Tremolo with added nysthi movements modulators", "Effect Chorus" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Flipper", "Flipper", "FlipFlops and Trigs to generate GATES and TRIGS on demand ", "Logic Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DYNAMO", "DYNAMO", "Stereo compressor, hard limiter", "Effect Compressor" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Strummer", "Strummer", "String strummer device", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "AutoFader", "AutoFader", "Automated fader and cross fader", "Utility recording VCA" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "VectorMixer", "VectorMixer", "Bidimensional mixer with 4 sources and sequencer for animations", "Mixer Utility VCA" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "metaAARDVARK", "metaAARDVARK", "Warren Burt noise s&h lfo Aardvark IV RVG cell, clockable, cvable, syncable", "Noise Utility Clock S&H LFO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Jooper", "Jooper 8 channel", "8 channel, with scene manager, UNITYMIXER, MULTIPLEXER, IN-OUT SWITCH", "Switch Utility Mixer Multiple" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "ClockableDelay", "ClockableDelay", " stereo echo delay, clockable, synchronizable, DLD imitation", "Effect Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "4Hands", "4Hands", "multi value sequencer", "Controller Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "LFOMultiPhase", "LFOMultiPhase", "LFO with 8 fixed phases and 1 variable, with precise frequency setting", "LFO VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "mix4", "mix4", "4mix 4 channels stero mixer. Channel 1 LEFT is POLY in INPUT", "Mixer VCA Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "mix8", "mix8", "8mix 8 channels stero mixer. Channel 1 LEFT is POLY in INPUT", "Mixer VCA Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "mix16", "mix16", "16mix 16 channels stero mixer. Channel 1 LEFT is POLY in INPUT", "Mixer VCA Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "UNNYSTHIPLEASURESGRAPHER", "UNNYSTHIPLEASURESGRAPHER", "TOY Waterfall Spectrograph", "Visual" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Phasor", "Phasor", "Graphic Harmonic VCO", "VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "BIGNUMBER", "BIGNUMBER", "", "Visual Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "BIGBUTTON", "BIGBUTTON", "", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "OP", "\u00b5OPERATOR", "FM Operator dx7 style, Sinusoid VCO", "VCO LFO FM Polyphonic Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "EN", "\u00b5ENVELOPE", "FM Envelope generator AR or ADSR style", "Envelope generator Function generator FM" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "M1", "\u00b5MIXER", "FM Mixer helper, Stereo mixer, 3 IN channels", "Mixer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "M2", "\u00b5MIXER2", "FM Mixer helper, Mixer, 4 IN mono channels", "Mixer Quad VCA FM" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SQ1", "\u00b5SEQUENCER1", "16 steps analog style sequencer", "Sequencer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SQ2", "\u00b5SEQUENCER2", "Programmable sequencer (Roland MC-4 style)", "Sequencer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SL", "\u00b5SLEW", "Dual slew with shaper", "Dual Slew Limiter Envelope Follower Filter" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DL", "\u00b5DELAY", "Dual signal delay with display", "Effect Dual Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "confusingSimpler", "confusingSimpler", "Really confused sampler oscillator", "Recording Sampler VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "WORMHOLIZER", "WORMHOLIZER", "Wormhole effect, delay reverb", "Delay Effect Reverb" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "CONVOLVZILLA", "CONVOLVZILLA reverb", "Real time impulse convolver, convolution reverb", "Delay Effect Reverb" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Ratchet", "Ratchet", "Ratcheting helper, Timed pulse repeater", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Bridges", "Bridges", "Gate with probabilty and locks", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Bivio", "Bivio", "3 path randomizers (with probabilty and locks)", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Janneker", "Janneker", "Pulse sequencer and sequencers director", "Utility Clock" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "JannekerTimed", "JannekerTimed", "Timed pulse sequencer and sequencers director", "Utility Clock" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "MagisterFuzz", "MagisterFuzz", "Maestro Fuzz emulator", "Effect Distortion" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "RodentV2", "RodentV2", "ProCo RAT distortion emulator", "Effect Distortion" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SmashMaster", "SmashMaster", "SmashMaster distortion emulator", "Effect Distortion" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "RXG100ChanA", "RXG100ChanA", "RXG100ChanA distortion emulator", "Effect Distortion" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "RXG100ChanB", "RXG100ChanB", "RXG100ChanB distortion emulator", "Effect Distortion" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolySevenSeas", "PolySevenSeas", "Polyphonic Wavetable VCO, with bidimensional navigator", "VCO Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolySevenSeas2", "PolySevenSeas2", "Polyphonic Wavetable VCO, with bidimensional navigator", "VCO Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SevenSeas", "SevenSeas", "Wavetable VCO, with bidimensional navigator", "VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "TIMEX", "TIMEX", "Timer and time utilities", "CLOCK" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SAM", "SAM", "CBM64 voice synthesizer", "VCO VOCODER" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "AttackSustainRelease16", "AttackSustainRelease16", "16 Attack (Sustain) Release Envelopes", "Utility Quad Envelope generator Function generator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "AttackSustainRelease8", "AttackSustainRelease8", "8 Attack (Sustain) Release Envelopes", "Utility Quad Envelope generator Function generator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "AttackSustainRelease4", "AttackSustainRelease4", "4 Attack (Sustain) Release Envelopes", "Utility Quad Envelope generator Function generator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "LOGAN", "LOGAN logger", "Logs signal to a CSV file", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "LOGAN20", "LOGAN20 logger", "Logs signal to a CSV file", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "02NAGOL", "02NAGOL UN-logger", "Read CSV files generated by LOGAN20 and LOGAN and replay it", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "b208_5steps", "208 5 steps sequencer", "Imitation of the Buchla 208 5 steps sequencer from the Buchla Easel", "Dual Sequencer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "b208_pulser", "208 pulser", "Imitation of the Buchla 208 pulser from the Buchla Easel", "Dual Clock" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "b208_envelope", "208 envelope", "Imitation of the Buchla 208 envelope from the Buchla Easel", "Dual LFO Envelope generator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "b208_random", "208 random + inverter", "Imitation of the Buchla 208 noise generators from the Buchla Easel", "Quad Random Noise" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "b208_dualLPG", "208 LPG", "Imitation of the Buchla 208 dual LPG from the Buchla Easel", "Dual VCA VCF Lowpass gate" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "QuadSimpler", "QuadSimpler", "Quad Sample player with mixer", "Quad Sampler VCO Drum" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "ClockMultiplier", "ClockMultiplier", "Clock Multiplier-Divider", "Quad Clock modulator" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Bitshifter", "Bitshifter BOH!NGLER", "256 bits bitshifter with S&H and noise and inner LFO and VCO", "Noise S&H Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "GraphicMeter", "GraphicMeter", "Voltage Visualizer-Voltmeter", "Utility Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "MultiVoltimetro", "MultiVoltimetro", "Voltage Visualizer", "Utility Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "FixedVoltageSource", "FixedVoltageSource", "Fixed Voltage Source with GATE and SUM", "Utility Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SlimFixedVoltageSource", "SlimFixedVoltageSource", "Single Fixed Voltage Source with GATE", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SlimDualFixedVoltageSource", "SlimDualFixedVoltageSource", "Dual Fixed Voltage Source with GATE", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Label", "Label", "Vertical Label Utility", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "LabelSlim", "LabelSlim", "Vertical Label Utility 1 unit", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "TUNATHOR", "TUNATHOR", "hardware calibration tool for external CV devices", "Utility Tuner" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "GranTunismo", "GranTunismo", "Chromatic TUNER", "Utility Tuner" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PitchVoltager", "Pitch2Voltage", "Pitch to voltage device", "Utility Tuner" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "ExpiredTime", "ExpiredTime", "Timer Utility to count time an create temporal events", "Utility Timer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "MultiTriggerDelayer", "ELSKER", "Multi TRIG/GATE with delay and settable lenght, clockable", "Utility Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "NYECHOEcoeco", "NYECHOEcoeco", "Analog delay based on magnetic disk", "Effect Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "JIRAJIRAECHO", "JIRAJIRAECHO", "Analog delay based on magnetic disk, Binson Echorec imitation", "Effect Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "MicrotonalHostHelper", "MicrotonalHostHelper", "Helper to bring microtonality to VST Host", "Utility Microtonal Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolyLPG", "Polyphonic LPG", "Polyphonic Buchla 208 LPG", "VCF VCA Polyphonic Lowpass gate" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Simpliciter", "Simpliciter", "Sample oscillator also known as confusingSimpler", "Recording Sampler VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Simpliciter2", "Simpliciter Multi", "the Simpliciter MultiTrack version, from 1 to 16 tracks", "Recording Sampler VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Pepper", "Pepper", "Notes module to be used with Jooper", "Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "TheCage", "TheCage", "Keyboard, Switch, Bridge, Sequencer, Quantizer with editable comparators", "Quantizer Switch Sequencer Bridge Polyphonic Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Sussudio", "Sussudio", "Multi head sample based oscillator", "Sampler Quad VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "LFOMultiPhase2", "LFOMultiPhase2 ", "LFO with 6 fixed phases and 1 variable, phases 0 60 120 180 240 300, with precise frequency setting", "LFO VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "MusicalBox", "MusicalBox", "Multi sampler with 8 oscillators", "Sampler Quad VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "GateTrigMerger", "GateTrigMerger", "GATE or TRIG mixer/merger", "Gate Quad LOGIC ADSR Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "XYdisplay", "ETCHASKETCHOSCOPE", "XY visualizer", "Visual Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "ScaleOffset", "Scale and Offset", "Scale and offset voltages", "VCA Utility Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Interleaver", "Interleaver", "Poly channels (de)interleaver", "Utility Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "YYdisplay", "YYdisplay", "YY visualizer", "Visual Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "BZ-MAPPER", "BZ-MAPPER", "function mapper", "Filter Polyphonic Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "BZ-XPAND", "BZ-XPAND", "function mapper expander", "Expander Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "BZ-XPANDXPAND", "BZ-XPANDXPAND", "function mapper expander expander", "Expander Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "BZENVELOPE", "BZ-ENVELOPE", "bezier envelope", "Filter Envelope Shaper Polyphonic Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "TZOP", "TZOP", "FM Operator dx7 style, Sinusoid VCO", "VCO LFO FM Polyphonic Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Ambuance", "Ambuance Reverb", "Reverb based on the Juhana Sadeharju GigaVerb", "REVERB EFFECT" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "TZEN", "TZEN Envelope", "Polyphonic ADSR linear and exponential, to use as expander for TZOP", "Envelope generator Function generator Expander Polyphonic" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "TZVU", "TZVU VU-meter", "monophonic VU-meter EMS style", "Visual Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "TZMX", "TZMX FM Operators mixers", "polyphonic FM mixers for DX7 style algorithms composition", "Polyphonic Mixer Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SimplerTapeControl", "SimplerTapeControl", "Reel to reel tape style controller for samplers; expander for Simpliciter and Confusing Simpler", "Utility Controller Expander Effect" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Programmer", "Programmer", "Serge Style Programmer/Sequencer", "Utility Controller Sequencer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "Nudger", "Nudger", "Serge Programmer expander", "Utility Controller Expander Sequencer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "ModuloMagic", "Modulo Magic", "CGS Modulo Magic", "Polyphonic Utility Quantizer" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "InfiniteMelody", "Infinite Melody", "CGS Infinite Melody", "Random Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "SlopeDetector", "Slope Detector", "CGS Slope Detector", "Dynamic Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "DualProcessor", "Dual Processor", "CGS Dual Processor", "Polyphonic Vca CV Mixer Audio Mixer Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "CVSpread", "CV Spread", "CGS CV Spread", "Polyphonic Vca Spreader Utility" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "MusicalBox2", "MusicalBox2", "Multi sampler 16 stereo channels (max 2Mb samples)", "Sampler Quad VCO" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "RAEL", "RAEL", "Multi TRIG/GATE with delay and settable lenght, clockable, with trigs and probabilities", "Utility Delay" },
 { "NYSTHI", "NYSTHI", "NYSTHI", "NYSTHI", "PolyVoltageMeter", "PolyVoltageMeter", "Voltage Visualizer-Voltmeter", "Utility Polyphonic" },
 { "ODDSound_MTS_ESP", "ODDSound MTS-ESP", "ODDSound", "ODDSound", "MIDI_CV_MTS_ESP", "MTS-ESP MIDI To CV", "Converts MIDI from an external device to CV and gates with MTS-ESP tuning support", "External MIDI Polyphonic" },
 { "ODDSound_MTS_ESP", "ODDSound MTS-ESP", "ODDSound", "ODDSound", "CV_MIDI_MTS_ESP", "MTS-ESP CV To MIDI", "Converts CV to MIDI and sends to an external device with MTS-ESP tuning support", "External MIDI Polyphonic" },
 { "ODDSound_MTS_ESP", "ODDSound MTS-ESP", "ODDSound", "ODDSound", "Quantizer_MTS_ESP", "MTS-ESP Quantizer", "Quantize pitch CV to the global MTS-ESP tuning table", "Quantizer Polyphonic" },
 { "ODDSound_MTS_ESP", "ODDSound MTS-ESP", "ODDSound", "ODDSound", "Interval", "Interval", "Transpose or bend pitch CV by any interval, defined either as an integer ratio or cents value.", "Tuner Polyphonic" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "KlokSpid", "KlokSpid", "CPU-controlled clock generator/modulator", "Clock generator Clock modulator" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "RKD", "RKD (Rotate Klok Divider)", "Rotate Klok Divider (RKD) module (inspired from 4ms RCD hardware)", "Clock modulator" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "BRK", "BRK (\"Break\") expander for RKD", "BRK (\"Break\") expander to setup RKD jumpers (inspired from 4ms BO hardware)", "Clock modulator Expander" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "Metriks", "Metriks", "Voltmeter and CV tuner", "Visual" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "SplitterModule", "Splitter 1x9", "Spread incoming mono-/polyphonic signal upto 9 outputs", "Multiple Utility Polyphonic" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "OhmerBlank1", "Blank 1 HP", "1 HP blank (themed) plate (uses 2 screws)", "Blank" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "OhmerBlank2", "Blank 2 HP", "2 HP blank (themed) plate (customizable screws disposal)", "Blank" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "OhmerBlank4", "Blank 4 HP", "4 HP blank (themed) plate", "Blank" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "OhmerBlank8", "Blank 8 HP", "8 HP blank (themed) plate", "Blank" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "OhmerBlank16", "Blank 16 HP", "16 HP blank (themed) plate", "Blank" },
 { "Ohmer", "Ohmer", "Ohmer Modules", "Dominique Camus", "OhmerBlank32", "Blank 32 HP", "32 HP blank (themed) plate", "Blank" },
 { "OhmerPrems", "OhmerPrems", "Ohmer Modules", "Dominique Camus", "KordZ", "KordZ", "Note/interval/chord display (CV-based)", "Visual Polyphonic" },
 { "OhmerPrems", "OhmerPrems", "Ohmer Modules", "Dominique Camus", "QuadPercs", "QuadPercs", "Quad-channel drums/percussions", "Drum Quad" },
 { "OmniMango-Hyper-Tune", "OmniMango HyperTune", "OmniMango", "Garnet Grimm", "OmniMango-Hyper-Tune", "HyperTune", "Automatic pitch detection and retuner", "Effect Tuner Vocoder" },
 { "OmniMango-Hyper", "OmniMango Hyper Wavetable", "OmniMango", "Garnet Grimm", "OmniMango-Hyper-Loop", "HyperLoop", "Incoming quick looper", "Sampler Expander" },
 { "OmniMango-Hyper", "OmniMango Hyper Wavetable", "OmniMango", "Garnet Grimm", "OmniMango-Hyper-Syrup", "HyperSyrup", "Wavetable Synthesizer", "Polyphonic Oscillator" },
 { "OmniMango-July-Chorus", "OmniMango Juno Chorus Clone", "OmniMango", "Garnet Grimm", "OmniMango-July-Chorus", "July-60", "Juno Chorus Clone", "Hardware clone Effect Chorus" },
 { "OmniMango-Subliminal-Messages", "OmniMango Subliminal Messages", "OmniMango", "Garnet Grimm", "OmniMango-Subliminal-Messages", "Subliminal-Messages", "Convert images to audio to be viewed back on a spectrogram", "Visual Physical modeling" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Fence", "Fence", "Keep CVs in a defined pitch range", "Quantizer Tuner Utility Distortion WaveShaper Polyphonic" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Swing", "Swing", "Micro Timing Sequencer", "Sequencer Clock Clock modulator" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Mother", "Mother", "Mode aware probability driven quantizer", "Quantizer Sequencer Polyphonic" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Phrase", "Phrase", "Utility to sequence phrases by sequencing a sequencer", "Sequencer Utility Clock modulator" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Dejavu", "Dejavu", "Random Cv and Trigger generator with nested repeat functionality", "Utility Polyphonic Random Sequencer Visual" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Gator", "Gator", "Phased Based Microtiming, Ratcheting and Strumming", "Utility Polyphonic Clock Modulator" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Resc", "Resc", "Utility to harmonicaly rescales pitch from one scale to another scale", "Utility Polyphonic" },
 { "OrangeLine", "OrangeLine", "", "Dieter Stubler", "Morph", "Morph", "Morphing of given or random sequences with turing machine functionality", "Utility Sequencer Random Polyphonic" },
 { "OSCelot", "OSCelot", "TheModularMind", "TheModularMind", "OSCelot", "OSCelot", "OSC mapping module for parameters of any module", "Utility" },
 { "OSCelot", "OSCelot", "TheModularMind", "TheModularMind", "OSCelotExpander", "OSCelotExpander", "Expander for OSC'elot outputting a trigger and CV for each controller", "Expander" },
 { "Oxidlab-Entferner-Free", "Oxidlab Entferner Free Modules", "Oxidlab", "Alexander Schadenberger", "EntfernerLE", "Entferner LE - Low-Pass Filter", "12dB Low-Pass Filter", "Filter" },
 { "Oxidlab-Entferner-Free", "Oxidlab Entferner Free Modules", "Oxidlab", "Alexander Schadenberger", "EntfernerPlateL", "Entferner Plate L", "Plate (left side)", "Blank Oscillator" },
 { "Oxidlab-Entferner", "Oxidlab Entferner Modules", "Oxidlab", "Alexander Schadenberger", "EntfernerL", "Entferner L - Low-Pass Filter", "6/12/18/24dB Low-Pass Filter", "Filter" },
 { "Oxidlab-Entferner", "Oxidlab Entferner Modules", "Oxidlab", "Alexander Schadenberger", "EntfernerH", "Entferner H - High-Pass Filter", "12/24dB High-Pass Filter", "Filter" },
 { "Oxidlab-Entferner", "Oxidlab Entferner Modules", "Oxidlab", "Alexander Schadenberger", "EntfernerB", "Entferner B - Band-Pass Filter", "12/24dB Band-Pass Filter", "Filter" },
 { "Oxidlab-Entferner", "Oxidlab Entferner Modules", "Oxidlab", "Alexander Schadenberger", "EntfernerPlateR", "Entferner Plate R", "Plate (right side)", "Blank Oscillator" },
 { "ParableInstruments", "Parable Instruments", "Parable Instruments", "adbrant", "Neil", "Neil", "", "Granular Reverb" },
 { "PatchAndTweak", "Patch & Tweak", "Patch & Tweak", "Kim Bj\u00f8rn", "Blank", "Blank panel", "Blank panel narrow", "Blank" },
 { "PatchAndTweak", "Patch & Tweak", "Patch & Tweak", "Kim Bj\u00f8rn", "BlankBenders", "C. Benders blank", "Blank panel with C. Benders quote", "Blank" },
 { "PatchAndTweak", "Patch & Tweak", "Patch & Tweak", "Kim Bj\u00f8rn", "BlankRimbaud", "R. Rimbaud blank", "Blank panel with R. Rimbaud quote", "Blank" },
 { "PatchAndTweak", "Patch & Tweak", "Patch & Tweak", "Kim Bj\u00f8rn", "BlankStarlight", "L. Starlight blank", "Blank panel with L. Starlight quote", "Blank" },
 { "PatchAndTweak", "Patch & Tweak", "Patch & Tweak", "Kim Bj\u00f8rn", "BlankBarbieri", "C. Barbieri blank", "Blank panel with C. Barbieri quote", "Blank" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "CheeseGrater", "CheeseGrater", "A granular sample and loop. Craft the exact right slice of sound for your music.", "Granular" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "Blender", "Blender", "A Distortion Looper. Play with 4 main knobs to snapshot dynamic effects.", "Granular" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "Spork", "Spork", "A granular FX module. Modulate 6 different granular effects.", "Granular Effect" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "Sifter", "Sifter", "A granular mixer. Sample 4 sound sources and recombine them endlessly through modulation.", "Granular Mixer" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "SporkExpander", "SporkExpander", "Expander for Spork. Adds mixing different modes at the same time.", "" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "SifterExpander", "SifterExpander", "Expander for Sifter. Adds panning and volume controls per channel.", "" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "BlenderExpander", "BlenderExpander", "Expander for Blender. Adds more control over how the loop plays.", "" },
 { "PathSet-Grains", "Path Set: Grains", "Path Set", "Andrew Hanson", "CheeseGraterExpander", "CheeseGraterExpander", "Expander for CheeseGrater. Adds control over which part of the sample plays and more ways to modify how it plays.", "" },
 { "PathSet-Infinity", "Path Set: Infinity", "Path Set", "Andrew Hanson", "QuantumCompass", "QuantumCompass", "Both/Neither Sequencer/Quantizer. Create a melodic sequence by selecting notes and letting QuantumCompass guide you.", "Quantizer Sequencer" },
 { "PathSet-Infinity", "Path Set: Infinity", "Path Set", "Andrew Hanson", "WarpDrive", "WarpDrive", "Dual-drive systems. Two sound sources with built in, clocks, lfos, and envelops.", "VCO LFO Clock Envelope Generator" },
 { "PathSet-Infinity", "Path Set: Infinity", "Path Set", "Andrew Hanson", "Orchestrator", "Orchestrator", "A conniving octopus that creates modulation and gate outputs to conduct a 10 minute long song.", "Random LFO Clock" },
 { "PathSet-Infinity", "Path Set: Infinity", "Path Set", "Andrew Hanson", "Shuttle", "Shuttle", "Travel the universe of harmonic sine waves.", "VCO Random" },
 { "PathSet-Rainbows", "Path Set: Rainbows", "Path Set", "Andrew Hanson", "4Expander", "Playhead Expander", "Adds 3 more play-heads to any Rainbow Sequencer", "Sequencer Random Quad" },
 { "PathSet-Rainbows", "Path Set: Rainbows", "Path Set", "Andrew Hanson", "RndExpander", "Randomizer Expander", "Adds Randomizing Triggers to any Rainbow Sequencer", "Sequencer Random Quad" },
 { "PathSet-Rainbows", "Path Set: Rainbows", "Path Set", "Andrew Hanson", "Grid", "Rainbow Grid", "Generate a panoply of sequences using a small grid of nine notes.", "Sequencer Random Quad" },
 { "PathSet-Rainbows", "Path Set: Rainbows", "Path Set", "Andrew Hanson", "Bridge", "Bridge", "Start with four linear sequences and build bridges to connect and jump around.", "Sequencer Random Quad" },
 { "PathSet-Rainbows", "Path Set: Rainbows", "Path Set", "Andrew Hanson", "Ring", "Ring", "Concentric rings of notes create an ever shifting sequence.", "Sequencer Random Quad" },
 { "PathSet-Rainbows", "Path Set: Rainbows", "Path Set", "Andrew Hanson", "Crossing", "Crossing", "Create paths and circuits and loops in this field of notes.", "Sequencer Random Quad" },
 { "PathSet", "Path Set: Free", "Path Set", "Andrew Hanson", "ShiftyMod", "Shifty", "Gate shift register with controllable delays. Create generative gate sequences from a single clock.", "Clock Clock modulator Sample and hold" },
 { "PathSet", "Path Set: Free", "Path Set", "Andrew Hanson", "IceTray", "IceTray", "Speed shifter and tape delay with selective memory. Perform into this and it will never forget your mistakes.", "Delay Recording Granular" },
 { "PathSet", "Path Set: Free", "Path Set", "Andrew Hanson", "AstroVibe", "AstroVibe", "Three stereo oscillators or LFOs with random waveforms. Explore a universe of unique waveforms.", "VCO LFO Physical modeling" },
 { "PathSet", "Path Set: Free", "Path Set", "Andrew Hanson", "GlassPane", "GlassPane", "Patchable, branchable, network sequencer. Create a cascading intricate self modulating sequence.", "Sequencer Random" },
 { "PathSet", "Path Set: Free", "Path Set", "Andrew Hanson", "ShiftyExpander", "ShiftyExpander", "Expander for Shifty. Adds CV and Atenuverters for all the knobs on Shifty.", "" },
 { "PathSet", "Path Set: Free", "Path Set", "Andrew Hanson", "Nudge", "Nudge", "Modulation generator that lets you randomly nudge the modulations whenever you want.", "Random" },
 { "PathSet", "Path Set: Free", "Path Set", "Andrew Hanson", "OneShot", "OneShot", "One-shot Sequencer that can be daisy-chained with other sequencers or more OneShots.", "Sequencer Random" },
 { "PdArray", "PdArray", "", "M\u00e1rton Gunyh\u00f3", "Array", "Array", "Draw or record sequences, envelopes or audio", "envelope generator function generator sampler visual waveshaper polyphonic" },
 { "PdArray", "PdArray", "", "M\u00e1rton Gunyh\u00f3", "Miniramp", "Miniramp", "Generate a ramp from 0V to 10V with a given duration", "envelope generator utility polyphonic" },
 { "PdArray", "PdArray", "", "M\u00e1rton Gunyh\u00f3", "Ministep", "Ministep", "Use triggers to step voltages from 0V to 10V in a given number of steps", "utility polyphonic" },
 { "PersonalModules", "Personal Modules", "SV Modular", "SV Modular", "VCO", "VCO", "My Own Personal VCO", "VCO Polyphonic" },
 { "PersonalModules", "Personal Modules", "SV Modular", "SV Modular", "VCA", "VCA", "My Own Personal VCA", "VCA Polyphonic" },
 { "PersonalModules", "Personal Modules", "SV Modular", "SV Modular", "Break", "Break", "My Own Personal Attenuator", "Attenuator Polyphonic" },
 { "PersonalModules", "Personal Modules", "SV Modular", "SV Modular", "Eq", "Eq", "My Own Personal Eq", "EQ Polyphonic" },
 { "PersonalModules", "Personal Modules", "SV Modular", "SV Modular", "Bias", "Bias", "My Own Personal Bias", "Attenuator Polyphonic" },
 { "PersonalModules", "Personal Modules", "SV Modular", "SV Modular", "Chrono", "Chrono", "My Own Personal Clock", "Clock" },
 { "PersonalModules", "Personal Modules", "SV Modular", "SV Modular", "MultiPan", "MultiPan", "My Own Personal Panner", "Utility Polyphonic" },
 { "pfzzz", "Pfzzz", "Pfzzz", "Omar Shaban", "OhGates", "OhGates", "", "Function generator" },
 { "PinkTrombone", "PinkTrombone", "PinkTrombone", "Vega Deftwing", "PinkTrombone", "PinkTrombone", "Voice Simulation", "Physical modeling" },
 { "Plurm", "Plurm", "Plurm", "David Cherepov", "Stacktrace", "Stacktrace", "Sample and hold in an 8-frame stack", "Sample and hold" },
 { "Plurm", "Plurm", "Plurm", "David Cherepov", "randomchordrecorder", "randomchordrecorder", "", "Sequencer Random" },
 { "Plurm", "Plurm", "Plurm", "David Cherepov", "randomchordexpndr", "randomchordexpndr", "an expander for randomchordrecorder", "Expander" },
 { "Polymaths", "Polymaths", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "STRX", "Ars Memorium", "State recall matrix", "Sequencer Function Generator Arbitrary Function Generator Random Controller" },
 { "Polymaths", "Polymaths", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "MINI", "Enochian Tablet", "CV controlled matrix mixer", "Mixer Distortion Feedback Matrix Mixer" },
 { "Polymaths", "Polymaths", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "VELO", u8"Hek\u0113bolos", "Integrator", "Utility Integrator Dual" },
 { "Polymaths", "Polymaths", "Magus Instrumentalis", "David Kant, Ryan Page, Mustafa Walker", "VERT", "Catoptromancer", "Inverter", "Utility Logic Dual" },
 { "Prism", "Prism", "", "John Hoar / Pyer / Steve Russell", "Rainbow", "Rainbow", "A multiband band-pass resonant filter, a port of the 4ms SMR", "Physical modeling VCF Hardware clone" },
 { "Prism", "Prism", "", "John Hoar / Pyer / Steve Russell", "RainbowScaleExpander", "Spectrum", "Expander for Rainbow for programming of user-defined scales", "Expander" },
 { "Prism", "Prism", "", "John Hoar / Pyer / Steve Russell", "Droplet", "Droplet", "A band-pass resonant filter, a port of the 4ms SMR MaxQ filter", "Physical modeling VCF Hardware clone" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "ProkBD", "Bass Drum", "Prok Drums Bass Drum", "Drum Hardware clone" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "ProkSN", "Snare Drum", "Prok Drums Snare", "Drum Hardware clone" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "ProkHH", "Hi Hat", "Prok Drums Hi Hat", "Drum Hardware clone" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "ProkCP", "Clap", "Prok Drums Clap", "Drum Hardware clone" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "ProkKL", "Klonk", "Prok Drums Klonk", "Drum" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "ShiftyBusiness", "Shifty Business", "Shift Register based random noise generator", "Noise Random" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "ClapEnvelope", "Clap Envelope", "Special envelope for synthesizing hand claps", "Envelope generator Drum" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "WhistleWhileYouWork", "Whistle While You Work", "Triple Noise Generator", "Noise" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "Overtime", "Overtime", "Distortion and Bit Crusher", "Distortion" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "DrumEnvelope", "Drum Envelope", "Three stage envelope (Attack, Decay, Breakpoint) for drum synthesis", "Envelope generator Drum" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "SkinInTheGame", "Skin In The Game", "Single oscillator with frequency and amplitude envelopes designed for drum synthesis", "Drum Oscillator Synth voice" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "WinWinSituation", "Win Win Situation", "Pair of Oscillators with frequency and amplitude envelopes designed for drum synthesis", "Drum Oscillator Synth voice" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "SixSquareFeet", "Six Square Feet", "Six Square Oscillators", "Oscillator" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "MicroMixer4", "Micro Mixer", "Micro Mixer for 5 inputs", "Mixer" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "DualFilter", "Dual Filter", "Dual filters with Band Pass, Low Pass and High Pass", "Filter" },
 { "Prok-Modular", "Prok Modular", "", "Prok", "QuadSelectorExpander", "Drum Expander", "Expander for Drum Modules. Allows transpose, decay time and quad control via knob or CV", "Expander" },
 { "PS-PurrSoftware", "PS-PurrSoftware", "PurrSoftware", "Ken Chaffin", "Meander", "Meander", "Algorithmic Composer", "Sequencer Polyphonic" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "Blank1", "Blank Panel | 1HP", "Blank Panel | 1HP", "Blank" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "Blank3", "Blank Panel | 3HP", "Blank Panel | 3HP", "Blank" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "Blank5", "Blank Panel | 5HP", "Blank Panel | 5HP", "Blank" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "BufferedMult", "Buffered Mult | 2HP", "Buffered multiple 1->3 or 1->6", "Multiple Polyphonic" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "DaisyChannel", "Daisy Mix Channel | 2HP", "Modular mixer channel - daisy chainable", "Mixer" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "DaisyMaster", "Daisy Mix Master | 3HP", "Modular mixer master", "Mixer VCA" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "Horsehair", "Horsehair VCO | 7HP", "2x VCO saw to pulsewave", "VCO" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "Mixer2", "Mixer 2 | Mono->Stereo | 5HP", "Mono or stereo 2 channel mixer", "Mixer Polyphonic" },
 { "QuantalAudio", "QuantalAudio", "QuantalAudio", "Jansen Price", "UnityMix", "Unity Mix | 2HP", "Multiple 3->1 or 6->1", "Multiple Polyphonic" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Byte", "Byte", "", "Utility Logic" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Chaos", "Chaos", "", "Sequencer" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Column", "Column", "", "Mixer" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Gate", "Gate", "", "Utility Attenuator" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Indra", "Indra's Net", "", "Oscillator" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Mix", "Mix", "", "Utility Mixer Amplifier" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "NEWS", "NEWS", "", "Sequencer" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "NOT", "NOT", "", "Utility Logic" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "OR", "OR", "", "Utility Logic" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Wrap", "Wrap", "", "Utility" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "XFade", "XFade", "", "Utility" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "XOR", "XOR", "", "Utility Logic" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Automaton", "Automaton", "", "Sequencer" },
 { "Qwelk", "Qwelk", "Qwelk", "raincheque", "Scaler", "Scaler", "", "Utility" },
 { "RacketScience", "Racket Science", "Racket Science", "ContemporaryInsanity", "RSVectorVictor", "Vector Victor", "Phase driven CV loop recorder", "Visual Recording Sequencer Utility" },
 { "RacketScience", "Racket Science", "Racket Science", "ContemporaryInsanity", "RSBoogieBay", "RSBoogieBay", "Volt meter / cable wobbler", "Visual Utility" },
 { "RacketScience", "Racket Science", "Racket Science", "ContemporaryInsanity", "RSBoogieBayH8", "RSBoogieBayH8", "Cable wobbler / poly merger", "Poly Visual Utility" },
 { "RacketScience", "Racket Science", "Racket Science", "ContemporaryInsanity", "RSMFH", "RSMFH", "Module From Hell", "Poly Function generator Utility" },
 { "RacketScience", "Racket Science", "Racket Science", "ContemporaryInsanity", "RSHeat", "RSHeat", "Note / Octave Heat Map", "Visual Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "bitshiftgain", "Dual BSG", "Dual gain shifter", "Attenuator Dual Polyphonic Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "capacitor", "Capacitor", "Filters (Mono)", "Equalizer Filter Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "capacitor_stereo", "Capacitor Stereo", "Filters (Stereo)", "Equalizer Filter Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "chorus", "Chorus", "Stereo chorus with multi-tap option", "Chorus Delay Effect Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "console", "Console", "Stereo summing mixer", "Mixer Polyphonic Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "console_mm", "Console MM", "Stereo summing mixer to work in conjunction with MindMeld's MixMaster", "Mixer Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "distance", "Distance", "Far-away-izer", "Effect Polyphonic Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "golem", "Golem", "Micro-delayable crossfader", "Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "holt", "Holt", "Resonant lowpass filter focussed on low frequencies", "Filter Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "hombre", "Hombre", "Texas tone and texture", "Effect Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "interstage", "Interstage", "Subtle analogifier", "Effect Filter Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "monitoring", "Monitoring", "Mix checker", "Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "mv", "MV", "Dual-mono reverb", "Effect Reverb" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "rasp", "Rasp", "De-Edger, high frequency tamer, acceleration limiter", "Equalizer EQ Filter Slew limiter Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "reseq", "ResEQ", "Resonance equalizer", "Equalizer Filter Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "tape", "Tape", "All-purpose tape mojo", "Distortion Effect Polyphonic" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "tremolo", "Tremolo", "Fluctuating saturation curves", "Effect Polyphonic Utility" },
 { "rackwindows", "Rackwindows", "Rackwindows", "Jens Robert Janke", "vibrato", "Vibrato", "FM vibrator o_O", "Chorus Clock generator Effect Flanger Polyphonic Utility" },
 { "RareBreeds_Orbits", "Orbits", "RareBreeds", "Rare Breeds", "RareBreeds_Orbits_Eugene", "Eugene", "Euclidean Rhythm Generator", "Clock modulator Sequencer" },
 { "RareBreeds_Orbits", "Orbits", "RareBreeds", "Rare Breeds", "RareBreeds_Orbits_Polygene", "Polygene", "Polyphonic Rhythm Generator", "Clock modulator Sequencer Polyphonic" },
 { "RB-Clapper", "Clapper", "Robotic Bean", "Robotic Bean", "RB-Clapper", "Clapper", "Synthesized 808-Style Hand Clap", "Drum" },
 { "RB-Tilter", "Tilter", "Robotic Bean", "Robotic Bean", "RB-Tilter", "Tilter", "Combined LP and HP filter", "VCF" },
 { "rchoices", "rchoices", "", "David Koch", "uchoice", "uchoice", "randomly select from inputs", "random" },
 { "rchoices", "rchoices", "", "David Koch", "gchoice", "gchoice", "randomly select from inputs using a gaussian distribution", "random" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-CVTgl", "CV Toggle", "A labelled toggle switch, outputs 0V or 10V", "Controller" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-CVMmt", "CV Momentary", "A labelled button, outputs 0V or 10V", "Controller" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-CVS0to10", "CV Sliders 0 to 10", "4 CV sliders, outputs 0V to 10V", "Controller" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-CV5to5", "CV Knob -5 to 5", "CV knob, outputs -5V to 5V", "Controller" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-CV0to10", "CV Knob 0 to 10", "CV knob, outputs 0V to 10V", "Controller" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-gverb", "GVerb", "Dirty unstable reverb", "Reverb" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-duck", "Duck", "Basic audio ducking", "Dynamics" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-seq-adapter", "SEQ Adapter", "Nord style reset for syncing simple sequencers", "Sequencer" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-sync", "Sync", "Simplified Nord style reset for syncing simple sequencers", "Sequencer" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-polynos", "Poly Noise", "Polyphonic white noise output. Polyphony matches src input", "Polyphonic Noise" },
 { "rcm", "RCM", "RCM", "RCM", "rcm-pianoroll", "Piano Roll", "Simple Piano Roll for sequencing", "Sequencer" },
 { "RebelTech", "RebelTech", "RebelTech", "Ewan Hemingway", "Stoicheia", "Stoicheia", "Dual Euclidean Sequencer", "Clock modulator Dual Hardware clone Sequencer" },
 { "RebelTech", "RebelTech", "RebelTech", "Ewan Hemingway", "Tonic", "Tonic", "Additive Interval Sequencer", "Sequencer Hardware clone Polyphonic" },
 { "RebelTech", "RebelTech", "RebelTech", "Ewan Hemingway", "Klasmata", "Klasmata", "Voltage controlled Euclidean sequencer", "Clock modulator Sequencer Hardware clone" },
 { "RebelTech", "RebelTech", "RebelTech", "Ewan Hemingway", "CLK", "CLK", "Triple clock generator that produces synchronised clock signals", "Clock generator Clock modulator Hardware clone" },
 { "RebelTech", "RebelTech", "RebelTech", "Ewan Hemingway", "Logoi", "Logoi", "Voltage controlled clock divider, counter, and delay", "Clock modulator Delay Hardware clone" },
 { "RebelTech", "RebelTech", "RebelTech", "Ewan Hemingway", "Phoreo", "Phoreo", "Trigger modulator, multiplier and repeater", "Clock modulator Hardware clone" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-cyclex-vco", "Cyclex VCO", "Oscillator that generates waveforms using looped simplex noise.", "VCO Polyphonic" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-cyclex-lfo", "Cyclex LFO", "Low-frequency oscillator that generates waveforms using looped simplex noise.", "LFO Polyphonic" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-frames", "Frames", "A sequencer that takes inspiration from tracker software.", "Sequencer" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-nessie-triangle", "Nessie Triangle", "Chip inspired quantized triangle oscillator.", "VCO Polyphonic" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-nessie-pulse", "Nessie Pulse", "Chip inspired pulse oscillator.", "VCO Polyphonic" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-nessie-noise", "Nessie Noise", "Chip inspired periodic noise oscillator.", "VCO" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-nessie-saw", "Nessie Saw", "Chip inspired sawtooth oscillator.", "VCO Polyphonic" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-quan", "Quan", "Note quantizer with even and uneven distribution modes.", "Utility Polyphonic" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-const", "Const", "Four-channel DC voltage generator.", "Utility" },
 { "regen-modular", "Regen Modular", "", "Studio Regen", "regen-xfade", "XFade", "Linear crossfader for blending between two input signals.", "Utility Polyphonic" },
 { "repelzen", "repelzen", "repelzen", "wiqid", "reblank", "re-blank", "4hp blank panel with logo", "blank" },
 { "repelzen", "repelzen", "repelzen", "wiqid", "reburst", "re-burst", "burst generator", "clock modulator random" },
 { "repelzen", "repelzen", "repelzen", "wiqid", "refold", "re-fold", "wavefolder", "waveshaper polyphonic" },
 { "repelzen", "repelzen", "repelzen", "wiqid", "rewin", "re-win", "4 channel quantizer", "quantizer quad" },
 { "repelzen", "repelzen", "repelzen", "wiqid", "rexmix", "rexmix", "6 channel mixer with three band eq and dual sends, inspired by befaco hexmix", "mixer equalizer" },
 { "repelzen", "repelzen", "repelzen", "wiqid", "retrig", "re-trig", "cv to trigger utility", "utility" },
 { "ReTunesFree", "ReTunes Free", "ReTunes", "Domino Marama", "ReTunes-ForFour", "For Four", "Clock splitter, counters and patterns for four beats per bar", "Clock" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Acid", "Acid", "Rich's take on the TB-303, with two VCOs, a powerful filter, an envelope generator and a pluck!", "VCO Multiple Synth voice Envelope generator" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "BPF", "BPF", "Band Pass Filter", "VCF" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Buttons", "Buttons", "Buttons", "Utility Controller" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Filters", "Filters", "A collection of filters", "VCF" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Notch", "Notch", "A Notch filter", "VCF" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Sidechain", "Sidechain", "A sidechain compressor, used to duck a signal and make pumping sounds.", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Chord", "Chord", "Generates chords in various positions", "MIDI Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Noise", "Noise", "Filtered Noise Generator", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "PlayableChord", "Playable Chord", "Generates chords in various positions, and accepts input via V/OCT with octave control.", "MIDI Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Floats", "Floats", "", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Octaves", "Octaves", "", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Splitter", "Splitter", "", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "ChordSeq", "ChordSeq", "Chord Sequencer", "Utility Sequencer" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Glides", "Glides", "Glide inbetween values with an adustable time", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "RandomFilter", "RandomFilter", "Hit the button, change the filter.", "VCF Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Splitters", "Splitters", "", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Volumes", "Volumes", "", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Displays", "Displays", "Display values digitally", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Integers", "Integers", "", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Randoms", "Randoms", "", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Stutter", "Stutter", "A stuttering effect", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Widener", "Widener", "Widens a mono signal into a stereo one", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "BPM", "BPM", "A beats-per-minute signal clock", "Clock generator" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "EssEff", "EssEff", "EssEff is a SoundFont (.sf2) file player.", "Synth voice" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "LRMixer", "LRMixer", "", "Mixer" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Range", "Range", "Map a signal to a range", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Supersaw", "Supersaw", "Two detuned saws going rawr.", "VCO" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "uQuant", "uQuant", "A tiny, useful quantizer.", "Quantizer" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Button", "Button", "It's a big button.", "Controller" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "MetaKnob", "MetaKnob", "It's a big knob.", "Controller" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Panner", "Panner", "It pans.", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "RangeLFO", "RangeLFO", "An LFO which can be mapped to a specific range.", "LFO" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "TwinLFO", "TwinLFO", "An LFO controlled by another LFO.", "LFO" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "BitCrush", "BitCrush", "It's a bit crusher.", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Filter", "Filter", "A very crude filter.", "VCF" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Mono", "Mono", "Take a stereo signal and make it mono.", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Panners", "Panners", "Mono to stereo.", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "ReplayKnob", "ReplayKnob", "A knob which can be recorded and replayed.", "Controller Delay Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Buffers", "Buffers", "Delay signals slightly.", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "FilterDelay", "FilterDelay", "Delay with integrated filter effect.", "Effect Delay VCF" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Pluck", "Pluck", "Integrated ADSR/VCA. Makes a pluck noise.", "Effect VCA Envelope generator" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "KTF", "KTF - Key Tracking Filter", "A 1v/oct key tracking filter.", "VCF" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "TriggerSwitch", "TriggerSwitch - Trigger Activated Gate Switch With Button", "Trigger Activated Gate Switch With Button.", "Controller Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "DryWet", "DryWet - Voltage Controlled Dry Wet Knob", "Voltage Controlled Dry Wet Knob", "Controller Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "MutateSeq", "MutateSeq - MutateSeq - Mutating Sequencer", "MutateSeq - Mutating Sequencer", "Utility Sequencer" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Notes", "Notes", "Static Notes - Polyphonic", "Utility Polyphonic" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Sequential", "Sequential Switch - 8 to 1", "Gate-triggered Sequential Switch", "Utility Sequencer" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Succulent", "Succulent", "r/synthesizercirclejerk", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "PingPong", "Clock Synced Ping Pong Delay", "Clock Synced Ping Pong Delay", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Brickwall", "Brick Wall Limiter", "Brick Wall Limiter", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Slapback", "Dual Slap Back Delay", "An opinionated dual slapback delay", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "LeftHandRightHand", "Split Keyboard MIDI-CV", "MIDI to CV for Splitting a Keyboard into Left and Right Hands", "Utility" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Euclidian", "Euclidian - Euclidian Rhythm Generator", "Euclidian - Euclidian Rhythm Generator in E(m, k) + i format, with presets.", "Sequencer" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Octo", "Octo - 8 Bespokely Phased Triangles", "Octo - 8 Bespokely Phased Triangles", "LFO" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "RJChorus", "Chorus - It's a Chorus", "Chorus", "Effect" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Instro", "Instro - Various Voices", "Instro - Various Voices", "VCO" },
 { "RJModules", "RJModules", "RJModules", "Rich Jones", "Gaussian", "Gaussian - Normal Distribution Gate Generator", "Gaussian - Normal Distribution Gate Generator", "Sequencer" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Grendel", "Grendel", "Quadruple low frequency oscillator, inspired by XAOC Batumi", "LFO" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Lavender", "Lavender", "Module with 2nd order LPF, HPF, BPF and BSF", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Easter", "Easter", "Module with 2 resonators", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "DryLand", "DryLand", "Module with 1st order LPF and HPF", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "TheWeb", "TheWeb", "Module with 2nd order Butterworth LPF, HPF, BPF and BSF", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Gazpacho", "Gazpacho", "Module with 2nd order Linkwitz-Riley LPF and HPF", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Estonia", "Estonia", "Estonia is a 1st order High and Low shelving filter.", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Brave", "Brave", "Brave is a 2nd Order Parametric EQ Filter: Non constant Q.", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Essence", "Essence", "Essence is a 2nd Order Parametric EQ Filter with a constant Q.", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "LadyNina", "LadyNina", "LadyNina is a 2nd order SFV (LPF, HPF, BPF, BSF)", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "SugarMice", "SugarMice", "3rd order Butterworth low-pass ladder filter.", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Montreal", "Montreal", "Ideal 2nd Order RLC Filters LPF, HPF, BPF and BSF", "VCF Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "BlindCurve", "BlindCurve", "Audio Detector", "Envelope Follower Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Gaza", "Gaza", "Envelope Follower", "Envelope Follower Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "CircularRide", "CircularRide", "Stereo Delay", "Delay Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "DrillingHoles", "DrillingHoles", "Normalizer", "Utility Switch Polyphonic" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "TuxOn", "TuxOn", "Audio player", "Utility" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "PigeonPlink", "FM Pigeon Plink", "Many function VCO", "VCO Polyphonic Synth voice" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "Genie", "Genie", "Chaos generator", "S&H" },
 { "RPJ", "RPJ", "RPJ", "Robert Kock", "GenieExpander", "GenieExpander", "Display for Genie Chaos generator", "S&H" },
 { "RPJVisualizer", "RPJ Visualizer", "RPJ", "Robert Kock", "LFMFull", "LFMFull", "Psycho visualizer, shown in a separate display. \nBased on ProjectM, this module uses MilkDrop/Winamp presets.", "Utility Visual" },
 { "RPJVisualizer", "RPJ Visualizer", "RPJ", "Robert Kock", "LFMEmbedded", "LFMEmbedded", "Psycho visualizer, shown in an embedded display. \nBased on ProjectM, this module uses MilkDrop/Winamp presets.", "Utility Visual" },
 { "s-ol", "s-ol", "s-ol", "sol bekic", "WrapComp", "Wrapping Comparator", "compares a voltage against a window in a circular space", "Utility Logic" },
 { "s-ol", "s-ol", "s-ol", "sol bekic", "CircleVCO", "Quadrature Circle VCO", "sinewave VCO with 90\u00b0 quadrature output for drawing circles.", "Digital Oscillator Visual" },
 { "s-ol", "s-ol", "s-ol", "sol bekic", "Modulo", "Modulo / Round", "generates a modulo + rounded signal for a voltage-controlled step size.", "Logic Quantizer" },
 { "SA-Seasons", "Seasons", "Spektro Audio", "Spektro Audio", "Seasons", "Seasons", "4-Stage Step Sequencer", "Sequencer Quad" },
 { "sb-StochKit", "StochKit", "StochKit", "Sam Laing", "GenEcho", "GenEcho", "The GenEcho module", "Effect" },
 { "sb-StochKit", "StochKit", "StochKit", "Sam Laing", "Grandy", "Grandy", "A generator module", "Granular VCO" },
 { "sb-StochKit", "StochKit", "StochKit", "Sam Laing", "Stitcher", "Stitcher", "Stitcher module", "Granular VCO" },
 { "scanner-darkly-collection-one", "Collection One", "scanner darkly", "scanner-darkly", "SDOrcasHeart", "Orca's Heart", "quad algorithmic sequencer generator", "Arpeggiator Clock modulator Quad Sequencer" },
 { "Sckitam", "Sckitam", "Sckitam", "Philippe Salembier", "2DRotation", "2DRotation", "2D Rotation of 2 input signals", "Utility Polyphonic" },
 { "Sckitam", "Sckitam", "Sckitam", "Philippe Salembier", "2DAffine", "2DAffine", "2D Affine transform of 2 input signals", "Utility Polyphonic" },
 { "Sckitam", "Sckitam", "Sckitam", "Philippe Salembier", "FIFOQueue", "FIFOQueue", "First-in First-out Queue", "Sample and hold Sequencer" },
 { "Sckitam", "Sckitam", "Sckitam", "Philippe Salembier", "MarkovSeq", "MarkovSeq", "Sequencer/Switch based on Markov chain", "Sequencer Switch Polyphonic" },
 { "Sckitam", "Sckitam", "Sckitam", "Philippe Salembier", "PolygonalVCO", "PolygonalVCO", "Polygonal VCO", "Oscillator Polyphonic" },
 { "Sckitam", "Sckitam", "Sckitam", "Philippe Salembier", "WDelay", "WaveguideDelay", "High precision delay. Building block for waveguide, Karplus-Strong synthesis, Flanger and Chorus", "Delay VCO Physical modeling Flanger Chorus" },
 { "Sculpt-O-Sound", "Sculpt-O-Sound", "Sculpt-O-Sound", "Jos Bouten aka Zaphod B.", "Vocode_O_Matic", "Vocode-O-Matic", "31 Terts Band Vocoder", "Effect Vocoder" },
 { "Sculpt-O-Sound", "Sculpt-O-Sound", "Sculpt-O-Sound", "Jos Bouten aka Zaphod B.", "Vocode_O_Matic_XL", "Vocode-O-Matic_XL", "31 Terts Band Vocoder with sliders for envelope attack and release time, level and panning", "Effect Vocoder" },
 { "SeasideModular", "Seaside Modular", "Seaside Modular", "Blue Nautilus", "Proteus", "Proteus", "Proteus generative sequencer", "Sequencer" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "Semiramis", "Semiramis", "Semimodular synthesizer", "Synth voice Filter Delay LFO VCO Envelope generator" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "Brutus", "Brutus", "Waveshaper and Distortion", "Distortion Limiter Waveshaper Polyphonic" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "Cellularnoise", "Cellular Noise", "Cellular automata VCO/LFO", "Noise LFO Random VCO" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "Combo", "Combo", "Dirty Comb Filter", "Delay Distortion Filter Polyphonic" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "Envels", "Envels", "ADSR Envelope", "Envelope generator Polyphonic" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "Filtron", "Filtron", "Double Butterworth Filter", "Filter Polyphonic" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "FMdom", "FMdom", "Linear FM VCO/LFO", "LFO Polyphonic VCO" },
 { "Semiramis", "Semiramis", "Sonus Dept.", "Sonus Dept.", "Virtualog", "Virtualog", "Virtual Analog VCO/LFO", "Noise LFO Polyphonic VCO" },
 { "SequelSequencers", "Daniel Davies", "Daniel Davies", "Daniel Davies", "Sequel8", "Sequel 8", "3 row / 8 step sequencer with built-in clock divider", "Clock modulator Sequencer" },
 { "SequelSequencers", "Daniel Davies", "Daniel Davies", "Daniel Davies", "Sequel16", "Sequel 16", "3 row / 16 step sequencer with built-in clock divider", "Clock modulator Sequencer" },
 { "SequelSequencers", "Daniel Davies", "Daniel Davies", "Daniel Davies", "Quantify", "Quantify", "3x Quantizer with attenuverted inputs + nudge and transpose controls", "Quantizer" },
 { "SequelSequencers", "Daniel Davies", "Daniel Davies", "Daniel Davies", "Samuel", "Samuel", "Morse code based rhythm generator", "Clock modulator" },
 { "SequelSequencers", "Daniel Davies", "Daniel Davies", "Daniel Davies", "Blank3", "Blank3", "3HP wide blank panel", "Blank" },
 { "SequelSequencers", "Daniel Davies", "Daniel Davies", "Daniel Davies", "Blank5", "Blank5", "5HP wide blank panel", "Blank" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "AbsorptionSpectrum", "Absorption Spectrum", "Hydrogen absorption spectrum", "Blank Visual" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "Collider", "Collider", "Physics-based shaker", "Granular Physical modeling Polyphonic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "Cosmosis", "Cosmosis", "Continuous sequencer with constellations", "Visual Sequencer Polyphonic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "JeremyBlankPanel", "Blank Panel", "", "Blank Visual" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "Neutrinode", "Neutrinode", "Node-based generator with four independent nodes to connected particles", "Visual Sequencer Polyphonic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "Orbitones", "Orbitones", "Physics-based LFO with four independent attractors", "Visual Low-frequency oscillator Polyphonic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "Photron", "Photron", "Animation with inputs", "Visual" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "PhotronPanel", "Photron Panel", "Animated panel", "Visual Expander" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "PhotronStrip", "Photron Strip", "Animated panel", "Visual Expander" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "PolyrhythmClock", "Polyrhythm Clock", "Clock with 3 layers of embedded rhythms and randomization", "Clock generator Clock modulator Random" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "QubitCrusher", "QubitCrusher", "Bit crusher and downsampler with randomization", "Digital Distortion Effect Sample and hold" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "RandGates", "Random Gate Switch", "Randomly routes one of 4 inputs to the output", "Utility Switch Polyphonic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "RandRoute", "Random Route Switch", "Randomly routes one input to 4 possible outputs", "Utility Switch Polyphonic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "StochSeq", "Stochastic Sequencer 1", "Probabilistic sequencer", "Sequencer Visual Logic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "StochSeq4", "Stochastic Sequencer 4", "Probabilistic sequencer with four independent voices", "Sequencer Visual Logic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "StochSeq4X", "Stochastic Sequencer 4 Expander", "Expander for the StochSeq4", "Expander Sequencer" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "StochSeqGrid", "Stochastic Sequencer Grid", "Probabilistic grid sequencer with subdivisions", "Sequencer Visual Logic" },
 { "Sha-Bang-Modules", "Sha#Bang! Modules", "", "Jeremy Muller", "Talea", "Talea", "A unique arpeggiator with polyrhythmic capabilities", "Arpeggiator" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "Blender", "Blender", "Stereo crossfade mixer with double modulation", "Mixer" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "Blender8", "Blender8", "8 single crossfade mixers", "Mixer" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "BtogglerSt", "bToggler", "Buffered stereo signal toggle switch router, with VCA and ASR envelope generator", "Logic Envelope generator Voltage-controlled amplifier" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "BtogglerStCompact", "bToggler Compact", "Buffered stereo signal toggle switch router, with VCA and ASR envelope generator, in a compact form factor", "Logic Envelope generator Voltage-controlled amplifier" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "Btoggler", "bToggler8", "8 buffered toggle switch signal router", "Logic" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "BtogglerPlus", "bToggler8Plus", "8 buffered toggle switch router, plus warnings to use with led midi controllers", "Logic Utility" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "Calcs", "Calcs", "Calculates sums, differences, multiplications, divisions and averages of 3 CV inputs", "Utility" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "Switcher", "Switcher", "2>1 switch, 1>2 router, 2 signal swapper, mute, flip flop, toggle gate", "Switch Utility" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "SwitcherSt", "SwitcherSt", "Stereo 2>1 switch, 1>2 router, 2 signal swapper, mute, flip flop, toggle gate", "Switch Utility" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "Toggler", "Toggler", "Stereo signal toggle switch router, with VCA and ASR envelope generator", "Logic Envelope generator Voltage-controlled amplifier" },
 { "SickoCV", "SickoCV", "Sickozell", "Sickozell", "TogglerCompact", "Toggler Compact", "Stereo signal toggle switch router, with VCA and ASR envelope generator, in a compact form factor", "Logic Envelope generator Voltage-controlled amplifier" },
 { "SignalFlux", "Signal Flux", "Signal Flux", "Sam Wolk and Signal Flux", "SimpleKnob", "Unipolar Offset", "Generates a voltage offset based on the knob position.", "Utility" },
 { "SignalFlux", "Signal Flux", "Signal Flux", "Sam Wolk and Signal Flux", "BipolarKnob", "Bipolar Offset", "Outputs positive and negative voltage proprtional to knob position.", "Utility" },
 { "SignalFlux", "Signal Flux", "Signal Flux", "Sam Wolk and Signal Flux", "Attenuate", "Attenuate", "A single attenuator.", "utility" },
 { "SignalFlux", "Signal Flux", "Signal Flux", "Sam Wolk and Signal Flux", "Attenuvert", "Attenuvert", "A single attenuverter.", "utility" },
 { "SignalFlux", "Signal Flux", "Signal Flux", "Sam Wolk and Signal Flux", "Invert", "Invert", "A single inverter.", "utility" },
 { "SkJack", "SkJack", "Skrylar", "Skrylar", "JackAudio", "JACK Audio", "Four named input and output JACK ports.", "external" },
 { "SkJack", "SkJack", "Skrylar", "Skrylar", "JackAudioOut8", "JACK Audio (8 Rack->JACK)", "Eight named JACK output ports.", "external" },
 { "SkJack", "SkJack", "Skrylar", "Skrylar", "JackAudioIn8", "JACK Audio (8 JACK->RACK)", "Eight named JACK input ports.", "external" },
 { "Skylander", "Skylander", "Skylander", "Skylander", "NymphesControl", "NymphesControl", "CC viewer and controller for Dreadbox NYMPHES v2 Firmware", "Controller" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkAdrift", "Adrift (Analogue Drift)", "Randomized Sample and Hold, simulates minor analogue drift", "Sample and hold" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkTuringV2", "Alan (Turing Machine)", "A Whitwell turing machine.", "Sequencer" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkTuringPulse", "Alan (Pulse Expander)", "Turing Machine pulse expander", "Utility" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkTuringVolts", "Alan (Volts Expander)", "Turing Machine volts expander", "Utility" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkTuringVactrol", "Alan (Digital Mix Expander)", "A vactrol mix expander using digital signal attenuation.", "Utility" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkTuringVactrolAnalogue", "Alan (Vactrol Mix Expander)", "A vactrol mix expander using an emulated vactrol chip.", "Utility" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkWhatnoteCV", "What Note?", "A CV tuner.", "Tuner Utility" },
 { "Skylights", "Skylights", "Skrylar", "Skrylar", "SkVactrolyzer", "Vactrolyzer", "An analogue modeled Vactrol.", "Utility" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Envelopes", "Envelopes", "Dual Semi-Interruptable Attack-Decay Envelope Generators", "Envelope generator Dual" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Filter", "LP4 Filter", "Physically-modelled 24dB per Octave Ladder Lowpass", "Filter Physical modeling Polyphonic" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Mixer", "Saturating Mixer", "Chainable Non-linear Mixer", "Mixer Distortion Physical modeling" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Quantizer", "Quantizer", "Variable-Intonation Transposing Quantizer", "Quantizer Polyphonic" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-PolySeq", "Polyrhythm Sequencer", "Three-track Polyrhythm Sequencer", "Sequencer Clock modulator" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-VCA", "VCA", "Linear Voltage-Controlled Amplifier", "Voltage-controlled amplifier Polyphonic" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-SubOscillator", "Sub-Oscillator", "Subharmonic Physically-modelled Self-Modulating Oscillator", "Oscillator Physical modeling" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Clock", "Clock", "Multi-Rate Clock Generator", "Clock generator" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Blank-4", "Blank (4HP)", "Decorative Panel (4HP)", "Blank" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Blank-7", "Blank (7HP)", "Decorative Panel (7HP)", "Blank" },
 { "SlimeChild-Substation", "Substation", "Slime Child Audio", "Slime Child Audio", "SlimeChild-Substation-Filter-Expander", "Filter+", "Expander for LP4 Filter", "Filter Polyphonic Physical modeling Expander" },
 { "SLM", "SLM", "SLM", "Salvatore LA MALFA", "mux-freak", "Mux Freak", "4 to 1 clocked multiplexer with switch probability and gate length controls", "quad switch random" },
 { "SLM", "SLM", "SLM", "Salvatore LA MALFA", "the-tailor", "The Tailor", "waveforms morphing tool", "digital" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Addiction", "Addiction", "Additive Oscillator", "VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Bitter", "Bitter", "Bit Manipulator", "Distortion Effect" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Bymidside", "Bymidside", "MS Encoder", "Dynamics Utility" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Campione", "Campione", "Live Sampler", "Sampler" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Chainsaw", "Chainsaw", "Fat Sawish VCO", "VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Ctrl", "Ctrl", "Customizable Controller", "Controller Utility" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Deathcrush", "Deathcrush", "Driver and Crusher", "Distortion Effect" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Fraction", "Fraction", "n^x / (n^x + 1) Oscillator", "VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Harmony", "Harmony", "Chord Tool", "Tuner Utility" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Ladrone", "Ladrone", "Drone Oscillator", "VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Luppolo", "Luppolo", "Simple Looper", "Sampler" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Luppolo3", "Luppolo3", "Loop Station", "Sampler" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Micromacro", "Micromacro", "Pitch Quantized Sequencer", "Sequencer" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Mrcheb", "Mr. Cheb", "Chebyshev Waveshaper", "Effect Waveshaper" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Multimulti", "Multimulti", "2x8 Multiples", "Multiple Utility" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Neurosc", "Neurosc", "Neural Wavetable Oscillator", "VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Oktagon", "Oktagon", "Quad-Quad LFO/VCO", "LFO Quad VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Osculum", "Osculum", "Unusual Oscillator", "VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Paramath", "Paramath", "Comparing and Maths", "Logic Utility" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Piconoise", "Piconoise", "Noise Generator", "Noise" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "PanintheHaas", "Pan in the Haas", "Haas Delay", "Delay Dual Panning" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Pusher", "Pusher", "Buttons Controller", "Controller Utility" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Ringo", "Ringo", "Ring Modulator", "Ring modulator Effect" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Scramblase", "Scramblase", "Many Waveshapers", "Effect Waveshaper" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Tropicana", "Tropicana", "Tropical Additive Oscillator", "VCO" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Twoff", "Twoff", "CV Offset", "Dual Utility" },
 { "SonusModular", "Sonus Modular", "Sonus Dept.", "Sonus Dept.", "Yabp", "Yabp", "Yet Another Blank Panel", "Blank" },
 { "Sparkette", "Sparkette's Stuff", "Sparkette's Stuff", "Sara Sparks", "Ellie", "Ellie", "Ellie is hiding on your rack as a blank panel!", "Blank" },
 { "Sparkette", "Sparkette's Stuff", "Sparkette's Stuff", "Sara Sparks", "NoteClassifier", "Note Classifier", "Classifies the pitch of an incoming note (C, D, etc.) and turns on a different output for each pitch.", "Utility Polyphonic" },
 { "Sparkette", "Sparkette's Stuff", "Sparkette's Stuff", "Sara Sparks", "PolyRepeater", "Polyphonic Repeater", "Converts a monophonic signal to a polyphonic signal where all channels have the same value. Outputs up to four copies of the polyphonic signal, because I had room for extra ports so why not?", "Polyphonic Utility" },
 { "Sparkette", "Sparkette's Stuff", "Sparkette's Stuff", "Sara Sparks", "RGBMatrix", "RGB Matrix", "An array of RGB lights with built-in oscillators for generating and displaying patterns.", "Visual Polyphonic" },
 { "Sparkette", "Sparkette's Stuff", "Sparkette's Stuff", "Sara Sparks", "HSV2RGB", "Color Wheel", "Converts a color from HSV format to RGB values.", "Utility Visual Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-mixm", "Form", "Mixer master module", "Mixer" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-mixStereo", "ExTwo", "Two channel stereo mixer expander", "Mixer Expander" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-mix4", "ExFor", "4 channel mixer expander", "Mixer Expander" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-ch10", "ch10", "ch10", "VCO" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-comp2", "Comp II", "Polyphonic Compressor", "Compressor Dynamics Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-samp", "SFZ Player", "Sampler that plays standard SFZ files.", "Polyphonic Sampler Synth Voice" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-comp", "Comp", "Ultra clean Compressor", "Compressor Dynamics Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-filt", "Stairway", "Ladder filter on steroids", "VCF Polyphonic Distortion" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-funv", "Functional VCO-1", "[deprecated] Multi-function VCO with low aliasing", "VCO" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-lfnb", "LFNB", "Low frequency random voltage generator 2", "NOISE RANDOM LFO" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-dt", "Polygate", "Polyphonic gate demultiplexer", "Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-wvco", "FM Kitchen Sink", "Many function VCO", "VCO Polyphonic Synth voice" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-sub", "Substitute", "Subharmonic VCO", "VCO Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-basic", "Basic VCO", "Precision VCO", "VCO Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-f2", "F2", "Multimode state-variable filter", "VCF Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-sines", "Organ Three", "Hammond organ emulator", "VCO Polyphonic Hardware Synth voice" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-mix8", "Mixer-8", "8 channel mixer", "Mixer" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-slew4", "Slade", "Octal slew/lag/VCA", "Slew limiter VCA" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-sequencer4", "Seq4x4", "Sequence player", "Sequencer Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-tremolo", "Chopper", "Tremolo with synched LFO", "Clock modulator Effect LFO" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-lfn", "LFN", "Low frequency random voltage generator", "Noise Random LFO" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-ev3", "EV3", "Triple VCO with even waveform", "VCO Multiple" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-vocalanimator", "Growler", "Vocal Animator", "Effect Filter" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-CHB2", "Chebyshev II", "Waveshaper VCO with FM", "VCO" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-shp", "Shaper", "Precision Wave Shaper", "Effect Waveshaper Distortion" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-blank", "Blank", "blank starting project", "Blank" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-vocalfilter", "Formants", "Singing Vocal Filter", "Effect Filter" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-gry", "Gray Code", "Eclectic clock divider", "Clock modulator Random Logic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-freqshifter", "Booty Shifter", "Frequency Shifter", "Ring Modulator effect" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-coloredNoise", "Colors", "All the colors of noise", "Noise" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-sequencer", "Seq++", "DAW-like sequencer", "Sequencer Polyphonic" },
 { "squinkylabs-plug1", "Squinky Labs", "", "Squinky Labs", "squinkylabs-super", "Saws", "Super saw VCO emulation", "VCO Polyphonic" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "VCDualNeuron", "VC Dual Neuron", "Voltage-controlled neural network module", "dual logic mixer noise random ring modulator s&h utility vca waveshaper" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Comparator", "8 Comparator", "Octal comparator", "utility clock generator logic" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Multiplier", "8 Multiplier", "Octal four-quadrant multipliers / ring modulators", "attenuator ring modulator utility vca" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Sum", "8 Summing mixer", "Octal three to one unity mixers", "mixer utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Diff", "8 Substractor", "Octal difference calculators", "utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Not", "8 Not operator", "Octal not operators", "logic utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Abs", "8 Absolute", "Octal absolute value operators", "utility waveshaper" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "ASR", "8-bit Shift Register", "8-bit analog shift register", "s&h logic clock modulator" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "VCSampleAndDelay", "8 VC Sample&Delay", "Octal variable length Sample&Holds", "S&H clock modulator utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "DAC", "DA Converter", "8-bit Digital to Analog Converter", "digital distortion utility waveshaper" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "ADC", "AD Converter", "Analog to Digital Converter", "digital clock generator distortion utility waveshaper" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Max", "8 Max/or operator", "Octal three input Max/Or operator", "logic utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "PosNegRectifier", "8 Positive/negative rectifier", "Octal Positive/negative rectifier", "distortion waveshaper utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Min", "8 Min/And operator", "Octal three inputs Min/And operator", "utility logic" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Function", "8 Function generators", "Octal slew-limiter/function generator/A-R envelope", "clock generator envelope follower envelope generator filter function generator lfo lowpass gate vco sequencer slew limiter utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Avg", "8 Averager", "Octal three-inputs signal averager", "utility logic" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "ABY", "8 A/B Y switches", "Octal 2-in 1-out switch (A/B Y)", "utility logic" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Offset", "8 Offset", "Octal offset module", "controller utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Clip", "8 Clip", "Octal clip distortion module", "distortion effect waveshaper utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "CtV", "8 Clock to V/Oct", "Octal clock to volt per octave converter", "clock generator utility" },
 { "Stalys", "Stalys", "Stalys", "Denis Dubo Chevalier", "Blank", "Blank", "Blank panel", "blank visual" },
 { "Starling_Via", "Starling Via", "", "Starling", "META", "META", "flexible contour generator", "Function Generator Drum Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "SYNC", "SYNC", "clock-synced signal source", "Oscillator Clock Modulator Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "SCANNER", "SCANNER", "multi-channel waveshaper", "Waveshaper Distortion Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "GATESEQ", "GATESEQ", "rhythm engine", "Sequencer Sample and Hold Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "ATSR", "ATSR", "crossfading envelope", "Envelope Generator LFO Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "OSC3", "OSC3", "musical oscillator trio", "VCO Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "SYNC3", "SYNC3", "frequency synthesizer", "Oscillator Clock Modulator Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "SYNC3XL", "SYNC3XL", "3 voice frequency synthesizer", "Oscillator Clock Modulator Hardware" },
 { "Starling_Via", "Starling Via", "", "Starling", "SYNC3XLLEVELS", "Sync3XL Levels", "SYNC3XL VCA expander", "Expander" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "Andromeda", "Andromeda", "", "Sequencer" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "BlankPanel", "Blank Panel", "", "Blank" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "Qusia", "Qusia", "", "Utilities, Delay" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "Sigma", "Sigma", "", "Utilities" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "Nomlia", "Nomlia", "", "Sequencer" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "Azular", "Azular", "", "Sequencer" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "Delta", "Delta", "", "Clock Modulator" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "Pelisia", "Pelisia", "", "Mixer, Utilities" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "AL41", "AL41", "", "Switch" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "AL14", "AL14", "", "Switch" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "AL81", "AL81", "", "Switch" },
 { "StellareModular-CreativeSuite", "Creative Suite", "Stellare Modular", "Stellare Modular", "AL18", "AL18", "", "Switch" },
 { "StellareModular-Link", "Stellare Link", "Stellare Modular", "Stellare Modular", "Link", "Link", "", "Clock" },
 { "StellareModular-Link", "Stellare Link", "Stellare Modular", "Stellare Modular", "Link2", "Link v2", "", "Clock" },
 { "StellareModular", "Turing Machine + Blank", "Stellare Modular", "Stellare Modular", "TuringMachine", "Turing Machine", "", "Sequencer Random" },
 { "StellareModular", "Turing Machine + Blank", "Stellare Modular", "Stellare Modular", "BlankPanel", "Blank Panel", "", "Blank" },
 { "stocaudio", "stocaudio", "", "Alessandro Petrone", "Polyturing", "Polyturing", "Turing Machine inspired polyphonic sampler/sequencer", "Random Sequencer Sampler Utility Polyphonic" },
 { "stocaudio", "stocaudio", "", "Alessandro Petrone", "Polydelay", "Polydelay", "Polyphonic Delay with channel spread", "Delay Effect Utility Polyphonic" },
 { "stocaudio", "stocaudio", "", "Alessandro Petrone", "Spread", "Spread", "Polyphonic stereo spreader and summer", "VCA Utility Polyphonic" },
 { "StochasticTelegraph", "Stochastic Telegraph", "Stochastic Telegraph", "Mahlen Morris", "Drifter", "Drifter", "Varying linear function generator. Makes sequences that change in small (or large) ways. A line defined by X/Y points, each doing a random walk.", "Random Sample and hold" },
 { "StochasticTelegraph", "Stochastic Telegraph", "Stochastic Telegraph", "Mahlen Morris", "Fuse", "Fuse", "Counts triggers and blocks/allows a signal after hitting a limit. Useful for timed composition changes, simulating components that break with overuse, or scaling a value based on the number of triggers.", "Clock modulator Utility Voltage-controlled amplifier" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "CVMap", "CV-MAP", "Add CV automation to 32 parameters of any module", "Utility Polyphonic Controller" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "CVMapCtx", "CTX for CV-MAP", "Expander for context menu mapping using CV-MAP", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "CVMapMicro", "\u00b5MAP", "Add CV automation to one parameter of any module", "Utility Controller" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "CVPam", "CV-PAM", "Generate CV from any parameter change of any module", "Utility Polyphonic Controller" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "RotorA", "ROTOR Model A", "Rotates a signal across polyphonic channels", "Utility Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "ReMoveLite", "ReMOVE Lite", "Recorder for parameter automation", "Utility Recording Controller" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Bolt", "BOLT", "Polyphonic logic boolean functions with modulation and sample & hold", "Utility Logic Polyphonic Sample and hold" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Infix", "INFIX", "Insert for polyphonic cables", "Utility Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "InfixMicro", "\u00b5INFIX", "Insert for polyphonic cables", "Utility Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Strip", "STRIP", "Manage a group of modules by using the expander-mechanism, providing load, save, copy, paste, disable, enable and randomize", "Utility Controller Random" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "StripBay4", "STRIP-BAY", "Utility module for STRIP keeping inputs/outputs connected", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "EightFace", "8FACE", "Universal expander for sequencing up to eight presets of any module", "Utility Sequencer" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "EightFaceX2", "8FACEx2", "Universal expander for sequencing up to sixteen presets of any module", "Utility Sequencer" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "MidiCat", "MIDI-CAT", "Mapping module for MIDI CCs and notes to parameters of any module, similar to VCV MIDI-MAP", "Utility MIDI" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "MidiCatEx", "MEM for MIDI-CAT", "Memory-expander for MIDI-CAT", "Utility MIDI" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "MidiCatCtx", "CTX for MIDI-CAT", "Expander for context menu mapping using MIDI-CAT", "Utility MIDI" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Sipo", "SIPO", "Serial-in parallel-out shift register with polyphonic output and CV controls for skipping and incrementing on sampled values", "Utility Sample and hold Digital Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "FourRounds", "4ROUNDS", "Randomizer for up to 16 input signals to create 15 output signals", "Utility Sample and hold Random Switch" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Arena", "ARENA", "2-dimensional XY-Mixer for 8 sources with various modulation targets and fun graphical interface", "Utility Controller Mixer" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Maze", "MAZE", "4 channel sequencer running on a 2-dimensional grid", "Sequencer Random" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Hive", "HIVE", "4 channel sequencer running on a 2-dimensional hexagonal grid", "Sequencer Random" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Intermix", "INTERMIX", "Precision adder 8x8 switch matrix with scene-support", "Mixer Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "IntermixGate", "INTERMIX-GATE", "Expander for INTERMIX outputting a gate-signal for each active row", "Expander" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "IntermixEnv", "INTERMIX-ENV", "Expander for INTERMIX outputting envelopes for a selected input-column", "Expander" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "IntermixFade", "INTERMIX-FADE", "Expander for INTERMIX for setting individual fade values", "Expander" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Sail", "SAIL", "Control any parameter currently hovered by mouse with CV, especially useful with MIDI-CC or MIDI-STEP", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Pile", "PILE", "Translate increment triggers or decrement triggers in an absolute voltage, especially useful with MIDI-STEP, with slew support", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "PilePoly", "POLY-PILE", "Translate increment triggers or decrement triggers in an absolute voltage, especially useful with MIDI-STEP, with slew support", "Utility Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "MidiStep", "MIDI-STEP", "Module for relative modes of endless knobs on your MIDI controller, such as Arturia Beatstep, Native Instruments Komplete Keyboards or Behringer X-TOUCH", "Utility MIDI Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Mirror", "MIRROR", "Utility for synchronizing module parameters", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Affix", "AFFIX", "Insert for polyphonic cables for adding offsets in Volt, semitones or octaves (16 channels)", "Polyphonic Utility Attenuator" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "AffixMicro", "\u00b5AFFIX", "Insert for polyphonic cables for adding offsets in Volt, semitones or octaves (8 channels)", "Polyphonic Utility Attenuator" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Grip", "GRIP", "Lock for module parameters", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Glue", "GLUE", "Label maker for your modules!", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Goto", "GOTO", "Utility for jumping directly to 10 locations in your patch by hotkey or using MIDI", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Stroke", "STROKE", "Utility for converting hotkeys to triggers, gates and some other special commands", "Utility Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Spin", "SPIN", "Utility for converting mouse-wheel movement into triggers, also handles middle-click of mouse, useful for SAIL", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Transit", "TRANSIT", "Parameter-morpher and sequencer for up to 96 snapshots", "Utility Sequencer" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "TransitEx", "+T", "Expander for TRANSIT", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "X4", "X4", "Dual multiple for parameter-mapping", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Macro", "MACRO", "Macro-knob for controlling multiple parameters, with attenuverts and slew-limiting", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Raw", "RAW", "Digital effect based on the dynamics of bistable systems", "Distortion Digital" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "MidiMon", "MIDI-MON", "Monitor for MIDI messages", "MIDI Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Orbit", "ORBIT", "Polyphonic stereo field spreader", "Panning Effect Polyphonic" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "EightFaceMk2", "8FACE mk2", "Universal expander for sequencing up to eight presets of multiple modules", "Utility Sequencer" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "EightFaceMk2Ex", "+8", "Expander for 8FACE mk2", "Expander" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "MidiPlug", "MIDI-PLUG", "Virtual MIDI merger and splitter", "MIDI Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "AudioInterface64", "AUDIO-64", "Sends CV and audio to/from an audio device", "External" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Mb", "MB", "Experimental replacement module browsers for Rack. Brings back the browser from Rack v0.6x and has a modified browser from Rack v1.x with adjustable preview size, favorites, extended filtering options and more.", "Utility" },
 { "Stoermelder-P1", "PackOne", "stoermelder", "Benjamin Dill", "Me", "ME", "Mouse enhancements", "Utility" },
 { "Stoev-Interference", "Interference", "Stoev", "Stoev", "Interference", "Interference", "Poly rhythm generator", "Sequencer Clock generator Clock modulator" },
 { "Stoev-Symmetry", "Symmetry", "Stoev", "Stoev", "Symmetry", "Symmetry", "Dual quantizer / scale arpeggiator", "Quantizer Arpeggiator Random Dual" },
 { "STS", "STS", "", "STS", "Odyssey", "Oddy", "Poly Synth", "Synth Voice Polyphonic" },
 { "STS", "STS", "", "STS", "PolySEQ16", "PolySEQ16", "Quantized 16 Step POLY Sequencer", "Sequencer Polyphonic" },
 { "STS", "STS", "", "STS", "Illiad", "Illiad", "Synth Controller", "Controller" },
 { "STS", "STS", "", "STS", "RingModulator", "RingModulator", "Ring Modulator", "Ring Modulator" },
 { "STS", "STS", "", "STS", "WaveFolder", "WaveFolder", "Wave Folder", "Waveshaper" },
 { "STS", "STS", "", "STS", "VU_Poly", "VU_Poly", "VU Meter Poly", "Visual Polyphonic" },
 { "STS", "STS", "", "STS", "LFOPoly", "LFOPoly", "Poly LFO 16", "LFO Polyphonic" },
 { "STS", "STS", "", "STS", "LFOPolySP", "LFOPolySnapPhase", "Poly LFO 16 with Snap Phase", "LFO Polyphonic" },
 { "STS", "STS", "", "STS", "MidiPlayer", "MidiPlayer", "Poly Midi Player", "Utility Synth Voice Polyphonic" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "KSDelay", "Wallenda", "Karplus\u2013Strong Delay with unison", "Polyphonic Delay Effect Physical modeling" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "Maccomo", "Maccomo", "Ladder Filter self oscillating vcf", "Polyphonic Filter" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "PolyShiftRegister", "Tyrant", "Polyphonic Shift Register", "Polyphonic Sample and Hold Random" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "Te", "Te", "Tyrant Expander", "Expander" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "CombFilter", "Massarti", "Comb Filter", "Polyphonic Filter Effect" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "LaLa", "LaLa", "Two way cross over", "Filter Polyphonic Utility Voltage-controlled amplifier" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "Eva", "Eva", "Mixer", "Mixer Voltage-controlled amplifier Polyphonic" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "Zazel", "Zazel", "Parameter Controller for fades and LFO", "Clock modulator Function generator Low-frequency oscillator Envelope generator Controller" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "Iverson", "Iverson", "Trigger Sequencer for use with midi controller", "Controller Sequencer" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "IversonJr", "IversonJr", "Trigger Sequencer for use with midi controller", "Controller Sequencer" },
 { "StudioSixPlusOne", "Studio Six Plus One", "Studio Six Plus One", "Studio Six Plus One", "Zilah", "Zilah", "14 bit Midi-CC input", "MIDI external" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "AG-104", "AG-104", "AG-104 AND Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "AG-106", "AG-106", "AG-106 AND Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "AG-202", "AG-202", "AG-202 4-input Polyphonic AND Gates", "LOGIC DUAL POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "A0-101", "AO-101", "AO-101 Arithmetic Operators", "UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "A0-106", "AO-106", "AO-106 Arithmetic Operators", "UTILITY MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "A0-112", "AO-112", "AO-112 Arithmetic Operators", "UTILITY MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "A0-118", "AO-118", "AO-118 Arithmetic Operators", "UTILITY MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "A0-124", "AO-124", "AO-124 Arithmetic Operators", "UTILITY MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "A0-136", "AO-136", "AO-136 Arithmetic Operators", "UTILITY MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BB-120", "BB-120", "BB-120 20-Stage Bucket Brigade Sample and Hold", "LOGIC DELAY SAMPLE AND HOLD MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-101", "BP-101", "BP-101 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-102", "BP-102", "BP-102 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-104", "BP-104", "BP-104 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-108", "BP-108", "BP-108 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-110", "BP-110", "BP-110 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-112", "BP-112", "BP-112 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-116", "BP-116", "BP-116 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-120", "BP-120", "BP-120 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-124", "BP-124", "BP-124 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "BP-132", "BP-132", "BP-132 Blanking Plate", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "DN-112", "DN-112", "DN-112 Digital Noise", "DIGITAL NOISE MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "DO-105", "DO-105", "DO-105 Digital Operators", "LOGIC MULTIPLE POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "DO-110", "DO-110", "DO-110 Digital Operators", "LOGIC MULTIPLE POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "DO-115", "DO-115", "DO-115 Digital Operators", "LOGIC MULTIPLE POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "DO-120", "DO-120", "DO-120 Digital Operators", "LOGIC MULTIPLE POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "EN-104", "EN-104", "EN-104 Quad ADSR Enveloper Generator", "ENVELOPE GENERATOR VCA MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "EO-102", "EO-102", "EO-102 Envelope Oscilloscope", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "FF-110", "FF-110", "FF-110 10-Stage Flip-Flop Counter", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "FF-120", "FF-120", "FF-120 20-Stage Flip-Flop Counter", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "FF-206", "FF-206", "FF-206 Edge Triggered Flip-Flops", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "FF-212", "FF-212", "FF-212 Edge Triggered Flip-Flops", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "HS-101", "HS-101", "HS-101 Hi-Res Storage Oscilloscope", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "LA-108", "LA-108", "LA-108 Logic Analyser", "LOGIC VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "LA-216", "LA-216", "LA-216 Logic Analyser", "LOGIC VISUAL DUAL POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "LD-103", "LD-103", "LD-103 Schmitt Trigger Line Drivers", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "LD-106", "LD-106", "LD-106 Schmitt Trigger Line Drivers", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "LT-116", "LT-116", "LT-116 Linear Transformations", "UTILITY POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "MZ-909", "MZ-909", "MZ-909 Masterizer", "POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "NG-106", "NG-106", "NG-106 NOT Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "NG-112", "NG-112", "NG-112 NOT Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "NG-206", "NG-206", "NG-206 Polyphonic NOT Gates", "LOGIC MULTIPLE POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "OA-103", "OA-103", "OA-103 Op-Amps", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "OA-105", "OA-105", "OA-105 Op-Amps", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "OG-104", "OG-104", "OG-104 OR Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "OG-106", "OG-106", "OG-106 OR Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "OG-202", "OG-202", "OG-202 4-Channel Polyphonic OR Gates", "LOGIC DUAL POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "PG-104", "PG-104", "PG-104 Pulse Generators", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "PG-112", "PG-112", "PG-112 Pulse Generators", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "PO-101", "PO-101", "PO-101 Phased VCO", "OSCILLATOR MULTIPLE DIGITAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "PO-102", "PO-102", "PO-102 Phased LFO", "OSCILLATOR MULTIPLE DIGITAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "PO-204", "PO-204", "PO-204 Phase Modulation Engine", "OSCILLATOR QUAD DIGITAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "SN-101", "SN-101", "SN-101 Smooth Noise Generator", "OSCILLATOR NOISE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "SS-112", "SS-112", "SS-112 12 Input Sinks", "UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "SS-208", "SS-208", "SS-208 8 Irrational Output Voltage Sources", "UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "SS-212", "SS-212", "SS-212 12 Chromatic Output Voltage Sources", "UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "SS-220", "SS-220", "SS-220 120 Chromatic Output Voltage Sources", "UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "SS-221", "SS-221", "SS-221 21 Output Voltage Sources", "UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TD-116", "TD-116", "", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TD-202", "TD-202", "TD-202 Vertical Text Display", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TD-316", "TD-316", "TD-316 Text Display", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TD-410", "TD-410", "TD-410 Text Display", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TD-510", "TD-510", "TD-510 Vertical Text Display", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TF-101", "TF-101", "TF-101 Text Display Format Control", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TF-102", "TF-102", "TF-102 Text Display Format Control", "VISUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "TM-105", "Obsolete", "This was Torpedo Merge TM-105", "BLANK" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "VM-101", "VM-101", "VM-101 VU-Meter", "UTILITY VISUAL HARDWARE POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "VM-102", "VM-102", "VM-102 2-Channel VU-Meter", "UTILITY VISUAL DUAL POLYPHONIC HARDWARE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "VM-104", "VM-104", "VM-104 4-Channel VU-Meter", "UTILITY VISUAL QUAD POLYPHONIC HARDWARE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "VM-201", "VM-201", "VM-201 Vintage VU-Meter", "UTILITY VISUAL HARDWARE POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "VM-202", "VM-202", "VM-202 2-Channel Vintage VU-Meter", "UTILITY VISUAL DUAL POLYPHONIC HARDWARE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "VM-204", "VM-204", "VM-204 4-Channel Vintage VU-Meter", "UTILITY VISUAL QUAD POLYPHONIC HARDWARE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "WK-101", "WK-101", "WK-101 Das Wohltemperierte Klavier", "QUANTIZER TUNER" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "WK-205", "WK-205", "WK-205 Das Wohltemperierte Klavier Nano", "QUANTIZER TUNER MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "WM-101", "WM-101", "WM-101 Wire Manager", "UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "WM-102", "WM-102", "WM-102 Wire Manager Billboard", "BLANK UTILITY" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XF-101", "XF-101", "XF-101 Single Mono Cross Fader", "MIXER" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XF-102", "XF-102", "XF-102 Dual Mono Cross Fader", "MIXER DUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XF-104", "XF-104", "XF-104 Quad Mono Cross Fader", "MIXER QUAD" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XF-201", "XF-201", "XF-201 Single Stereo Cross Fader", "MIXER" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XF-202", "XF-202", "XF-202 Dual Stereo Cross Fader", "MIXER DUAL" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XF-301", "XF-301", "XF-301 Small Form Factor Stereo Cross Fader", "MIXER" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XG-104", "XG-104", "XG-104 XOR Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XG-106", "XG-106", "XG-106 XOR Gates", "LOGIC MULTIPLE" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XG-202", "XG-202", "XG-202 4-Input Polyphonic XOR Gates", "LOGIC DUAL POLYPHONIC" },
 { "SubmarineFree", "Submarine", "Submarine", "carbon14", "XX-219", "Obsolete", "This was Secret Santa 2019", "BLANK" },
 { "SunsetSignals", "SunsetSignals", "SunsetSignals", "Jeremy Mitchell", "SignalBooster", "SignalBooster", "Reads a signal in and boosts it", "Utility" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeDelay", "SurgeDelay", "The Surge stereo delay effect", "Effect Polyphonic Delay" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeChorus", "SurgeChorus", "The Surge chorus effect", "Effect Polyphonic Chorus" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeEQ", "SurgeEQ", "The Surge 3-band equalizer", "Effect Polyphonic Equalizer" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgePhaser", "SurgePhaser", "The Surge phaser", "Effect Polyphonic Phaser" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeRotary", "SurgeRotary", "The Surge rotary speaker emulation effect", "Effect Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeDistort", "SurgeDistort", "The Surge distortion effect", "Effect Polyphonic Distortion Waveshaper" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeReverb", "SurgeReverb", "The Surge reverb", "Effect Polyphonic Reverb" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeReverb2", "SurgeReverb2", "The Surge reverb (second one)", "Effect Polyphonic Reverb" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeFreqShift", "SurgeFreqShift", "The Surge frequency shifter", "Effect Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeConditioner", "SurgeConditioner", "The Surge conditioner/limiter effect", "Effect Polyphonic Limiter EQ" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeFlanger", "SurgeFlanger", "The Surge flanger effect", "Effect Polyphonic Flanger" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeRingMod", "SurgeRingMod", "The Surge ring modulator effect", "Effect Polyphonic Ring Modulator" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeClock", "SurgeClock", "A utility clock generator", "Clock Generator" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeADSR", "SurgeADSR", "The Surge ADSR envelope generator with various modes", "Envelope generator Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeOSC", "SurgeOSC", "The Surge classic oscillators, including square, saw, sine, FM and niose", "VCO Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeWaveShaper", "SurgeWaveShaper", "The Surge waveshapers", "Waveshaper Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeWTOSC", "SurgeWTOSC", "The Surge WaveTable collection with a pair of interpolating oscillators", "VCO Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeNoise", "SurgeNoise", "The Surge correlated noise channel", "Noise" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeLFO", "SurgeLFO", "The Surge LFO", "LFO Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeVOC", "SurgeVOC", "The Surge vocoder", "Vocoder Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgeBiquad", "SurgeBiquad", "A single BiQuad filter stage of the Surge FilterBank", "VCF Polyphonic" },
 { "SurgeRack", "Surge for Rack", "", "Surge Synth Team", "SurgePatchPlayer", "SurgePatchPlayer", "A full instance of the Surge plugin able to play the patches in your environment", "Synth voice Polyphonic" },
 { "Synthetic", "Synthetic", "SV Modular", "SV Modular", "Eastside", "Eastside", "Eastside Polyphonic Synth", "Synth voice Polyphonic" },
 { "Synthetic", "Synthetic", "SV Modular", "SV Modular", "BigBlue", "Big Blue", "Big Blue Polyphonic Synth", "Synth voice Polyphonic" },
 { "Synthetic", "Synthetic", "SV Modular", "SV Modular", "Paddington", "Paddington", "PAD Algorithm Based Synthesizer", "Oscillator" },
 { "Synthetic", "Synthetic", "SV Modular", "SV Modular", "Alchemy", "Alchemy", "Alchemy Synth", "Synth voice" },
 { "Synthetic", "Synthetic", "SV Modular", "SV Modular", "Caillou", "Caillou", "Caillou Granular Resynthesis Engine", "Synth voice Granular Oscillator" },
 { "Synthetic", "Synthetic", "SV Modular", "SV Modular", "CaillouVoiceExpander", "Caillou Voice Expander", "Voice Expander for the Caillou Granular Resynthesis Engine", "Expander" },
 { "Synthetic", "Synthetic", "SV Modular", "SV Modular", "CaillouManipulatorExpander", "Caillou Manipulator Expander", "Manipulator Expander for the Caillou Granular Resynthesis Engine", "Expander" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "FourPoleLadder", "4-Pole", "Synthetic FX Four Pole Ladder Filter", "VCF Effect Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Curds", "Curds", "Synthetic FX Curds", "VCF Effect Digital Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "State", "State", "Synthetic FX State Variable Filter", "VCF Effect Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Rez", "Rez", "Synthetic FX Resonant Filter", "VCF Effect Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Comb", "Comb", "Synthetic FX Comb Filter", "VCF Effect Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Chorus", "Chorus", "Synthetic FX Chorus Effect", "VCF Chorus Effect Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Whey", "Whey", "Synthetic FX Whey", "VCF Effect Digital Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Tuffet", "Tuffet", "Synthetic FX Tuffet", "VCF Effect Digital Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Delay", "Delay", "Synthetic FX Delay", "Delay Effect Polyphonic" },
 { "SyntheticFX", "Synthetic FX", "SV Modular", "SV Modular", "Mix", "Mix", "Synthetic FX Effect Mixer", "Mixer" },
 { "SyntheticFXFree", "Synthetic FX Free", "SV Modular", "SV Modular", "FourPoleLadder", "4-Pole", "Synthetic FX Free Four Pole Ladder Filter", "VCF Effect" },
 { "SyntheticFXFree", "Synthetic FX Free", "SV Modular", "SV Modular", "State", "State", "Synthetic FX Free State Variable Filter", "VCF Effect" },
 { "SyntheticFXFree", "Synthetic FX Free", "SV Modular", "SV Modular", "Rez", "Rez", "Synthetic FX Free Resonant Filter", "VCF Effect" },
 { "SyntheticFXFree", "Synthetic FX Free", "SV Modular", "SV Modular", "Comb", "Comb", "Synthetic FX Free Comb Filter", "VCF Effect" },
 { "SyntheticFXFree", "Synthetic FX Free", "SV Modular", "SV Modular", "Chorus", "Chorus", "Synthetic FX Free Chorus Effect", "VCF Chorus Effect" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "1x8Splitter", "1x8 Splitter", "1 in 8 out", "Clock modulator Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "1x8SplitterCV", "1x8 Splitter (CV)", "CV Controlled 1x8 Splitter", "Clock modulator Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "And", "And", "Logical Bitwise And", "Utility Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "Or", "Or", "Logical Bitwise Or", "Utility Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "Addition", "Addition", "Simple value addition", "Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "Subtraction", "Subtraction", "Simple value subtraction", "Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "ClockDivider", "Clock Divider", "Clock Divider", "Clock modulator Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "FibonacciClockDivider", "Fibonacci Clock Divider", "Fibonacci Clock Divider", "Clock modulator Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "PrimeClockDivider", "PrimeClock Divider", "Prime Clock Divider", "Clock modulator Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "RotatingClockDivider", "Rotating Clock Divider", "Rotating Clock Divider", "Clock modulator Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "ShiftingClockDividerCV", "Shifting Clock Divider", "Shifting Clock Divider", "Clock modulator Logic" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "4-StepSequencer", "4-Step Sequencer", "4-Step Sequencer", "Sequencer" },
 { "SynthKit", "SynthKit", "", "Jerry Sievert", "8-StepSequencer", "8-Step Sequencer", "8-Step Sequencer", "Sequencer" },
 { "TercerBrazo", "TercerBrazo", "TercerBrazo", "Diego Dorado", "TercerBrazo-CV2612", "CV2612", "Sega Genesis chip based synth", "MIDI VCO Poly" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Klee", "Klee", "Klee Sequencer", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "ascii", "ascii", "ascii Sequencer - make notes sing", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "M581", "M581", "581 Sequencer", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Z8K", "Z8K", "Z8000 Sequencer", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Renato", "Renato", "Renato Sequencer", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Spiralone", "Spiralone", "Spiralone Sequencer", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "nag", "nag nag nag", "nag nag nag Sequencer", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "o88o", "o88o", "o88o Sequencer", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Burst", "Burst", "quick output bursts", "Utility" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Uncertain", "Uncertain", "uncertain, buchla-esque voltages", "Random" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "PWMClock", "PWMClock", "PWM Clock Generator", "Clock generator" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Quantizer", "Quantizer", "note quantizer", "Quantizer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "midyQuant", "midyQuant", "quantized MIDI output", "Quantizer MIDI" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "AttAmp", "AttAmp", "attenuator/amplifier/offset", "Attenuator Amplifier" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Boole", "Boole", "boolean logic for your signals", "Logic" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "flop", "flop", "flop (and flip) logic for your signals", "Logic" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "XSwitch", "XSwitch", "circuit breaker", "Switch" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Counter", "Counter", "count inputs and generate a signal when reaches 0", "Utility" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Mplex", "Mplex", "Multiplexer", "Switch" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "Dmplex", "Dmplex", "Demultiplexer", "Switch" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "quattro", "quattro", "quattro lines for otto steps", "Sequencer" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "empty", "empty", "a strategy to waste your precious rack space", "Blank" },
 { "TheXOR", "TheXOR", "TheXOR", "The XOR", "volt", "volt", "microtonal quantizer", "Quantizer" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "SH16", "Sample and hold x16", "Get 16 random values on trigger (sample and hold). Internal noise only.", "sample and hold utility random" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "MG1", "Modulation Generator x1", "Get a random value (S&H on internal noise) or LFO with random state (rate, waveform, scale, phase) generated on a trigger. Settings for variance and bias of random, whether to include S&H values and unipolar or bipolar.", "sample and hold utility low-frequency oscillator random" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "MG8", "Modulation Generator x8", "Get up to 8 random value (S&H on internal noise) or LFO with random state (rate, waveform, scale, phase) generated on a trigger. Settings for variance and bias of random, whether to include S&H values and unipolar or bipolar.", "sample and hold utility low-frequency oscillator" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "MG16", "Modulation Generator x16", "Get up to 16 random value (S&H on internal noise) or LFO with random state (rate, waveform, scale, phase) generated on a trigger. Settings for variance and bias of random, whether to include S&H values and unipolar or bipolar.", "sample and hold utility low-frequency oscillator" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "A8", "Attenuator x8", "8x attenuators with same level.", "utility attenuator" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "RM8", "Random Mute x8", "Randomly mute a defined number of 1-8 channels.", "utility switch" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "RM8S", "Random Stereo Mute x8", "Randomly mute a defined number of 1-8 stereo channels.", "utility switch" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TT-A", "Arithmetic", "A bunch of arithmetic tricks on two inputs.", "utility poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TT-L", "Logic", "A bunch of logic tricks on two inputs.", "utility logic poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTSIN", "Sine Oscillator", "A tiny sine based oscillator.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTSAW", "Saw Oscillator", "A tiny saw based oscillator.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTSQR", "Square Oscillator", "A tiny square based oscillator.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTTRI", "Triangle Oscillator", "A tiny triangle based oscillator.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTSINPLUS", "Sine+ Oscillator", "Three sine based oscillators with detune and sync.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTSAWPLUS", "Sawtooth+ Oscillator", "Three sawtooth based oscillators with detune and sync.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTSQRPLUS", "Square+ Oscillator", "Three square based oscillators with detune and sync.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "TTTRIPLUS", "Triangle+ Oscillator", "Three triangle based oscillators with detune and sync.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "RX8", "Random Mix x8", "Randomly mix 8 channels.", "switch random utility" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "SN1", "Simplex Noise LFO", "Low-frequency oscillator based on simplex noise.", "low-frequency oscillator random" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "SN8", "Simplex Noise LFO x8", "8x Low-frequency oscillators based on simplex noise.", "low-frequency oscillator random" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "SNOSC", "Simplex Oscillator", "A oscillator based on a simplex noise source.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "WAVE", "Wavetable Oscillator", "A wavetable oscillator where you can record your own waves.", "oscillator poly" },
 { "TinyTricks", "Tiny Tricks", "Tiny Tricks", "Thomas Ren\u00e9 Sidor", "RW", "Random Wrangler", "Random generation that you control.", "random noise low-frequency oscillator sample and hold" },
 { "Tonecarver", "Tonecarver", "Tonecarver", "Bill Davies", "Blur", "Blur", "Spectral Manipulator: Blur, Filter, Pitch, Gain, Robot", "Effect" },
 { "Tonecarver", "Tonecarver", "Tonecarver", "Bill Davies", "Morse", "Morse", "Generate Morse Code gate sequence", "Sequencer" },
 { "Tonecarver", "Tonecarver", "Tonecarver", "Bill Davies", "Traveler", "Traveler", "Generative sequencer using rovers and obstacles to create evolving patterns", "Sequencer Random" },
 { "TriggerFish-Elements", "TriggerFish-Elements", "TriggerFish", "JTriggerFish", "TfSlop", "Slop", "Slop", "Noise" },
 { "TriggerFish-Elements", "TriggerFish-Elements", "TriggerFish", "JTriggerFish", "TfSlop4", "Slop4", "Slop", "Noise" },
 { "TriggerFish-Elements", "TriggerFish-Elements", "TriggerFish", "JTriggerFish", "TfVDPO", "VDPO", "Van Der Pol Oscillator", "Oscillator" },
 { "TriggerFish-Elements", "TriggerFish-Elements", "TriggerFish", "JTriggerFish", "TfVCA", "TFVCA", "analog modelled VCA that is loosely based on the minimoog's circuit", "Voltage-controlled amplifier" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "trigSeq", "trigSeq", "16-step pad sequencer with a built-in Open Sound Control (OSC) interface.", "Sequencer External" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "trigSeq64", "trigSeq64", "64-step pad sequencer with a built-in Open Sound Control (OSC) interface.", "Sequencer External" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "voltSeq", "voltSeq", "16-step variable voltage/note sequencer with a built-in Open Sound Control (OSC) interface.", "Sequencer External" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "multiSeq64", "multiSeq64", "64-step trigger/variable voltage/note sequencer with a built-in Open Sound Control (OSC) interface. Basically, trigSeq and voltSeq combined into one.", "Sequencer External" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "multiWave", "multiWave", "Digital oscillator module with three (3) oscillators/clocks, each with two (2) configurable wave channel outputs.", "Oscillator Ring modulator" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "multiScope", "multiScope", "Visual effects scope, with lissajous mode, that allows three (3) waveforms to be drawn on the same screen/canvas.", "Visual" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "cvOSCcv", "cvOSCcv", "Generic Open Sound Control (OSC) module for outputting Rack CVs to OSC and reading in simple OSC messages into Rack CVs.", "External Polyphonic" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "cvOSCcv-InputExpander", "cvOSC Input Expander", "Expansion module for cvOSCcv. Allows more input CV channels to be sent to OSC.", "External Polyphonic Expander" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "cvOSCcv-OutputExpander", "OSCcv Output Expander", "Expansion module for cvOSCcv. Allows more output CV channels to be received from OSC.", "External Polyphonic Expander" },
 { "trowaSoft", "trowaSoft", "trowaSoft", "j4s0n-c", "tsBlank", "tsBlank", "Simple trowaSoft blank panel (variable width).", "Blank" },
 { "Truly", "Truly", "Truly", "Travis Thompson", "DasBut", "DasBut", "Push someone's buttons", "controller" },
 { "Truly", "Truly", "Truly", "Travis Thompson", "DasButPoly", "DasButPoly", "Push me harder", "controller polyphonic" },
 { "Truly", "Truly", "Truly", "Travis Thompson", "DasBut8", "DasBut8", "Hold on to your but", "controller" },
 { "UnfilteredVolume1", "Unfiltered Volume 1", "", "Unfiltered Audio", "DentCrusher", "Dent Crusher", "Multimode bitcrusher", "Effect Digital Distortion" },
 { "UnfilteredVolume1", "Unfiltered Volume 1", "", "Unfiltered Audio", "Fusion", "Fusion", "Two-input signal smasher and creative mixer", "Effect Digital Mixer" },
 { "UnfilteredVolume1", "Unfiltered Volume 1", "", "Unfiltered Audio", "GlitchShifter", "Glitch Shifter", "Unpredictable granular delay buffer", "Effect Digital Granular Clock Generator" },
 { "UnfilteredVolume1", "Unfiltered Volume 1", "", "Unfiltered Audio", "Indent", "Indent Saturation", "Multimode distortion and saturation", "Effect Waveshaper ADistortion" },
 { "UnfilteredVolume1", "Unfiltered Volume 1", "", "Unfiltered Audio", "InstantDelay", "Instant Delay", "Smooth granular delay without artifacts", "Effect Delay Granular Clock Generator" },
 { "UnfilteredVolume1", "Unfiltered Volume 1", "", "Unfiltered Audio", "PitchDelay", "Pitch Delay", "Granular pitch-shifting delay", "Effect Delay Granular Clock Generator" },
 { "UnfilteredVolume2", "Unfiltered Volume 2", "", "Unfiltered Audio", "Yoko", "Yoko", "3-Band Frequency Splitter", "Effect Digital Mixer Equalizer" },
 { "UnfilteredVolume2", "Unfiltered Volume 2", "", "Unfiltered Audio", "Sunder", "Sunder", "3-Band Amplitude Splitter", "Effect Digital Mixer Dynamics" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "piong", "piong", "arcade modulator", "Sequencer Random" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "markov", "mr. chainkov", "a markov-chain melody generator", "Sequencer Random" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "atoms", "ATOMS", "adjustable rotating octa-multi-switch", "Switch Mixer Utility" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "cantor", "tancor", "swinging gate machine based around a parametric binary tree, inspired by the cantor set", "Sequencer Clock generator" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "room", "room", "a rack row arranger that can move complete rows of modules and add empty rows between existing ones for a faster workflow", "Utility" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "snake", "SNAKIA", "emulative snake game modulator", "Random Sequencer" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "towers", "towers", "dual fader bank, constant CV source with polyphonic io and mods. up to 16 faders each", "Attenuator Polyphonic Utility" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "pianoid", "pianoid", "a compact piano for monitoring polyphonic v/oct signals from midi or other sources. includes sustain mode and manual note/chord inputting.", "Visual Polyphonic Controller Sample and hold" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "premuter", "pre-muter", "mute signals for 1 second on Rack launch to avoid noise bursts", "Utility" },
 { "unless_modules", "unless modules", "unless games", "\u00c1kos Plesznivy", "avoider", "avoider", "correct v/oct signals to avoid certain intervals in relation to a chord, inspired by the 'avoid note' concept from music theory", "Quantizer" },
 { "Valley", "Valley", "", "Valley", "Topograph", "Topograph", "Topographic drum machine. This module is based on the original\nMutable Instruments (TM) Grids sequencer module. The Map and Density\ncontrols explore and control the denisty of many pre-baked drum patterns.", "Sequencer" },
 { "Valley", "Valley", "", "Valley", "uGraph", "uGraph", "Topographic drum machine. This module is based on the original\nMutable Instruments (TM) Grids sequencer module. The Map and Density\ncontrols explore and control the denisty of many pre-baked drum patterns.", "Sequencer" },
 { "Valley", "Valley", "", "Valley", "Dexter", "Dexter", "A multi-timbral, 4-operator FM oscillator with wavetable and\nwaveshaping capabilities.", "Oscillator" },
 { "Valley", "Valley", "", "Valley", "Plateau", "Plateau", "Lush and bendable plate reverb based on the Dattorro 1997 algorithm.", "Reverb Effect Polyphonic" },
 { "Valley", "Valley", "", "Valley", "Interzone", "Interzone", "Polyphonic, virtual analogue synthesiser voice complete with\na VCO, mixer, filter, LFO, and envelope generator.", "Synth Voice Polyphonic" },
 { "Valley", "Valley", "", "Valley", "Amalgam", "Amalgam", "Multi-mode stereo signal combiner. Amalgam lets you combine and\nsmash together signals in many different ways.", "Ring Modulator Effect Waveshaper" },
 { "Valley", "Valley", "", "Valley", "Feline", "Feline", "A stereo, state variable, virtual analogue filter.", "Filter" },
 { "Valley", "Valley", "", "Valley", "Terrorform", "Terrorform", "An extensive wavetable oscillator that lets you explore\nand rip apart wavetables in many different ways.", "Oscillator Polyphonic Synth voice Waveshaper LFO" },
 { "VCV-Chords", "VCV Chords", "VCV", "VCV", "Chords", "Chords", "Quad-note chord generator", "Sequencer Polyphonic" },
 { "VCV-Console", "VCV Console", "VCV", "VCV", "Console8_3", "Console", "8-channel stereo master mixer", "Mixer" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "DrumMachine", "Drum Machine", "", "Drum Mixer" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "Kick", "Kick", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "Snare", "Snare", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "Tom", "Tom", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "Rim", "Rim", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "Clap", "Clap", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "ClosedHat", "Closed Hat", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "OpenHat", "Open Hat", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "Crash", "Crash", "", "Drum" },
 { "VCV-Drums", "VCV Drums", "VCV", "VCV", "Ride", "Ride", "", "Drum" },
 { "VCV-Host", "VCV Host", "VCV", "VCV", "Host", "Host", "VST instrument plugin host", "External Polyphonic" },
 { "VCV-Host", "VCV Host", "VCV", "VCV", "Host-FX", "Host-FX", "VST effect plugin host", "External Polyphonic" },
 { "VCV-Host", "VCV Host", "VCV", "VCV", "Host-XL", "Host-XL", "Expanded VST instrument/effect plugin host", "External Polyphonic" },
 { "VCV-Host", "VCV Host", "VCV", "VCV", "Host-CV", "Host-CV", "MIDI output expander for all Host modules", "External MIDI" },
 { "VCV-Host", "VCV Host", "VCV", "VCV", "Host-CC", "Host-CC", "MIDI CC output expander for all Host modules", "External MIDI" },
 { "VCV-Host", "VCV Host", "VCV", "VCV", "Host-Gate", "Host-Gate", "MIDI note gate output expander for all Host modules", "External MIDI" },
 { "VCV-Parametra", "VCV Parametra", "VCV", "VCV", "Parametra", "Parametra", "Parametric filter designer", "Equalizer VCF Visual" },
 { "VCV-Pro", "VCV Pro", "VCV", "VCV", "Chorus", "Chorus", "", "Chorus Effect Polyphonic" },
 { "VCV-Pro", "VCV Pro", "VCV", "VCV", "Flanger", "Flanger", "", "Flanger Effect Polyphonic" },
 { "VCV-Pro", "VCV Pro", "VCV", "VCV", "Phaser", "Phaser", "", "Phaser Effect Polyphonic" },
 { "VCV-Prototype", "Prototype", "VCV", "VCV", "Prototype", "Prototype", "Run scripting languages for prototyping, learning, and live coding.", "External" },
 { "VCV-PulseMatrix", "VCV Pulse Matrix", "VCV", "VCV", "PulseMatrix16", "Pulse Matrix 16", "Grid-based trigger sequencer", "Sequencer" },
 { "VCV-PulseMatrix", "VCV Pulse Matrix", "VCV", "VCV", "PulseMatrix8", "Pulse Matrix 8", "Grid-based trigger sequencer", "Sequencer" },
 { "VCV-Recorder", "VCV Recorder", "VCV", "VCV", "Recorder", "Recorder", "Records stereo audio and video to a file", "Recording Visual" },
 { "VCV-Router", "VCV Router", "VCV", "VCV", "OctalRouter", "Octal Router", "Sequential switch matrix", "Sequencer Switch" },
 { "VCV-Router", "VCV Router", "VCV", "VCV", "Router1_4", "Router 1:4", "Sequential switch", "Sequencer Switch" },
 { "VCV-Router", "VCV Router", "VCV", "VCV", "Router4_1", "Router 4:1", "Sequential switch", "Sequencer Switch" },
 { "VCV-Scalar", "VCV Scalar", "VCV", "VCV", "Scalar", "Scalar", "Quantizer and scale tuner", "Quantizer" },
 { "VCV-SoundStage", "VCV Sound Stage", "VCV", "VCV", "SoundStage", "Sound Stage", "Reverb processor that simulates virtual sound sources and microphones in a 3D room", "Reverb" },
 { "VCV-Spectra", "VCV Spectra", "VCV", "VCV", "Spectra", "Spectra", "16-band spectral designer", "Vocoder VCF Equalizer" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Twister", "Twister", "Quad hardware knob controller", "hardware MIDI Quad Utility" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Twister_Expander", "Twister Expander", "CV and MIDI expander for Twister with vMIDI Support", "Expander MIDI" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Smasher", "Smasher", "Hardware button interface", "Hardware" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Smasher_Expander", "Smasher Expander", "CV and MIDI expander for Smasher with vMIDI Support", "Expander MIDI" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Slider", "Slider", "Hardware slider/button interface", "Hardware" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Slider_Expander", "Slider Expander", "CV and MIDI expander for Slider with vMIDI Support", "Expander MIDI" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Spinner", "Spinner", "Hardware wheel interface", "Hardware" },
 { "Virtue-Control", "Virtue Hardware Companion Modules", "Kilpatrick Audio", "Andrew Kilpatrick", "Spinner_Expander", "Spinner Expander", "CV and MIDI expander for Spinner with vMIDI Support", "Expander MIDI" },
 { "vitamin", "Vitamin", "Vitamin", "Xavier Shay", "Bypass", "B (Effect Bypass)", "Multi-channel effect bypass.", "utility polyphonic" },
 { "vitamin", "Vitamin", "Vitamin", "Xavier Shay", "Pan", "P (Pan)", "Pan a polyphonic mono input using constant power law to maintain overall volume.", "pan mixer polyphonic" },
 { "VO", "VO", "VO", "Evgeniy Metelev", "VO-OneKnob", "OneKnob", "Control last touched parameter with midi map or cv", "Controller" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "autobreak", "Autobreak", "Automatic breakbeat sample chopper", "Sampler Drum" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "AutobreakStudio", "Autobreak Studio", "Advanced automatic breakbeat sample chopper", "Sampler Drum" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "bytebeat", "Byte Beat", "Bytebeat player with built-in presets.", "Oscillator" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "digitalprogrammer", "Digital Programmer", "16 channel polyphonic programmer with built-in bank memory slots", "Utility Polyphonic" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "digitalsequencer", "Digital Sequencer", "Six-in-one cv/gate sequencers with independent control over clock division and sequence length.", "Sequencer" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "digitalsequencerxp", "Digital Sequencer XP", "Polyphonic version of the Digital Sequencer.  Sixteen-in-one cv/gate sequencers with independent control over clock division and sequence length.", "Sequencer Polyphonic" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "glitchsequencer", "Glitch Sequencer", "Cellular Automaton Gate Sequencer", "Sequencer" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "ghosts", "Ghosts", "Granular synthesis sample player/scanner with looping grains.", "Granular Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "grainfx", "Grain Fx", "Granular effects for incoming audio.", "Granular Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "GrainEngineMK2", "Grain Engine MK2", "Granular syntesis based .wav player", "Granular Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "GrainEngineMK2Expander", "Grain Engine MK2 Expander", "External audio recorder expander for Grain Engine MK2", "Granular Sampler Expander" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "groovebox", "Groove Box", "8-track sample based groovebox with parameter locks", "Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "GrooveBoxExpander", "Groove Box Expander", "Expander module for the Voxglitch Groovebox that provides Mutes, Solos, Gate Outputs, and track-level control over volume, pan, and pitch.", "Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "hazumi", "Hazumi", "Bouncing ball sequencer", "Sequencer" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "looper", "Looper", "Bare minimum sample looper", "Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "repeater", "Repeater", "Looping sample player with playback offset control.", "Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "satanonaut", "Satanonaut", "Based on the new comic Galacto Pitfighter: An alien entity hell-bent on mutilating your audio.", "Effect" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "samplerx8", "SamplerX8", "Eight stereo sample playback devices in one compact module.", "Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "wavbank", "Wav Bank", "Sample player that can load and switch between all .wav files in a folder.", "Sampler" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "wavbankmc", "Wav Bank MC", "Extended version of Wav Bank that supports multi-channel WAV files", "Sampler Polyphonic" },
 { "voxglitch", "Voxglitch", "Voxglitch", "Bret Truchan", "xy", "XY", "CV output generator with built in gesture recording.", "Sequencer Recording Envelope Generator" },
 { "VultCompacts", "Vult Compacts", "Vult", "Leonardo Laguna Ruiz", "Freak", "Freak", "Manifold Filter", "VCF Polyphonic Hardware clone" },
 { "VultCompacts", "Vult Compacts", "Vult", "Leonardo Laguna Ruiz", "Freak-HW", "Freak-HW", "Manifold Filter", "VCF Hardware clone" },
 { "VultCompacts", "Vult Compacts", "Vult", "Leonardo Laguna Ruiz", "Incubus", "Incubus", "Nightmare Synthesizer", "Synth Voice Polyphonic" },
 { "VultCompacts", "Vult Compacts", "Vult", "Leonardo Laguna Ruiz", "Knock", "Knock", "Bass Drum", "Drum Polyphonic" },
 { "VultCompacts", "Vult Compacts", "Vult", "Leonardo Laguna Ruiz", "Vorg", "Vorg", "Low/High Pass Filter", "VCF Polyphonic Hardware clone" },
 { "VultCompacts", "Vult Compacts", "Vult", "Leonardo Laguna Ruiz", "Vraids", "Vraids (Freak alternate firmware)", "Macro Oscillator", "VCO Hardware clone" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Basal", "Basal", "Smooth Oscillator", "VCO Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Bleak", "Bleak", "Analog Oscillator", "VCO Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Boomstick", "Boomstick", "Sallen-Key filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Caudal", "Caudal", "Mechanical Chaos Source", "Random LFO Noise Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Debriatus", "Debriatus", "Wave Destruction", "Distortion Waveshaper Effect Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Decline", "Decline", "Equalizer Line", "Equalizer Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Disjoint", "Disjoint", "DJ Style Filter", "Equalizer VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Flame", "Flame", "Analog Distortion", "Distortion Waveshaper Effect Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Ferox", "Ferox", "CMOS Filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Flux", "Flux", "Quad Voltage Processor", "Attenuator Envelope follower Quad Sample and hold Slew limiter Utility Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Fuser", "Fuser", "Voltage Mixer", "Mixer Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "HyperPower", "HyperPower", "Infinite Power Supply", "Utility" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Jorus", "Jorus", "Analog Chorus", "Effect Chorus Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Julste", "Julste", "Simple Low Pass Gate", "Low pass gate Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Lateralus", "Lateralus", "Diode Ladder Filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Leakage", "Leakage", "Voltage Processor", "Attenuator Envelope follower Sample and hold Slew limiter Utility Random Noise Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Nitrous", "Nitrous", "Acid Filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Nopskate", "Nopskate", "Flip-Flop Octaver", "Waveshaper Effect Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Noxious", "Noxious", "Pure Distortion Oscillator", "VCO LFO Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Noxious-Poly", "Noxious-Poly", "Polyphonic Noxious", "VCO LFO Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Nurage", "Nurage", "Dual Low Pass Gate/Filter", "Low pass gate VCF VCA Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Opulus", "Opulus", "Retro FM Operator", "Synth voice Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "OpulusMicro", "OpulusMicro", "Accidental FM Operator", "Synth voice Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Punch", "Punch", "Voltage Controlled Amplifier", "VCA Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Rescomb", "Rescomb", "Resonant Comb Filter", "VCF Effect Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Rescomb2", "Rescomb 2", "Resonant Comb Filter", "VCF Effect Physical modeling Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Slap", "Slap", "Hitting Envelope", "Envelope generator VCA Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Spank", "Spank", "Drum Envelope", "Envelope generator VCA Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Splie", "Splie", "Active Buffer", "Multiple Utility Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Stabile", "Stabile", "State Variable Filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Tangents", "Tangents", "Steiner-Parker Filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Tohe", "Tohe", "Tone Control", "VCF Equalizer Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Trummor", "Trummor", "Drum Synthesizer", "Drum Envelope generator Noise Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Trummor2", "Trummor 2", "Percussion Synthesizer", "Drum Envelope generator Noise Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Unstabile", "Unstabile", "Bent State Variable Filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Vessek", "Vessek", "Complex Analog Oscillator", "VCO Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Vortex", "Vortex", "Russian Filter", "VCF Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Vultari", "Vultari", "Punk Console", "VCO Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "Wolv", "Wolv", "Waveshaper", "Waveshaper Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "BlackPanelSmall", "Blank: 3 HP", "Blank: 3 HP", "Blank" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "BlackPanel", "Blank: 6 HP", "Blank: 6 HP", "Blank" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "BlackPanelBig", "Blank: 12 HP", "Blank: 12 HP", "Blank" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "UtilBypass", "Bypass", "Stereo Channel Effect Bypass", "Utility Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "UtilKnobs", "Knobs", "Modulation Mixer and Macro Control", "Utility Attenuator Mixer Dual Polyphonic" },
 { "VultModules", "Vult Modules", "Vult", "Leonardo Laguna Ruiz", "UtilSend", "Send", "Stereo Channel Send/Return", "Utility Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Basal", "Basal (Free)", "Smooth Oscillator", "VCO Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Bleak", "Bleak (Free)", "Analog Oscillator", "VCO Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Boomstick", "Boomstick (Free)", "Sallen-Key filter", "VCF Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Caudal", "Caudal (Free)", "Mechanical Chaos Source", "Random LFO Noise Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Debriatus", "Debriatus (Free)", "Wave Destruction", "Distortion Waveshaper Effect Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Decline", "Decline (Free)", "Equalizer Line", "Equalizer Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Disjoint", "Disjoint (Free)", "DJ Style Filter", "Equalizer VCF Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Fuser", "Fuser", "Voltage Mixer", "Mixer Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Flux", "Flux (Free)", "Quad Voltage Processor", "Attenuator Envelope follower Quad Sample and hold Slew limiter Utility Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Jorus", "Jorus", "Analog Chorus", "Effect Chorus Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Julste", "Julste (Free)", "Simple Low Pass Gate", "Low pass gate Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Lateralus", "Lateralus (Free)", "Diode Ladder Filter", "VCF Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Leakage", "Leakage (Free)", "Voltage Processor", "Attenuator Envelope follower Sample and hold Slew limiter Utility Random Noise Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Nopskate", "Nopskate (Free)", "Flip-Flop Octaver", "Waveshaper Effect Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Nitrous", "Nitrous (Free)", "Acid Filter", "VCF Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Opulus", "Opulus", "Retro FM Operator", "Synth voice Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "OpulusMicro", "OpulusMicro", "Accidental FM Operator", "Synth voice Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Punch", "Punch", "Voltage Controlled Amplifier", "VCA Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Rescomb", "Rescomb (Free)", "Resonant Comb Filter", "VCF Effect Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Slap", "Slap (Free)", "Hitting Envelope", "Envelope generator VCA Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Spank", "Spank (Free)", "Drum Envelope", "Envelope generator VCA Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Splie", "Splie (Free)", "Active Buffer", "Multiple Utility Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Stabile", "Stabile (Free)", "State Variable Filter", "VCF Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Tangents", "Tangents (Free)", "Steiner-Parker Filter", "VCF Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Tohe", "Tohe (Free)", "Tone Control", "VCF Equalizer Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Trummor", "Trummor (Free)", "Drum Synthesizer", "Drum Envelope generator Noise Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Trummor2", "Trummor 2 (Free)", "Percussion Synthesizer", "Drum Envelope generator Noise Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Unstabile", "Unstabile (Free)", "Bent State Variable Filter", "VCF Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Vessek", "Vessek (Free)", "Complex Analog Oscillator", "VCO Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Vultari", "Vultari (Free)", "Punk Console", "VCO Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "Wolv", "Wolv", "Waveshaper", "Waveshaper Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "BlackPanelSmall", "Blank: 3 HP (Free)", "Blank: 3 HP", "Blank" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "BlackPanel", "Blank: 6 HP (Free)", "Blank: 6 HP", "Blank" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "BlackPanelBig", "Blank: 12 HP (Free)", "Blank: 12 HP", "Blank" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "UtilBypass", "Bypass (Free)", "Stereo Channel Effect Bypass", "Utility Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "UtilKnobs", "Knobs (Free)", "Modulation Mixer and Macro Control", "Utility Attenuator Mixer Dual Polyphonic" },
 { "VultModulesFree", "Vult Modules Free", "Vult", "Leonardo Laguna Ruiz", "UtilSend", "Send (Free)", "Stereo Channel Send/Return", "Utility Polyphonic" },
 { "VultMysteries", "Vult Mysteries", "Vult", "Leonardo Laguna Ruiz", "Anima", "Anima", "Psychic Sequence Generator", "Sequencer Random" },
 { "VultMysteries", "Vult Mysteries", "Vult", "Leonardo Laguna Ruiz", "Lapsus", "Lapsus", "Non-Euclidean Rhythm Generator", "Sequencer" },
 { "VultMysteries", "Vult Mysteries", "Vult", "Leonardo Laguna Ruiz", "Quincunx", "Quincunx", "Probability Machine", "Random" },
 { "VultMysteries", "Vult Mysteries", "Vult", "Leonardo Laguna Ruiz", "Dopamine", "Dopamine", "Neural Tape", "Sequencer Random" },
 { "VultMysteries", "Vult Mysteries", "Vult", "Leonardo Laguna Ruiz", "Feigen", "Feigen", "Bifurcations Generator", "Random" },
 { "WeldSplatter", "WeldSplatter", "pknodle", "Philip Knodle", "WeldSplatter-AcornTable", "AcornTable", "", "" },
 { "WhatTheRack", "WhatTheRack", "", "korfuri", "WhatTheRack", "WhatTheRack", "Rack randomizer", "utility" },
 { "WhatTheRack", "WhatTheRack", "", "korfuri", "WhatTheJack", "WhatTheJack", "Wire randomizer", "utility" },
 { "WhatTheRack", "WhatTheRack", "", "korfuri", "WhatTheMod", "WhatTheMod", "Module randomizer", "utility" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "expanse", "expanse", "resizable blank", "blank" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "languor", "languor", "chaotic low-frequency oscillator using strange attractors", "lfo multiple random" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "halvorsen", "halvorsen", "2hp halvorsen strange attractor chaotic lfo", "lfo random" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "lorenz", "lorenz", "2hp lorenz strange attractor chaotic lfo", "lfo random" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "thomas", "thomas", "2hp thomas strange attractor chaotic lfo", "lfo random" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "sakarya", "sakarya", "2hp sakarya strange attractor chaotic lfo", "lfo random" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "dadras", "dadras", "2hp dadras strange attractor chaotic lfo", "lfo random" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "slf", "sprott-linz f", "2hp sprott-linz f strange attractor chaotic lfo", "lfo random" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "2at", "dual attenuverter", "2hp polyphonic dual attenuverter with offset", "attenuator dual poly vca" },
 { "wiqid-anomalies", "wiqid anomalies", "wiqid", "wiqid", "fullscope", "full scope black edition", "full scope - in black! with toggleable stats", "visual" },
 { "WrongPeople", "Wrong People", "Wrong People", "Wrong People", "MIDIPlayer", "MIDI Player", "Multitrack MIDI files player", "Clock generator Envelope generator MIDI Polyphonic Sequencer" },
 { "WrongPeople", "Wrong People", "Wrong People", "Wrong People", "Lua", "Lua", "Lua interpreter with 8 inputs, 8 outputs and display", "Utility Polyphonic Visual" },
 { "WrongPeople", "Wrong People", "Wrong People", "Wrong People", "Tourette", "Tourette", "Tourette syndrome simulator", "Drum Effect Granular Random Sampler" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "BrownianBridge", "BrownianBridge", "Brownian bridge from one value to another", "Random Utility" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "OrnsteinUhlenbeck", "OrnsteinUhlenbeck", "Ornstein-Uhlenbeck stochastic process", "Random Utility" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "IOU", "IOU", "stochastic generator/mixer", "Random" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "Warbler", "WeebleWarbler", "Oscillator with some mixing capability", "Oscillator" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "Rosenchance", "Rosenchance", "2 State, 2 Emission Hidden Markov Model", "Random Utility" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "GuildensTurn", "GuildensTurn", "4 state Markovian Router", "Random Utility" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "RosslerRustler", "RosslerRustler", "Filter/Oscillator combination based on Rossler Attractor", "Oscillator Effect Distortion" },
 { "ZetaCarinae", "ZetaCarinae", "ZetaCarinae", "Marshall Hampton", "Firefly", "Firefly", "Phase-coupled oscillator system", "Oscillator" },
 { "ZZC-Phaseque", "ZZC Phaseque", "ZZC", "Sergey Ukolov", "Phaseque", "Phaseque", "Phase-Driven Sequencer", "Sequencer Polyphonic" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "Clock", "Clock", "Clock & Phase Generator", "Clock generator" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "Divider", "Divider", "Phase Clock Divider (Scaler)", "Clock modulator" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "FN-3", "FN-3", "Function Generator", "Function generator Polyphonic" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "SC-VCA", "SC-VCA", "Soft Clipping VCA", "VCA Waveshaper Polyphonic" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "SH-8", "SH-8", "Sample & Hold", "Noise Sample and hold" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "SRC", "SRC", "Voltage Source", "Quantizer Utility" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "Div", "Div", "Phase Clock Divider (Compact)", "Clock modulator" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "DivExp", "Div (Expander)", "Phase Clock Divider (Expander)", "Clock modulator Expander" },
 { "ZZC", "ZZC", "ZZC", "Sergey Ukolov", "Polygate", "Polygate", "Polyphonic Gate Bank", "Controller Polyphonic Switch Utility" }
};

