// Based on dialogs from iemguis in Pd Vanilla (by Tim Schoen & Porres)

sys_gui("\n"
"namespace eval ::dialog_menu:: {\n"
"}\n"
// arrays to store per-dialog values
"array set ::dialog_menu::var_width {} ;\n"
"array set ::dialog_menu::var_height {} ;\n"
"array set ::dialog_menu::var_fontsize {} ;\n"
"\n"
"array set ::dialog_menu::var_outline {} ;\n"
"array set ::dialog_menu::var_outmode {} ;\n"
"\n"
"array set ::dialog_menu::var_load {} ;\n"
"array set ::dialog_menu::var_loadbang {} ;\n"
"array set ::dialog_menu::var_savestate {} ;\n"
"\n"
"array set ::dialog_menu::var_keep {} ;\n"
"array set ::dialog_menu::var_pos {} ;\n"
"\n"
"array set ::dialog_menu::var_lbl {} ;\n"
"array set ::dialog_menu::var_rcv {} ;\n"
"array set ::dialog_menu::var_snd {} ;\n"
"array set ::dialog_menu::var_prm {} ;\n"
"array set ::dialog_menu::var_var {} ;\n"
"\n"
"array set ::dialog_menu::var_color_bg {} ;\n"
"array set ::dialog_menu::var_color_fg {} ;\n"
"array set ::dialog_menu::var_colorradio {} ;\n" // radio for what color type we're setting
"\n"
//
// ------------------------------------------------------------------------------------------------
// Get parameters from Pd when asking for properties!
"proc menu_dialog {id \\\n"
"         width height fontsize \\\n"
"         outline outmode \\\n"
"         load loadbang savestate keep pos \\\n"
"         lbl rcv snd prm var \\\n"
"         bg fg} {\n"
// The vid indicates the instance ID of this dialog
"    set vid [string trimleft $id .]\n"
// initialize the array with received values for this dialog instance
"    set ::dialog_menu::var_width($vid) $width \n"
"    set ::dialog_menu::var_height($vid) $height \n"
"    set ::dialog_menu::var_fontsize($vid) $fontsize \n"
"    set ::dialog_menu::var_outline($vid) $outline \n"
"    set ::dialog_menu::var_outmode($vid) [string map {{\\ } \" \"} $outmode]\n"
"    set ::dialog_menu::var_load($vid) $load \n"
"    set ::dialog_menu::var_loadbang($vid) $loadbang \n"
"    set ::dialog_menu::var_savestate($vid) $savestate \n"
"    set ::dialog_menu::var_keep($vid) $keep \n"
"    set ::dialog_menu::var_pos($vid) [string map {{\\ } \" \"} $pos]\n"
"\n" // attached symbols
"    set lbl [::pdtk_text::unescape $lbl]\n"
"    set rcv [::pdtk_text::unescape $rcv]\n"
"    set snd [::pdtk_text::unescape $snd]\n"
"    set prm [::pdtk_text::unescape $prm]\n"
"    set var [::pdtk_text::unescape $var]\n"
"    if {$lbl==\"\"} {\n"
"       set lbl \"\"\n"
"    }\n"
"    if {$rcv==\"empty\"} {\n"
"       set rcv \"\"\n"
"    }\n"
"    if {$snd==\"empty\"} {\n"
"       set snd \"\"\n"
"    }\n"
"    if {$prm==\"empty\"} {\n"
"       set prm \"\"\n"
"    }\n"
"    if {$var==\"empty\"} {\n"
"       set var \"\"\n"
"    }\n"
"\n"
"    set ::dialog_menu::var_lbl($vid) [string map {{\\ } \" \"} $lbl]\n"
"    set ::dialog_menu::var_rcv($vid) [string map {{\\ } \" \"} $rcv]\n"
"    set ::dialog_menu::var_snd($vid) [string map {{\\ } \" \"} $snd]\n"
"    set ::dialog_menu::var_prm($vid) [string map {{\\ } \" \"} $prm]\n"
"    set ::dialog_menu::var_var($vid) [string map {{\\ } \" \"} $var]\n"
"\n" // colors
"    set ::dialog_menu::var_color_bg($vid) $bg\n"
"    set ::dialog_menu::var_color_fg($vid) $fg\n"
"    set ::dialog_menu::var_colorradio($vid) 0\n" // init to 'bg'
"\n"
// ------------------------------------------------------------------------------------------------
// HELPER PROCEDURES/FUNCTIONS:
//
"proc ::dialog_menu::applymacos {id} {\n"
"    if {$::windowingsystem eq \"aqua\"} {\n"
"        ::dialog_menu::apply $id\n"
"    }\n"
"}\n"
"\n"
//
"proc ::dialog_menu::savestate_check {id} {\n"
"    set vid [string trimleft $id .]\n"
"    if { $::dialog_menu::var_savestate($vid) == 1 } {\n"
"       $id.load.load.ent configure -state disabled\n"
"    } else {\n"
"       $id.load.load.ent configure -state normal\n"
"    }\n"
"}\n"
"\n"
//
"proc ::dialog_menu::outmenucheck {option id} {\n"
"    $id.out.mode.mb configure -text $option\n"
"    ::dialog_menu::applymacos $id\n"
"}\n"
"\n"
//
"proc ::dialog_menu::posmenucheck {option id} {\n"
"    $id.misc.pos.mb configure -text $option\n"
"    ::dialog_menu::applymacos $id\n"
"}\n"
"\n"
// --------------------------------------------------------------------------------------------
// DRAW PROPERTIES' WINDOW:
// Initialize creation/drawing of properties window
"    toplevel $id -class DialogWindow\n"
"    wm title $id {[popmenu] Properties}\n"
"    wm group $id .\n"
"    wm resizable $id 0 0\n" // ???
"    wm transient $id $::focused_window\n"
"    $id configure -menu $::dialog_menubar\n"
"    $id configure -padx 0 -pady 0\n"
"    ::pd_bindings::dialog_bindings $id \"menu\"\n"
"\n"
// Frame for 'Dimensions' (Width, Height and Fontsize)
"    labelframe $id.dim\n"
"    pack $id.dim -side top -fill x\n"
"    $id.dim config -borderwidth 1 -pady 4\n"
        // Width
"    frame $id.dim.width \n"
"    label $id.dim.width.w_lab -text \"Width:\"\n"
"    entry $id.dim.width.w_ent -textvariable ::dialog_menu::var_width($vid) -width 4\n"
"    pack $id.dim.width.w_lab $id.dim.width.w_ent -side left\n"
        // Heigth
"    frame $id.dim.height \n"
"    label $id.dim.height.w_lab -text \"Height:\"\n"
"    entry $id.dim.height.w_ent -textvariable ::dialog_menu::var_height($vid) -width 4\n"
"    pack $id.dim.height.w_lab $id.dim.height.w_ent -side left\n"
        // Font size
"    frame $id.dim.fontsize \n"
"    label $id.dim.fontsize.w_lab -text \"Font size:\"\n"
"    entry $id.dim.fontsize.w_ent -textvariable ::dialog_menu::var_fontsize($vid) -width 4\n"
"    pack $id.dim.fontsize.w_lab $id.dim.fontsize.w_ent -side left\n"
        // Position of items
"    pack $id.dim.width $id.dim.height $id.dim.fontsize -side left -anchor center\n"
"    $id.dim config -padx 60\n"
"\n"
// Frame Outline and Outmode
"    labelframe $id.out\n"
"    pack $id.out -side top -fill x\n"
"    $id.out config -borderwidth 1 -pady 4 \n"
    // Outline Checkbox
"    frame $id.out.outline\n"
"    label $id.out.outline.lab -text [_ \"Outline: \"]\n"
"    checkbutton $id.out.outline.ent -variable ::dialog_menu::var_outline($vid) -width 5\\\n"
"       -command \"::dialog_menu::applymacos $id\"\n"
"    pack $id.out.outline.ent $id.out.outline.lab -side right -anchor e\n"
        // Dropdown menu for out mode:
"    frame $id.out.mode\n"
"    label $id.out.mode.lab -text [_ \"Out mode: \"]\n"
"   menubutton $id.out.mode.mb -text $::dialog_menu::var_outmode($vid) -menu $id.out.mode.mb.menu -width 6\n"
"   menu $id.out.mode.mb.menu -tearoff 0\n"
"   $id.out.mode.mb configure -menu $id.out.mode.mb.menu\n"
        // Add radiobuttons using foreach
"   set outmodes { Index Item Both }\n"
"   foreach out_selection $outmodes {\n"
"       $id.out.mode.mb.menu add radiobutton -label $out_selection \\\n"
"           -variable ::dialog_menu::var_outmode($vid) -value $out_selection \\\n"
"           -command \"::dialog_menu::outmenucheck $out_selection $id\"\n"
"   }\n"
"    pack $id.out.mode.lab $id.out.mode.mb -side left\n"
        // Position of items
"    pack $id.out.outline $id.out.mode -side left -anchor center\n"
"    $id.out config -padx 60\n"
"\n"
"\n"
// Frame for Load settings
"    labelframe $id.load\n"
"    pack $id.load -side top -fill x\n"
"    $id.load config -borderwidth 1 -pady 5\n"
        // Checkbox for Loadbang
"    frame $id.load.loadbang\n"
"    label $id.load.loadbang.lab -text [_ \"Loadbang: \"]\n"
"    checkbutton $id.load.loadbang.ent -variable ::dialog_menu::var_loadbang($vid) -width 5\n"
"    pack $id.load.loadbang.ent $id.load.loadbang.lab -side right -anchor e\n"
        // Checkbox for Savestate
"    frame $id.load.savestate\n"
"    label $id.load.savestate.lab -text [_ \"Savestate: \"]\n"
"    checkbutton $id.load.savestate.ent -variable ::dialog_menu::var_savestate($vid) -width 5\\\n"
"        -command [concat ::dialog_menu::savestate_check $id]\n"
"    pack $id.load.savestate.ent $id.load.savestate.lab -side right -anchor e\n"
        // Entry for load value
"    frame $id.load.load \n"
"    label $id.load.load.lab -text [_ \"Load Value\"]\n"
"    entry $id.load.load.ent -textvariable ::dialog_menu::var_load($vid) -width 3 -state normal\n"
"    pack $id.load.load.ent $id.load.load.lab -side right -anchor e\n"
        // When savestate is selected, disbale load box
"    if { $::dialog_menu::var_savestate($vid) == 1 } {\n"
"       $id.load.load.ent configure -state disabled\n"
"    }\n"
        // Position of items
"    pack $id.load.loadbang $id.load.savestate $id.load.load -side left -anchor center\n"        
"    $id.load config -padx 20\n"
"\n"
// Frame Keep and Positioning
"    labelframe $id.misc\n"
"    pack $id.misc -side top -fill x\n"
"    $id.misc config -borderwidth 1 -pady 4\n"
        // Keep Checkbox
"    frame $id.misc.keep\n"
"    label $id.misc.keep.lab -text [_ \"Keep Items: \"]\n"
"    checkbutton $id.misc.keep.ent -variable ::dialog_menu::var_keep($vid) -width 5\\\n"
"       -command \"::dialog_menu::applymacos $id\"\n"
"    pack $id.misc.keep.ent $id.misc.keep.lab -side right -anchor e\n"
        

        // Dropdown menu for out mode:
"    frame $id.misc.pos\n"
"    label $id.misc.pos.lab -text [_ \"Menu Position: \"]\n"
"   menubutton $id.misc.pos.mb -text $::dialog_menu::var_pos($vid) -menu $id.misc.pos.mb.menu -width 6\n"
"   menu $id.misc.pos.mb.menu -tearoff 0\n"
"   $id.misc.pos.mb configure -menu $id.misc.pos.mb.menu\n"
        // Add radiobuttons using foreach
"   set posmodes { Bottom Top Left Right Over }\n"
"   foreach pos_selection $posmodes {\n"
"       $id.misc.pos.mb.menu add radiobutton -label $pos_selection \\\n"
"           -variable ::dialog_menu::var_pos($vid) -value $pos_selection \\\n"
"           -command \"::dialog_menu::posmenucheck $pos_selection $id\"\n"
"   }\n"
"    pack $id.misc.pos.lab $id.misc.pos.mb -side left\n"
        
/*        // Entry for Position
"    frame $id.misc.pos \n"
"    label $id.misc.pos.lab -text [_ \"Menu Position: \"]\n"
"    entry $id.misc.pos.ent -textvariable ::dialog_menu::var_pos($vid) -width 6\n"
"    pack $id.misc.pos.ent $id.misc.pos.lab -side right -anchor e\n" */
        
        // Position of items
"    pack $id.misc.keep $id.misc.pos -side left -anchor center\n"
"    $id.misc config -padx 60\n"
"\n"
// Frame Label
"    labelframe $id.label\n"
"    pack $id.label -side top -fill x\n"
"    $id.label config -borderwidth 1 -pady 4\n"
    // Entry for Label
"    frame $id.label.label \n"
"    label $id.label.label.lab -text [_ \"Label for no Selection: \"]\n"
"    entry $id.label.label.ent -textvariable ::dialog_menu::var_lbl($vid) -width 24\n"
"    pack $id.label.label.ent $id.label.label.lab -side right -anchor e\n"
    // Position of items
"    pack $id.label.label -side left -anchor center\n"
"    $id.label config -padx 30\n"
"\n"
// Frame for attached symbols
"    labelframe $id.syms -borderwidth 1 -padx 5 -pady 8 -text [_ \"Attached symbols: \"]\n"
"    pack $id.syms -side top -fill x\n"
        // Receive
"    frame $id.syms.receive \n"
"    label $id.syms.receive.w_lab -text \"Receive:\"\n"
"    entry $id.syms.receive.w_ent -textvariable ::dialog_menu::var_rcv($vid) -width 15\n"
"    if { $rcv ne \"norcvno\" } {\n"
"        pack $id.syms.receive.w_lab $id.syms.receive.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Send
"    frame $id.syms.send \n"
"    label $id.syms.send.w_lab -text \"Send:\"\n"
"    entry $id.syms.send.w_ent -textvariable ::dialog_menu::var_snd($vid) -width 15\n"
"    if { $snd ne \"nosndno\" } {\n"
"        pack $id.syms.send.w_lab $id.syms.send.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Param
"    frame $id.syms.param \n"
"    label $id.syms.param.w_lab -text \"Param:\"\n"
"    entry $id.syms.param.w_ent -textvariable ::dialog_menu::var_prm($vid) -width 15\n"
"    if { $prm ne \"noprmno\" } {\n"
"        pack $id.syms.param.w_lab $id.syms.param.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Var
"    frame $id.syms.var \n"
"    label $id.syms.var.w_lab -text \"Variable:\"\n"
"    entry $id.syms.var.w_ent -textvariable ::dialog_menu::var_var($vid) -width 15\n"
"    if { $var ne \"novarno\" } {\n"
"        pack $id.syms.var.w_lab $id.syms.var.w_ent -side left\\\n"
"            -fill x -expand 1\n"
"    }\n"
        // Align items to grid
"    pack $id.syms -side top -fill x\n"
        // column 0
"    grid $id.syms.receive -row 0 -column 0 -sticky e -padx {10 0}\n"
"    grid $id.syms.send -row 1 -column 0 -sticky e -padx {10 0}\n"
        // column 1
"    grid $id.syms.param -row 0 -column 1 -sticky e -padx {5 0}\n"
"    grid $id.syms.var -row 1 -column 1 -sticky e -padx {5 0}\n"
"\n"
// Frame for colors section
"    labelframe $id.colors -borderwidth 1 -text [_ \"Colors:\"] -padx 5 -pady 8\n"
"    pack $id.colors -fill x\n"
        // Color Radiobuttons and "Compose" button
"    frame $id.colors.radio\n"
"    pack $id.colors.radio -side top\n"
"    radiobutton $id.colors.radio.bg -value 0 -variable ::dialog_menu::var_colorradio($vid)\\\n"
"        -text [_ \"Background\"]\n"
"    radiobutton $id.colors.radio.fg -value 1 -variable ::dialog_menu::var_colorradio($vid)\\\n"
"        -text [_ \"Front\"]\n"
"    label $id.colors.radio.dummy -text \"\" -width 1\n"
"    button $id.colors.radio.but -text [_ \"Compose\"] -command \"::dialog_menu::compose_color $id\"\n"
"    pack $id.colors.radio.bg $id.colors.radio.fg $id.colors.radio.dummy $id.colors.radio.but -side left\n"
"\n"
        // Preset colors, color scheme by Mary Ann Benedetto http://piR2.org
"    frame $id.colors.presets -pady 8\n"
"    pack $id.colors.presets -fill x\n"
"    foreach r {r1 r2 r3} hexcols {\n"
"       { \"#FFFFFF\" \"#DFDFDF\" \"#BBBBBB\" \"#FFC7C6\" \"#FFE3C6\" \"#FEFFC6\" \"#C6FFC7\" \"#C6FEFF\" \"#C7C6FF\" \"#E3C6FF\" }\n"
"       { \"#9F9F9F\" \"#7C7C7C\" \"#606060\" \"#FF0400\" \"#FF8300\" \"#FAFF00\" \"#00FF04\" \"#00FAFF\" \"#0400FF\" \"#9C00FF\" }\n"
"       { \"#404040\" \"#202020\" \"#000000\" \"#551312\" \"#553512\" \"#535512\" \"#0F4710\" \"#0E4345\" \"#131255\" \"#2F004D\" } }\\\n"
"    {\n"
"       frame $id.colors.presets.$r\n"
"       pack $id.colors.presets.$r -side top\n"
"       foreach i { 0 1 2 3 4 5 6 7 8 9} hexcol $hexcols \\\n"
"           {\n"
"               label $id.colors.presets.$r.c$i -background $hexcol -activebackground $hexcol -relief ridge -padx 7 -pady 0 -width 1\n"
"               bind $id.colors.presets.$r.c$i <Button> \"::dialog_menu::preset_col $id $hexcol\"\n"
"           }\n"
"       pack $id.colors.presets.$r.c0 $id.colors.presets.$r.c1 $id.colors.presets.$r.c2 $id.colors.presets.$r.c3 \\\n"
"           $id.colors.presets.$r.c4 $id.colors.presets.$r.c5 $id.colors.presets.$r.c6 $id.colors.presets.$r.c7 \\\n"
"           $id.colors.presets.$r.c8 $id.colors.presets.$r.c9 -side left\n"
"    }\n"
"\n"
// Cancel, Apply and OK buttons
"    frame $id.cao -pady 4\n"
"    pack $id.cao -side top\n"
"    button $id.cao.cancel -text [_ \"Cancel\"] \\\n"
"        -command \"::dialog_menu::cancel $id\"\n"
"    pack $id.cao.cancel -side left -expand 1 -fill x -padx 15 -ipadx 10\n"
"    if {$::windowingsystem ne \"aqua\"} {\n" // INCLUDE APPLY BUTTON ONLY IF NOT IN MACOS!
"        button $id.cao.apply -text [_ \"Apply\"] \\\n"
"            -command \"::dialog_menu::apply $id\"\n"
"        pack $id.cao.apply -side left -expand 1 -fill x -padx 15 -ipadx 10\n"
"    }\n"
"    button $id.cao.ok -text [_ \"OK\"] \\\n"
"        -command \"::dialog_menu::ok $id\" -default active\n"
"    pack $id.cao.ok -side left -expand 1 -fill x -padx 15 -ipadx 10\n"

// ----------------------------------------------------------------------------------------------------

// BUTTON FUNCTIONS
        
// Preset Colors
"proc ::dialog_menu::preset_col {id presetcol} {\n"
"    set vid [string trimleft $id .]\n"
"\n"
"    switch -- $::dialog_menu::var_colorradio($vid) {\n" // get type from radio and set
"        0 { set ::dialog_menu::var_color_bg($vid) $presetcol }\n"
"        1 { set ::dialog_menu::var_color_fg($vid) $presetcol }\n"
"    }\n"
"    if {$::windowingsystem eq \"aqua\"} {\n" // Apply color change if in MACOS
"       ::dialog_menu::bind_enter_to_apply $id \n"
"    }\n"
"}\n"
"\n"
// COMPOSE Color:
"proc ::dialog_menu::compose_color {id} {\n"
"    set vid [string trimleft $id .]\n"
"\n"
// Check which color field is currently active
"    switch -- $::dialog_menu::var_colorradio($vid) {\n"
"        0 {\n"
"            set title [_ \"Background color\" ]\n"
"            set color $::dialog_menu::var_color_bg($vid)\n"
"        }\n"
"        1 {\n"
"            set title [_ \"Foreground color\" ]\n"
"            set color $::dialog_menu::var_color_fg($vid)\n"
"        }\n"
"    }\n"
"    set color [tk_chooseColor -title $title -initialcolor $color]\n"
"\n"
"    if { $color ne \"\" } {\n"
"        ::dialog_menu::preset_col $id $color\n"
"    }\n"
"}\n"
"\n"
                
//  CANCEL button
"proc ::dialog_menu::cancel {id} {\n"
"    pdsend \"$id cancel\"\n"
"}\n"
"\n"
                
// OK button
"proc ::dialog_menu::ok {id} {\n"
"    ::dialog_menu::apply $id\n"
"    ::dialog_menu::cancel $id\n"
"}\n"
        
// APPLY BUTTON: Send current values to Pd
"proc ::dialog_menu::apply {id} {\n"
"    set vid [string trimleft $id .]\n"
"\n"
//  Initialize receive, send, param and var as 'empty'
"    set lbl_name \"\"\n"
"    set rcv_name empty\n"
"    set snd_name empty\n"
"    set prm_name empty\n"
"    set var_name empty\n"
"\n"
//  Set receive, send, param and var if not empty
"    if {$::dialog_menu::var_lbl($vid) ne \"\"} {set lbl_name $::dialog_menu::var_lbl($vid)}\n"
"    if {$::dialog_menu::var_rcv($vid) ne \"\"} {set rcv_name $::dialog_menu::var_rcv($vid)}\n"
"    if {$::dialog_menu::var_snd($vid) ne \"\"} {set snd_name $::dialog_menu::var_snd($vid)}\n"
"    if {$::dialog_menu::var_prm($vid) ne \"\"} {set prm_name $::dialog_menu::var_prm($vid)}\n"
"    if {$::dialog_menu::var_var($vid) ne \"\"} {set var_name $::dialog_menu::var_var($vid)}\n"
"\n"
//  Send to the object
"    pdsend [concat $id dialog \\\n"
"                $::dialog_menu::var_width($vid) \\\n"
"                $::dialog_menu::var_height($vid) \\\n"
"                $::dialog_menu::var_fontsize($vid) \\\n"
"                $::dialog_menu::var_outline($vid) \\\n"
"                $::dialog_menu::var_outmode($vid) \\\n"
"                $::dialog_menu::var_load($vid) \\\n"
"                $::dialog_menu::var_loadbang($vid) \\\n"
"                $::dialog_menu::var_savestate($vid) \\\n"
"                $::dialog_menu::var_keep($vid) \\\n"
"                $::dialog_menu::var_pos($vid) \\\n"
"                [string map {\"$\" {\\$}} [unspace_text $lbl_name]] \\\n"
"                [string map {\"$\" {\\$}} [unspace_text $rcv_name]] \\\n"
"                [string map {\"$\" {\\$}} [unspace_text $snd_name]] \\\n"
"                [string map {\"$\" {\\$}} [unspace_text $prm_name]] \\\n" // clean?
"                [string map {\"$\" {\\$}} [unspace_text $var_name]] \\\n" // clean?
"                [string tolower $::dialog_menu::var_color_bg($vid)] \\\n"
"                [string tolower $::dialog_menu::var_color_fg($vid)] \\\n"
"            ]\n"
"}\n"
// Bind and unbind enter key to Apply button on macOS for entry widgets
"    if {$::windowingsystem eq \"aqua\"} {\n"
// call apply on Return in entry boxes that are in focus & rebind Return to ok button
"        bind $id.dim.width.w_ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.dim.height.w_ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.dim.fontsize.w_ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.load.load.ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.label.label.ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.syms.send.w_ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.syms.param.w_ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.syms.var.w_ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
"        bind $id.syms.receive.w_ent <KeyPress-Return> \"::dialog_menu::bind_enter_to_apply $id\"\n"
// unbind Return from ok button when an entry takes focus
"        $id.dim.width.w_ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.dim.height.w_ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.dim.fontsize.w_ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.load.load.ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.label.label.ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.syms.send.w_ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.syms.param.w_ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.syms.var.w_ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
"        $id.syms.receive.w_ent config -validate focusin -vcmd \"::dialog_menu::unbind_return $id\"\n"
// remove cancel button from focus list since it's not activated on Return
"        $id.cao.cancel config -takefocus 0\n"
// show active focus on the ok button as it *is* activated on Return
"        $id.cao.ok config -default normal\n"
"        bind $id.cao.ok <FocusIn> \"$id.cao.ok config -default active\"\n"
"        bind $id.cao.ok <FocusOut> \"$id.cao.ok config -default normal\"\n"
// since we show the active focus, disable the highlight outline\n"
"        $id.cao.ok config -highlightthickness 0\n"
"        $id.cao.cancel config -highlightthickness 0\n"
"    }\n"
"    position_over_window $id $::focused_window\n"
"}\n"
"\n"
// bind proc
"proc ::dialog_menu::bind_enter_to_apply {id} {\n"
"    ::dialog_menu::apply $id\n"
"    bind $id <KeyPress-Return> \"::dialog_menu::ok $id\"\n"
"    focus $id.cao.ok\n"
"    return 0\n"
"}\n"
"\n"
// unbind proc
"proc ::dialog_menu::unbind_return {id} {\n"
"    bind $id <KeyPress-Return> break\n"
"    return 1\n"
"}\n");
