sys_gui("\n" // Tcl/Tk properties code based on IEMGUI's
            "package provide dialog_numbox 0.1\n"
            "namespace eval ::dialog_numbox:: {\n"
            "    variable define_min_fontsize 4\n"
            "\n"
            "    namespace export pdtk_numbox_dialog\n"
            "}\n"
            "\n"
            "\n"
            "proc ::dialog_numbox::clip_dim {mytoplevel} {\n"
            "    set vid [string trimleft $mytoplevel .]\n"
            "\n"
            "    set var_numbox_wdt [concat numbox_wdt_$vid]\n"
            "    global $var_numbox_wdt\n"
            "    set var_numbox_min_wdt [concat numbox_min_wdt_$vid]\n"
            "    global $var_numbox_min_wdt\n"
            "    set var_numbox_hgt [concat numbox_hgt_$vid]\n"
            "    global $var_numbox_hgt\n"
            "    set var_numbox_min_hgt [concat numbox_min_hgt_$vid]\n"
            "    global $var_numbox_min_hgt\n"
            "\n"
            "    if {[eval concat $$var_numbox_wdt] < [eval concat $$var_numbox_min_wdt]} {\n"
            "        set $var_numbox_wdt [eval concat $$var_numbox_min_wdt]\n"
            "        $mytoplevel.dim.w_ent configure -textvariable $var_numbox_wdt\n"
            "    }\n"
            "    if {[eval concat $$var_numbox_hgt] < [eval concat $$var_numbox_min_hgt]} {\n"
            "        set $var_numbox_hgt [eval concat $$var_numbox_min_hgt]\n"
            "        $mytoplevel.dim.h_ent configure -textvariable $var_numbox_hgt\n"
            "    }\n"
            "}\n"
            "proc ::dialog_numbox::set_col_example {mytoplevel} {\n"
            "    set vid [string trimleft $mytoplevel .]\n"
            "\n"
            "    set var_numbox_l2_f1_b0 [concat numbox_l2_f1_b0_$vid]\n"
            "    global $var_numbox_l2_f1_b0\n"
            "    set var_numbox_bcol [concat numbox_bcol_$vid]\n"
            "    global $var_numbox_bcol\n"
            "    set var_numbox_fcol [concat numbox_fcol_$vid]\n"
            "    global $var_numbox_fcol\n"
            "\n"
            "    if { [eval concat $$var_numbox_fcol] ne \"none\" } {\n"
            "        $mytoplevel.colors.sections.exp.fr_bk configure \\\n"
            "            -background [eval concat $$var_numbox_bcol] \\\n"
            "            -activebackground [eval concat $$var_numbox_bcol] \\\n"
            "            -foreground [eval concat $$var_numbox_fcol] \\\n"
            "            -activeforeground [eval concat $$var_numbox_fcol]\n"
            "    } else {\n"
            "        $mytoplevel.colors.sections.exp.fr_bk configure \\\n"
            "            -background [eval concat $$var_numbox_bcol] \\\n"
            "            -activebackground [eval concat $$var_numbox_bcol] \\\n"
            "            -foreground [eval concat $$var_numbox_bcol] \\\n"
            "            -activeforeground [eval concat $$var_numbox_bcol]}\n"
            "\n"
            "    # for OSX live updates\n"
            "    if {$::windowingsystem eq \"aqua\"} {\n"
            "        ::dialog_numbox::apply_and_rebind_return $mytoplevel\n"
            "    }\n"
            "}\n"
            "\n"
            "proc ::dialog_numbox::preset_col {mytoplevel presetcol} {\n"
            "    set vid [string trimleft $mytoplevel .]\n"
            "    set var_numbox_l2_f1_b0 [concat numbox_l2_f1_b0_$vid]\n"
            "    global $var_numbox_l2_f1_b0\n"
            "\n"
            "    set var_numbox_bcol [concat numbox_bcol_$vid]\n"
            "    global $var_numbox_bcol\n"
            "    set var_numbox_fcol [concat numbox_fcol_$vid]\n"
            "    global $var_numbox_fcol\n"
            "\n"
            "    if { [eval concat $$var_numbox_l2_f1_b0] == 0 } { set $var_numbox_bcol $presetcol }\n"
            "    if { [eval concat $$var_numbox_l2_f1_b0] == 1 } { set $var_numbox_fcol $presetcol }\n"
            "    ::dialog_numbox::set_col_example $mytoplevel\n"
            "}\n"
            "\n"
            "proc ::dialog_numbox::choose_col_bkfrlb {mytoplevel} {\n"
            "    set vid [string trimleft $mytoplevel .]\n"
            "\n"
            "    set var_numbox_l2_f1_b0 [concat numbox_l2_f1_b0_$vid]\n"
            "    global $var_numbox_l2_f1_b0\n"
            "    set var_numbox_bcol [concat numbox_bcol_$vid]\n"
            "    global $var_numbox_bcol\n"
            "    set var_numbox_fcol [concat numbox_fcol_$vid]\n"
            "    global $var_numbox_fcol\n"
            "\n"
            "    if {[eval concat $$var_numbox_l2_f1_b0] == 0} {\n"
            "        set $var_numbox_bcol [eval concat $$var_numbox_bcol]\n"
            "        set helpstring [tk_chooseColor -title [_ \"Background color\"] -initialcolor [eval concat $$var_numbox_bcol]]\n"
            "        if { $helpstring ne \"\" } {\n"
            "            set $var_numbox_bcol $helpstring }\n"
            "    }\n"
            "    if {[eval concat $$var_numbox_l2_f1_b0] == 1} {\n"
            "        set $var_numbox_fcol [eval concat $$var_numbox_fcol]\n"
            "        set helpstring [tk_chooseColor -title [_ \"Text color\"] -initialcolor [eval concat $$var_numbox_fcol]]\n"
            "        if { $helpstring ne \"\" } {\n"
            "            set $var_numbox_fcol $helpstring }\n"
            "    }\n"
            "    ::dialog_numbox::set_col_example $mytoplevel\n"
            "}\n"
            "\n"
            "\n"
            "\n"
            "\n"
            "proc ::dialog_numbox::ramp {mytoplevel} {\n"
            "    set vid [string trimleft $mytoplevel .]\n"
            "\n"
            "    set var_numbox_ramp [concat numbox_ramp_$vid]\n"
            "    global $var_numbox_ramp\n"
            "\n"
            "    if {[eval concat $$var_numbox_ramp]} {\n"
            "        set $var_numbox_ramp 0\n"
            "        $mytoplevel.para.ramp configure -text [_ \"Input\"]\n"
            "    } else {\n"
            "        set $var_numbox_ramp 1\n"
            "        $mytoplevel.para.ramp configure -text [_ \"Output\"]\n"
            "    }\n"
            "}\n"
            "\n"
            "proc ::dialog_numbox::apply {mytoplevel} {\n"
            "    set vid [string trimleft $mytoplevel .]\n"
            "\n"
            "    set var_numbox_wdt [concat numbox_wdt_$vid]\n"
            "    global $var_numbox_wdt\n"
            "    set var_numbox_min_wdt [concat numbox_min_wdt_$vid]\n"
            "    global $var_numbox_min_wdt\n"
            "    set var_numbox_hgt [concat numbox_hgt_$vid]\n"
            "    global $var_numbox_hgt\n"
            "    set var_numbox_min_hgt [concat numbox_min_hgt_$vid]\n"
            "    global $var_numbox_min_hgt\n"
            "    set var_numbox_interval [concat numbox_interval_$vid]\n"
            "    global $var_numbox_interval\n"
            "    set var_numbox_initial [concat numbox_initial_$vid]\n"
            "    global $var_numbox_initial\n"
            "    set var_numbox_ramp [concat numbox_ramp_$vid]\n"
            "    global $var_numbox_ramp\n"
            "    set var_numbox_bcol [concat numbox_bcol_$vid]\n"
            "    global $var_numbox_bcol\n"
            "    set var_numbox_fcol [concat numbox_fcol_$vid]\n"
            "    global $var_numbox_fcol\n"
            "    set var_numbox_min_rng [concat numbox_min_rng_$vid]\n"
            "    global $var_numbox_min_rng\n"
            "    set var_numbox_max_rng [concat numbox_max_rng_$vid]\n"
            "    global $var_numbox_max_rng\n"
            "\n"
            "    ::dialog_numbox::clip_dim $mytoplevel\n"
            "\n"
            "\n"
            "\n"
            "\n"
// send "dialog" message to pd
            "    pdsend [concat $mytoplevel dialog \\\n"
            "            [eval concat $$var_numbox_wdt] \\\n"
            "            [eval concat $$var_numbox_hgt] \\\n"
            "            [eval concat $$var_numbox_ramp] \\\n"
            "            [eval concat $$var_numbox_interval] \\\n"
            "            [eval concat $$var_numbox_initial] \\\n"
            "            [string tolower [eval concat $$var_numbox_bcol]] \\\n"
            "            [string tolower [eval concat $$var_numbox_fcol]] \\\n"
            "            [eval concat $$var_numbox_min_rng] \\\n"
            "            [eval concat $$var_numbox_max_rng]] \\\n"
            "}\n"
            "\n"
            "\n"
            "proc ::dialog_numbox::cancel {mytoplevel} {\n"
            "    pdsend \"$mytoplevel cancel\"\n"
            "}\n"
            "\n"
            "proc ::dialog_numbox::ok {mytoplevel} {\n"
            "    ::dialog_numbox::apply $mytoplevel\n"
            "    ::dialog_numbox::cancel $mytoplevel\n"
            "}\n"
            "\n"
            "proc ::dialog_numbox::pdtk_numbox_dialog {mytoplevel \\\n"
            "                                       wdt min_wdt \\\n"
            "                                       hgt min_hgt \\\n"
            "                                       ramp interval initial \\\n"
            "                                       bcol fcol min_rng max_rng} {\n"
            "\n"
            "    set vid [string trimleft $mytoplevel .]\n"
            "\n"
            "    set var_numbox_wdt [concat numbox_wdt_$vid]\n"
            "    global $var_numbox_wdt\n"
            "    set var_numbox_min_wdt [concat numbox_min_wdt_$vid]\n"
            "    global $var_numbox_min_wdt\n"
            "    set var_numbox_hgt [concat numbox_hgt_$vid]\n"
            "    global $var_numbox_hgt\n"
            "    set var_numbox_min_hgt [concat numbox_min_hgt_$vid]\n"
            "    global $var_numbox_min_hgt\n"
            "    set var_numbox_initial [concat numbox_initial_$vid]\n"
            "    global $var_numbox_initial\n"
            "    set var_numbox_interval [concat numbox_interval_$vid]\n"
            "    global $var_numbox_interval\n"
            "    set var_numbox_ramp [concat numbox_ramp_$vid]\n"
            "    global $var_numbox_ramp\n"
            "    set var_numbox_bcol [concat numbox_bcol_$vid]\n"
            "    global $var_numbox_bcol\n"
            "    set var_numbox_fcol [concat numbox_fcol_$vid]\n"
            "    global $var_numbox_fcol\n"
            "    set var_numbox_l2_f1_b0 [concat numbox_l2_f1_b0_$vid]\n"
            "    global $var_numbox_l2_f1_b0\n"
            "    set var_numbox_min_rng [concat numbox_min_rng_$vid]\n"
            "    global $var_numbox_min_rng\n"
            "    set var_numbox_max_rng [concat numbox_max_rng_$vid]\n"
            "    global $var_numbox_max_rng\n"
            "\n"
            "    set $var_numbox_wdt $wdt\n"
            "    set $var_numbox_min_wdt $min_wdt\n"
            "    set $var_numbox_hgt $hgt\n"
            "    set $var_numbox_min_hgt $min_hgt\n"
            "    set $var_numbox_interval $interval\n"
            "    set $var_numbox_initial $initial\n"
            "    set $var_numbox_ramp $ramp\n"
            "    set $var_numbox_bcol $bcol\n"
            "    set $var_numbox_fcol $fcol\n"
            "    set $var_numbox_min_rng $min_rng\n"
            "    set $var_numbox_max_rng $max_rng\n"
            "\n"
            "    set $var_numbox_l2_f1_b0 0\n"
            "\n"
            "    set numbox_type [_ \"numbox~\"]\n"
            "    set wdt_label [_ \"Width (digits):\"]\n"
            "    set hgt_label [_ \"Font Size:\"]\n"
            "    toplevel $mytoplevel -class DialogWindow\n"
            "    wm title $mytoplevel [format [_ \"%s properties\"] $numbox_type]\n"
            "    wm group $mytoplevel .\n"
            "    wm resizable $mytoplevel 0 0\n"
            "    wm transient $mytoplevel $::focused_window\n"
            "    $mytoplevel configure -menu $::dialog_menubar\n"
            "    $mytoplevel configure -padx 0 -pady 0\n"
            "    ::pd_bindings::dialog_bindings $mytoplevel \"numbox\"\n"
            "\n"
            "    # dimensions\n"
            "    frame $mytoplevel.dim -height 7\n"
            "    pack $mytoplevel.dim -side top\n"
            "    label $mytoplevel.dim.w_lab -text [_ $wdt_label]\n"
            "    entry $mytoplevel.dim.w_ent -textvariable $var_numbox_wdt -width 4\n"
            "    label $mytoplevel.dim.dummy1 -text \"\" -width 1\n"
            "    label $mytoplevel.dim.h_lab -text [_ $hgt_label]\n"
            "    entry $mytoplevel.dim.h_ent -textvariable $var_numbox_hgt -width 4\n"
            "    pack $mytoplevel.dim.w_lab $mytoplevel.dim.w_ent -side left\n"
            "    if { $hgt_label ne \"empty\" } {\n"
            "        pack $mytoplevel.dim.dummy1 $mytoplevel.dim.h_lab $mytoplevel.dim.h_ent -side left }\n"
            "\n"
            "    # range\n"
            "    labelframe $mytoplevel.rng\n"
            "    pack $mytoplevel.rng -side top -fill x\n"
            "    frame $mytoplevel.rng.min\n"
            "    label $mytoplevel.rng.min.lab -text \"Lower\"\n"
            "    entry $mytoplevel.rng.min.ent -textvariable $var_numbox_min_rng -width 7\n"
            "    label $mytoplevel.rng.dummy1 -text \"\" -width 1\n"
            "    label $mytoplevel.rng.max_lab -text \"Upper\"\n"
            "    entry $mytoplevel.rng.max_ent -textvariable $var_numbox_max_rng -width 7\n"
            "    $mytoplevel.rng config -borderwidth 1 -pady 4 -text \"Output Range\"\n"
     
            "    pack $mytoplevel.rng.min\n"
            "    pack $mytoplevel.rng.min.lab $mytoplevel.rng.min.ent -side left\n"
            "    $mytoplevel.rng config -padx 26\n"
            "    pack configure $mytoplevel.rng.min -side left\n"
            "    pack $mytoplevel.rng.dummy1 $mytoplevel.rng.max_lab $mytoplevel.rng.max_ent -side left\n"
            "\n"
            "    # parameters\n"
            "    labelframe $mytoplevel.para -borderwidth 1 -padx 5 -pady 5 -text [_ \"Parameters\"]\n"
            "    pack $mytoplevel.para -side top -fill x -pady 5\n"

            "   frame $mytoplevel.para.initial\n"
            "       label $mytoplevel.para.initial.lab -text [_ \"Load Value\"]\n"
            "       entry $mytoplevel.para.initial.ent -textvariable $var_numbox_initial -width 6\n"
            "       pack $mytoplevel.para.initial.ent $mytoplevel.para.initial.lab -side right -anchor e\n"
            "   frame $mytoplevel.para.interval\n"
            "       label $mytoplevel.para.interval.lab -text [_ \"Rate (ms)\"]\n"
            "       entry $mytoplevel.para.interval.ent -textvariable $var_numbox_interval -width 6\n"
            "       pack $mytoplevel.para.interval.ent $mytoplevel.para.interval.lab -side right -anchor e\n"
            "   frame $mytoplevel.para.ramp\n"
            "       label $mytoplevel.para.ramp.lab -text [_ \"Ramp (ms)\"]\n"
            "       entry $mytoplevel.para.ramp.ent -textvariable $var_numbox_ramp -width 6\n"
            "       pack $mytoplevel.para.ramp.ent $mytoplevel.para.ramp.lab -side right -anchor e\n"
            "       pack $mytoplevel.para.initial -side left -expand 1 -ipadx 10\n"
            "       pack $mytoplevel.para.interval -side left -expand 1 -ipadx 10\n"
            "       pack $mytoplevel.para.ramp -side left -expand 1 -ipadx 10\n"
            "    # get the current font name from the int given from C-space (gn_f)\n"
            "    set current_font $::font_family\n"
            "\n"
            "    # colors\n"
            "    labelframe $mytoplevel.colors -borderwidth 1 -text [_ \"Colors\"] -padx 5 -pady 5\n"
            "    pack $mytoplevel.colors -fill x\n"
            "\n"
            "    frame $mytoplevel.colors.select\n"
            "    pack $mytoplevel.colors.select -side top\n"
            "    radiobutton $mytoplevel.colors.select.radio0 -value 0 -variable \\\n"
            "        $var_numbox_l2_f1_b0 -text [_ \"Background\"] -justify left\n"
            "    radiobutton $mytoplevel.colors.select.radio1 -value 1 -variable \\\n"
            "        $var_numbox_l2_f1_b0 -text [_ \"Foreground\"] -justify left\n"
            "    radiobutton $mytoplevel.colors.select.radio2 -value 2 -variable \\\n"
            "        $var_numbox_l2_f1_b0 -text [_ \"Text\"] -justify left\n"
            "    if { [eval concat $$var_numbox_fcol] ne \"none\" } {\n"
            "        pack $mytoplevel.colors.select.radio0 $mytoplevel.colors.select.radio1 \\\n"
            "            -side left\n"
            "    } else {\n"
            "        pack $mytoplevel.colors.select.radio0 -side left\n"
            "    }\n"
            "\n"
            "    frame $mytoplevel.colors.sections\n"
            "    pack $mytoplevel.colors.sections -side top\n"
            "    button $mytoplevel.colors.sections.but -text [_ \"Compose color\"] \\\n"
            "        -command \"::dialog_numbox::choose_col_bkfrlb $mytoplevel\"\n"
            "    pack $mytoplevel.colors.sections.but -side left -anchor w -pady 5 \\\n"
            "        -expand yes -fill x\n"
            "    frame $mytoplevel.colors.sections.exp\n"
            "    pack $mytoplevel.colors.sections.exp -side right -padx 5\n"
            "    if { [eval concat $$var_numbox_fcol] ne \"none\" } {\n"
            "        label $mytoplevel.colors.sections.exp.fr_bk -text \"o=||=o\" -width 6 \\\n"
            "            -background [eval concat $$var_numbox_bcol] \\\n"
            "            -activebackground [eval concat $$var_numbox_bcol] \\\n"
            "            -foreground [eval concat $$var_numbox_fcol] \\\n"
            "            -activeforeground [eval concat $$var_numbox_fcol] \\\n"
            "            -font [list $current_font 14 $::font_weight] -padx 2 -pady 2 -relief ridge\n"
            "    } else {\n"
            "        label $mytoplevel.colors.sections.exp.fr_bk -text \"o=||=o\" -width 6 \\\n"
            "            -background [eval concat $$var_numbox_bcol] \\\n"
            "            -activebackground [eval concat $$var_numbox_bcol] \\\n"
            "            -foreground [eval concat $$var_numbox_bcol] \\\n"
            "            -activeforeground [eval concat $$var_numbox_bcol] \\\n"
            "            -font [list $current_font 14 $::font_weight] -padx 2 -pady 2 -relief ridge\n"
            "    }\n"
            "\n"
            "    # color scheme by Mary Ann Benedetto http://piR2.org\n"
            "    foreach r {r1 r2 r3} hexcols {\n"
            "       { \"#FFFFFF\" \"#DFDFDF\" \"#BBBBBB\" \"#FFC7C6\" \"#FFE3C6\" \"#FEFFC6\" \"#C6FFC7\" \"#C6FEFF\" \"#C7C6FF\" \"#E3C6FF\" }\n"
            "       { \"#9F9F9F\" \"#7C7C7C\" \"#606060\" \"#FF0400\" \"#FF8300\" \"#FAFF00\" \"#00FF04\" \"#00FAFF\" \"#0400FF\" \"#9C00FF\" }\n"
            "       { \"#404040\" \"#202020\" \"#000000\" \"#551312\" \"#553512\" \"#535512\" \"#0F4710\" \"#0E4345\" \"#131255\" \"#2F004D\" } } \\\n"
            "    {\n"
            "       frame $mytoplevel.colors.$r\n"
            "       pack $mytoplevel.colors.$r -side top\n"
            "       foreach i { 0 1 2 3 4 5 6 7 8 9} hexcol $hexcols \\\n"
            "           {\n"
            "               label $mytoplevel.colors.$r.c$i -background $hexcol -activebackground $hexcol -relief ridge -padx 7 -pady 0 -width 1\n"
            "               bind $mytoplevel.colors.$r.c$i <Button> \"::dialog_numbox::preset_col $mytoplevel $hexcol\"\n"
            "           }\n"
            "       pack $mytoplevel.colors.$r.c0 $mytoplevel.colors.$r.c1 $mytoplevel.colors.$r.c2 $mytoplevel.colors.$r.c3 \\\n"
            "           $mytoplevel.colors.$r.c4 $mytoplevel.colors.$r.c5 $mytoplevel.colors.$r.c6 $mytoplevel.colors.$r.c7 \\\n"
            "           $mytoplevel.colors.$r.c8 $mytoplevel.colors.$r.c9 -side left\n"
            "    }\n"
            "\n"
            "    # buttons\n"
            "    frame $mytoplevel.cao -pady 10\n"
            "    pack $mytoplevel.cao -side top\n"
            "    button $mytoplevel.cao.cancel -text [_ \"Cancel\"] \\\n"
            "        -command \"::dialog_numbox::cancel $mytoplevel\"\n"
            "    pack $mytoplevel.cao.cancel -side left -expand 1 -fill x -padx 15 -ipadx 10\n"
            "    if {$::windowingsystem ne \"aqua\"} {\n"
            "        button $mytoplevel.cao.apply -text [_ \"Apply\"] \\\n"
            "            -command \"::dialog_numbox::apply $mytoplevel\"\n"
            "        pack $mytoplevel.cao.apply -side left -expand 1 -fill x -padx 15 -ipadx 10\n"
            "    }\n"
            "    button $mytoplevel.cao.ok -text [_ \"OK\"] \\\n"
            "        -command \"::dialog_numbox::ok $mytoplevel\" -default active\n"
            "    pack $mytoplevel.cao.ok -side left -expand 1 -fill x -padx 15 -ipadx 10\n"
            "\n"
            "    $mytoplevel.dim.w_ent select from 0\n"
            "    $mytoplevel.dim.w_ent select adjust end\n"
            "    focus $mytoplevel.dim.w_ent\n"
            "\n"
            "    # live widget updates on OSX in lieu of Apply button\n"
            "    if {$::windowingsystem eq \"aqua\"} {\n"
            "\n"
            "        # call apply on Return in entry boxes that are in focus & rebind Return to ok button\n"
            "        bind $mytoplevel.dim.w_ent <KeyPress-Return> \"::dialog_numbox::apply_and_rebind_return $mytoplevel\"\n"
            "        bind $mytoplevel.dim.h_ent <KeyPress-Return>    \"::dialog_numbox::apply_and_rebind_return $mytoplevel\"\n"
            "\n"
            "        # unbind Return from ok button when an entry takes focus\n"
            "        $mytoplevel.dim.w_ent config -validate focusin -vcmd \"::dialog_numbox::unbind_return $mytoplevel\"\n"
            "        $mytoplevel.dim.h_ent config -validate focusin -vcmd  \"::dialog_numbox::unbind_return $mytoplevel\"\n"
            "\n"
            "        # remove cancel button from focus list since it's not activated on Return\n"
            "        $mytoplevel.cao.cancel config -takefocus 0\n"
            "\n"
            "        # show active focus on the ok button as it *is* activated on Return\n"
            "        $mytoplevel.cao.ok config -default normal\n"
            "        bind $mytoplevel.cao.ok <FocusIn> \"$mytoplevel.cao.ok config -default active\"\n"
            "        bind $mytoplevel.cao.ok <FocusOut> \"$mytoplevel.cao.ok config -default normal\"\n"
            "\n"
            "        # since we show the active focus, disable the highlight outline\n"
            "        $mytoplevel.cao.ok config -highlightthickness 0\n"
            "        $mytoplevel.cao.cancel config -highlightthickness 0\n"
            "    }\n"
            "\n"
            "    position_over_window $mytoplevel $::focused_window\n"
            "}\n"
            "\n"
            "# for live widget updates on OSX\n"
            "proc ::dialog_numbox::apply_and_rebind_return {mytoplevel} {\n"
            "    ::dialog_numbox::apply $mytoplevel\n"
            "    bind $mytoplevel <KeyPress-Return> \"::dialog_numbox::ok $mytoplevel\"\n"
            "    focus $mytoplevel.cao.ok\n"
            "    return 0\n"
            "}\n"
            "\n"
            "# for live widget updates on OSX\n"
            "proc ::dialog_numbox::unbind_return {mytoplevel} {\n"
            "    bind $mytoplevel <KeyPress-Return> break\n"
            "    return 1\n"
            "}\n");
