#! /bin/bash
# generated by collect_git_remote_add_recursively.sh

pushd $(dirname $0)                                                             2> /dev/null   > /dev/null
cd ..

mode="d"

getopts ":fqh" opt
#echo opt+arg = "$opt$OPTARG"
case "$opt$OPTARG" in
f )
  echo "--- check out master/HEAD before registering all git remotes ---"
  for (( i=OPTIND; i > 1; i-- )) do
    shift
  done
  #echo args: $@
  mode="f"

  git submodule sync
  git submodule update --init
  git submodule update --init --recursive

  tools/git_checkout_submodules_head.sh
  ;;

"?" )
  echo "--- set up git remotes only ---"
  ;;

q )
  echo "--- set up git remotes only ---"
  for (( i=OPTIND; i > 1; i-- )) do
    shift
  done
  #echo args: $@
  mode="q"
  ;;

* )
  cat <<EOT
$0 [-f] [-q] [submodule-paths]

set up git remotes for any / all submodules.

-f       : 'full featured', i.e. check out the preferred branch for each submodule
           and register all submodule remotes.
-q       : 'quick', i.e. only register all submodule remotes.
submodule-paths
         : when you specify one or more submodule directories, than only the
           remotes for those submodules will be set up.
           This is optional; the default sets up the remotes for ALL submodules.

EOT
  exit
  ;;
esac


submodule=xxxxxx

# args: (path, name, repo, argc, argv...)
function register_remote {
    argc=$#
    argv=("$@")
    path=$1
    name=$2
    repo=$3
    #echo register_remote [$path] [$name] [$repo] [$argc] [...]

    # only when paths have been specified on the commandline do we check whether the given remote should be registered
    # (apart from the separate check to see if the submodule has actually been installed, see further below)
    if test $argc -gt 4 ; then
        hit=0
        for ((i=4; i < $argc; i++)); do
            #echo testing dir $i: ${argv[$i]}
            if test ${argv[$i]} = $path ; then
                hit=1
                break
            fi
        done
    else
        hit=1
    fi

    if test $hit -ne 0 ; then
        if test -d $path && test -s $path/.git ; then
            if test $submodule != $path ; then
                echo -------------------------------------------------------------------------------------
                echo submodule:: $path
                submodule=$path
            fi
            pushd $path                                                         2> /dev/null   > /dev/null
            if test "$mode" = "f" ; then
                git remote rm $name
            fi
            git remote add $name $repo
            popd                                                                2> /dev/null   > /dev/null
        fi
    fi
}






register_remote .                                                             BlazesRus                                git@github.com:BlazesRus/pthread-win32.git                                       $# $@
register_remote .                                                             BrianGladman                             git@github.com:BrianGladman/pthreads.git                                         $# $@
register_remote .                                                             Cinegy                                   git@github.com:Cinegy/pthread-win32.git                                          $# $@
register_remote .                                                             DeckerSU                                 git@github.com:DeckerSU/pthread-win32.git                                        $# $@
register_remote .                                                             DrIxionerr                               git@github.com:DrIxionerr/pthreads.git                                           $# $@
register_remote .                                                             GerHobbelt                               git@github.com:GerHobbelt/pthread-win32.git                                      $# $@
register_remote .                                                             GerHobbelt-original                      git@github.com:GerHobbelt/pthread-win32.git                                      $# $@
register_remote .                                                             Puasonych                                git@github.com:Puasonych/pthread-win32.git                                       $# $@
register_remote .                                                             Sav0966                                  git@github.com:Sav0966/pthreads.git                                              $# $@
register_remote .                                                             UltraCombos                              git@github.com:UltraCombos/pthread-win32.git                                     $# $@
register_remote .                                                             bscottm                                  git@github.com:bscottm/pthreads4w.git                                            $# $@
register_remote .                                                             coapp-packages                           git@github.com:coapp-packages/pthreads.git                                       $# $@
register_remote .                                                             cpp-pm                                   git@github.com:cpp-pm/pthreads-win32.git                                         $# $@
register_remote .                                                             gajgeospatial                            git@github.com:gajgeospatial/pthreads-3.0.0.git                                  $# $@
register_remote .                                                             guyfrancoeur                             git@github.com:guyfrancoeur/pthreads-win32.git                                   $# $@
register_remote .                                                             h2obrain                                 git@github.com:h2obrain/pthread-win32.git                                        $# $@
register_remote .                                                             jschmidlapp                              git@github.com:jschmidlapp/pthreads-emb.git                                      $# $@
register_remote .                                                             jwinarske                                git@github.com:jwinarske/pthreads4w.git                                          $# $@
register_remote .                                                             martell                                  git@github.com:martell/pthreads-win32.git                                        $# $@
register_remote .                                                             neurolabusc                              git@github.com:neurolabusc/pthreads4w.git                                        $# $@
register_remote .                                                             nmoinvaz                                 git@github.com:nmoinvaz/pthreads4w.git                                           $# $@
register_remote .                                                             oktonion                                 git@github.com:oktonion/pthread-win32.git                                        $# $@
register_remote .                                                             redox-os                                 git@github.com:redox-os/pthreads-emb.git                                         $# $@
register_remote .                                                             rs0h                                     git@github.com:rs0h/pthread-win32.git                                            $# $@
register_remote .                                                             sourceforge                              https://git.code.sf.net/p/pthreads4w/code                                        $# $@
register_remote .                                                             tinkugadu                                git@github.com:tinkugadu/pthreads.git                                            $# $@
register_remote .                                                             tmagomedov                               git@github.com:tmagomedov/pthreads-win32.git                                     $# $@
register_remote .                                                             tpruvot                                  git@github.com:tpruvot/pthreads.git                                              $# $@
register_remote .                                                             uudiin                                   git@github.com:uudiin/pthreads-w32.git                                           $# $@
register_remote .                                                             vancegroup-mirrors                       git@github.com:vancegroup-mirrors/pthreads-win32.git                             $# $@



popd                                                                            2> /dev/null   > /dev/null

