--------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2021-present Ondrej Ille
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
-- -------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2015-2020 MIT License
-- 
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
-- 
-- Project advisors: 
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
-- 
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Register map implementation of: Control_registers
--------------------------------------------------------------------------------
-- This file is autogenerated, DO NOT EDIT!

Library ieee;
use ieee.std_logic_1164.all;

Library ctu_can_fd_rtl;
use ctu_can_fd_rtl.can_registers_pkg.all;
use ctu_can_fd_rtl.cmn_reg_map_pkg.all;

entity control_registers_reg_map is
generic (
    constant DATA_WIDTH          : natural := 32;
    constant ADDRESS_WIDTH       : natural := 8;
    constant REGISTERED_READ     : boolean := true;
    constant CLEAR_READ_DATA     : boolean := true;
    constant SUP_FILT_A          : boolean := true;
    constant SUP_TRAFFIC_CTRS    : boolean := true;
    constant SUP_RANGE           : boolean := true;
    constant SUP_FILT_C          : boolean := true;
    constant SUP_FILT_B          : boolean := true
);
port (
    signal clk_sys               :in std_logic;
    signal res_n                 :in std_logic;
    signal address               :in std_logic_vector(address_width - 1 downto 0);
    signal w_data                :in std_logic_vector(data_width - 1 downto 0);
    signal r_data                :out std_logic_vector(data_width - 1 downto 0);
    signal cs                    :in std_logic;
    signal read                  :in std_logic;
    signal write                 :in std_logic;
    signal be                    :in std_logic_vector(data_width / 8 - 1 downto 0);
    signal lock_1                :in std_logic;
    signal lock_2                :in std_logic;
    signal control_registers_out :out Control_registers_out_t;
    signal control_registers_in  :in Control_registers_in_t
);
end entity control_registers_reg_map;


architecture rtl of control_registers_reg_map is
  signal reg_sel : std_logic_vector(38 downto 0);
  constant ADDR_VECT
                 : std_logic_vector(233 downto 0) := "100110100101100100100011100010100001100000011111011110011101011100011011011010011001011000010111010110010101010100010011010010010001010000001111001110001101001100001011001010001001001000000111000110000101000100000011000010000001000000";
  signal read_data_mux_in : std_logic_vector(1247 downto 0);
  signal read_data_mask_n : std_logic_vector(31 downto 0);
  signal control_registers_out_i : Control_registers_out_t;
  signal write_en : std_logic_vector(3 downto 0);
begin

    write_en <= be when (write = '1' and cs = '1') else (others => '0');

    ----------------------------------------------------------------------------
    -- Write address to One-hot decoder
    ----------------------------------------------------------------------------

    address_decoder_control_registers_comp : address_decoder
    generic map(
        address_width                   => 6 ,
        address_entries                 => 39 ,
        addr_vect                       => ADDR_VECT ,
        registered_out                  => false 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        address                         => address(7 downto 2) ,-- in
        enable                          => cs ,-- in
        addr_dec                        => reg_sel -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[RST]
    ----------------------------------------------------------------------------

    mode_rst_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(0 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_rst -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[BMM]
    ----------------------------------------------------------------------------

    mode_bmm_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(1 downto 1) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_bmm -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[STM]
    ----------------------------------------------------------------------------

    mode_stm_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(2 downto 2) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_stm -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[AFM]
    ----------------------------------------------------------------------------

    mode_afm_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(3 downto 3) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_afm -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[FDE]
    ----------------------------------------------------------------------------

    mode_fde_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(4 downto 4) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_fde -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[TTTM]
    ----------------------------------------------------------------------------

    mode_tttm_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(5 downto 5) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_tttm -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[ROM]
    ----------------------------------------------------------------------------

    mode_rom_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(6 downto 6) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_rom -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[ACF]
    ----------------------------------------------------------------------------

    mode_acf_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 7) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_acf -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[TSTM]
    ----------------------------------------------------------------------------

    mode_tstm_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(8 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_tstm -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[RXBAM]
    ----------------------------------------------------------------------------

    mode_rxbam_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(9 downto 9) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_rxbam -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[TXBBM]
    ----------------------------------------------------------------------------

    mode_txbbm_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(10 downto 10) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_txbbm -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[SAM]
    ----------------------------------------------------------------------------

    mode_sam_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 11) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_sam -- out
    );

    ----------------------------------------------------------------------------
    -- MODE[ERFM]
    ----------------------------------------------------------------------------

    mode_erfm_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(12 downto 12) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.mode_erfm -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[RTRLE]
    ----------------------------------------------------------------------------

    settings_rtrle_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(16 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_rtrle -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[RTRTH]
    ----------------------------------------------------------------------------

    settings_rtrth_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 4 ,
        reset_value                     => "0000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(20 downto 17) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value                       => control_registers_out_i.settings_rtrth -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[ILBP]
    ----------------------------------------------------------------------------

    settings_ilbp_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(21 downto 21) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_ilbp -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[ENA]
    ----------------------------------------------------------------------------

    settings_ena_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(22 downto 22) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_ena -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[NISOFD]
    ----------------------------------------------------------------------------

    settings_nisofd_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 23) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_nisofd -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[PEX]
    ----------------------------------------------------------------------------

    settings_pex_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(24 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_pex -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[TBFBO]
    ----------------------------------------------------------------------------

    settings_tbfbo_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(25 downto 25) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_tbfbo -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[FDRF]
    ----------------------------------------------------------------------------

    settings_fdrf_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(26 downto 26) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_fdrf -- out
    );

    ----------------------------------------------------------------------------
    -- SETTINGS[PCHKE]
    ----------------------------------------------------------------------------

    settings_pchke_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(27 downto 27) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(1) ,-- in
        reg_value(0)                    => control_registers_out_i.settings_pchke -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[RXRPMV]
    ----------------------------------------------------------------------------

    command_rxrpmv_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(1 downto 1) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_rxrpmv -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[RRB]
    ----------------------------------------------------------------------------

    command_rrb_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(2 downto 2) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_rrb -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[CDO]
    ----------------------------------------------------------------------------

    command_cdo_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(3 downto 3) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_cdo -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[ERCRST]
    ----------------------------------------------------------------------------

    command_ercrst_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(4 downto 4) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_ercrst -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[RXFCRST]
    ----------------------------------------------------------------------------

    command_rxfcrst_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(5 downto 5) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_rxfcrst -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[TXFCRST]
    ----------------------------------------------------------------------------

    command_txfcrst_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(6 downto 6) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_txfcrst -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[CPEXS]
    ----------------------------------------------------------------------------

    command_cpexs_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 7) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_cpexs -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[CRXPE]
    ----------------------------------------------------------------------------

    command_crxpe_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(8 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_crxpe -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[CTXPE]
    ----------------------------------------------------------------------------

    command_ctxpe_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(9 downto 9) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_ctxpe -- out
    );

    ----------------------------------------------------------------------------
    -- COMMAND[CTXDPE]
    ----------------------------------------------------------------------------

    command_ctxdpe_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(10 downto 10) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(3) ,-- in
        reg_value(0)                    => control_registers_out_i.command_ctxdpe -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[RXI]
    ----------------------------------------------------------------------------

    int_stat_rxi_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(0 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_rxi -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[TXI]
    ----------------------------------------------------------------------------

    int_stat_txi_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(1 downto 1) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_txi -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[EWLI]
    ----------------------------------------------------------------------------

    int_stat_ewli_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(2 downto 2) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_ewli -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[DOI]
    ----------------------------------------------------------------------------

    int_stat_doi_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(3 downto 3) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_doi -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[FCSI]
    ----------------------------------------------------------------------------

    int_stat_fcsi_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(4 downto 4) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_fcsi -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[ALI]
    ----------------------------------------------------------------------------

    int_stat_ali_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(5 downto 5) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_ali -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[BEI]
    ----------------------------------------------------------------------------

    int_stat_bei_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(6 downto 6) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_bei -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[OFI]
    ----------------------------------------------------------------------------

    int_stat_ofi_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 7) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_ofi -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[RXFI]
    ----------------------------------------------------------------------------

    int_stat_rxfi_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(8 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_rxfi -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[BSI]
    ----------------------------------------------------------------------------

    int_stat_bsi_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(9 downto 9) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_bsi -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[RBNEI]
    ----------------------------------------------------------------------------

    int_stat_rbnei_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(10 downto 10) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_rbnei -- out
    );

    ----------------------------------------------------------------------------
    -- INT_STAT[TXBHCI]
    ----------------------------------------------------------------------------

    int_stat_txbhci_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 11) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(4) ,-- in
        reg_value(0)                    => control_registers_out_i.int_stat_txbhci -- out
    );

    ----------------------------------------------------------------------------
    -- INT_ENA_SET[INT_ENA_SET_SLICE_1]
    ----------------------------------------------------------------------------

    int_ena_set_int_ena_set_slice_1_reg_comp : memory_reg_os
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(5) ,-- in
        reg_value                       => control_registers_out_i.int_ena_set_int_ena_set(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- INT_ENA_SET[INT_ENA_SET_SLICE_2]
    ----------------------------------------------------------------------------

    int_ena_set_int_ena_set_slice_2_reg_comp : memory_reg_os
    generic map(
        data_width                      => 4 ,
        reset_value                     => "0000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(5) ,-- in
        reg_value                       => control_registers_out_i.int_ena_set_int_ena_set(11 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- INT_ENA_CLR[INT_ENA_CLR_SLICE_1]
    ----------------------------------------------------------------------------

    int_ena_clr_int_ena_clr_slice_1_reg_comp : memory_reg_os
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(6) ,-- in
        reg_value                       => control_registers_out_i.int_ena_clr_int_ena_clr(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- INT_ENA_CLR[INT_ENA_CLR_SLICE_2]
    ----------------------------------------------------------------------------

    int_ena_clr_int_ena_clr_slice_2_reg_comp : memory_reg_os
    generic map(
        data_width                      => 4 ,
        reset_value                     => "0000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(6) ,-- in
        reg_value                       => control_registers_out_i.int_ena_clr_int_ena_clr(11 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- INT_MASK_SET[INT_MASK_SET_SLICE_1]
    ----------------------------------------------------------------------------

    int_mask_set_int_mask_set_slice_1_reg_comp : memory_reg_os
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(7) ,-- in
        reg_value                       => control_registers_out_i.int_mask_set_int_mask_set(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- INT_MASK_SET[INT_MASK_SET_SLICE_2]
    ----------------------------------------------------------------------------

    int_mask_set_int_mask_set_slice_2_reg_comp : memory_reg_os
    generic map(
        data_width                      => 4 ,
        reset_value                     => "0000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(7) ,-- in
        reg_value                       => control_registers_out_i.int_mask_set_int_mask_set(11 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- INT_MASK_CLR[INT_MASK_CLR_SLICE_1]
    ----------------------------------------------------------------------------

    int_mask_clr_int_mask_clr_slice_1_reg_comp : memory_reg_os
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(8) ,-- in
        reg_value                       => control_registers_out_i.int_mask_clr_int_mask_clr(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- INT_MASK_CLR[INT_MASK_CLR_SLICE_2]
    ----------------------------------------------------------------------------

    int_mask_clr_int_mask_clr_slice_2_reg_comp : memory_reg_os
    generic map(
        data_width                      => 4 ,
        reset_value                     => "0000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(8) ,-- in
        reg_value                       => control_registers_out_i.int_mask_clr_int_mask_clr(11 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[PROP]
    ----------------------------------------------------------------------------

    btr_prop_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 7 ,
        reset_value                     => "0000101" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(6 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_prop -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[PH1_SLICE_1]
    ----------------------------------------------------------------------------

    btr_ph1_slice_1_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 7) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value(0)                    => control_registers_out_i.btr_ph1(0) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[PH1_SLICE_2]
    ----------------------------------------------------------------------------

    btr_ph1_slice_2_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00001" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(12 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_ph1(5 downto 1) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[PH2_SLICE_1]
    ----------------------------------------------------------------------------

    btr_ph2_slice_1_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 3 ,
        reset_value                     => "101" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 13) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_ph2(2 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[PH2_SLICE_2]
    ----------------------------------------------------------------------------

    btr_ph2_slice_2_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(18 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_ph2(5 downto 3) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[BRP_SLICE_1]
    ----------------------------------------------------------------------------

    btr_brp_slice_1_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 5 ,
        reset_value                     => "01010" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 19) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_brp(4 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[BRP_SLICE_2]
    ----------------------------------------------------------------------------

    btr_brp_slice_2_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(26 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_brp(7 downto 5) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR[SJW]
    ----------------------------------------------------------------------------

    btr_sjw_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00010" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 27) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(9) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_sjw -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[PROP_FD]
    ----------------------------------------------------------------------------

    btr_fd_prop_fd_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 6 ,
        reset_value                     => "000011" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(5 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd_prop_fd -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[PH1_FD_SLICE_1]
    ----------------------------------------------------------------------------

    btr_fd_ph1_fd_slice_1_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 7) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value(0)                    => control_registers_out_i.btr_fd_ph1_fd(0) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[PH1_FD_SLICE_2]
    ----------------------------------------------------------------------------

    btr_fd_ph1_fd_slice_2_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 4 ,
        reset_value                     => "0001" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd_ph1_fd(4 downto 1) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[PH2_FD_SLICE_1]
    ----------------------------------------------------------------------------

    btr_fd_ph2_fd_slice_1_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 3 ,
        reset_value                     => "011" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 13) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd_ph2_fd(2 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[PH2_FD_SLICE_2]
    ----------------------------------------------------------------------------

    btr_fd_ph2_fd_slice_2_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 2 ,
        reset_value                     => "00" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(17 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd_ph2_fd(4 downto 3) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[BRP_FD_SLICE_1]
    ----------------------------------------------------------------------------

    btr_fd_brp_fd_slice_1_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00100" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 19) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd_brp_fd(4 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[BRP_FD_SLICE_2]
    ----------------------------------------------------------------------------

    btr_fd_brp_fd_slice_2_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(26 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd_brp_fd(7 downto 5) -- out
    );

    ----------------------------------------------------------------------------
    -- BTR_FD[SJW_FD]
    ----------------------------------------------------------------------------

    btr_fd_sjw_fd_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00010" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(31 downto 27) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(10) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.btr_fd_sjw_fd -- out
    );

    ----------------------------------------------------------------------------
    -- EWL[EW_LIMIT]
    ----------------------------------------------------------------------------

    ewl_ew_limit_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 8 ,
        reset_value                     => "01100000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(11) ,-- in
        lock                            => lock_1 ,-- in
        reg_value                       => control_registers_out_i.ewl_ew_limit -- out
    );

    ----------------------------------------------------------------------------
    -- ERP[ERP_LIMIT]
    ----------------------------------------------------------------------------

    erp_erp_limit_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 8 ,
        reset_value                     => "10000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(11) ,-- in
        lock                            => lock_1 ,-- in
        reg_value                       => control_registers_out_i.erp_erp_limit -- out
    );

    ----------------------------------------------------------------------------
    -- CTR_PRES[CTPV_SLICE_1]
    ----------------------------------------------------------------------------

    ctr_pres_ctpv_slice_1_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(14) ,-- in
        lock                            => lock_1 ,-- in
        reg_value                       => control_registers_out_i.ctr_pres_ctpv(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- CTR_PRES[CTPV_SLICE_2]
    ----------------------------------------------------------------------------

    ctr_pres_ctpv_slice_2_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(8 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(14) ,-- in
        lock                            => lock_1 ,-- in
        reg_value(0)                    => control_registers_out_i.ctr_pres_ctpv(8) -- out
    );

    ----------------------------------------------------------------------------
    -- CTR_PRES[PTX]
    ----------------------------------------------------------------------------

    ctr_pres_ptx_reg_comp : memory_reg_os_lock
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(9 downto 9) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(14) ,-- in
        lock                            => lock_1 ,-- in
        reg_value(0)                    => control_registers_out_i.ctr_pres_ptx -- out
    );

    ----------------------------------------------------------------------------
    -- CTR_PRES[PRX]
    ----------------------------------------------------------------------------

    ctr_pres_prx_reg_comp : memory_reg_os_lock
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(10 downto 10) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(14) ,-- in
        lock                            => lock_1 ,-- in
        reg_value(0)                    => control_registers_out_i.ctr_pres_prx -- out
    );

    ----------------------------------------------------------------------------
    -- CTR_PRES[ENORM]
    ----------------------------------------------------------------------------

    ctr_pres_enorm_reg_comp : memory_reg_os_lock
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 11) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(14) ,-- in
        lock                            => lock_1 ,-- in
        reg_value(0)                    => control_registers_out_i.ctr_pres_enorm -- out
    );

    ----------------------------------------------------------------------------
    -- CTR_PRES[EFD]
    ----------------------------------------------------------------------------

    ctr_pres_efd_reg_comp : memory_reg_os_lock
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(12 downto 12) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(14) ,-- in
        lock                            => lock_1 ,-- in
        reg_value(0)                    => control_registers_out_i.ctr_pres_efd -- out
    );

    FILTER_A_MASK_present_gen_t : if (SUP_FILT_A = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_A_MASK[BIT_MASK_A_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_a_mask_bit_mask_a_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(15) ,-- in
        reg_value                       => control_registers_out_i.filter_a_mask_bit_mask_a_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_A_MASK[BIT_MASK_A_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_a_mask_bit_mask_a_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(15) ,-- in
        reg_value                       => control_registers_out_i.filter_a_mask_bit_mask_a_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_A_MASK[BIT_MASK_A_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_a_mask_bit_mask_a_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(15) ,-- in
        reg_value                       => control_registers_out_i.filter_a_mask_bit_mask_a_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_A_MASK[BIT_MASK_A_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_a_mask_bit_mask_a_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(15) ,-- in
        reg_value                       => control_registers_out_i.filter_a_mask_bit_mask_a_val(28 downto 24) -- out
    );

    end generate FILTER_A_MASK_present_gen_t;

    FILTER_A_MASK_present_gen_f : if (SUP_FILT_A = false) generate
        control_registers_out_i.filter_a_mask_bit_mask_a_val <= (others => '0');
    end generate FILTER_A_MASK_present_gen_f;

    FILTER_A_VAL_present_gen_t : if (SUP_FILT_A = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_A_VAL[BIT_VAL_A_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_a_val_bit_val_a_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(16) ,-- in
        reg_value                       => control_registers_out_i.filter_a_val_bit_val_a_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_A_VAL[BIT_VAL_A_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_a_val_bit_val_a_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(16) ,-- in
        reg_value                       => control_registers_out_i.filter_a_val_bit_val_a_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_A_VAL[BIT_VAL_A_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_a_val_bit_val_a_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(16) ,-- in
        reg_value                       => control_registers_out_i.filter_a_val_bit_val_a_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_A_VAL[BIT_VAL_A_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_a_val_bit_val_a_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(16) ,-- in
        reg_value                       => control_registers_out_i.filter_a_val_bit_val_a_val(28 downto 24) -- out
    );

    end generate FILTER_A_VAL_present_gen_t;

    FILTER_A_VAL_present_gen_f : if (SUP_FILT_A = false) generate
        control_registers_out_i.filter_a_val_bit_val_a_val <= (others => '0');
    end generate FILTER_A_VAL_present_gen_f;

    FILTER_B_MASK_present_gen_t : if (SUP_FILT_B = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_B_MASK[BIT_MASK_B_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_b_mask_bit_mask_b_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(17) ,-- in
        reg_value                       => control_registers_out_i.filter_b_mask_bit_mask_b_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_B_MASK[BIT_MASK_B_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_b_mask_bit_mask_b_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(17) ,-- in
        reg_value                       => control_registers_out_i.filter_b_mask_bit_mask_b_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_B_MASK[BIT_MASK_B_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_b_mask_bit_mask_b_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(17) ,-- in
        reg_value                       => control_registers_out_i.filter_b_mask_bit_mask_b_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_B_MASK[BIT_MASK_B_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_b_mask_bit_mask_b_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(17) ,-- in
        reg_value                       => control_registers_out_i.filter_b_mask_bit_mask_b_val(28 downto 24) -- out
    );

    end generate FILTER_B_MASK_present_gen_t;

    FILTER_B_MASK_present_gen_f : if (SUP_FILT_B = false) generate
        control_registers_out_i.filter_b_mask_bit_mask_b_val <= (others => '0');
    end generate FILTER_B_MASK_present_gen_f;

    FILTER_B_VAL_present_gen_t : if (SUP_FILT_B = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_B_VAL[BIT_VAL_B_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_b_val_bit_val_b_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(18) ,-- in
        reg_value                       => control_registers_out_i.filter_b_val_bit_val_b_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_B_VAL[BIT_VAL_B_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_b_val_bit_val_b_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(18) ,-- in
        reg_value                       => control_registers_out_i.filter_b_val_bit_val_b_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_B_VAL[BIT_VAL_B_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_b_val_bit_val_b_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(18) ,-- in
        reg_value                       => control_registers_out_i.filter_b_val_bit_val_b_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_B_VAL[BIT_VAL_B_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_b_val_bit_val_b_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(18) ,-- in
        reg_value                       => control_registers_out_i.filter_b_val_bit_val_b_val(28 downto 24) -- out
    );

    end generate FILTER_B_VAL_present_gen_t;

    FILTER_B_VAL_present_gen_f : if (SUP_FILT_B = false) generate
        control_registers_out_i.filter_b_val_bit_val_b_val <= (others => '0');
    end generate FILTER_B_VAL_present_gen_f;

    FILTER_C_MASK_present_gen_t : if (SUP_FILT_C = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_C_MASK[BIT_MASK_C_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_c_mask_bit_mask_c_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(19) ,-- in
        reg_value                       => control_registers_out_i.filter_c_mask_bit_mask_c_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_C_MASK[BIT_MASK_C_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_c_mask_bit_mask_c_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(19) ,-- in
        reg_value                       => control_registers_out_i.filter_c_mask_bit_mask_c_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_C_MASK[BIT_MASK_C_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_c_mask_bit_mask_c_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(19) ,-- in
        reg_value                       => control_registers_out_i.filter_c_mask_bit_mask_c_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_C_MASK[BIT_MASK_C_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_c_mask_bit_mask_c_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(19) ,-- in
        reg_value                       => control_registers_out_i.filter_c_mask_bit_mask_c_val(28 downto 24) -- out
    );

    end generate FILTER_C_MASK_present_gen_t;

    FILTER_C_MASK_present_gen_f : if (SUP_FILT_C = false) generate
        control_registers_out_i.filter_c_mask_bit_mask_c_val <= (others => '0');
    end generate FILTER_C_MASK_present_gen_f;

    FILTER_C_VAL_present_gen_t : if (SUP_FILT_C = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_C_VAL[BIT_VAL_C_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_c_val_bit_val_c_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(20) ,-- in
        reg_value                       => control_registers_out_i.filter_c_val_bit_val_c_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_C_VAL[BIT_VAL_C_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_c_val_bit_val_c_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(20) ,-- in
        reg_value                       => control_registers_out_i.filter_c_val_bit_val_c_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_C_VAL[BIT_VAL_C_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_c_val_bit_val_c_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(20) ,-- in
        reg_value                       => control_registers_out_i.filter_c_val_bit_val_c_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_C_VAL[BIT_VAL_C_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_c_val_bit_val_c_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(20) ,-- in
        reg_value                       => control_registers_out_i.filter_c_val_bit_val_c_val(28 downto 24) -- out
    );

    end generate FILTER_C_VAL_present_gen_t;

    FILTER_C_VAL_present_gen_f : if (SUP_FILT_C = false) generate
        control_registers_out_i.filter_c_val_bit_val_c_val <= (others => '0');
    end generate FILTER_C_VAL_present_gen_f;

    FILTER_RAN_LOW_present_gen_t : if (SUP_RANGE = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_RAN_LOW[BIT_RAN_LOW_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_ran_low_bit_ran_low_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(21) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_low_bit_ran_low_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_RAN_LOW[BIT_RAN_LOW_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_ran_low_bit_ran_low_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(21) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_low_bit_ran_low_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_RAN_LOW[BIT_RAN_LOW_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_ran_low_bit_ran_low_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(21) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_low_bit_ran_low_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_RAN_LOW[BIT_RAN_LOW_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_ran_low_bit_ran_low_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(21) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_low_bit_ran_low_val(28 downto 24) -- out
    );

    end generate FILTER_RAN_LOW_present_gen_t;

    FILTER_RAN_LOW_present_gen_f : if (SUP_RANGE = false) generate
        control_registers_out_i.filter_ran_low_bit_ran_low_val <= (others => '0');
    end generate FILTER_RAN_LOW_present_gen_f;

    FILTER_RAN_HIGH_present_gen_t : if (SUP_RANGE = true) generate
    ----------------------------------------------------------------------------
    -- FILTER_RAN_HIGH[BIT_RAN_HIGH_VAL_SLICE_1]
    ----------------------------------------------------------------------------

    filter_ran_high_bit_ran_high_val_slice_1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(22) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_high_bit_ran_high_val(7 downto 0) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_RAN_HIGH[BIT_RAN_HIGH_VAL_SLICE_2]
    ----------------------------------------------------------------------------

    filter_ran_high_bit_ran_high_val_slice_2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(22) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_high_bit_ran_high_val(15 downto 8) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_RAN_HIGH[BIT_RAN_HIGH_VAL_SLICE_3]
    ----------------------------------------------------------------------------

    filter_ran_high_bit_ran_high_val_slice_3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00000000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(22) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_high_bit_ran_high_val(23 downto 16) -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_RAN_HIGH[BIT_RAN_HIGH_VAL_SLICE_4]
    ----------------------------------------------------------------------------

    filter_ran_high_bit_ran_high_val_slice_4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 5 ,
        reset_value                     => "00000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(28 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(22) ,-- in
        reg_value                       => control_registers_out_i.filter_ran_high_bit_ran_high_val(28 downto 24) -- out
    );

    end generate FILTER_RAN_HIGH_present_gen_t;

    FILTER_RAN_HIGH_present_gen_f : if (SUP_RANGE = false) generate
        control_registers_out_i.filter_ran_high_bit_ran_high_val <= (others => '0');
    end generate FILTER_RAN_HIGH_present_gen_f;

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FANB]
    ----------------------------------------------------------------------------

    filter_control_fanb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(0 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fanb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FANE]
    ----------------------------------------------------------------------------

    filter_control_fane_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(1 downto 1) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fane -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FAFB]
    ----------------------------------------------------------------------------

    filter_control_fafb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(2 downto 2) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fafb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FAFE]
    ----------------------------------------------------------------------------

    filter_control_fafe_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "1" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(3 downto 3) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fafe -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FBNB]
    ----------------------------------------------------------------------------

    filter_control_fbnb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(4 downto 4) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fbnb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FBNE]
    ----------------------------------------------------------------------------

    filter_control_fbne_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(5 downto 5) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fbne -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FBFB]
    ----------------------------------------------------------------------------

    filter_control_fbfb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(6 downto 6) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fbfb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FBFE]
    ----------------------------------------------------------------------------

    filter_control_fbfe_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(7 downto 7) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fbfe -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FCNB]
    ----------------------------------------------------------------------------

    filter_control_fcnb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(8 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fcnb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FCNE]
    ----------------------------------------------------------------------------

    filter_control_fcne_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(9 downto 9) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fcne -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FCFB]
    ----------------------------------------------------------------------------

    filter_control_fcfb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(10 downto 10) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fcfb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FCFE]
    ----------------------------------------------------------------------------

    filter_control_fcfe_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 11) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_fcfe -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FRNB]
    ----------------------------------------------------------------------------

    filter_control_frnb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(12 downto 12) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_frnb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FRNE]
    ----------------------------------------------------------------------------

    filter_control_frne_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(13 downto 13) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_frne -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FRFB]
    ----------------------------------------------------------------------------

    filter_control_frfb_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(14 downto 14) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_frfb -- out
    );

    ----------------------------------------------------------------------------
    -- FILTER_CONTROL[FRFE]
    ----------------------------------------------------------------------------

    filter_control_frfe_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 15) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(23) ,-- in
        reg_value(0)                    => control_registers_out_i.filter_control_frfe -- out
    );

    ----------------------------------------------------------------------------
    -- RX_SETTINGS[RTSOP]
    ----------------------------------------------------------------------------

    rx_settings_rtsop_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(16 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(26) ,-- in
        reg_value(0)                    => control_registers_out_i.rx_settings_rtsop -- out
    );

    ----------------------------------------------------------------------------
    -- RX_DATA access signallization
    ----------------------------------------------------------------------------

    rx_data_access_signaller_comp : access_signaller
    generic map(
        data_width                      => 32 ,
        read_signalling                 => True ,
        write_signalling                => False ,
        read_signalling_reg             => False ,
        write_signalling_reg            => False 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        cs                              => reg_sel(27) ,-- in
        read                            => read ,-- in
        write                           => write ,-- in
        be                              => be(3 downto 0) ,-- in
        write_signal                    => open ,-- out
        read_signal                     => control_registers_out_i.rx_data_read -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXCE]
    ----------------------------------------------------------------------------

    tx_command_txce_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(0 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txce -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXCR]
    ----------------------------------------------------------------------------

    tx_command_txcr_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(1 downto 1) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txcr -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXCA]
    ----------------------------------------------------------------------------

    tx_command_txca_reg_comp : memory_reg_os
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(2 downto 2) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txca -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB1]
    ----------------------------------------------------------------------------

    tx_command_txb1_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(8 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb1 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB2]
    ----------------------------------------------------------------------------

    tx_command_txb2_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(9 downto 9) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb2 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB3]
    ----------------------------------------------------------------------------

    tx_command_txb3_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(10 downto 10) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb3 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB4]
    ----------------------------------------------------------------------------

    tx_command_txb4_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(11 downto 11) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb4 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB5]
    ----------------------------------------------------------------------------

    tx_command_txb5_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(12 downto 12) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb5 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB6]
    ----------------------------------------------------------------------------

    tx_command_txb6_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(13 downto 13) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb6 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB7]
    ----------------------------------------------------------------------------

    tx_command_txb7_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(14 downto 14) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb7 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_COMMAND[TXB8]
    ----------------------------------------------------------------------------

    tx_command_txb8_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 1 ,
        reset_value                     => "0" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(15 downto 15) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(29) ,-- in
        reg_value(0)                    => control_registers_out_i.tx_command_txb8 -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT1P]
    ----------------------------------------------------------------------------

    tx_priority_txt1p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "001" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(2 downto 0) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt1p -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT2P]
    ----------------------------------------------------------------------------

    tx_priority_txt2p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(6 downto 4) ,-- in
        write                           => write_en(0) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt2p -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT3P]
    ----------------------------------------------------------------------------

    tx_priority_txt3p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(10 downto 8) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt3p -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT4P]
    ----------------------------------------------------------------------------

    tx_priority_txt4p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(14 downto 12) ,-- in
        write                           => write_en(1) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt4p -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT5P]
    ----------------------------------------------------------------------------

    tx_priority_txt5p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(18 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt5p -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT6P]
    ----------------------------------------------------------------------------

    tx_priority_txt6p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(22 downto 20) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt6p -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT7P]
    ----------------------------------------------------------------------------

    tx_priority_txt7p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(26 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt7p -- out
    );

    ----------------------------------------------------------------------------
    -- TX_PRIORITY[TXT8P]
    ----------------------------------------------------------------------------

    tx_priority_txt8p_reg_comp : memory_reg_rw
    generic map(
        data_width                      => 3 ,
        reset_value                     => "000" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(30 downto 28) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(30) ,-- in
        reg_value                       => control_registers_out_i.tx_priority_txt8p -- out
    );

    ----------------------------------------------------------------------------
    -- SSP_CFG[SSP_OFFSET]
    ----------------------------------------------------------------------------

    ssp_cfg_ssp_offset_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 8 ,
        reset_value                     => "00001010" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(23 downto 16) ,-- in
        write                           => write_en(2) ,-- in
        cs                              => reg_sel(32) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.ssp_cfg_ssp_offset -- out
    );

    ----------------------------------------------------------------------------
    -- SSP_CFG[SSP_SRC]
    ----------------------------------------------------------------------------

    ssp_cfg_ssp_src_reg_comp : memory_reg_rw_lock
    generic map(
        data_width                      => 2 ,
        reset_value                     => "00" 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_in                         => w_data(25 downto 24) ,-- in
        write                           => write_en(3) ,-- in
        cs                              => reg_sel(32) ,-- in
        lock                            => lock_2 ,-- in
        reg_value                       => control_registers_out_i.ssp_cfg_ssp_src -- out
    );

    ----------------------------------------------------------------------------
    -- Read data multiplexor
    ----------------------------------------------------------------------------

    data_mux_control_registers_comp : data_mux
    generic map(
        data_out_width                  => 32 ,
        data_in_width                   => 1248 ,
        sel_width                       => 6 ,
        registered_out                  => REGISTERED_READ 
    )
    port map(
        clk_sys                         => clk_sys ,-- in
        res_n                           => res_n ,-- in
        data_selector                   => address(7 downto 2) ,-- in
        data_in                         => read_data_mux_in ,-- in
        data_mask_n                     => read_data_mask_n ,-- in
        enable                          => '1' ,-- in
        data_out                        => r_data -- out
    );

  ------------------------------------------------------------------------------
  -- Read data driver
  ------------------------------------------------------------------------------
  read_data_mux_in <=
    -- Adress:152
	control_registers_in.timestamp_high_timestamp_high	&

    -- Adress:148
	control_registers_in.timestamp_low_timestamp_low	&

    -- Adress:144
	control_registers_in.yolo_reg_yolo_val	&

    -- Adress:140
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.debug_register_pc_sof	&
	control_registers_in.debug_register_pc_ovr	&
	control_registers_in.debug_register_pc_susp	&
	control_registers_in.debug_register_pc_int	&
	control_registers_in.debug_register_pc_eof	&
	control_registers_in.debug_register_pc_ackd	&
	control_registers_in.debug_register_pc_ack	&
	control_registers_in.debug_register_pc_crcd	&
	control_registers_in.debug_register_pc_crc	&
	control_registers_in.debug_register_pc_stc	&
	control_registers_in.debug_register_pc_dat	&
	control_registers_in.debug_register_pc_con	&
	control_registers_in.debug_register_pc_arb	&
	control_registers_in.debug_register_destuff_count	&
	control_registers_in.debug_register_stuff_count	&

    -- Adress:136
	control_registers_in.tx_fr_ctr_tx_fr_ctr_val	&

    -- Adress:132
	control_registers_in.rx_fr_ctr_rx_fr_ctr_val	&

    -- Adress:128
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.ssp_cfg_ssp_src	&
	control_registers_out_i.ssp_cfg_ssp_offset	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.trv_delay_trv_delay_value	&

    -- Adress:124
	'0'	&
	'0'	&
	control_registers_in.ts_info_ts_bits	&
	control_registers_in.alc_alc_id_field	&
	control_registers_in.alc_alc_bit	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.retr_ctr_retr_ctr_val	&
	control_registers_in.err_capt_err_type	&
	control_registers_in.err_capt_err_erp	&
	control_registers_in.err_capt_err_pos	&

    -- Adress:120
	'0'	&
	control_registers_out_i.tx_priority_txt8p	&
	'0'	&
	control_registers_out_i.tx_priority_txt7p	&
	'0'	&
	control_registers_out_i.tx_priority_txt6p	&
	'0'	&
	control_registers_out_i.tx_priority_txt5p	&
	'0'	&
	control_registers_out_i.tx_priority_txt4p	&
	'0'	&
	control_registers_out_i.tx_priority_txt3p	&
	'0'	&
	control_registers_out_i.tx_priority_txt2p	&
	'0'	&
	control_registers_out_i.tx_priority_txt1p	&

    -- Adress:116
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.txtb_info_txt_buffer_count	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&

    -- Adress:112
	control_registers_in.tx_status_tx8s	&
	control_registers_in.tx_status_tx7s	&
	control_registers_in.tx_status_tx6s	&
	control_registers_in.tx_status_tx5s	&
	control_registers_in.tx_status_tx4s	&
	control_registers_in.tx_status_tx3s	&
	control_registers_in.tx_status_tx2s	&
	control_registers_in.tx_status_tx1s	&

    -- Adress:108
	control_registers_in.rx_data_rx_data	&

    -- Adress:104
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.rx_settings_rtsop	&
	'0'	&
	control_registers_in.rx_status_rxfrc	&
	'0'	&
	control_registers_in.rx_status_rxmof	&
	control_registers_in.rx_status_rxf	&
	control_registers_in.rx_status_rxe	&

    -- Adress:100
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.rx_pointers_rx_rpp	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.rx_pointers_rx_wpp	&

    -- Adress:96
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.rx_mem_info_rx_mem_free	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.rx_mem_info_rx_buff_size	&

    -- Adress:92
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.filter_status_sfr	&
	control_registers_in.filter_status_sfc	&
	control_registers_in.filter_status_sfb	&
	control_registers_in.filter_status_sfa	&
	control_registers_out_i.filter_control_frfe	&
	control_registers_out_i.filter_control_frfb	&
	control_registers_out_i.filter_control_frne	&
	control_registers_out_i.filter_control_frnb	&
	control_registers_out_i.filter_control_fcfe	&
	control_registers_out_i.filter_control_fcfb	&
	control_registers_out_i.filter_control_fcne	&
	control_registers_out_i.filter_control_fcnb	&
	control_registers_out_i.filter_control_fbfe	&
	control_registers_out_i.filter_control_fbfb	&
	control_registers_out_i.filter_control_fbne	&
	control_registers_out_i.filter_control_fbnb	&
	control_registers_out_i.filter_control_fafe	&
	control_registers_out_i.filter_control_fafb	&
	control_registers_out_i.filter_control_fane	&
	control_registers_out_i.filter_control_fanb	&

    -- Adress:88
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_ran_high_bit_ran_high_val	&

    -- Adress:84
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_ran_low_bit_ran_low_val	&

    -- Adress:80
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_c_val_bit_val_c_val	&

    -- Adress:76
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_c_mask_bit_mask_c_val	&

    -- Adress:72
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_b_val_bit_val_b_val	&

    -- Adress:68
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_b_mask_bit_mask_b_val	&

    -- Adress:64
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_a_val_bit_val_a_val	&

    -- Adress:60
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.filter_a_mask_bit_mask_a_val	&

    -- Adress:56
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&

    -- Adress:52
	control_registers_in.err_fd_err_fd_val	&
	control_registers_in.err_norm_err_norm_val	&

    -- Adress:48
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.tec_tec_val	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.rec_rec_val	&

    -- Adress:44
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.fault_state_bof	&
	control_registers_in.fault_state_erp	&
	control_registers_in.fault_state_era	&
	control_registers_out_i.erp_erp_limit	&
	control_registers_out_i.ewl_ew_limit	&

    -- Adress:40
	control_registers_out_i.btr_fd_sjw_fd	&
	control_registers_out_i.btr_fd_brp_fd	&
	'0'	&
	control_registers_out_i.btr_fd_ph2_fd	&
	'0'	&
	control_registers_out_i.btr_fd_ph1_fd	&
	'0'	&
	control_registers_out_i.btr_fd_prop_fd	&

    -- Adress:36
	control_registers_out_i.btr_sjw	&
	control_registers_out_i.btr_brp	&
	control_registers_out_i.btr_ph2	&
	control_registers_out_i.btr_ph1	&
	control_registers_out_i.btr_prop	&

    -- Adress:32
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&

    -- Adress:28
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.int_mask_set_int_mask_set	&

    -- Adress:24
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&

    -- Adress:20
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.int_ena_set_int_ena_set	&

    -- Adress:16
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.int_stat_txbhci	&
	control_registers_in.int_stat_rbnei	&
	control_registers_in.int_stat_bsi	&
	control_registers_in.int_stat_rxfi	&
	control_registers_in.int_stat_ofi	&
	control_registers_in.int_stat_bei	&
	control_registers_in.int_stat_ali	&
	control_registers_in.int_stat_fcsi	&
	control_registers_in.int_stat_doi	&
	control_registers_in.int_stat_ewli	&
	control_registers_in.int_stat_txi	&
	control_registers_in.int_stat_rxi	&

    -- Adress:12
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&

    -- Adress:8
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.status_sprt	&
	control_registers_in.status_strgs	&
	control_registers_in.status_stcnt	&
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_in.status_txdpe	&
	control_registers_in.status_txpe	&
	control_registers_in.status_rxpe	&
	control_registers_in.status_pexs	&
	control_registers_in.status_idle	&
	control_registers_in.status_ewl	&
	control_registers_in.status_txs	&
	control_registers_in.status_rxs	&
	control_registers_in.status_eft	&
	control_registers_in.status_txnf	&
	control_registers_in.status_dor	&
	control_registers_in.status_rxne	&

    -- Adress:4
	'0'	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.settings_pchke	&
	control_registers_out_i.settings_fdrf	&
	control_registers_out_i.settings_tbfbo	&
	control_registers_out_i.settings_pex	&
	control_registers_out_i.settings_nisofd	&
	control_registers_out_i.settings_ena	&
	control_registers_out_i.settings_ilbp	&
	control_registers_out_i.settings_rtrth	&
	control_registers_out_i.settings_rtrle	&
	'0'	&
	'0'	&
	'0'	&
	control_registers_out_i.mode_erfm	&
	control_registers_out_i.mode_sam	&
	control_registers_out_i.mode_txbbm	&
	control_registers_out_i.mode_rxbam	&
	control_registers_out_i.mode_tstm	&
	control_registers_out_i.mode_acf	&
	control_registers_out_i.mode_rom	&
	control_registers_out_i.mode_tttm	&
	control_registers_out_i.mode_fde	&
	control_registers_out_i.mode_afm	&
	control_registers_out_i.mode_stm	&
	control_registers_out_i.mode_bmm	&
	control_registers_out_i.mode_rst	&

    -- Adress:0
	control_registers_in.version_ver_major	&
	control_registers_in.version_ver_minor	&
	control_registers_in.device_id_device_id
;

    ----------------------------------------------------------------------------
    -- Read data mask - Byte enables
    ----------------------------------------------------------------------------
    read_data_mask_n <=
      be(3) & be(3) & be(3) & be(3) & be(3) & be(3) & be(3) & be(3) & 
      be(2) & be(2) & be(2) & be(2) & be(2) & be(2) & be(2) & be(2) & 
      be(1) & be(1) & be(1) & be(1) & be(1) & be(1) & be(1) & be(1) & 
      be(0) & be(0) & be(0) & be(0) & be(0) & be(0) & be(0) & be(0) ;

    Control_registers_out <= Control_registers_out_i;

    -- <RELEASE_OFF>
    ----------------------------------------------------------------------------
    -- Functional coverage
    ----------------------------------------------------------------------------
    --  psl default clock is rising_edge(clk_sys);
    -- psl device_id_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(0)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl version_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(0)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl mode_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(1)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl mode_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(1)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl settings_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(1)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl settings_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(1)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(2)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl command_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(3)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl int_stat_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(4)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_stat_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(4)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_ena_set_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(5)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_ena_set_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(5)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_ena_clr_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(6)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_mask_set_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(7)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_mask_set_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(7)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl int_mask_clr_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(8)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl btr_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(9)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl btr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(9)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl btr_fd_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(10)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl btr_fd_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(10)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl ewl_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(11)='1') and ((be(0)='1')))};

    -- psl ewl_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(11)='1') and ((be(0)='1')))};

    -- psl erp_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(11)='1') and ((be(1)='1')))};

    -- psl erp_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(11)='1') and ((be(1)='1')))};

    -- psl fault_state_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(11)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl rec_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(12)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl tec_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(12)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl err_norm_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(13)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl err_fd_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(13)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl ctr_pres_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(14)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_mask_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(15)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_mask_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(15)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_val_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(16)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_a_val_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(16)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_mask_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(17)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_mask_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(17)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_val_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(18)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_b_val_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(18)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_mask_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(19)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_mask_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(19)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_val_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(20)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_c_val_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(20)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_low_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(21)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_low_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(21)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_high_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(22)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_ran_high_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(22)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl filter_control_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(23)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl filter_control_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(23)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl filter_status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(23)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl rx_mem_info_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(24)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl rx_pointers_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(25)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl rx_status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(26)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl rx_settings_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(26)='1') and ((be(2)='1')))};

    -- psl rx_settings_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(26)='1') and ((be(2)='1')))};

    -- psl rx_data_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(27)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_status_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(28)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_command_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(29)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl txtb_info_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(29)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl tx_priority_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(30)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_priority_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(30)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl err_capt_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(0)='1')))};

    -- psl retr_ctr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(1)='1')))};

    -- psl alc_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(2)='1')))};

    -- psl ts_info_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(31)='1') and ((be(3)='1')))};

    -- psl trv_delay_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(32)='1') and ((be(0)='1') or (be(1)='1')))};

    -- psl ssp_cfg_write_access_cov : cover
    -- {((cs='1') and (write='1') and (reg_sel(32)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl ssp_cfg_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(32)='1') and ((be(2)='1') or (be(3)='1')))};

    -- psl rx_fr_ctr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(33)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl tx_fr_ctr_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(34)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl debug_register_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(35)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl yolo_reg_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(36)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl timestamp_low_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(37)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- psl timestamp_high_read_access_cov : cover
    -- {((cs='1') and (read='1') and (reg_sel(38)='1') and ((be(0)='1') or (be(1)='1') or (be(2)='1') or (be(3)='1')))};

    -- <RELEASE_ON>

end architecture rtl;
