--
-- Synopsys
-- Vhdl wrapper for top level design, written on Mon Jul 18 09:35:08 2022
--
library ieee;
use ieee.std_logic_1164.all;
library ctu_can_fd_rtl;
use ctu_can_fd_rtl.can_constants_pkg.all;
use ctu_can_fd_rtl.can_fd_frame_format.all;
use ctu_can_fd_rtl.can_fd_register_map.all;
use ctu_can_fd_rtl.drv_stat_pkg.all;
use ctu_can_fd_rtl.unary_ops_pkg.all;
use ctu_can_fd_rtl.can_types_pkg.all;
use ctu_can_fd_rtl.id_transfer_pkg.all;
use ieee.numeric_std.all;
use ieee.math_real.all;

entity wrapper_for_ctu_can_fd_libero_top is
   port (
      clk_sys : in std_logic;
      res_n : in std_logic;
      res_n_out : out std_logic;
      data_in : in std_logic_vector(31 downto 0);
      data_out : out std_logic_vector(31 downto 0);
      adress : in std_logic_vector(15 downto 0);
      scs : in std_logic;
      srd : in std_logic;
      swr : in std_logic;
      sbe : in std_logic_vector(3 downto 0);
      int : out std_logic;
      can_tx : out std_logic;
      can_rx : in std_logic;
      timestamp : in std_logic_vector(63 downto 0)
   );
end wrapper_for_ctu_can_fd_libero_top;

architecture rtl of wrapper_for_ctu_can_fd_libero_top is

component ctu_can_fd_libero_top
 port (
   clk_sys : in std_logic;
   res_n : in std_logic;
   res_n_out : out std_logic;
   data_in : in std_logic_vector (31 downto 0);
   data_out : out std_logic_vector (31 downto 0);
   adress : in std_logic_vector (15 downto 0);
   scs : in std_logic;
   srd : in std_logic;
   swr : in std_logic;
   sbe : in std_logic_vector (3 downto 0);
   int : out std_logic;
   can_tx : out std_logic;
   can_rx : in std_logic;
   timestamp : in std_logic_vector (63 downto 0)
 );
end component;

signal tmp_clk_sys : std_logic;
signal tmp_res_n : std_logic;
signal tmp_res_n_out : std_logic;
signal tmp_data_in : std_logic_vector (31 downto 0);
signal tmp_data_out : std_logic_vector (31 downto 0);
signal tmp_adress : std_logic_vector (15 downto 0);
signal tmp_scs : std_logic;
signal tmp_srd : std_logic;
signal tmp_swr : std_logic;
signal tmp_sbe : std_logic_vector (3 downto 0);
signal tmp_int : std_logic;
signal tmp_can_tx : std_logic;
signal tmp_can_rx : std_logic;
signal tmp_timestamp : std_logic_vector (63 downto 0);

begin

tmp_clk_sys <= clk_sys;

tmp_res_n <= res_n;

res_n_out <= tmp_res_n_out;

tmp_data_in <= data_in;

data_out <= tmp_data_out;

tmp_adress <= adress;

tmp_scs <= scs;

tmp_srd <= srd;

tmp_swr <= swr;

tmp_sbe <= sbe;

int <= tmp_int;

can_tx <= tmp_can_tx;

tmp_can_rx <= can_rx;

tmp_timestamp <= timestamp;



u1:   ctu_can_fd_libero_top port map (
		clk_sys => tmp_clk_sys,
		res_n => tmp_res_n,
		res_n_out => tmp_res_n_out,
		data_in => tmp_data_in,
		data_out => tmp_data_out,
		adress => tmp_adress,
		scs => tmp_scs,
		srd => tmp_srd,
		swr => tmp_swr,
		sbe => tmp_sbe,
		int => tmp_int,
		can_tx => tmp_can_tx,
		can_rx => tmp_can_rx,
		timestamp => tmp_timestamp
       );
end rtl;
