--------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2021-present Ondrej Ille
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
-- -------------------------------------------------------------------------------
-- 
-- CTU CAN FD IP Core 
-- Copyright (C) 2015-2020 MIT License
-- 
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
-- 
-- Project advisors: 
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
-- 
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
-- 
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
-- 
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
-- 
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
-- 
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
-- 
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Memory map for: CAN_Frame_format
-- This file is autogenerated, DO NOT EDIT!
--------------------------------------------------------------------------------

Library ieee;
use ieee.std_logic_1164.all;

package can_fd_frame_format is

  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  -- Address block: CAN_FD_Frame_format
  ------------------------------------------------------------------------------
  ------------------------------------------------------------------------------
  constant CAN_FD_FRAME_FORMAT_BLOCK    : std_logic_vector(3 downto 0) := x"0";

  constant FRAME_FORMAT_W_ADR        : std_logic_vector(11 downto 0) := x"000";
  constant IDENTIFIER_W_ADR          : std_logic_vector(11 downto 0) := x"004";
  constant TIMESTAMP_L_W_ADR         : std_logic_vector(11 downto 0) := x"008";
  constant TIMESTAMP_U_W_ADR         : std_logic_vector(11 downto 0) := x"00C";
  constant DATA_1_4_W_ADR            : std_logic_vector(11 downto 0) := x"010";
  constant DATA_5_8_W_ADR            : std_logic_vector(11 downto 0) := x"014";
  constant DATA_9_12_W_ADR           : std_logic_vector(11 downto 0) := x"018";
  constant DATA_13_16_W_ADR          : std_logic_vector(11 downto 0) := x"01C";
  constant DATA_17_20_W_ADR          : std_logic_vector(11 downto 0) := x"020";
  constant DATA_21_24_W_ADR          : std_logic_vector(11 downto 0) := x"024";
  constant DATA_25_28_W_ADR          : std_logic_vector(11 downto 0) := x"028";
  constant DATA_29_32_W_ADR          : std_logic_vector(11 downto 0) := x"02C";
  constant DATA_33_36_W_ADR          : std_logic_vector(11 downto 0) := x"030";
  constant DATA_37_40_W_ADR          : std_logic_vector(11 downto 0) := x"034";
  constant DATA_41_44_W_ADR          : std_logic_vector(11 downto 0) := x"038";
  constant DATA_45_48_W_ADR          : std_logic_vector(11 downto 0) := x"03C";
  constant DATA_49_52_W_ADR          : std_logic_vector(11 downto 0) := x"040";
  constant DATA_53_56_W_ADR          : std_logic_vector(11 downto 0) := x"044";
  constant DATA_57_60_W_ADR          : std_logic_vector(11 downto 0) := x"048";
  constant DATA_61_64_W_ADR          : std_logic_vector(11 downto 0) := x"04C";
  constant FRAME_TEST_W_ADR          : std_logic_vector(11 downto 0) := x"050";

  ------------------------------------------------------------------------------
  -- FRAME_FORMAT_W register
  --
  -- Frame format word with CAN frame metadata.
  ------------------------------------------------------------------------------
  constant DLC_L                  : natural := 0;
  constant DLC_H                  : natural := 3;
  constant ERF_IND                : natural := 4;
  constant RTR_IND                : natural := 5;
  constant IDE_IND                : natural := 6;
  constant FDF_IND                : natural := 7;
  constant LBPF_IND               : natural := 8;
  constant BRS_IND                : natural := 9;
  constant ESI_RSV_IND           : natural := 10;
  constant RWCNT_L               : natural := 11;
  constant RWCNT_H               : natural := 15;
  constant ERF_POS_L             : natural := 16;
  constant ERF_POS_H             : natural := 19;
  constant ERF_ERP_IND           : natural := 20;
  constant ERF_TYPE_L            : natural := 21;
  constant ERF_TYPE_H            : natural := 23;
  constant IVLD_IND              : natural := 24;
  constant LBTBI_L               : natural := 25;
  constant LBTBI_H               : natural := 27;

  -- "RTR" field enumerated values
  constant NO_RTR_FRAME       : std_logic := '0';
  constant RTR_FRAME          : std_logic := '1';

  -- "IDE" field enumerated values
  constant BASE               : std_logic := '0';
  constant EXTENDED           : std_logic := '1';

  -- "FDF" field enumerated values
  constant NORMAL_CAN         : std_logic := '0';
  constant FD_CAN             : std_logic := '1';

  -- "BRS" field enumerated values
  constant BR_NO_SHIFT        : std_logic := '0';
  constant BR_SHIFT           : std_logic := '1';

  -- "ESI_RSV" field enumerated values
  constant ESI_ERR_ACTIVE     : std_logic := '0';
  constant ESI_ERR_PASIVE     : std_logic := '1';

  -- "LBPF" field enumerated values
  constant LBPF_FOREIGN       : std_logic := '0';
  constant LBPF_LOOPBACK      : std_logic := '1';

  -- "ERF" field enumerated values
  constant ERF_CAN_FRAME      : std_logic := '0';
  constant ERF_ERR_FRAME      : std_logic := '1';

  -- "IVLD" field enumerated values
  constant IVLD_INALID        : std_logic := '0';
  constant IVLD_VALID         : std_logic := '1';

  -- "LBTBI" field enumerated values
  constant TXT_BUF_1 : std_logic_vector(2 downto 0) := "000";
  constant TXT_BUF_2 : std_logic_vector(2 downto 0) := "001";
  constant TXT_BUF_3 : std_logic_vector(2 downto 0) := "010";
  constant TXT_BUF_4 : std_logic_vector(2 downto 0) := "011";
  constant TXT_BUF_5 : std_logic_vector(2 downto 0) := "100";
  constant TXT_BUF_6 : std_logic_vector(2 downto 0) := "101";
  constant TXT_BUF_7 : std_logic_vector(2 downto 0) := "110";
  constant TXT_BUF_8 : std_logic_vector(2 downto 0) := "111";

  -- FRAME_FORMAT_W register reset values

  ------------------------------------------------------------------------------
  -- IDENTIFIER_W register
  --
  -- CAN Identifier.
  ------------------------------------------------------------------------------
  constant IDENTIFIER_EXT_L       : natural := 0;
  constant IDENTIFIER_EXT_H      : natural := 17;
  constant IDENTIFIER_BASE_L     : natural := 18;
  constant IDENTIFIER_BASE_H     : natural := 28;

  -- IDENTIFIER_W register reset values

  ------------------------------------------------------------------------------
  -- TIMESTAMP_L_W register
  --
  ------------------------------------------------------------------------------
  constant TIME_STAMP_L_W_L       : natural := 0;
  constant TIME_STAMP_L_W_H      : natural := 31;

  -- TIMESTAMP_L_W register reset values

  ------------------------------------------------------------------------------
  -- TIMESTAMP_U_W register
  --
  ------------------------------------------------------------------------------
  constant TIMESTAMP_U_W_L        : natural := 0;
  constant TIMESTAMP_U_W_H       : natural := 31;

  -- TIMESTAMP_U_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_1_4_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_1_L               : natural := 0;
  constant DATA_1_H               : natural := 7;
  constant DATA_2_L               : natural := 8;
  constant DATA_2_H              : natural := 15;
  constant DATA_3_L              : natural := 16;
  constant DATA_3_H              : natural := 23;
  constant DATA_4_L              : natural := 24;
  constant DATA_4_H              : natural := 31;

  -- DATA_1_4_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_5_8_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_5_L               : natural := 0;
  constant DATA_5_H               : natural := 7;
  constant DATA_6_L               : natural := 8;
  constant DATA_6_H              : natural := 15;
  constant DATA_7_L              : natural := 16;
  constant DATA_7_H              : natural := 23;
  constant DATA_8_L              : natural := 24;
  constant DATA_8_H              : natural := 31;

  -- DATA_5_8_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_9_12_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_9_L               : natural := 0;
  constant DATA_9_H               : natural := 7;
  constant DATA_10_L              : natural := 8;
  constant DATA_10_H             : natural := 15;
  constant DATA_11_L             : natural := 16;
  constant DATA_11_H             : natural := 23;
  constant DATA_12_L             : natural := 24;
  constant DATA_12_H             : natural := 31;

  -- DATA_9_12_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_13_16_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_13_L              : natural := 0;
  constant DATA_13_H              : natural := 7;
  constant DATA_14_L              : natural := 8;
  constant DATA_14_H             : natural := 15;
  constant DATA_15_L             : natural := 16;
  constant DATA_15_H             : natural := 23;
  constant DATA_16_L             : natural := 24;
  constant DATA_16_H             : natural := 31;

  -- DATA_13_16_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_17_20_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_17_L              : natural := 0;
  constant DATA_17_H              : natural := 7;
  constant DATA_18_L              : natural := 8;
  constant DATA_18_H             : natural := 15;
  constant DATA_19_L             : natural := 16;
  constant DATA_19_H             : natural := 23;
  constant DATA_20_L             : natural := 24;
  constant DATA_20_H             : natural := 31;

  -- DATA_17_20_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_21_24_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_21_L              : natural := 0;
  constant DATA_21_H              : natural := 7;
  constant DATA_22_L              : natural := 8;
  constant DATA_22_H             : natural := 15;
  constant DATA_23_L             : natural := 16;
  constant DATA_23_H             : natural := 23;
  constant DATA_24_L             : natural := 24;
  constant DATA_24_H             : natural := 31;

  -- DATA_21_24_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_25_28_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_25_L              : natural := 0;
  constant DATA_25_H              : natural := 7;
  constant DATA_26_L              : natural := 8;
  constant DATA_26_H             : natural := 15;
  constant DATA_27_L             : natural := 16;
  constant DATA_27_H             : natural := 23;
  constant DATA_28_L             : natural := 24;
  constant DATA_28_H             : natural := 31;

  -- DATA_25_28_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_29_32_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_29_L              : natural := 0;
  constant DATA_29_H              : natural := 7;
  constant DATA_30_L              : natural := 8;
  constant DATA_30_H             : natural := 15;
  constant DATA_31_L             : natural := 16;
  constant DATA_31_H             : natural := 23;
  constant DATA_32_L             : natural := 24;
  constant DATA_32_H             : natural := 31;

  -- DATA_29_32_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_33_36_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_33_L              : natural := 0;
  constant DATA_33_H              : natural := 7;
  constant DATA_34_L              : natural := 8;
  constant DATA_34_H             : natural := 15;
  constant DATA_35_L             : natural := 16;
  constant DATA_35_H             : natural := 23;
  constant DATA_36_L             : natural := 24;
  constant DATA_36_H             : natural := 31;

  -- DATA_33_36_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_37_40_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_37_L              : natural := 0;
  constant DATA_37_H              : natural := 7;
  constant DATA_38_L              : natural := 8;
  constant DATA_38_H             : natural := 15;
  constant DATA_39_L             : natural := 16;
  constant DATA_39_H             : natural := 23;
  constant DATA_40_L             : natural := 24;
  constant DATA_40_H             : natural := 31;

  -- DATA_37_40_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_41_44_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_41_L              : natural := 0;
  constant DATA_41_H              : natural := 7;
  constant DATA_42_L              : natural := 8;
  constant DATA_42_H             : natural := 15;
  constant DATA_43_L             : natural := 16;
  constant DATA_43_H             : natural := 23;
  constant DATA_44_L             : natural := 24;
  constant DATA_44_H             : natural := 31;

  -- DATA_41_44_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_45_48_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_45_L              : natural := 0;
  constant DATA_45_H              : natural := 7;
  constant DATA_46_L              : natural := 8;
  constant DATA_46_H             : natural := 15;
  constant DATA_47_L             : natural := 16;
  constant DATA_47_H             : natural := 23;
  constant DATA_48_L             : natural := 24;
  constant DATA_48_H             : natural := 31;

  -- DATA_45_48_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_49_52_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_49_L              : natural := 0;
  constant DATA_49_H              : natural := 7;
  constant DATA_50_L              : natural := 8;
  constant DATA_50_H             : natural := 15;
  constant DATA_51_L             : natural := 16;
  constant DATA_51_H             : natural := 23;
  constant DATA_52_L             : natural := 24;
  constant DATA_52_H             : natural := 31;

  -- DATA_49_52_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_53_56_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_53_L              : natural := 0;
  constant DATA_53_H              : natural := 7;
  constant DATA_56_L              : natural := 8;
  constant DATA_56_H             : natural := 15;
  constant DATA_55_L             : natural := 16;
  constant DATA_55_H             : natural := 23;
  constant DATA_54_L             : natural := 24;
  constant DATA_54_H             : natural := 31;

  -- DATA_53_56_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_57_60_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_57_L              : natural := 0;
  constant DATA_57_H              : natural := 7;
  constant DATA_58_L              : natural := 8;
  constant DATA_58_H             : natural := 15;
  constant DATA_59_L             : natural := 16;
  constant DATA_59_H             : natural := 23;
  constant DATA_60_L             : natural := 24;
  constant DATA_60_H             : natural := 31;

  -- DATA_57_60_W register reset values

  ------------------------------------------------------------------------------
  -- DATA_61_64_W register
  --
  ------------------------------------------------------------------------------
  constant DATA_61_L              : natural := 0;
  constant DATA_61_H              : natural := 7;
  constant DATA_62_L              : natural := 8;
  constant DATA_62_H             : natural := 15;
  constant DATA_63_L             : natural := 16;
  constant DATA_63_H             : natural := 23;
  constant DATA_64_L             : natural := 24;
  constant DATA_64_H             : natural := 31;

  -- DATA_61_64_W register reset values

  ------------------------------------------------------------------------------
  -- FRAME_TEST_W register
  --
  ------------------------------------------------------------------------------
  constant FSTC_IND               : natural := 0;
  constant FCRC_IND               : natural := 1;
  constant SDLC_IND               : natural := 2;
  constant TPRM_L                 : natural := 8;
  constant TPRM_H                : natural := 12;

  -- FRAME_TEST_W register reset values

end package;
