/* SPDX-License-Identifier: GPL-2.0-or-later */
/*******************************************************************************
 *
 * CTU CAN FD IP Core
 *
 * Copyright (C) 2015-2018 Ondrej Ille <ondrej.ille@gmail.com> FEE CTU
 * Copyright (C) 2018-2020 Ondrej Ille <ondrej.ille@gmail.com> self-funded
 * Copyright (C) 2018-2019 Martin Jerabek <martin.jerabek01@gmail.com> FEE CTU
 * Copyright (C) 2018-2020 Pavel Pisa <pisa@cmp.felk.cvut.cz> FEE CTU/self-funded
 *
 * Project advisors:
 *     Jiri Novak <jnovak@fel.cvut.cz>
 *     Pavel Pisa <pisa@cmp.felk.cvut.cz>
 *
 * Department of Measurement         (http://meas.fel.cvut.cz/)
 * Faculty of Electrical Engineering (http://www.fel.cvut.cz)
 * Czech Technical University        (http://www.cvut.cz/)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 ******************************************************************************/

/* This file is autogenerated, DO NOT EDIT! */

#ifndef __CTU_CAN_FD_CAN_FD_FRAME_FORMAT__
#define __CTU_CAN_FD_CAN_FD_FRAME_FORMAT__

/* CAN_Frame_format memory map */
enum ctu_can_fd_can_frame_format {
	CTU_CAN_FD_FRAME_FORMAT_W       = 0x0,
	CTU_CAN_FD_IDENTIFIER_W         = 0x4,
	CTU_CAN_FD_TIMESTAMP_L_W        = 0x8,
	CTU_CAN_FD_TIMESTAMP_U_W        = 0xc,
	CTU_CAN_FD_DATA_1_4_W          = 0x10,
	CTU_CAN_FD_DATA_5_8_W          = 0x14,
	CTU_CAN_FD_DATA_9_12_W         = 0x18,
	CTU_CAN_FD_DATA_13_16_W        = 0x1c,
	CTU_CAN_FD_DATA_17_20_W        = 0x20,
	CTU_CAN_FD_DATA_21_24_W        = 0x24,
	CTU_CAN_FD_DATA_25_28_W        = 0x28,
	CTU_CAN_FD_DATA_29_32_W        = 0x2c,
	CTU_CAN_FD_DATA_33_36_W        = 0x30,
	CTU_CAN_FD_DATA_37_40_W        = 0x34,
	CTU_CAN_FD_DATA_41_44_W        = 0x38,
	CTU_CAN_FD_DATA_45_48_W        = 0x3c,
	CTU_CAN_FD_DATA_49_52_W        = 0x40,
	CTU_CAN_FD_DATA_53_56_W        = 0x44,
	CTU_CAN_FD_DATA_57_60_W        = 0x48,
	CTU_CAN_FD_DATA_61_64_W        = 0x4c,
	CTU_CAN_FD_FRAME_TEST_W        = 0x50,
};


/* Register descriptions: */
union ctu_can_fd_frame_format_w {
	uint32_t u32;
	struct ctu_can_fd_frame_format_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* FRAME_FORMAT_W */
		uint32_t dlc                     : 4;
		uint32_t erf                     : 1;
		uint32_t rtr                     : 1;
		uint32_t ide                     : 1;
		uint32_t fdf                     : 1;
		uint32_t lbpf                    : 1;
		uint32_t brs                     : 1;
		uint32_t esi_rsv                 : 1;
		uint32_t rwcnt                   : 5;
		uint32_t erf_pos                 : 4;
		uint32_t erf_erp                 : 1;
		uint32_t erf_type                : 3;
		uint32_t ivld                    : 1;
		uint32_t lbtbi                   : 3;
		uint32_t reserved_31_28          : 4;
#else
		uint32_t reserved_31_28          : 4;
		uint32_t lbtbi                   : 3;
		uint32_t ivld                    : 1;
		uint32_t erf_type                : 3;
		uint32_t erf_erp                 : 1;
		uint32_t erf_pos                 : 4;
		uint32_t rwcnt                   : 5;
		uint32_t esi_rsv                 : 1;
		uint32_t brs                     : 1;
		uint32_t lbpf                    : 1;
		uint32_t fdf                     : 1;
		uint32_t ide                     : 1;
		uint32_t rtr                     : 1;
		uint32_t erf                     : 1;
		uint32_t dlc                     : 4;
#endif
	} s;
};

enum ctu_can_fd_frame_format_w_erf {
	ERF_CAN_FRAME       = 0x0,
	ERF_ERR_FRAME       = 0x1,
};

enum ctu_can_fd_frame_format_w_rtr {
	NO_RTR_FRAME       = 0x0,
	RTR_FRAME          = 0x1,
};

enum ctu_can_fd_frame_format_w_ide {
	BASE           = 0x0,
	EXTENDED       = 0x1,
};

enum ctu_can_fd_frame_format_w_fdf {
	NORMAL_CAN       = 0x0,
	FD_CAN           = 0x1,
};

enum ctu_can_fd_frame_format_w_lbpf {
	LBPF_FOREIGN        = 0x0,
	LBPF_LOOPBACK       = 0x1,
};

enum ctu_can_fd_frame_format_w_brs {
	BR_NO_SHIFT       = 0x0,
	BR_SHIFT          = 0x1,
};

enum ctu_can_fd_frame_format_w_esi_rsv {
	ESI_ERR_ACTIVE       = 0x0,
	ESI_ERR_PASIVE       = 0x1,
};

enum ctu_can_fd_frame_format_w_ivld {
	IVLD_INALID       = 0x0,
	IVLD_VALID        = 0x1,
};

enum ctu_can_fd_frame_format_w_lbtbi {
	TXT_BUF_1       = 0x0,
	TXT_BUF_2       = 0x1,
	TXT_BUF_3       = 0x2,
	TXT_BUF_4       = 0x3,
	TXT_BUF_5       = 0x4,
	TXT_BUF_6       = 0x5,
	TXT_BUF_7       = 0x6,
	TXT_BUF_8       = 0x7,
};

union ctu_can_fd_identifier_w {
	uint32_t u32;
	struct ctu_can_fd_identifier_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* IDENTIFIER_W */
		uint32_t identifier_ext         : 18;
		uint32_t identifier_base        : 11;
		uint32_t reserved_31_29          : 3;
#else
		uint32_t reserved_31_29          : 3;
		uint32_t identifier_base        : 11;
		uint32_t identifier_ext         : 18;
#endif
	} s;
};

union ctu_can_fd_timestamp_l_w {
	uint32_t u32;
	struct ctu_can_fd_timestamp_l_w_s {
  /* TIMESTAMP_L_W */
		uint32_t time_stamp_l_w         : 32;
	} s;
};

union ctu_can_fd_timestamp_u_w {
	uint32_t u32;
	struct ctu_can_fd_timestamp_u_w_s {
  /* TIMESTAMP_U_W */
		uint32_t timestamp_u_w          : 32;
	} s;
};

union ctu_can_fd_data_1_4_w {
	uint32_t u32;
	struct ctu_can_fd_data_1_4_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_1_4_W */
		uint32_t data_1                  : 8;
		uint32_t data_2                  : 8;
		uint32_t data_3                  : 8;
		uint32_t data_4                  : 8;
#else
		uint32_t data_4                  : 8;
		uint32_t data_3                  : 8;
		uint32_t data_2                  : 8;
		uint32_t data_1                  : 8;
#endif
	} s;
};

union ctu_can_fd_data_5_8_w {
	uint32_t u32;
	struct ctu_can_fd_data_5_8_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_5_8_W */
		uint32_t data_5                  : 8;
		uint32_t data_6                  : 8;
		uint32_t data_7                  : 8;
		uint32_t data_8                  : 8;
#else
		uint32_t data_8                  : 8;
		uint32_t data_7                  : 8;
		uint32_t data_6                  : 8;
		uint32_t data_5                  : 8;
#endif
	} s;
};

union ctu_can_fd_data_9_12_w {
	uint32_t u32;
	struct ctu_can_fd_data_9_12_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_9_12_W */
		uint32_t data_9                  : 8;
		uint32_t data_10                 : 8;
		uint32_t data_11                 : 8;
		uint32_t data_12                 : 8;
#else
		uint32_t data_12                 : 8;
		uint32_t data_11                 : 8;
		uint32_t data_10                 : 8;
		uint32_t data_9                  : 8;
#endif
	} s;
};

union ctu_can_fd_data_13_16_w {
	uint32_t u32;
	struct ctu_can_fd_data_13_16_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_13_16_W */
		uint32_t data_13                 : 8;
		uint32_t data_14                 : 8;
		uint32_t data_15                 : 8;
		uint32_t data_16                 : 8;
#else
		uint32_t data_16                 : 8;
		uint32_t data_15                 : 8;
		uint32_t data_14                 : 8;
		uint32_t data_13                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_17_20_w {
	uint32_t u32;
	struct ctu_can_fd_data_17_20_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_17_20_W */
		uint32_t data_17                 : 8;
		uint32_t data_18                 : 8;
		uint32_t data_19                 : 8;
		uint32_t data_20                 : 8;
#else
		uint32_t data_20                 : 8;
		uint32_t data_19                 : 8;
		uint32_t data_18                 : 8;
		uint32_t data_17                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_21_24_w {
	uint32_t u32;
	struct ctu_can_fd_data_21_24_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_21_24_W */
		uint32_t data_21                 : 8;
		uint32_t data_22                 : 8;
		uint32_t data_23                 : 8;
		uint32_t data_24                 : 8;
#else
		uint32_t data_24                 : 8;
		uint32_t data_23                 : 8;
		uint32_t data_22                 : 8;
		uint32_t data_21                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_25_28_w {
	uint32_t u32;
	struct ctu_can_fd_data_25_28_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_25_28_W */
		uint32_t data_25                 : 8;
		uint32_t data_26                 : 8;
		uint32_t data_27                 : 8;
		uint32_t data_28                 : 8;
#else
		uint32_t data_28                 : 8;
		uint32_t data_27                 : 8;
		uint32_t data_26                 : 8;
		uint32_t data_25                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_29_32_w {
	uint32_t u32;
	struct ctu_can_fd_data_29_32_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_29_32_W */
		uint32_t data_29                 : 8;
		uint32_t data_30                 : 8;
		uint32_t data_31                 : 8;
		uint32_t data_32                 : 8;
#else
		uint32_t data_32                 : 8;
		uint32_t data_31                 : 8;
		uint32_t data_30                 : 8;
		uint32_t data_29                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_33_36_w {
	uint32_t u32;
	struct ctu_can_fd_data_33_36_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_33_36_W */
		uint32_t data_33                 : 8;
		uint32_t data_34                 : 8;
		uint32_t data_35                 : 8;
		uint32_t data_36                 : 8;
#else
		uint32_t data_36                 : 8;
		uint32_t data_35                 : 8;
		uint32_t data_34                 : 8;
		uint32_t data_33                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_37_40_w {
	uint32_t u32;
	struct ctu_can_fd_data_37_40_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_37_40_W */
		uint32_t data_37                 : 8;
		uint32_t data_38                 : 8;
		uint32_t data_39                 : 8;
		uint32_t data_40                 : 8;
#else
		uint32_t data_40                 : 8;
		uint32_t data_39                 : 8;
		uint32_t data_38                 : 8;
		uint32_t data_37                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_41_44_w {
	uint32_t u32;
	struct ctu_can_fd_data_41_44_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_41_44_W */
		uint32_t data_41                 : 8;
		uint32_t data_42                 : 8;
		uint32_t data_43                 : 8;
		uint32_t data_44                 : 8;
#else
		uint32_t data_44                 : 8;
		uint32_t data_43                 : 8;
		uint32_t data_42                 : 8;
		uint32_t data_41                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_45_48_w {
	uint32_t u32;
	struct ctu_can_fd_data_45_48_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_45_48_W */
		uint32_t data_45                 : 8;
		uint32_t data_46                 : 8;
		uint32_t data_47                 : 8;
		uint32_t data_48                 : 8;
#else
		uint32_t data_48                 : 8;
		uint32_t data_47                 : 8;
		uint32_t data_46                 : 8;
		uint32_t data_45                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_49_52_w {
	uint32_t u32;
	struct ctu_can_fd_data_49_52_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_49_52_W */
		uint32_t data_49                 : 8;
		uint32_t data_50                 : 8;
		uint32_t data_51                 : 8;
		uint32_t data_52                 : 8;
#else
		uint32_t data_52                 : 8;
		uint32_t data_51                 : 8;
		uint32_t data_50                 : 8;
		uint32_t data_49                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_53_56_w {
	uint32_t u32;
	struct ctu_can_fd_data_53_56_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_53_56_W */
		uint32_t data_53                 : 8;
		uint32_t data_56                 : 8;
		uint32_t data_55                 : 8;
		uint32_t data_54                 : 8;
#else
		uint32_t data_54                 : 8;
		uint32_t data_55                 : 8;
		uint32_t data_56                 : 8;
		uint32_t data_53                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_57_60_w {
	uint32_t u32;
	struct ctu_can_fd_data_57_60_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_57_60_W */
		uint32_t data_57                 : 8;
		uint32_t data_58                 : 8;
		uint32_t data_59                 : 8;
		uint32_t data_60                 : 8;
#else
		uint32_t data_60                 : 8;
		uint32_t data_59                 : 8;
		uint32_t data_58                 : 8;
		uint32_t data_57                 : 8;
#endif
	} s;
};

union ctu_can_fd_data_61_64_w {
	uint32_t u32;
	struct ctu_can_fd_data_61_64_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* DATA_61_64_W */
		uint32_t data_61                 : 8;
		uint32_t data_62                 : 8;
		uint32_t data_63                 : 8;
		uint32_t data_64                 : 8;
#else
		uint32_t data_64                 : 8;
		uint32_t data_63                 : 8;
		uint32_t data_62                 : 8;
		uint32_t data_61                 : 8;
#endif
	} s;
};

union ctu_can_fd_frame_test_w {
	uint32_t u32;
	struct ctu_can_fd_frame_test_w_s {
#ifdef __LITTLE_ENDIAN_BITFIELD
  /* FRAME_TEST_W */
		uint32_t fstc                    : 1;
		uint32_t fcrc                    : 1;
		uint32_t sdlc                    : 1;
		uint32_t reserved_7_3            : 5;
		uint32_t tprm                    : 5;
		uint32_t reserved_31_13         : 19;
#else
		uint32_t reserved_31_13         : 19;
		uint32_t tprm                    : 5;
		uint32_t reserved_7_3            : 5;
		uint32_t sdlc                    : 1;
		uint32_t fcrc                    : 1;
		uint32_t fstc                    : 1;
#endif
	} s;
};

#endif
