/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef PROCESS_STREAMBUF_H
#define PROCESS_STREAMBUF_H

#include <streambuf>
#include <list>
#include <cstring>

namespace PdCom {

class Process;

/****************************************************************************/

/** Stream buffer implementation for Process.
 */

class ProcessStreambuf:
    public std::streambuf
{
    public:
        ProcessStreambuf(
                Process *process,
                unsigned int buflen = 4096,
                unsigned int max_buffers = 0
                );
        virtual ~ProcessStreambuf();

        bool hasData() const;
        int writeReady();
        void reset();

    private:
        Process * const process;

        const unsigned int buflen;
        const unsigned int max_buffers;

        int new_page();

        // Output functions reimplemented from streambuf
        std::streamsize xsputn(const char *s, std::streamsize n);
        int overflow(int c);
        int sync();

        char *wptr;     // Write pointer of the output
        char *wbuf;     // Current write buffer
        char *ibuf;     // Current input buffer

        typedef std::list<char *> BufferList;
        // Buffer list.
        // Output buffer is the first buffer
        // Input buffer is the last buffer
        BufferList buf;
};

} // namespace PdCom

#endif // PROCESS_OSTREAM_H

/****************************************************************************/
