/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef MSRPARAM_H
#define MSRPARAM_H

#include "MsrVariable.h"
#include "pdcom/Exception.h"

#include <list>
#include <set>

namespace MSRProto {

class ProtocolHandler;

/****************************************************************************/

/** MSR parameter.
 */

class Param: public Variable {
    friend class ProtocolHandler;

    public:
        Param(
                ProtocolHandler *protocolhandler,
                std::ostream *os,
                const char *name,
                unsigned int index,
                unsigned int rnum,
                unsigned int cnum,
                const char *orientation,
                unsigned int flags,
                unsigned int datasize,
                const char *unit,
                const char *datatype);
        ~Param();

    private:
        void requestParameter();

        bool pollActive;
        bool requestActive;
        bool subscribed;

        /** New parameter values.
         *
         * Called by MSR Parser when parameter data has arrived
         * */
        void newValues(const char *t, const char *buf);

        /** Signal from the MSR process that the parameter has changed */
        void parameterUpdate();

        static const char *hexvalues[];
        bool binparameters;
        bool pushparameters;
        bool pmtime;

        /* Reimplemented from baseclass */
        unsigned int addTransmissionInterval(double interval);
        void rmTransmissionDecimation(int decimation);
        void pollVariable();
        void valueChanged(const char* src, size_t n);
};

} // namespace MSRProto

#endif // MSRPARAM_H

/****************************************************************************/
