/*****************************************************************************
 *
 * Copyright (C) 2021 Richard Hacker (lerichi at gmx dot net),
 *                    Florian Pose (fp at igh dot de),
 *                    Bjarne von Horn (vh at igh dot de).
 *
 * This file is part of the QtPdCom library.
 *
 * The QtPdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The QtPdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the QtPdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

/** @file */

#ifndef PDCOM5_SELECTOR_H
#define PDCOM5_SELECTOR_H

#include <memory>
#include <vector>

/****************************************************************************/

namespace PdCom {

namespace impl {
    struct Selector;
}

class Selector
{
    std::shared_ptr<const impl::Selector> impl_;

    public:
        Selector();
        Selector(std::shared_ptr<const impl::Selector> impl) :
            impl_(std::move(impl))
        {}
};

struct ScalarSelector: Selector
{
    ScalarSelector(std::vector<int> indices);
};

} // namespace PdCom

/****************************************************************************/

#endif
