# EtherLab Message Tool

This command-line tool helps you manage user-facing messages and translations
for real-time processes communicating via
[PdServ](https://gitlab.com/etherlab.org/pdserv). It enables editing,
importing, exporting, and transforming message definitions in XML and YAML
formats.

## Version History

- Version 1.2

    - PdServ YAML import with `--import-pdserv`
    - Export plain messages as YAML alternatively with `--export-yaml`.

- Version 1.1

    - Removed /time extensions
    - Added option for not using fragment selector
    - Use index attribute for vector messages
    - Added testing infrastructure


## Messaging Workflow

![Messaging Workflow](doc/etherlab-messaging.png "Messaging Workflow")

### Editing

The editing of the messages and their translatations takes place in the file
messages.xml using an XML or text editor. The [format is described
below](#xml-format-and-features).

### Import

A list of PdServ events (messages) can be exported directly from a running
PdServ instance using

- the function call `pdserv_event_export()`
- or on process startup using the `eventexport` variable in the
  configuration file.

The exported messages (here `pdserv-events.yml`) can then be imported via

```sh
etherlab_messages.py --import-pdserv pdserv-events.yml messages.xml
```

This command will insert new messages to `messages.xml` and mark deprecated
entries.

### Export

After editing, a simple list of plain messages can be exported [to plain
XML](#exporting-plain-messages-xml) (`--export-plain`) or [to
YAML](#exporting-plain-messages-yaml) (`--export-yaml`). The YAML format is
preferred. Currently the following tools support loading message translations:

- [QtPdCom](https://gitlab.com/etherlab.org/QtPdCom)::MessageModel [plain XML]
- [Testmanager](https://gitlab.com/etherlab.org/testmanager) (via QtPdCom::MessageModel) [plain XML]
- [Data Logging Service](https://gitlab.com/etherlab.org/dls) [plain XML]
- [PdServ](https://gitlab.com/etherlab.org/pdserv) [YAML]

## Git Integration

This repository uses [Pre-Commit](https://pre-commit.com/) hooks. Before committing, ensure you have the hooks installed:

```sh
pre-commit install
pre-commit run
```

## XML Format and Features

Here is a simple example of the XML format used for the message definition
file containing one message with translations for two languages.

```xml
<?xml version="1.0" encoding="utf-8"?>
<EtherLabMessages>
  <NodeGroup>
    <Node name="Io"/>
    <NodeGroup>
      <Node name="BusMonitor"/>
      <NodeGroup type="Error">
        <Node name="Error"/>
        <Text lang="en">Fieldbus failure on hydraulic panel</Text>
        <Text lang="de">Feldbus gestört am Hydraulik-Panel</Text>
        <Description lang="en">A description</Description>
        <Description lang="de">Eine Beschreibung</Description>
      </NodeGroup>
    </NodeGroup>
  </NodeGroup>
</EtherLabMessages>
```

## Exporting Plain Messages XML

The messages definitions can be exported to a broken-down flat message list
(`EtherLabPlainMessages` XML) with the `--export-plain` option:

```sh
etherlab_messages.py --export-plain plainmessages.xml messages.xml
```

The encoding of the exported plain text file can be specified with the
`--plain-encoding` option.

The above example will result in the following file, which is understood by
the [QtPdCom](https://gitlab.com/etherlab.org/qtpdcom)::MessageModel,
and thus [TestManager](https://gitlab.com/etherlab.org/testmanager).
[DLS](https://gitlab.com/etherlab.org/dls) also supports it.

```xml
<?xml version="1.0" encoding="utf-8"?>
<EtherLabPlainMessages>
  <Message variable="/Io/BusMonitor/Error" type="Error">
    <Text>
      <Translation lang="en">Fieldbus failure on hydraulic panel</Translation>
      <Translation lang="de">Feldbus gestört am Hydraulik-Panel</Translation>
    </Text>
    <Description>
      <Translation lang="en">A description</Translation>
      <Translation lang="de">Eine Beschreibung</Translation>
    </Description>
  </Message>
</EtherLabPlainMessages>
```

## Exporting Plain Messages YAML

The messages definitions can also be exported to a broken-down flat message list
(`EtherLabPlainMessages` YAML) with the `--export-yaml` option:

```sh
etherlab_messages.py --export-yaml plainmessages.yml messages.xml
```

The encoding of the exported plain YAML file is always UTF-8.

The above example will result in the following file, which is understood by the
[PdServ](https://gitlab.com/etherlab.org/pdserv) using the `importmessages`
variable in the configuration file.

```yaml
content: EtherLabPlainMessages
version: 1
messages:
- path: /Io/BusMonitor/Error
  type: Error
  elements:
  - text:
      en: Fieldbus failure on hydraulic panel
      de: Feldbus gestört am Hydraulik-Panel
    description:
      en: A description
      de: Eine Beschreibung
```

### Variables

Variables can be defined on a `<Node>` using the `<Var>` element. They can be
later on replaced using the `<Arg>` element. This helps defining messages with
different text for similar subsystems.

```xml
<EtherLabMessages>
  <NodeGroup>
    <Node name="Green">
      <Var key="color">
        <Text lang="en">Green</Text>
      </Var>
    </Node>
    <Node name="Yellow">
      <Var key="color">
        <Text lang="en">Yellow</Text>
      </Var>
    </Node>
    <NodeGroup>
      <Node name="BusMonitor"/>
      <NodeGroup type="Error">
        <Node name="Error"/>
        <Text lang="en">Fieldbus failure on panel <Arg key="color"/></Text>
        <Description lang="en">A description</Description>
      </NodeGroup>
    </NodeGroup>
  </NodeGroup>
</EtherLabMessages>
```

This will create two messages of type `Error`:

| Path | (English) Text |
| ---  | --- |
`/Green/BusMonitor/Error` | Fieldbus failure on panel Green |
`/Yellow/BusMonitor/Error` | Fieldbus failure on panel Yellow |

See [the exported file](tests/plainmessages_var.xml) for this file.

## Arrays

Arrays can be defined in a document using the `<Array>` element. They can be
later on replaced in vector messages (`<NodeGroup>`s with `width` > 1) using
the `<Map>` element. The index of the vector component can also be referenced with the `<Index>` element (with an optional `offset` attribute).

```xml
<?xml version="1.0" encoding="utf-8"?>
<EtherLabMessages>
  <Array key="color">
    <Entry>
      <Text lang="de">Gelb</Text>
    </Entry>
    <Entry>
      <Text lang="de">Grün</Text>
    </Entry>
  </Array>
  <NodeGroup>
    <Node name="Io"/>
    <NodeGroup>
      <Node name="BusMonitor"/>
      <NodeGroup type="Error" width="2">
        <Node name="Error"/>
        <Text lang="de">Feldbus gestört an Panel <Map key="color"/></Text>
        <Description lang="de">Eine Beschreibung</Description>
      </NodeGroup>
    </NodeGroup>
  </NodeGroup>
</EtherLabMessages>
```

This will create two messages of type `Error`:

| Path | (English) Text |
| ---  | --- |
`/Io/BusMonitor/Error/0` | Feldbus gestört an Panel Gelb |
`/Io/BusMonitor/Error/1` | Feldbus gestört an Panel Grün |

See [the exported file](tests/plainmessages_array.xml) for this file.

## Importing from Text Files

> [!caution] This section documents a former approach.
> A better way is to import messages from a YAML document originating from
> PdServ ([see Import](#import)).

To update the message definitions, `etherlab_messages.py` is also able to
import a plain text file (UTF-8 encoded) with message paths and types. The file
must contain one row per message, using two columns, separated by whitespace.
The first column contains the message path, while second column contains the
type. Possible types are

| Type  | Additional aliases allowed during plain-text import |
| ---   | --- |
| `Error` | `Critical`, `CritError` |
| `Warning` | `Warn` |
| `Information` | `Info` |

```
/Tank/TemperatureLow Warning
/Tank/LevelHigh Error
```

The file can then be imported into the message definition file `messages.xml`
with the command `etherlab_messages.py -i plain_file.txt messages.xml`.
