/*****************************************************************************
 *
 * Testmanager - Graphical Automation and Visualisation Tool
 *
 * Copyright (C) 2023  Daniel Ramirez <dr@igh.de>
 *
 * This file is part of Testmanager.
 *
 * Testmanager is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * Testmanager is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with Testmanager. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef PD_PARAMETER_H
#define PD_PARAMETER_H

#include <QtPdCom1/ScalarSubscriber.h>
#include <QtPdCom1/Process.h>

#include <QUrl>

namespace Pd
{
    class ParameterSetWidget;

    /************************************************************************/

    class Parameter:
        public QObject, public QtPdCom::ScalarSubscriber
    {
        Q_OBJECT

      public:
        Parameter(Pd::ParameterSetWidget *);
        virtual ~Parameter();

        QUrl url;
        QString connectionPath;

        void fromJson(const QJsonValue &);

        void replaceUrl(const QUrl &, const QUrl &);

        bool hasData() const { return dataPresent; }

        double getSavedValue() const { return savedValue; }
        double getCurrentValue() const { return currentValue; }

        void connectParameter(QtPdCom::Process *);

      signals:
        void dataChanged();

      private:
        Pd::ParameterSetWidget * const widget;
        bool dataPresent;
        double savedValue;
        double currentValue;

        // virtual from QtPdCom::ScalarSubscriber
        void newValues(std::chrono::nanoseconds) override;
        void stateChange(PdCom::Subscription::State) override;

        Parameter();
    };

    /************************************************************************/

}  // namespace Pd

#endif
