/*****************************************************************************
 *
 * Copyright (C) 2022  Florian Pose <fp@igh.de>
 *
 * This file is part of the QtPdCom library.
 *
 * The QtPdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The QtPdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the QtPdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "Transmission.h"

#include <QString>

#include <sstream>

using namespace QtPdCom;

/****************************************************************************/

PdCom::Transmission Transmission::toPdCom() const
{
    switch (mode_) {
        case Poll:
        case ManualPoll:
        default:
            return {PdCom::poll_mode};
        case Event:
            return {PdCom::event_mode};
        case Continuous:
            return {std::chrono::duration<double>(interval_)};
    }
}

/****************************************************************************/

QString Transmission::toString() const
{
    switch (mode_) {
        case Poll:
        default:
            return QString("poll(%1)").arg(interval_);
        case ManualPoll:
            return QString("manual_poll");
        case Event:
            return QString("event");
        case Continuous:
            return QString("cont(%1)").arg(interval_);
    }
}

/****************************************************************************/
