/*****************************************************************************
 *
 * Testmanager - Graphical Automation and Visualisation Tool
 *
 * Copyright (C) 2025  Florian Pose <fp@igh.de>
 *
 * This file is part of Testmanager.
 *
 * Testmanager is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * Testmanager is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with Testmanager. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "DetachedDockWidget.h"

#include "MainWindow.h"
#include "DetachableTabWidget.h"

/****************************************************************************/

DetachedDockWidget::DetachedDockWidget(MainWindow *mainWindow):
    QDockWidget(mainWindow),
    mainWindow(mainWindow),
    attachOnClose {true}
{
    editModeChanged();  // update features
}

/****************************************************************************/

void DetachedDockWidget::setAttachOnClose(bool attach)
{
    attachOnClose = attach;
}

/****************************************************************************/

void DetachedDockWidget::editModeChanged()
{
    QDockWidget::DockWidgetFeatures features {
            QDockWidget::NoDockWidgetFeatures};

    if (mainWindow->getEditMode()) {
        features |= QDockWidget::DockWidgetClosable;
        features |= QDockWidget::DockWidgetMovable;
        features |= QDockWidget::DockWidgetFloatable;
    }

    setFeatures(features);
}

/****************************************************************************/

void DetachedDockWidget::closeEvent(QCloseEvent *event)
{
    if (attachOnClose) {
        mainWindow->getTabWidget()->attachTab(this);
        event->ignore();
    }
    else {
        event->accept();
    }
}

/****************************************************************************/
