/*****************************************************************************
 *
 * $Id$
 *
 * Copyright (C) 2009 - 2012  Richard Hacker <lerich@gmx.net>
 *                            Florian Pose <fp@igh-essen.com>
 *
 * This file is part of the PdCom library.
 *
 * The PdCom library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The PdCom library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the PdCom Library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "pdcom/Variable.h"

#define DEBUG_CONVERSIONS 0

#if DEBUG_CONVERSIONS
#include <iostream>
using std::cout;
using std::cerr;
using std::endl;
#endif

using namespace PdCom;

// **************   bool_t -> ***************************
void Variable::boolToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToBool" << endl;
#endif
    //(dst, src, datawidth[bool_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = ((bool*)src)[i];
    }
}
void Variable::boolToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((bool*)src)[i] == true);
    }
}
void Variable::boolToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((bool*)src)[i]);
    }
}
void Variable::boolToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((bool*)src)[i]);
    }
}
void Variable::write_boolToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( ((((bool*)src)[i] == true) - scale->offset) /
                    scale->gain
                 );
    }
}
void Variable::write_boolToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( ((((bool*)src)[i] == true) - scale->offset) /
                    scale->gain
                  );
    }
}
void Variable::read_boolToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((bool*)src)[i] == true)
                    + scale->offset
                 );
    }
}
void Variable::read_boolToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "boolToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((bool*)src)[i] == true)
                    + scale->offset
                  );
    }
}

// **************   uint8_t -> ***************************
void Variable::uint8ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((uint8_t*)src)[i]) ? true : false;
    }
}
void Variable::uint8ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToUint8" << endl;
#endif
    //(dst, src, datawidth[uint8_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = ((uint8_t*)src)[i];
    }
}
void Variable::uint8ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((uint8_t*)src)[i]);
    }
}
void Variable::uint8ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((uint8_t*)src)[i]);
    }
}
void Variable::write_uint8ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float((((uint8_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_uint8ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double((((uint8_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_uint8ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float(scale->gain * (((uint8_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_uint8ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint8ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((uint8_t*)src)[i]) + scale->offset);
    }
}

// **************   int8_t -> ***************************
void Variable::sint8ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((int8_t*)src)[i]) ? true : false;
    }
}
void Variable::sint8ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToSint8" << endl;
#endif
    //(dst, src, datawidth[sint8_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = ((int8_t*)src)[i];
    }
}
void Variable::sint8ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((int8_t*)src)[i]);
    }
}
void Variable::sint8ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((int8_t*)src)[i]);
    }
}
void Variable::write_sint8ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((int8_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_sint8ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((int8_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_sint8ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((int8_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_sint8ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint8ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((int8_t*)src)[i]) + scale->offset);
    }
}

// **************   uint16_t -> ***************************
void Variable::uint16ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((uint16_t*)src)[i]) ? true : false;
    }
}
void Variable::uint16ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToUint16" << endl;
#endif
    //(dst, src, datawidth[uint16_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = ((uint16_t*)src)[i];
    }
}
void Variable::uint16ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((uint16_t*)src)[i]);
    }
}
void Variable::uint16ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((uint16_t*)src)[i]);
    }
}
void Variable::write_uint16ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((uint16_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_uint16ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((uint16_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_uint16ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((uint16_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_uint16ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint16ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((uint16_t*)src)[i]) + scale->offset);
    }
}

// **************   int16_t -> ***************************
void Variable::sint16ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((int16_t*)src)[i]) ? true : false;
    }
}
void Variable::sint16ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToSint16" << endl;
#endif
    //(dst, src, datawidth[sint16_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = ((int16_t*)src)[i];
    }
}
void Variable::sint16ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((int16_t*)src)[i]);
    }
}
void Variable::sint16ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((int16_t*)src)[i]);
    }
}
void Variable::write_sint16ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((int16_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_sint16ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((int16_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_sint16ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((int16_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_sint16ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint16ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((int16_t*)src)[i]) + scale->offset);
    }
}

// **************   uint32_t -> ***************************
void Variable::uint32ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((uint32_t*)src)[i]) ? true : false;
    }
}
void Variable::uint32ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToUint32" << endl;
#endif
    //(dst, src, datawidth[uint32_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = ((uint32_t*)src)[i];
    }
}
void Variable::uint32ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((uint32_t*)src)[i]);
    }
}
void Variable::uint32ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((uint32_t*)src)[i]);
    }
}
void Variable::write_uint32ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((uint32_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_uint32ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((uint32_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_uint32ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((uint32_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_uint32ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint32ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((uint32_t*)src)[i]) + scale->offset);
    }
}

// **************   int32_t -> ***************************
void Variable::sint32ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((int32_t*)src)[i]) ? true : false;
    }
}
void Variable::sint32ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToSint32" << endl;
#endif
    //(dst, src, datawidth[sint32_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = ((int32_t*)src)[i];
    }
}
void Variable::sint32ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((int32_t*)src)[i]);
    }
}
void Variable::sint32ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((int32_t*)src)[i]);
    }
}
void Variable::write_sint32ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((int32_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_sint32ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((int32_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_sint32ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((int32_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_sint32ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint32ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((int32_t*)src)[i]) + scale->offset);
    }
}

// **************   uint64_t -> ***************************
void Variable::uint64ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((uint64_t*)src)[i]) ? true : false;
    }
}
void Variable::uint64ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToUint64" << endl;
#endif
    //(dst, src, datawidth[uint64_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = ((uint64_t*)src)[i];
    }
}
void Variable::uint64ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((uint64_t*)src)[i]);
    }
}
void Variable::uint64ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((uint64_t*)src)[i]);
    }
}
void Variable::write_uint64ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((uint64_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_uint64ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((uint64_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_uint64ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((uint64_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_uint64ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "uint64ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((uint64_t*)src)[i]) + scale->offset);
    }
}

// **************   int64_t -> ***************************
void Variable::sint64ToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((int64_t*)src)[i]) ? true : false;
    }
}
void Variable::sint64ToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToSint64" << endl;
#endif
    //(dst, src, datawidth[sint64_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = ((int64_t*)src)[i];
    }
}
void Variable::sint64ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float(((int64_t*)src)[i]);
    }
}
void Variable::sint64ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double(((int64_t*)src)[i]);
    }
}
void Variable::write_sint64ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((int64_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_sint64ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((int64_t*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::read_sint64ToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((int64_t*)src)[i]) + scale->offset);
    }
}
void Variable::read_sint64ToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "sint64ToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((int64_t*)src)[i]) + scale->offset);
    }
}

// **************   single_t -> ***************************
void Variable::singleToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = ((float*)src)[i] ? true : false;
    }
}
void Variable::singleToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t( ((float*)src)[i]);
    }
}
void Variable::singleToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t( ((float*)src)[i]);
    }
}
void Variable::singleToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t( ((float*)src)[i]);
    }
}
void Variable::singleToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t( ((float*)src)[i]);
    }
}
void Variable::singleToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t( ((float*)src)[i]);
    }
}
void Variable::singleToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t( ((float*)src)[i]);
    }
}
void Variable::singleToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t( ((float*)src)[i]);
    }
}
void Variable::singleToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t( ((float*)src)[i]);
    }
}
void Variable::singleToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSingle" << endl;
#endif
    //(dst, src, datawidth[single_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = ((float*)src)[i];
    }
}
void Variable::singleToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = double( ((float*)src)[i]);
    }
}
void Variable::write_singleToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((float*)src)[i] - scale->offset)
            ? true : false;
    }
}
void Variable::write_singleToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] =
            uint8_t( (((float*)src)[i] - scale->offset) / scale->gain);
    }
}
void Variable::write_singleToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] =
            int8_t( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] =
            uint16_t( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] =
            int16_t( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] =
            uint32_t( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] =
            int32_t( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] =
            uint64_t( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] =
            int64_t( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_singleToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((float*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::read_singleToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((float*)src)[i] + scale->offset) ? true : false;
    }
}
void Variable::read_singleToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] =
            uint8_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] =
            int8_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] =
            uint16_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] =
            int16_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] =
            uint32_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] =
            int32_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] =
            uint64_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] =
            int64_t( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}
void Variable::read_singleToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "singleToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((float*)src)[i]) + scale->offset);
    }
}


// **************   double_t -> ***************************
void Variable::doubleToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = ((double*)src)[i] ? true : false;
    }
}
void Variable::doubleToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] = uint8_t( ((double*)src)[i]);
    }
}
void Variable::doubleToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] = int8_t( ((double*)src)[i]);
    }
}
void Variable::doubleToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] = uint16_t( ((double*)src)[i]);
    }
}
void Variable::doubleToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] = int16_t( ((double*)src)[i]);
    }
}
void Variable::doubleToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] = uint32_t( ((double*)src)[i]);
    }
}
void Variable::doubleToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] = int32_t( ((double*)src)[i]);
    }
}
void Variable::doubleToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] = uint64_t( ((double*)src)[i]);
    }
}
void Variable::doubleToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] = int64_t( ((double*)src)[i]);
    }
}
void Variable::doubleToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] = float( ((double*)src)[i]);
    }
}
void Variable::doubleToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToDouble" << endl;
#endif
    //(dst, src, datawidth[double_T] * count);
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] = ((double*)src)[i];
    }
}
void Variable::write_doubleToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((double*)src)[i] - scale->offset)
            ? true : false;
    }
}
void Variable::write_doubleToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] =
            uint8_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] =
            int8_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] =
            uint16_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] =
            int16_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] =
            uint32_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] =
            int32_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] =
            uint64_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] =
            int64_t( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::write_doubleToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( (((double*)src)[i] - scale->offset) / scale->gain );
    }
}
void Variable::read_doubleToBool( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToBool" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((bool*)dst)[i] = (((double*)src)[i] + scale->offset) ? true : false;
    }
}
void Variable::read_doubleToUint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint8_t*)dst)[i] =
            uint8_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToSint8( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint8" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int8_t*)dst)[i] =
            int8_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToUint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint16_t*)dst)[i] =
            uint16_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToSint16( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint16" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int16_t*)dst)[i] =
            int16_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToUint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint32_t*)dst)[i] =
            uint32_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToSint32( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint32" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int32_t*)dst)[i] =
            int32_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToUint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToUint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((uint64_t*)dst)[i] =
            uint64_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToSint64( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSint64" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((int64_t*)dst)[i] =
            int64_t( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToSingle( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToSingle" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((float*)dst)[i] =
            float( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}
void Variable::read_doubleToDouble( const void *src, void *dst, size_t count,
        const Variable::Scale *scale)
{
#if DEBUG_CONVERSIONS
    cerr << "doubleToDouble" << endl;
#endif
    for (unsigned int i = 0; i < count; i++) {
        ((double*)dst)[i] =
            double( scale->gain * (((double*)src)[i]) + scale->offset);
    }
}


// ***** DEPENDS ON dtype_d *****
// Usage: read_convert[rt_dtype][user_dtype]
const Variable::convert_t Variable::read_convert[11][11] = {
    {   boolToBool,
        boolToUint8,      boolToSint8,
        boolToUint16,     boolToSint16,
        boolToUint32,     boolToSint32,
        boolToUint64,     boolToSint64,
        read_boolToSingle, read_boolToDouble,
    },
    {   uint8ToBool,
        uint8ToUint8,      uint8ToSint8,
        uint8ToUint16,     uint8ToSint16,
        uint8ToUint32,     uint8ToSint32,
        uint8ToUint64,     uint8ToSint64,
        read_uint8ToSingle, read_uint8ToDouble,
    },
    {   sint8ToBool,
        sint8ToUint8,      sint8ToSint8,
        sint8ToUint16,     sint8ToSint16,
        sint8ToUint32,     sint8ToSint32,
        sint8ToUint64,     sint8ToSint64,
        read_sint8ToSingle, read_sint8ToDouble,
    },
    {   uint16ToBool,
        uint16ToUint8,      uint16ToSint8,
        uint16ToUint16,     uint16ToSint16,
        uint16ToUint32,     uint16ToSint32,
        uint16ToUint64,     uint16ToSint64,
        read_uint16ToSingle, read_uint16ToDouble,
    },
    {   sint16ToBool,
        sint16ToUint8,      sint16ToSint8,
        sint16ToUint16,     sint16ToSint16,
        sint16ToUint32,     sint16ToSint32,
        sint16ToUint64,     sint16ToSint64,
        read_sint16ToSingle, read_sint16ToDouble,
    },
    {   uint32ToBool,
        uint32ToUint8,      uint32ToSint8,
        uint32ToUint16,     uint32ToSint16,
        uint32ToUint32,     uint32ToSint32,
        uint32ToUint64,     uint32ToSint64,
        read_uint32ToSingle, read_uint32ToDouble,
    },
    {   sint32ToBool,
        sint32ToUint8,      sint32ToSint8,
        sint32ToUint16,     sint32ToSint16,
        sint32ToUint32,     sint32ToSint32,
        sint32ToUint64,     sint32ToSint64,
        read_sint32ToSingle, read_sint32ToDouble,
    },
    {   uint64ToBool,
        uint64ToUint8,      uint64ToSint8,
        uint64ToUint16,     uint64ToSint16,
        uint64ToUint32,     uint64ToSint32,
        uint64ToUint64,     uint64ToSint64,
        read_uint64ToSingle, read_uint64ToDouble,
    },
    {   sint64ToBool,
        sint64ToUint8,      sint64ToSint8,
        sint64ToUint16,     sint64ToSint16,
        sint64ToUint32,     sint64ToSint32,
        sint64ToUint64,     sint64ToSint64,
        read_sint64ToSingle, read_sint64ToDouble,
    },
    {   read_singleToBool,
        read_singleToUint8,  read_singleToSint8,
        read_singleToUint16, read_singleToSint16,
        read_singleToUint32, read_singleToSint32,
        read_singleToUint64, read_singleToSint64,
        read_singleToSingle, read_singleToDouble,
    },
    {   read_doubleToBool,
        read_doubleToUint8,  read_doubleToSint8,
        read_doubleToUint16, read_doubleToSint16,
        read_doubleToUint32, read_doubleToSint32,
        read_doubleToUint64, read_doubleToSint64,
        read_doubleToSingle, read_doubleToDouble,
    },
};

// ***** DEPENDS ON dtype_d *****
// Usage: write_convert[rt_dtype][user_dtype]
const Variable::convert_t Variable::write_convert[11][11] = {
    {          boolToBool,
              uint8ToBool,           sint8ToBool,
             uint16ToBool,          sint16ToBool,
             uint32ToBool,          sint32ToBool,
             uint64ToBool,          sint64ToBool,
       write_singleToBool,    write_doubleToBool,
    },
    {         boolToUint8,
             uint8ToUint8,          sint8ToUint8,
            uint16ToUint8,         sint16ToUint8,
            uint32ToUint8,         sint32ToUint8,
            uint64ToUint8,         sint64ToUint8,
      write_singleToUint8,   write_doubleToUint8,
    },
    {         boolToSint8,
             uint8ToSint8,          sint8ToSint8,
            uint16ToSint8,         sint16ToSint8,
            uint32ToSint8,         sint32ToSint8,
            uint64ToSint8,         sint64ToSint8,
      write_singleToSint8,   write_doubleToSint8,
    },
    {         boolToUint16,
             uint8ToUint16,        sint8ToUint16,
            uint16ToUint16,       sint16ToUint16,
            uint32ToUint16,       sint32ToUint16,
            uint64ToUint16,       sint64ToUint16,
      write_singleToUint16, write_doubleToUint16,
    },
    {         boolToSint16,
             uint8ToSint16,        sint8ToSint16,
            uint16ToSint16,       sint16ToSint16,
            uint32ToSint16,       sint32ToSint16,
            uint64ToSint16,       sint64ToSint16,
      write_singleToSint16, write_doubleToSint16,
    },
    {         boolToUint32,
             uint8ToUint32,        sint8ToUint32,
            uint16ToUint32,       sint16ToUint32,
            uint32ToUint32,       sint32ToUint32,
            uint64ToUint32,       sint64ToUint32,
      write_singleToUint32, write_doubleToUint32,
    },
    {         boolToSint32,
             uint8ToSint32,        sint8ToSint32,
            uint16ToSint32,       sint16ToSint32,
            uint32ToSint32,       sint32ToSint32,
            uint64ToSint32,       sint64ToSint32,
      write_singleToSint32, write_doubleToSint32,
    },
    {         boolToUint64,
             uint8ToUint64,        sint8ToUint64,
            uint16ToUint64,       sint16ToUint64,
            uint32ToUint64,       sint32ToUint64,
            uint64ToUint64,       sint64ToUint64,
      write_singleToUint64, write_doubleToUint64,
    },
    {         boolToSint64,
             uint8ToSint64,        sint8ToSint64,
            uint16ToSint64,       sint16ToSint64,
            uint32ToSint64,       sint32ToSint64,
            uint64ToSint64,       sint64ToSint64,
      write_singleToSint64, write_doubleToSint64,
    },
    {     write_boolToSingle,
         write_uint8ToSingle,  write_sint8ToSingle,
        write_uint16ToSingle, write_sint16ToSingle,
        write_uint32ToSingle, write_sint32ToSingle,
        write_uint64ToSingle, write_sint64ToSingle,
        write_singleToSingle, write_doubleToSingle,
    },
    {     write_boolToDouble,
         write_uint8ToDouble,  write_sint8ToDouble,
        write_uint16ToDouble, write_sint16ToDouble,
        write_uint32ToDouble, write_sint32ToDouble,
        write_uint64ToDouble, write_sint64ToDouble,
        write_singleToDouble, write_doubleToDouble,
    },
};

// ***** DEPENDS ON dtype_d *****
// Usage: read_convert_noscale[from_dtype][to_dtype]
const Variable::convert_t Variable::read_convert_noscale[11][11] = {
    {   boolToBool,
        boolToUint8,      boolToSint8,
        boolToUint16,     boolToSint16,
        boolToUint32,     boolToSint32,
        boolToUint64,     boolToSint64,
        boolToSingle,     boolToDouble,
    },
    {   uint8ToBool,
        uint8ToUint8,      uint8ToSint8,
        uint8ToUint16,     uint8ToSint16,
        uint8ToUint32,     uint8ToSint32,
        uint8ToUint64,     uint8ToSint64,
        uint8ToSingle,     uint8ToDouble,
    },
    {   sint8ToBool,
        sint8ToUint8,      sint8ToSint8,
        sint8ToUint16,     sint8ToSint16,
        sint8ToUint32,     sint8ToSint32,
        sint8ToUint64,     sint8ToSint64,
        sint8ToSingle,     sint8ToDouble,
    },
    {   uint16ToBool,
        uint16ToUint8,      uint16ToSint8,
        uint16ToUint16,     uint16ToSint16,
        uint16ToUint32,     uint16ToSint32,
        uint16ToUint64,     uint16ToSint64,
        uint16ToSingle,     uint16ToDouble,
    },
    {   sint16ToBool,
        sint16ToUint8,      sint16ToSint8,
        sint16ToUint16,     sint16ToSint16,
        sint16ToUint32,     sint16ToSint32,
        sint16ToUint64,     sint16ToSint64,
        sint16ToSingle,     sint16ToDouble,
    },
    {   uint32ToBool,
        uint32ToUint8,      uint32ToSint8,
        uint32ToUint16,     uint32ToSint16,
        uint32ToUint32,     uint32ToSint32,
        uint32ToUint64,     uint32ToSint64,
        uint32ToSingle,     uint32ToDouble,
    },
    {   sint32ToBool,
        sint32ToUint8,      sint32ToSint8,
        sint32ToUint16,     sint32ToSint16,
        sint32ToUint32,     sint32ToSint32,
        sint32ToUint64,     sint32ToSint64,
        sint32ToSingle,     sint32ToDouble,
    },
    {   uint64ToBool,
        uint64ToUint8,      uint64ToSint8,
        uint64ToUint16,     uint64ToSint16,
        uint64ToUint32,     uint64ToSint32,
        uint64ToUint64,     uint64ToSint64,
        uint64ToSingle,     uint64ToDouble,
    },
    {   sint64ToBool,
        sint64ToUint8,      sint64ToSint8,
        sint64ToUint16,     sint64ToSint16,
        sint64ToUint32,     sint64ToSint32,
        sint64ToUint64,     sint64ToSint64,
        sint64ToSingle,     sint64ToDouble,
    },
    {   singleToBool,
        singleToUint8,      singleToSint8,
        singleToUint16,     singleToSint16,
        singleToUint32,     singleToSint32,
        singleToUint64,     singleToSint64,
        singleToSingle,     singleToDouble,
    },
    {   doubleToBool,
        doubleToUint8,      doubleToSint8,
        doubleToUint16,     doubleToSint16,
        doubleToUint32,     doubleToSint32,
        doubleToUint64,     doubleToSint64,
        doubleToSingle,     doubleToDouble,
    },
};

// Usage: write_convert_noscale[rt_dtype][user_dtype]
const Variable::convert_t Variable::write_convert_noscale[11][11] = {
    {          boolToBool,
              uint8ToBool,           sint8ToBool,
             uint16ToBool,          sint16ToBool,
             uint32ToBool,          sint32ToBool,
             uint64ToBool,          sint64ToBool,
             singleToBool,          doubleToBool,
    },
    {         boolToUint8,
             uint8ToUint8,          sint8ToUint8,
            uint16ToUint8,         sint16ToUint8,
            uint32ToUint8,         sint32ToUint8,
            uint64ToUint8,         sint64ToUint8,
            singleToUint8,         doubleToUint8,
    },
    {         boolToSint8,
             uint8ToSint8,          sint8ToSint8,
            uint16ToSint8,         sint16ToSint8,
            uint32ToSint8,         sint32ToSint8,
            uint64ToSint8,         sint64ToSint8,
            singleToSint8,         doubleToSint8,
    },
    {         boolToUint16,
             uint8ToUint16,        sint8ToUint16,
            uint16ToUint16,       sint16ToUint16,
            uint32ToUint16,       sint32ToUint16,
            uint64ToUint16,       sint64ToUint16,
            singleToUint16,       doubleToUint16,
    },
    {         boolToSint16,
             uint8ToSint16,        sint8ToSint16,
            uint16ToSint16,       sint16ToSint16,
            uint32ToSint16,       sint32ToSint16,
            uint64ToSint16,       sint64ToSint16,
            singleToSint16,       doubleToSint16,
    },
    {         boolToUint32,
             uint8ToUint32,        sint8ToUint32,
            uint16ToUint32,       sint16ToUint32,
            uint32ToUint32,       sint32ToUint32,
            uint64ToUint32,       sint64ToUint32,
            singleToUint32,       doubleToUint32,
    },
    {         boolToSint32,
             uint8ToSint32,        sint8ToSint32,
            uint16ToSint32,       sint16ToSint32,
            uint32ToSint32,       sint32ToSint32,
            uint64ToSint32,       sint64ToSint32,
            singleToSint32,       doubleToSint32,
    },
    {         boolToUint64,
             uint8ToUint64,        sint8ToUint64,
            uint16ToUint64,       sint16ToUint64,
            uint32ToUint64,       sint32ToUint64,
            uint64ToUint64,       sint64ToUint64,
            singleToUint64,       doubleToUint64,
    },
    {         boolToSint64,
             uint8ToSint64,        sint8ToSint64,
            uint16ToSint64,       sint16ToSint64,
            uint32ToSint64,       sint32ToSint64,
            uint64ToSint64,       sint64ToSint64,
            singleToSint64,       doubleToSint64,
    },
    {           boolToSingle,
               uint8ToSingle,        sint8ToSingle,
              uint16ToSingle,       sint16ToSingle,
              uint32ToSingle,       sint32ToSingle,
              uint64ToSingle,       sint64ToSingle,
              singleToSingle,       doubleToSingle,
    },
    {           boolToDouble,
               uint8ToDouble,        sint8ToDouble,
              uint16ToDouble,       sint16ToDouble,
              uint32ToDouble,       sint32ToDouble,
              uint64ToDouble,       sint64ToDouble,
              singleToDouble,       doubleToDouble,
    },
};

