/*****************************************************************************
 *
 *  Copyright 2010 Richard Hacker (lerichi at gmx dot net)
 *
 *  This file is part of the pdserv library.
 *
 *  The pdserv library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  The pdserv library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with the pdserv library. If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#include "Event.h"
#include "Config.h"

using namespace PdServ;

//////////////////////////////////////////////////////////////////////////////
Event::Event(const char *path, size_t nelem):
    path(path),
    messages(nelem)
{
    if (nelem <= 0) {
        throw std::invalid_argument(
                "Event element count must be greater zero");
    }
}

//////////////////////////////////////////////////////////////////////////////
Event::~Event()
{
}

//////////////////////////////////////////////////////////////////////////////
void Event::setTexts(const char * const *msg)
{
    for (size_t i = 0; i < messages.size(); i++) {
        if (msg and msg[i]) {
            messages[i] = msg[i];
        }
        else {
            messages[i].clear();
        }
    }
}
