#!/bin/bash

BUILD_DIR=build-leap
REPO=$(realpath .)

docker run \
    --rm \
    --interactive \
    --tty \
    --volume $REPO:$REPO \
    --workdir $REPO/$BUILD_DIR \
    --volume /tmp/.X11-unix:/tmp/.X11-unix:rw \
    --user $(id -u):$(id -g) \
    --env DISPLAY=$DISPLAY \
    --env QT_GRAPHICSSYSTEM=native \
    --env XDG_CONFIG_HOME=$REPO/xdg \
    docker:5000/testmanager-leap \
    bash -i
