/*
     This file is part of libhttpserver
     Copyright (C) 2011-2019 Sebastiano Merlino

     This library is free software; you can redistribute it and/or
     modify it under the terms of the GNU Lesser General Public
     License as published by the Free Software Foundation; either
     version 2.1 of the License, or (at your option) any later version.

     This library is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public
     License along with this library; if not, write to the Free Software
     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
     USA
*/

#if !defined (_HTTPSERVER_HPP_INSIDE_) && !defined (HTTPSERVER_COMPILATION)
#error "Only <httpserver.hpp> or <httpserverpp> can be included directly."
#endif

#ifndef _FILE_RESPONSE_HPP_
#define _FILE_RESPONSE_HPP_

#include "httpserver/http_response.hpp"

namespace httpserver
{

class file_response : public http_response
{
    public:
        file_response():
            http_response(),
            filename("")
        {
        }

        explicit file_response(
                const std::string& filename,
                int response_code = http::http_utils::http_ok,
                const std::string& content_type = http::http_utils::text_plain
        ):
            http_response(response_code, content_type),
            filename(filename)
        {
        }

        file_response(const file_response& other):
            http_response(other),
            filename(other.filename)
        {
        }

        file_response(file_response&& other) noexcept:
            http_response(std::move(other)),
            filename(std::move(other.filename))
        {
        }

        file_response& operator=(const file_response& b)
        {
            if (this == &b) return *this;

            (http_response&) (*this) = b;
            this->filename = b.filename;

            return *this;
        }

        file_response& operator=(file_response&& b)
        {
            if (this == &b) return *this;

            (http_response&) (*this) = std::move(b);
            this->filename = std::move(b.filename);

            return *this;
        }

        ~file_response()
        {
        }

        MHD_Response* get_raw_response();

    private:
        std::string filename;
};

}
#endif // _FILE_RESPONSE_HPP_
