// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.


//---------------------------------------------------------------------------

//
// This file is automatically generated.  Please do not edit it directly.
//
// File name: wgx_render_types_generated.h
//---------------------------------------------------------------------------

#pragma once

BEGIN_MILENUM( MilUnit )
    //
    // Each unit is one device pixel.
    //
    Pixel = 2,

    //
    // Each unit is a printer's point, or 1/72 inch.
    //
    Point = 3,

    //
    // Each unit is 1 inch.
    //
    Inch = 4,

    //
    // Each unit is 1/300 inch.
    //
    Document = 5,

    //
    // Each unit is 1 millimeter.
    //
    Millimeter = 6,

    //
    // Each unit is 1/100 millimeter.
    //
    Metafile = 7,

    //
    // Each unit is 1/96 inch.
    //
    WVG = 8,
END_MILENUM

BEGIN_MILENUM( MilLineShape )
    None = 0,
    Square = 1,
    Round = 2,
    Diamond = 3,
    Arrow = 4,
    Custom = 5,
END_MILENUM

BEGIN_MILENUM( MilLineJoin )
    Miter = 0,
    Bevel = 1,
    Round = 2,
    MiterClipped = 3,
END_MILENUM

//
// We may want to add an exclude combine mode later
//
BEGIN_MILENUM( MilClipCombineMode )
    And = 0,
END_MILENUM

BEGIN_MILENUM( MilPathsRelation )
    Unknown = 0,
    Disjoint = 1,
    IsContained = 2,
    Contains = 3,
    Overlap = 4,
END_MILENUM

BEGIN_MILENUM( MilCompositingQuality )
    Invalid = 0,
    Default = 1,
    HighSpeed = 2,
    HighQuality = 3,
    GammaCorrected = 4,
    AssumeLinear = 5,
END_MILENUM

BEGIN_MILENUM( MilAntiAliasMode )
    None = 0,
    EightByEight = 1,
END_MILENUM

typedef enum
{
    MILVFAttrNone = 0x0,
    MILVFAttrXY = 0x1,
    MILVFAttrZ = 0x2,
    MILVFAttrXYZ = 0x3,
    MILVFAttrNormal = 0x4,
    MILVFAttrDiffuse = 0x8,
    MILVFAttrSpecular = 0x10,
    MILVFAttrUV1 = 0x100,
    MILVFAttrUV2 = 0x300,
    MILVFAttrUV3 = 0x700,
    MILVFAttrUV4 = 0xf00,
    MILVFAttrUV5 = 0x1f00,
    MILVFAttrUV6 = 0x3f00,
    MILVFAttrUV7 = 0x7f00,
    MILVFAttrUV8 = 0xff00,

    MilVertexFormatAttribute_FORCE_DWORD = 0xffffffff
} MilVertexFormatAttribute;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilRectU
//
//------------------------------------------------------------------------------
typedef struct
{
    UINT left;
    UINT top;
    UINT right;
    UINT bottom;
} MilRectU;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilPointAndSize3F
//
//------------------------------------------------------------------------------
typedef struct
{
    FLOAT X;
    FLOAT Y;
    FLOAT Z;
    FLOAT LengthX;
    FLOAT LengthY;
    FLOAT LengthZ;
} MilPointAndSize3F;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilIccProfile
//
//------------------------------------------------------------------------------
typedef struct
{
    //
    // profile type
    //
    DWORD dwType;

    //
    // filename or buffer containing profile
    //
    PVOID pProfileData;

    //
    // size of profile data
    //
    DWORD cbDataSize;
} MilIccProfile;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilIccProfileHeader
//
//------------------------------------------------------------------------------
typedef struct
{
    //
    // profile size in bytes
    //
    DWORD phSize;

    //
    // CMM for this profile
    //
    DWORD phCMMType;

    //
    // profile format version number
    //
    DWORD phVersion;

    //
    // type of profile
    //
    DWORD phClass;

    //
    // color space of data
    //
    DWORD phDataColorSpace;

    //
    // PCS
    //
    DWORD phConnectionSpace;

    //
    // date profile was created
    //
    DWORD phDateTime[3];

    //
    // magic number
    //
    DWORD phSignature;

    //
    // primary platform
    //
    DWORD phPlatform;

    //
    // various bit settings
    //
    DWORD phProfileFlags;

    //
    // device manufacturer
    //
    DWORD phManufacturer;

    //
    // device model number
    //
    DWORD phModel;

    //
    // device manufacturer
    //
    DWORD phAttributes[2];

    //
    // rendering intent
    //
    DWORD phRenderingIntent;

    //
    // profile illuminant
    //
    CIEXYZ phIlluminant;

    //
    // profile creator
    //
    DWORD phCreator;

    //
    // reserved for future use
    //
    BYTE phReserved[44];
} MilIccProfileHeader;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilVertexXYD
//
//------------------------------------------------------------------------------
typedef struct
{
    MilPoint2F Pos;
    MilColorF Diffuse;

    enum {Format = MILVFAttrXY | MILVFAttrDiffuse};
} MilVertexXYD;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilVertexXYUV
//
//------------------------------------------------------------------------------
typedef struct
{
    MilPoint2F Pos;
    MilPoint2F Tex;

    enum {Format = MILVFAttrXY | MILVFAttrUV1};
} MilVertexXYUV;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilVertexXYDUV
//
//------------------------------------------------------------------------------
typedef struct
{
    MilPoint2F Pos;
    MilColorF Diffuse;
    MilPoint2F Tex;

    enum {Format = MILVFAttrXY | MILVFAttrDiffuse | MILVFAttrUV1};
} MilVertexXYDUV;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilVertexXYZDUV2
//
//------------------------------------------------------------------------------
typedef struct
{
    MilPoint3F Pos;
    DWORD dwDiffuse;
    MilPoint2F Tex1;
    MilPoint2F Tex2;

    enum {Format = MILVFAttrXYZ | MILVFAttrDiffuse | MILVFAttrUV2};
} MilVertexXYZDUV2;

//+-----------------------------------------------------------------------------
//
//  Class:
//      MilVertexXYZNDSUV4
//
//------------------------------------------------------------------------------
typedef struct
{
    FLOAT X;
    FLOAT Y;
    FLOAT Z;
    FLOAT Nx;
    FLOAT Ny;
    FLOAT Nz;
    MilColorF Diffuse;
    MilColorF Specular;
    MilPoint2F Tex1;
    MilPoint2F Tex2;
    MilPoint2F Tex3;
    MilPoint2F Tex4;

    enum {Format = MILVFAttrXYZ | MILVFAttrNormal | MILVFAttrDiffuse | MILVFAttrSpecular | MILVFAttrUV4};
} MilVertexXYZNDSUV4;

#ifdef COMPOUND_PEN_IMPLEMENTED
BEGIN_MILENUM( MilCompoundStyle )
    Single = 0,
    Double = 1,
    Triple = 2,
    Custom = 3,
END_MILENUM
#endif // COMPOUND_PEN_IMPLEMENTED
