## List of blog posts that provide a 'deep-dive' into the CoreCLR source code

### Posts that take a high-level overview of releases

- [Corestart 2.0: What's new for performance in .NET Core 2.0](https://www.ageofascent.com/2017/11/05/perfromance-dotnet-core-2-corestart-conference/)
- [Performance improvements in .NET Core 2.0](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-core/)
- [Performance improvements in .NET Core 2.1](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-core-2-1/)
- [Performance improvements in .NET Core 3.0](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-core-3-0/)
- [Performance improvements in .NET 5](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-5/)
- [Performance improvements in .NET 6](https://devblogs.microsoft.com/dotnet/performance-improvements-in-net-6/)
- [Performance improvements in .NET 7](https://devblogs.microsoft.com/dotnet/performance_improvements_in_net_7/)

### Posts that take a high-level look at the entire source:

- [A Hitchhikers Guide to the CoreCLR Source Code](http://mattwarren.org/2017/03/23/Hitchhikers-Guide-to-the-CoreCLR-Source-Code/)
- [The 68 things the CLR does before executing a single line of your code](http://mattwarren.org/2017/02/07/The-68-things-the-CLR-does-before-executing-a-single-line-of-your-code/)
- [Research papers in the .NET source](http://mattwarren.org/2016/12/12/Research-papers-in-the-.NET-source/)

### Posts that reference specific parts of the source:

- [A look at the internals of 'boxing' in the CLR](http://mattwarren.org/2017/08/02/A-look-at-the-internals-of-boxing-in-the-CLR/)
- [Memory Usage Inside the CLR](http://mattwarren.org/2017/07/10/Memory-Usage-Inside-the-CLR/)
- [How the .NET Runtime loads a Type](http://mattwarren.org/2017/06/15/How-the-.NET-Rutime-loads-a-Type/)
- [Adding a new Bytecode Instruction to the CLR](http://mattwarren.org/2017/05/19/Adding-a-new-Bytecode-Instruction-to-the-CLR/)
- [Arrays and the CLR - a Very Special Relationship](http://mattwarren.org/2017/05/08/Arrays-and-the-CLR-a-Very-Special-Relationship/)
- [The CLR Thread Pool 'Thread Injection' Algorithm](http://mattwarren.org/2017/04/13/The-CLR-Thread-Pool-Thread-Injection-Algorithm/)
- [The .NET IL Interpreter](http://mattwarren.org/2017/03/30/The-.NET-IL-Interpreter/)
- [How do .NET delegates work?](http://mattwarren.org/2017/01/25/How-do-.NET-delegates-work/)
- [Why is reflection slow?](http://mattwarren.org/2016/12/14/Why-is-Reflection-slow/)
- [Preventing .NET Garbage Collections with the TryStartNoGCRegion API](http://mattwarren.org/2016/08/16/Preventing-dotNET-Garbage-Collections-with-the-TryStartNoGCRegion-API/)
- [GC Pauses and Safe Points](http://mattwarren.org/2016/08/08/GC-Pauses-and-Safe-Points/)
- [Strings and the CLR - a Special Relationship](http://mattwarren.org/2016/05/31/Strings-and-the-CLR-a-Special-Relationship/)
- [How Async/Await Really Works in C#](https://devblogs.microsoft.com/dotnet/how-async-await-really-works/)
