## TFSA-2022-009: OOM due to integer overflow in `StringNGrams`

### CVE Number
CVE-2022-21733

### Impact
The [implementation of `StringNGrams`](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/kernels/string_ngrams_op.cc#L29-L161) can be used to trigger a denial of service attack by causing an OOM condition after an integer overflow:

```python
import tensorflow as tf

tf.raw_ops.StringNGrams(
  data=['123456'],
  data_splits=[0,1],
  separator='a'*15,
  ngram_widths=[],
  left_pad='',
  right_pad='',
  pad_width=-5,
  preserve_short_sequences=True)
```

We are missing a validation on `pad_witdh` and that result in computing a negative value for `ngram_width` which is later used to allocate parts of the output.

### Patches
We have patched the issue in GitHub commit [f68fdab93fb7f4ddb4eb438c8fe052753c9413e8](https://github.com/tensorflow/tensorflow/commit/f68fdab93fb7f4ddb4eb438c8fe052753c9413e8).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Yu Tian of Qihoo 360 AIVul Team.
